# SPDX-FileCopyrightText: 2018-2024 Greenbone AG
#
# SPDX-License-Identifier: GPL-3.0-or-later
#

from gvm.errors import RequiredArgument


class GmpGetVulnerabilityTestMixin:
    def test_get_vulnerability(self):
        self.gmp.get_vulnerability("a1")

        self.connection.send.has_been_called_with('<get_vulns vuln_id="a1"/>')

        self.gmp.get_vulnerability(vulnerability_id="a1")

        self.connection.send.has_been_called_with('<get_vulns vuln_id="a1"/>')

    def test_get_vulnerability_invalid_vulnerability_id(self):
        with self.assertRaises(RequiredArgument):
            self.gmp.get_vulnerability(vulnerability_id=None)

        with self.assertRaises(RequiredArgument):
            self.gmp.get_vulnerability(vulnerability_id="")
