# coding: utf-8

"""
    Harbor API

    These APIs provide services for manipulating Harbor project.  # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ArtifactApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def add_label(self, project_name, repository_name, reference, label, **kwargs):  # noqa: E501
        """Add label to artifact  # noqa: E501

        Add label to the specified artiact.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_label(project_name, repository_name, reference, label, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param Label label: The label that added to the artifact. Only the ID property is needed. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.add_label_with_http_info(project_name, repository_name, reference, label, **kwargs)  # noqa: E501
        else:
            (data) = self.add_label_with_http_info(project_name, repository_name, reference, label, **kwargs)  # noqa: E501
            return data

    def add_label_with_http_info(self, project_name, repository_name, reference, label, **kwargs):  # noqa: E501
        """Add label to artifact  # noqa: E501

        Add label to the specified artiact.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.add_label_with_http_info(project_name, repository_name, reference, label, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param Label label: The label that added to the artifact. Only the ID property is needed. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'label', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method add_label" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `add_label`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `add_label`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `add_label`")  # noqa: E501
        # verify the required parameter 'label' is set
        if ('label' not in params or
                params['label'] is None):
            raise ValueError("Missing the required parameter `label` when calling `add_label`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `add_label`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'label' in params:
            body_params = params['label']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/labels', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def copy_artifact(self, project_name, repository_name, _from, **kwargs):  # noqa: E501
        """Copy artifact  # noqa: E501

        Copy the artifact specified in the \"from\" parameter to the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_artifact(project_name, repository_name, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str _from: The artifact from which the new artifact is copied from, the format should be \"project/repository:tag\" or \"project/repository@digest\". (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.copy_artifact_with_http_info(project_name, repository_name, _from, **kwargs)  # noqa: E501
        else:
            (data) = self.copy_artifact_with_http_info(project_name, repository_name, _from, **kwargs)  # noqa: E501
            return data

    def copy_artifact_with_http_info(self, project_name, repository_name, _from, **kwargs):  # noqa: E501
        """Copy artifact  # noqa: E501

        Copy the artifact specified in the \"from\" parameter to the repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.copy_artifact_with_http_info(project_name, repository_name, _from, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str _from: The artifact from which the new artifact is copied from, the format should be \"project/repository:tag\" or \"project/repository@digest\". (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', '_from', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method copy_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `copy_artifact`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `copy_artifact`")  # noqa: E501
        # verify the required parameter '_from' is set
        if ('_from' not in params or
                params['_from'] is None):
            raise ValueError("Missing the required parameter `_from` when calling `copy_artifact`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `copy_artifact`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501

        query_params = []
        if '_from' in params:
            query_params.append(('from', params['_from']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_tag(self, project_name, repository_name, reference, tag, **kwargs):  # noqa: E501
        """Create tag  # noqa: E501

        Create a tag for the specified artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tag(project_name, repository_name, reference, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param Tag tag: The JSON object of tag. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_tag_with_http_info(project_name, repository_name, reference, tag, **kwargs)  # noqa: E501
        else:
            (data) = self.create_tag_with_http_info(project_name, repository_name, reference, tag, **kwargs)  # noqa: E501
            return data

    def create_tag_with_http_info(self, project_name, repository_name, reference, tag, **kwargs):  # noqa: E501
        """Create tag  # noqa: E501

        Create a tag for the specified artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_tag_with_http_info(project_name, repository_name, reference, tag, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param Tag tag: The JSON object of tag. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'tag', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `create_tag`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `create_tag`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `create_tag`")  # noqa: E501
        # verify the required parameter 'tag' is set
        if ('tag' not in params or
                params['tag'] is None):
            raise ValueError("Missing the required parameter `tag` when calling `create_tag`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `create_tag`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'tag' in params:
            body_params = params['tag']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/tags', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_artifact(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """Delete the specific artifact  # noqa: E501

        Delete the artifact specified by the reference under the project and repository. The reference can be digest or tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_artifact(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_artifact_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_artifact_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
            return data

    def delete_artifact_with_http_info(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """Delete the specific artifact  # noqa: E501

        Delete the artifact specified by the reference under the project and repository. The reference can be digest or tag  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_artifact_with_http_info(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `delete_artifact`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `delete_artifact`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `delete_artifact`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `delete_artifact`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_tag(self, project_name, repository_name, reference, tag_name, **kwargs):  # noqa: E501
        """Delete tag  # noqa: E501

        Delete the tag of the specified artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag(project_name, repository_name, reference, tag_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str tag_name: The name of the tag (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_tag_with_http_info(project_name, repository_name, reference, tag_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_tag_with_http_info(project_name, repository_name, reference, tag_name, **kwargs)  # noqa: E501
            return data

    def delete_tag_with_http_info(self, project_name, repository_name, reference, tag_name, **kwargs):  # noqa: E501
        """Delete tag  # noqa: E501

        Delete the tag of the specified artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_tag_with_http_info(project_name, repository_name, reference, tag_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str tag_name: The name of the tag (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'tag_name', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_tag" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `delete_tag`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `delete_tag`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `delete_tag`")  # noqa: E501
        # verify the required parameter 'tag_name' is set
        if ('tag_name' not in params or
                params['tag_name'] is None):
            raise ValueError("Missing the required parameter `tag_name` when calling `delete_tag`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `delete_tag`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501
        if 'tag_name' in params:
            path_params['tag_name'] = params['tag_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/tags/{tag_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_addition(self, project_name, repository_name, reference, addition, **kwargs):  # noqa: E501
        """Get the addition of the specific artifact  # noqa: E501

        Get the addition of the artifact specified by the reference under the project and repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_addition(project_name, repository_name, reference, addition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str addition: The type of addition. (required)
        :param str x_request_id: An unique ID for the request
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_addition_with_http_info(project_name, repository_name, reference, addition, **kwargs)  # noqa: E501
        else:
            (data) = self.get_addition_with_http_info(project_name, repository_name, reference, addition, **kwargs)  # noqa: E501
            return data

    def get_addition_with_http_info(self, project_name, repository_name, reference, addition, **kwargs):  # noqa: E501
        """Get the addition of the specific artifact  # noqa: E501

        Get the addition of the artifact specified by the reference under the project and repository.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_addition_with_http_info(project_name, repository_name, reference, addition, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str addition: The type of addition. (required)
        :param str x_request_id: An unique ID for the request
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'addition', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_addition" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `get_addition`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `get_addition`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `get_addition`")  # noqa: E501
        # verify the required parameter 'addition' is set
        if ('addition' not in params or
                params['addition'] is None):
            raise ValueError("Missing the required parameter `addition` when calling `get_addition`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_addition`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501
        if 'addition' in params:
            path_params['addition'] = params['addition']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/additions/{addition}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_artifact(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """Get the specific artifact  # noqa: E501

        Get the artifact specified by the reference under the project and repository. The reference can be digest or tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param bool with_tag: Specify whether the tags are inclued inside the returning artifacts
        :param bool with_label: Specify whether the labels are inclued inside the returning artifacts
        :param bool with_scan_overview: Specify whether the scan overview is inclued inside the returning artifacts
        :param bool with_signature: Specify whether the signature is inclued inside the returning artifacts
        :param bool with_immutable_status: Specify whether the immutable status is inclued inside the tags of the returning artifacts. Only works when setting \"with_tag=true\"
        :return: Artifact
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_artifact_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
        else:
            (data) = self.get_artifact_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
            return data

    def get_artifact_with_http_info(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """Get the specific artifact  # noqa: E501

        Get the artifact specified by the reference under the project and repository. The reference can be digest or tag.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_artifact_with_http_info(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param bool with_tag: Specify whether the tags are inclued inside the returning artifacts
        :param bool with_label: Specify whether the labels are inclued inside the returning artifacts
        :param bool with_scan_overview: Specify whether the scan overview is inclued inside the returning artifacts
        :param bool with_signature: Specify whether the signature is inclued inside the returning artifacts
        :param bool with_immutable_status: Specify whether the immutable status is inclued inside the tags of the returning artifacts. Only works when setting \"with_tag=true\"
        :return: Artifact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'x_request_id', 'page', 'page_size', 'with_tag', 'with_label', 'with_scan_overview', 'with_signature', 'with_immutable_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `get_artifact`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `get_artifact`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `get_artifact`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_artifact`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `get_artifact`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'with_tag' in params:
            query_params.append(('with_tag', params['with_tag']))  # noqa: E501
        if 'with_label' in params:
            query_params.append(('with_label', params['with_label']))  # noqa: E501
        if 'with_scan_overview' in params:
            query_params.append(('with_scan_overview', params['with_scan_overview']))  # noqa: E501
        if 'with_signature' in params:
            query_params.append(('with_signature', params['with_signature']))  # noqa: E501
        if 'with_immutable_status' in params:
            query_params.append(('with_immutable_status', params['with_immutable_status']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Artifact',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_artifacts(self, project_name, repository_name, **kwargs):  # noqa: E501
        """List artifacts  # noqa: E501

        List artifacts under the specific project and repository. Except the basic properties, the other supported queries in \"q\" includes \"tags=*\" to list only tagged artifacts, \"tags=nil\" to list only untagged artifacts, \"tags=~v\" to list artifacts whose tag fuzzy matches \"v\", \"tags=v\" to list artifact whose tag exactly matches \"v\", \"labels=(id1, id2)\" to list artifacts that both labels with id1 and id2 are added to  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_artifacts(project_name, repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str x_request_id: An unique ID for the request
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :param int page: The page number
        :param int page_size: The size of per page
        :param bool with_tag: Specify whether the tags are included inside the returning artifacts
        :param bool with_label: Specify whether the labels are included inside the returning artifacts
        :param bool with_scan_overview: Specify whether the scan overview is included inside the returning artifacts
        :param bool with_signature: Specify whether the signature is included inside the tags of the returning artifacts. Only works when setting \"with_tag=true\"
        :param bool with_immutable_status: Specify whether the immutable status is included inside the tags of the returning artifacts. Only works when setting \"with_tag=true\"
        :return: list[Artifact]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_artifacts_with_http_info(project_name, repository_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_artifacts_with_http_info(project_name, repository_name, **kwargs)  # noqa: E501
            return data

    def list_artifacts_with_http_info(self, project_name, repository_name, **kwargs):  # noqa: E501
        """List artifacts  # noqa: E501

        List artifacts under the specific project and repository. Except the basic properties, the other supported queries in \"q\" includes \"tags=*\" to list only tagged artifacts, \"tags=nil\" to list only untagged artifacts, \"tags=~v\" to list artifacts whose tag fuzzy matches \"v\", \"tags=v\" to list artifact whose tag exactly matches \"v\", \"labels=(id1, id2)\" to list artifacts that both labels with id1 and id2 are added to  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_artifacts_with_http_info(project_name, repository_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str x_request_id: An unique ID for the request
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :param int page: The page number
        :param int page_size: The size of per page
        :param bool with_tag: Specify whether the tags are included inside the returning artifacts
        :param bool with_label: Specify whether the labels are included inside the returning artifacts
        :param bool with_scan_overview: Specify whether the scan overview is included inside the returning artifacts
        :param bool with_signature: Specify whether the signature is included inside the tags of the returning artifacts. Only works when setting \"with_tag=true\"
        :param bool with_immutable_status: Specify whether the immutable status is included inside the tags of the returning artifacts. Only works when setting \"with_tag=true\"
        :return: list[Artifact]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'x_request_id', 'q', 'page', 'page_size', 'with_tag', 'with_label', 'with_scan_overview', 'with_signature', 'with_immutable_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_artifacts" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `list_artifacts`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `list_artifacts`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_artifacts`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_artifacts`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'with_tag' in params:
            query_params.append(('with_tag', params['with_tag']))  # noqa: E501
        if 'with_label' in params:
            query_params.append(('with_label', params['with_label']))  # noqa: E501
        if 'with_scan_overview' in params:
            query_params.append(('with_scan_overview', params['with_scan_overview']))  # noqa: E501
        if 'with_signature' in params:
            query_params.append(('with_signature', params['with_signature']))  # noqa: E501
        if 'with_immutable_status' in params:
            query_params.append(('with_immutable_status', params['with_immutable_status']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Artifact]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tags(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """List tags  # noqa: E501

        List tags of the specific artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tags(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :param int page: The page number
        :param int page_size: The size of per page
        :param bool with_signature: Specify whether the signature is included inside the returning tags
        :param bool with_immutable_status: Specify whether the immutable status is included inside the returning tags
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tags_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tags_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
            return data

    def list_tags_with_http_info(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """List tags  # noqa: E501

        List tags of the specific artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tags_with_http_info(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :param int page: The page number
        :param int page_size: The size of per page
        :param bool with_signature: Specify whether the signature is included inside the returning tags
        :param bool with_immutable_status: Specify whether the immutable status is included inside the returning tags
        :return: list[Tag]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'x_request_id', 'q', 'page', 'page_size', 'with_signature', 'with_immutable_status']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tags" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `list_tags`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `list_tags`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `list_tags`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_tags`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_tags`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'with_signature' in params:
            query_params.append(('with_signature', params['with_signature']))  # noqa: E501
        if 'with_immutable_status' in params:
            query_params.append(('with_immutable_status', params['with_immutable_status']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/tags', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Tag]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def remove_label(self, project_name, repository_name, reference, label_id, **kwargs):  # noqa: E501
        """Remove label from artifact  # noqa: E501

        Remove the label from the specified artiact.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_label(project_name, repository_name, reference, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param int label_id: The ID of the label that removed from the artifact. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.remove_label_with_http_info(project_name, repository_name, reference, label_id, **kwargs)  # noqa: E501
        else:
            (data) = self.remove_label_with_http_info(project_name, repository_name, reference, label_id, **kwargs)  # noqa: E501
            return data

    def remove_label_with_http_info(self, project_name, repository_name, reference, label_id, **kwargs):  # noqa: E501
        """Remove label from artifact  # noqa: E501

        Remove the label from the specified artiact.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.remove_label_with_http_info(project_name, repository_name, reference, label_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param int label_id: The ID of the label that removed from the artifact. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'label_id', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method remove_label" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `remove_label`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `remove_label`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `remove_label`")  # noqa: E501
        # verify the required parameter 'label_id' is set
        if ('label_id' not in params or
                params['label_id'] is None):
            raise ValueError("Missing the required parameter `label_id` when calling `remove_label`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `remove_label`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501
        if 'label_id' in params:
            path_params['label_id'] = params['label_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/labels/{label_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
