# coding: utf-8

"""
    Harbor API

    These APIs provide services for manipulating Harbor project.  # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class PreheatApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_instance(self, instance, **kwargs):  # noqa: E501
        """Create p2p provider instances  # noqa: E501

        Create p2p provider instances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instance(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Instance instance: The JSON object of instance. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_instance_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.create_instance_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def create_instance_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Create p2p provider instances  # noqa: E501

        Create p2p provider instances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_instance_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Instance instance: The JSON object of instance. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `create_instance`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `create_instance`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'instance' in params:
            body_params = params['instance']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/instances', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def create_policy(self, project_name, policy, **kwargs):  # noqa: E501
        """Create a preheat policy under a project  # noqa: E501

        Create a preheat policy under a project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_policy(project_name, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param PreheatPolicy policy: The policy schema info (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_policy_with_http_info(project_name, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.create_policy_with_http_info(project_name, policy, **kwargs)  # noqa: E501
            return data

    def create_policy_with_http_info(self, project_name, policy, **kwargs):  # noqa: E501
        """Create a preheat policy under a project  # noqa: E501

        Create a preheat policy under a project  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_policy_with_http_info(project_name, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param PreheatPolicy policy: The policy schema info (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'policy', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `create_policy`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `create_policy`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `create_policy`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy' in params:
            body_params = params['policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_instance(self, preheat_instance_name, **kwargs):  # noqa: E501
        """Delete the specified P2P provider instance  # noqa: E501

        Delete the specified P2P provider instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instance(preheat_instance_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preheat_instance_name: Instance Name (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_instance_with_http_info(preheat_instance_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_instance_with_http_info(preheat_instance_name, **kwargs)  # noqa: E501
            return data

    def delete_instance_with_http_info(self, preheat_instance_name, **kwargs):  # noqa: E501
        """Delete the specified P2P provider instance  # noqa: E501

        Delete the specified P2P provider instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_instance_with_http_info(preheat_instance_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preheat_instance_name: Instance Name (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['preheat_instance_name', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'preheat_instance_name' is set
        if ('preheat_instance_name' not in params or
                params['preheat_instance_name'] is None):
            raise ValueError("Missing the required parameter `preheat_instance_name` when calling `delete_instance`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `delete_instance`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'preheat_instance_name' in params:
            path_params['preheat_instance_name'] = params['preheat_instance_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/instances/{preheat_instance_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_policy(self, project_name, preheat_policy_name, **kwargs):  # noqa: E501
        """Delete a preheat policy  # noqa: E501

        Delete a preheat policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_policy(project_name, preheat_policy_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_policy_with_http_info(project_name, preheat_policy_name, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_policy_with_http_info(project_name, preheat_policy_name, **kwargs)  # noqa: E501
            return data

    def delete_policy_with_http_info(self, project_name, preheat_policy_name, **kwargs):  # noqa: E501
        """Delete a preheat policy  # noqa: E501

        Delete a preheat policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_policy_with_http_info(project_name, preheat_policy_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `delete_policy`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `delete_policy`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `delete_policy`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_execution(self, project_name, preheat_policy_name, execution_id, **kwargs):  # noqa: E501
        """Get a execution detail by id  # noqa: E501

        Get a execution detail by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution(project_name, preheat_policy_name, execution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param str x_request_id: An unique ID for the request
        :return: Execution
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_execution_with_http_info(project_name, preheat_policy_name, execution_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_execution_with_http_info(project_name, preheat_policy_name, execution_id, **kwargs)  # noqa: E501
            return data

    def get_execution_with_http_info(self, project_name, preheat_policy_name, execution_id, **kwargs):  # noqa: E501
        """Get a execution detail by id  # noqa: E501

        Get a execution detail by id  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_execution_with_http_info(project_name, preheat_policy_name, execution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param str x_request_id: An unique ID for the request
        :return: Execution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'execution_id', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `get_execution`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `get_execution`")  # noqa: E501
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_execution`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_execution`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501
        if 'execution_id' in params:
            path_params['execution_id'] = params['execution_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}/executions/{execution_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Execution',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_instance(self, preheat_instance_name, **kwargs):  # noqa: E501
        """Get a P2P provider instance  # noqa: E501

        Get a P2P provider instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instance(preheat_instance_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preheat_instance_name: Instance Name (required)
        :param str x_request_id: An unique ID for the request
        :return: Instance
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_instance_with_http_info(preheat_instance_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_instance_with_http_info(preheat_instance_name, **kwargs)  # noqa: E501
            return data

    def get_instance_with_http_info(self, preheat_instance_name, **kwargs):  # noqa: E501
        """Get a P2P provider instance  # noqa: E501

        Get a P2P provider instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_instance_with_http_info(preheat_instance_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preheat_instance_name: Instance Name (required)
        :param str x_request_id: An unique ID for the request
        :return: Instance
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['preheat_instance_name', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'preheat_instance_name' is set
        if ('preheat_instance_name' not in params or
                params['preheat_instance_name'] is None):
            raise ValueError("Missing the required parameter `preheat_instance_name` when calling `get_instance`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_instance`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'preheat_instance_name' in params:
            path_params['preheat_instance_name'] = params['preheat_instance_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/instances/{preheat_instance_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Instance',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_policy(self, project_name, preheat_policy_name, **kwargs):  # noqa: E501
        """Get a preheat policy  # noqa: E501

        Get a preheat policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_policy(project_name, preheat_policy_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param str x_request_id: An unique ID for the request
        :return: PreheatPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_policy_with_http_info(project_name, preheat_policy_name, **kwargs)  # noqa: E501
        else:
            (data) = self.get_policy_with_http_info(project_name, preheat_policy_name, **kwargs)  # noqa: E501
            return data

    def get_policy_with_http_info(self, project_name, preheat_policy_name, **kwargs):  # noqa: E501
        """Get a preheat policy  # noqa: E501

        Get a preheat policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_policy_with_http_info(project_name, preheat_policy_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param str x_request_id: An unique ID for the request
        :return: PreheatPolicy
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `get_policy`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `get_policy`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_policy`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='PreheatPolicy',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_preheat_log(self, project_name, preheat_policy_name, execution_id, task_id, **kwargs):  # noqa: E501
        """Get the log text stream of the specified task for the given execution  # noqa: E501

        Get the log text stream of the specified task for the given execution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_preheat_log(project_name, preheat_policy_name, execution_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param int task_id: Task ID (required)
        :param str x_request_id: An unique ID for the request
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_preheat_log_with_http_info(project_name, preheat_policy_name, execution_id, task_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_preheat_log_with_http_info(project_name, preheat_policy_name, execution_id, task_id, **kwargs)  # noqa: E501
            return data

    def get_preheat_log_with_http_info(self, project_name, preheat_policy_name, execution_id, task_id, **kwargs):  # noqa: E501
        """Get the log text stream of the specified task for the given execution  # noqa: E501

        Get the log text stream of the specified task for the given execution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_preheat_log_with_http_info(project_name, preheat_policy_name, execution_id, task_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param int task_id: Task ID (required)
        :param str x_request_id: An unique ID for the request
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'execution_id', 'task_id', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_preheat_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `get_preheat_log`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `get_preheat_log`")  # noqa: E501
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_preheat_log`")  # noqa: E501
        # verify the required parameter 'task_id' is set
        if ('task_id' not in params or
                params['task_id'] is None):
            raise ValueError("Missing the required parameter `task_id` when calling `get_preheat_log`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_preheat_log`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501
        if 'execution_id' in params:
            path_params['execution_id'] = params['execution_id']  # noqa: E501
        if 'task_id' in params:
            path_params['task_id'] = params['task_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}/executions/{execution_id}/tasks/{task_id}/logs', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_executions(self, project_name, preheat_policy_name, **kwargs):  # noqa: E501
        """List executions for the given policy  # noqa: E501

        List executions for the given policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_executions(project_name, preheat_policy_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[Execution]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_executions_with_http_info(project_name, preheat_policy_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_executions_with_http_info(project_name, preheat_policy_name, **kwargs)  # noqa: E501
            return data

    def list_executions_with_http_info(self, project_name, preheat_policy_name, **kwargs):  # noqa: E501
        """List executions for the given policy  # noqa: E501

        List executions for the given policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_executions_with_http_info(project_name, preheat_policy_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[Execution]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'x_request_id', 'page', 'page_size', 'q']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_executions" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `list_executions`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `list_executions`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_executions`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_executions`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}/executions', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Execution]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_instances(self, **kwargs):  # noqa: E501
        """List P2P provider instances  # noqa: E501

        List P2P provider instances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_instances(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[Instance]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_instances_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_instances_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_instances_with_http_info(self, **kwargs):  # noqa: E501
        """List P2P provider instances  # noqa: E501

        List P2P provider instances  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_instances_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[Instance]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id', 'page', 'page_size', 'q']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_instances" % key
                )
            params[key] = val
        del params['kwargs']

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_instances`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_instances`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/instances', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Instance]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_policies(self, project_name, **kwargs):  # noqa: E501
        """List preheat policies  # noqa: E501

        List preheat policies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_policies(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[PreheatPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_policies_with_http_info(project_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_policies_with_http_info(project_name, **kwargs)  # noqa: E501
            return data

    def list_policies_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """List preheat policies  # noqa: E501

        List preheat policies  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_policies_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[PreheatPolicy]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'x_request_id', 'page', 'page_size', 'q']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_policies" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `list_policies`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_policies`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_policies`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[PreheatPolicy]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers(self, **kwargs):  # noqa: E501
        """List P2P providers  # noqa: E501

        List P2P providers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: An unique ID for the request
        :return: list[Metadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_providers_with_http_info(self, **kwargs):  # noqa: E501
        """List P2P providers  # noqa: E501

        List P2P providers  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: An unique ID for the request
        :return: list[Metadata]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers" % key
                )
            params[key] = val
        del params['kwargs']

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_providers`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Metadata]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_providers_under_project(self, project_name, **kwargs):  # noqa: E501
        """Get all providers at project level  # noqa: E501

        Get all providers at project level  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_under_project(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str x_request_id: An unique ID for the request
        :return: list[ProviderUnderProject]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_providers_under_project_with_http_info(project_name, **kwargs)  # noqa: E501
        else:
            (data) = self.list_providers_under_project_with_http_info(project_name, **kwargs)  # noqa: E501
            return data

    def list_providers_under_project_with_http_info(self, project_name, **kwargs):  # noqa: E501
        """Get all providers at project level  # noqa: E501

        Get all providers at project level  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_providers_under_project_with_http_info(project_name, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str x_request_id: An unique ID for the request
        :return: list[ProviderUnderProject]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_providers_under_project" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `list_providers_under_project`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_providers_under_project`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/providers', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[ProviderUnderProject]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_tasks(self, project_name, preheat_policy_name, execution_id, **kwargs):  # noqa: E501
        """List all the related tasks for the given execution  # noqa: E501

        List all the related tasks for the given execution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks(project_name, preheat_policy_name, execution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_tasks_with_http_info(project_name, preheat_policy_name, execution_id, **kwargs)  # noqa: E501
        else:
            (data) = self.list_tasks_with_http_info(project_name, preheat_policy_name, execution_id, **kwargs)  # noqa: E501
            return data

    def list_tasks_with_http_info(self, project_name, preheat_policy_name, execution_id, **kwargs):  # noqa: E501
        """List all the related tasks for the given execution  # noqa: E501

        List all the related tasks for the given execution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_tasks_with_http_info(project_name, preheat_policy_name, execution_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param str x_request_id: An unique ID for the request
        :param int page: The page number
        :param int page_size: The size of per page
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :return: list[Task]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'execution_id', 'x_request_id', 'page', 'page_size', 'q']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_tasks" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `list_tasks`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `list_tasks`")  # noqa: E501
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `list_tasks`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_tasks`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_tasks`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501
        if 'execution_id' in params:
            path_params['execution_id'] = params['execution_id']  # noqa: E501

        query_params = []
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}/executions/{execution_id}/tasks', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Task]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def manual_preheat(self, project_name, preheat_policy_name, policy, **kwargs):  # noqa: E501
        """Manual preheat  # noqa: E501

        Manual preheat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.manual_preheat(project_name, preheat_policy_name, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param PreheatPolicy policy: The policy schema info (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.manual_preheat_with_http_info(project_name, preheat_policy_name, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.manual_preheat_with_http_info(project_name, preheat_policy_name, policy, **kwargs)  # noqa: E501
            return data

    def manual_preheat_with_http_info(self, project_name, preheat_policy_name, policy, **kwargs):  # noqa: E501
        """Manual preheat  # noqa: E501

        Manual preheat  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.manual_preheat_with_http_info(project_name, preheat_policy_name, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param PreheatPolicy policy: The policy schema info (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'policy', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method manual_preheat" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `manual_preheat`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `manual_preheat`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `manual_preheat`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `manual_preheat`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy' in params:
            body_params = params['policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def ping_instances(self, instance, **kwargs):  # noqa: E501
        """Ping status of a instance.  # noqa: E501

        This endpoint checks status of a instance, the instance can be given by ID or Endpoint URL (together with credential)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_instances(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Instance instance: The JSON object of instance. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.ping_instances_with_http_info(instance, **kwargs)  # noqa: E501
        else:
            (data) = self.ping_instances_with_http_info(instance, **kwargs)  # noqa: E501
            return data

    def ping_instances_with_http_info(self, instance, **kwargs):  # noqa: E501
        """Ping status of a instance.  # noqa: E501

        This endpoint checks status of a instance, the instance can be given by ID or Endpoint URL (together with credential)   # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.ping_instances_with_http_info(instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param Instance instance: The JSON object of instance. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['instance', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method ping_instances" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `ping_instances`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `ping_instances`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'instance' in params:
            body_params = params['instance']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/instances/ping', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def stop_execution(self, project_name, preheat_policy_name, execution_id, execution, **kwargs):  # noqa: E501
        """Stop a execution  # noqa: E501

        Stop a execution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_execution(project_name, preheat_policy_name, execution_id, execution, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param Execution execution: The data of execution (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.stop_execution_with_http_info(project_name, preheat_policy_name, execution_id, execution, **kwargs)  # noqa: E501
        else:
            (data) = self.stop_execution_with_http_info(project_name, preheat_policy_name, execution_id, execution, **kwargs)  # noqa: E501
            return data

    def stop_execution_with_http_info(self, project_name, preheat_policy_name, execution_id, execution, **kwargs):  # noqa: E501
        """Stop a execution  # noqa: E501

        Stop a execution  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.stop_execution_with_http_info(project_name, preheat_policy_name, execution_id, execution, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param int execution_id: Execution ID (required)
        :param Execution execution: The data of execution (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'execution_id', 'execution', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method stop_execution" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `stop_execution`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `stop_execution`")  # noqa: E501
        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params or
                params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `stop_execution`")  # noqa: E501
        # verify the required parameter 'execution' is set
        if ('execution' not in params or
                params['execution'] is None):
            raise ValueError("Missing the required parameter `execution` when calling `stop_execution`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `stop_execution`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501
        if 'execution_id' in params:
            path_params['execution_id'] = params['execution_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'execution' in params:
            body_params = params['execution']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}/executions/{execution_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_instance(self, preheat_instance_name, instance, **kwargs):  # noqa: E501
        """Update the specified P2P provider instance  # noqa: E501

        Update the specified P2P provider instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instance(preheat_instance_name, instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preheat_instance_name: Instance Name (required)
        :param Instance instance: The instance to update (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_instance_with_http_info(preheat_instance_name, instance, **kwargs)  # noqa: E501
        else:
            (data) = self.update_instance_with_http_info(preheat_instance_name, instance, **kwargs)  # noqa: E501
            return data

    def update_instance_with_http_info(self, preheat_instance_name, instance, **kwargs):  # noqa: E501
        """Update the specified P2P provider instance  # noqa: E501

        Update the specified P2P provider instance  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_instance_with_http_info(preheat_instance_name, instance, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str preheat_instance_name: Instance Name (required)
        :param Instance instance: The instance to update (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['preheat_instance_name', 'instance', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_instance" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'preheat_instance_name' is set
        if ('preheat_instance_name' not in params or
                params['preheat_instance_name'] is None):
            raise ValueError("Missing the required parameter `preheat_instance_name` when calling `update_instance`")  # noqa: E501
        # verify the required parameter 'instance' is set
        if ('instance' not in params or
                params['instance'] is None):
            raise ValueError("Missing the required parameter `instance` when calling `update_instance`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `update_instance`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'preheat_instance_name' in params:
            path_params['preheat_instance_name'] = params['preheat_instance_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'instance' in params:
            body_params = params['instance']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/p2p/preheat/instances/{preheat_instance_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_policy(self, project_name, preheat_policy_name, policy, **kwargs):  # noqa: E501
        """Update preheat policy  # noqa: E501

        Update preheat policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_policy(project_name, preheat_policy_name, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param PreheatPolicy policy: The policy schema info (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_policy_with_http_info(project_name, preheat_policy_name, policy, **kwargs)  # noqa: E501
        else:
            (data) = self.update_policy_with_http_info(project_name, preheat_policy_name, policy, **kwargs)  # noqa: E501
            return data

    def update_policy_with_http_info(self, project_name, preheat_policy_name, policy, **kwargs):  # noqa: E501
        """Update preheat policy  # noqa: E501

        Update preheat policy  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_policy_with_http_info(project_name, preheat_policy_name, policy, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str preheat_policy_name: Preheat Policy Name (required)
        :param PreheatPolicy policy: The policy schema info (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'preheat_policy_name', 'policy', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_policy" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `update_policy`")  # noqa: E501
        # verify the required parameter 'preheat_policy_name' is set
        if ('preheat_policy_name' not in params or
                params['preheat_policy_name'] is None):
            raise ValueError("Missing the required parameter `preheat_policy_name` when calling `update_policy`")  # noqa: E501
        # verify the required parameter 'policy' is set
        if ('policy' not in params or
                params['policy'] is None):
            raise ValueError("Missing the required parameter `policy` when calling `update_policy`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `update_policy`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'preheat_policy_name' in params:
            path_params['preheat_policy_name'] = params['preheat_policy_name']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'policy' in params:
            body_params = params['policy']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/preheat/policies/{preheat_policy_name}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
