# coding: utf-8

"""
    Harbor API

    These APIs provide services for manipulating Harbor project.  # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class RobotApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def create_robot(self, robot, **kwargs):  # noqa: E501
        """Create a robot account  # noqa: E501

        Create a robot account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_robot(robot, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RobotCreate robot: The JSON object of a robot account. (required)
        :param str x_request_id: An unique ID for the request
        :return: RobotCreated
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.create_robot_with_http_info(robot, **kwargs)  # noqa: E501
        else:
            (data) = self.create_robot_with_http_info(robot, **kwargs)  # noqa: E501
            return data

    def create_robot_with_http_info(self, robot, **kwargs):  # noqa: E501
        """Create a robot account  # noqa: E501

        Create a robot account  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.create_robot_with_http_info(robot, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param RobotCreate robot: The JSON object of a robot account. (required)
        :param str x_request_id: An unique ID for the request
        :return: RobotCreated
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['robot', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method create_robot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'robot' is set
        if ('robot' not in params or
                params['robot'] is None):
            raise ValueError("Missing the required parameter `robot` when calling `create_robot`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `create_robot`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'robot' in params:
            body_params = params['robot']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/robots', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RobotCreated',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def delete_robot(self, robot_id, **kwargs):  # noqa: E501
        """Delete a robot account  # noqa: E501

        This endpoint deletes specific robot account information by robot ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_robot(robot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.delete_robot_with_http_info(robot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.delete_robot_with_http_info(robot_id, **kwargs)  # noqa: E501
            return data

    def delete_robot_with_http_info(self, robot_id, **kwargs):  # noqa: E501
        """Delete a robot account  # noqa: E501

        This endpoint deletes specific robot account information by robot ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.delete_robot_with_http_info(robot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['robot_id', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_robot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'robot_id' is set
        if ('robot_id' not in params or
                params['robot_id'] is None):
            raise ValueError("Missing the required parameter `robot_id` when calling `delete_robot`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `delete_robot`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'robot_id' in params:
            path_params['robot_id'] = params['robot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/robots/{robot_id}', 'DELETE',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def get_robot_by_id(self, robot_id, **kwargs):  # noqa: E501
        """Get a robot account  # noqa: E501

        This endpoint returns specific robot account information by robot ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_robot_by_id(robot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param str x_request_id: An unique ID for the request
        :return: Robot
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_robot_by_id_with_http_info(robot_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_robot_by_id_with_http_info(robot_id, **kwargs)  # noqa: E501
            return data

    def get_robot_by_id_with_http_info(self, robot_id, **kwargs):  # noqa: E501
        """Get a robot account  # noqa: E501

        This endpoint returns specific robot account information by robot ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_robot_by_id_with_http_info(robot_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param str x_request_id: An unique ID for the request
        :return: Robot
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['robot_id', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_robot_by_id" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'robot_id' is set
        if ('robot_id' not in params or
                params['robot_id'] is None):
            raise ValueError("Missing the required parameter `robot_id` when calling `get_robot_by_id`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_robot_by_id`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'robot_id' in params:
            path_params['robot_id'] = params['robot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/robots/{robot_id}', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='Robot',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def list_robot(self, **kwargs):  # noqa: E501
        """Get robot account  # noqa: E501

        List the robot accounts with the specified level and project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_robot(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: An unique ID for the request
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :param int page: The page number
        :param int page_size: The size of per page
        :return: list[Robot]
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.list_robot_with_http_info(**kwargs)  # noqa: E501
        else:
            (data) = self.list_robot_with_http_info(**kwargs)  # noqa: E501
            return data

    def list_robot_with_http_info(self, **kwargs):  # noqa: E501
        """Get robot account  # noqa: E501

        List the robot accounts with the specified level and project.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.list_robot_with_http_info(async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str x_request_id: An unique ID for the request
        :param str q: Query string to query resources. Supported query patterns are \"exact match(k=v)\", \"fuzzy match(k=~v)\", \"range(k=[min~max])\", \"list with union releationship(k={v1 v2 v3})\" and \"list with intersetion relationship(k=(v1 v2 v3))\". The value of range and list can be string(enclosed by \" or '), integer or time(in format \"2020-04-09 02:36:00\"). All of these query patterns should be put in the query string \"q=xxx\" and splitted by \",\". e.g. q=k1=v1,k2=~v2,k3=[min~max]
        :param int page: The page number
        :param int page_size: The size of per page
        :return: list[Robot]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['x_request_id', 'q', 'page', 'page_size']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method list_robot" % key
                )
            params[key] = val
        del params['kwargs']

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `list_robot`, length must be greater than or equal to `1`")  # noqa: E501
        if 'page_size' in params and params['page_size'] > 100:  # noqa: E501
            raise ValueError("Invalid value for parameter `page_size` when calling `list_robot`, must be a value less than or equal to `100`")  # noqa: E501
        collection_formats = {}

        path_params = {}

        query_params = []
        if 'q' in params:
            query_params.append(('q', params['q']))  # noqa: E501
        if 'page' in params:
            query_params.append(('page', params['page']))  # noqa: E501
        if 'page_size' in params:
            query_params.append(('page_size', params['page_size']))  # noqa: E501

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/robots', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='list[Robot]',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def refresh_sec(self, robot_id, robot_sec, **kwargs):  # noqa: E501
        """Refresh the robot secret  # noqa: E501

        Refresh the robot secret  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_sec(robot_id, robot_sec, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param RobotSec robot_sec: The JSON object of a robot account. (required)
        :param str x_request_id: An unique ID for the request
        :return: RobotSec
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.refresh_sec_with_http_info(robot_id, robot_sec, **kwargs)  # noqa: E501
        else:
            (data) = self.refresh_sec_with_http_info(robot_id, robot_sec, **kwargs)  # noqa: E501
            return data

    def refresh_sec_with_http_info(self, robot_id, robot_sec, **kwargs):  # noqa: E501
        """Refresh the robot secret  # noqa: E501

        Refresh the robot secret  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.refresh_sec_with_http_info(robot_id, robot_sec, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param RobotSec robot_sec: The JSON object of a robot account. (required)
        :param str x_request_id: An unique ID for the request
        :return: RobotSec
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['robot_id', 'robot_sec', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method refresh_sec" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'robot_id' is set
        if ('robot_id' not in params or
                params['robot_id'] is None):
            raise ValueError("Missing the required parameter `robot_id` when calling `refresh_sec`")  # noqa: E501
        # verify the required parameter 'robot_sec' is set
        if ('robot_sec' not in params or
                params['robot_sec'] is None):
            raise ValueError("Missing the required parameter `robot_sec` when calling `refresh_sec`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `refresh_sec`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'robot_id' in params:
            path_params['robot_id'] = params['robot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'robot_sec' in params:
            body_params = params['robot_sec']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/robots/{robot_id}', 'PATCH',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='RobotSec',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def update_robot(self, robot_id, robot, **kwargs):  # noqa: E501
        """Update a robot account  # noqa: E501

        This endpoint updates specific robot account information by robot ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_robot(robot_id, robot, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param Robot robot: The JSON object of a robot account. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.update_robot_with_http_info(robot_id, robot, **kwargs)  # noqa: E501
        else:
            (data) = self.update_robot_with_http_info(robot_id, robot, **kwargs)  # noqa: E501
            return data

    def update_robot_with_http_info(self, robot_id, robot, **kwargs):  # noqa: E501
        """Update a robot account  # noqa: E501

        This endpoint updates specific robot account information by robot ID.  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.update_robot_with_http_info(robot_id, robot, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param int robot_id: Robot ID (required)
        :param Robot robot: The JSON object of a robot account. (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['robot_id', 'robot', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method update_robot" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'robot_id' is set
        if ('robot_id' not in params or
                params['robot_id'] is None):
            raise ValueError("Missing the required parameter `robot_id` when calling `update_robot`")  # noqa: E501
        # verify the required parameter 'robot' is set
        if ('robot' not in params or
                params['robot'] is None):
            raise ValueError("Missing the required parameter `robot` when calling `update_robot`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `update_robot`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'robot_id' in params:
            path_params['robot_id'] = params['robot_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        if 'robot' in params:
            body_params = params['robot']
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/robots/{robot_id}', 'PUT',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
