# coding: utf-8

"""
    Harbor API

    These APIs provide services for manipulating Harbor project.  # noqa: E501

    OpenAPI spec version: 2.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


from __future__ import absolute_import

import re  # noqa: F401

# python 2 and python 3 compatibility library
import six

from swagger_client.api_client import ApiClient


class ScanApi(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        if api_client is None:
            api_client = ApiClient()
        self.api_client = api_client

    def get_report_log(self, project_name, repository_name, reference, report_id, **kwargs):  # noqa: E501
        """Get the log of the scan report  # noqa: E501

        Get the log of the scan report  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_log(project_name, repository_name, reference, report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str report_id: The report id to get the log (required)
        :param str x_request_id: An unique ID for the request
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.get_report_log_with_http_info(project_name, repository_name, reference, report_id, **kwargs)  # noqa: E501
        else:
            (data) = self.get_report_log_with_http_info(project_name, repository_name, reference, report_id, **kwargs)  # noqa: E501
            return data

    def get_report_log_with_http_info(self, project_name, repository_name, reference, report_id, **kwargs):  # noqa: E501
        """Get the log of the scan report  # noqa: E501

        Get the log of the scan report  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.get_report_log_with_http_info(project_name, repository_name, reference, report_id, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str report_id: The report id to get the log (required)
        :param str x_request_id: An unique ID for the request
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'report_id', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_report_log" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `get_report_log`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `get_report_log`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `get_report_log`")  # noqa: E501
        # verify the required parameter 'report_id' is set
        if ('report_id' not in params or
                params['report_id'] is None):
            raise ValueError("Missing the required parameter `report_id` when calling `get_report_log`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `get_report_log`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501
        if 'report_id' in params:
            path_params['report_id'] = params['report_id']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['text/plain'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/scan/{report_id}/log', 'GET',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type='str',  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)

    def scan_artifact(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """Scan the artifact  # noqa: E501

        Scan the specified artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.scan_artifact(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """
        kwargs['_return_http_data_only'] = True
        if kwargs.get('async_req'):
            return self.scan_artifact_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
        else:
            (data) = self.scan_artifact_with_http_info(project_name, repository_name, reference, **kwargs)  # noqa: E501
            return data

    def scan_artifact_with_http_info(self, project_name, repository_name, reference, **kwargs):  # noqa: E501
        """Scan the artifact  # noqa: E501

        Scan the specified artifact  # noqa: E501
        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please pass async_req=True
        >>> thread = api.scan_artifact_with_http_info(project_name, repository_name, reference, async_req=True)
        >>> result = thread.get()

        :param async_req bool
        :param str project_name: The name of the project (required)
        :param str repository_name: The name of the repository. If it contains slash, encode it with URL encoding. e.g. a/b -> a%252Fb (required)
        :param str reference: The reference of the artifact, can be digest or tag (required)
        :param str x_request_id: An unique ID for the request
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['project_name', 'repository_name', 'reference', 'x_request_id']  # noqa: E501
        all_params.append('async_req')
        all_params.append('_return_http_data_only')
        all_params.append('_preload_content')
        all_params.append('_request_timeout')

        params = locals()
        for key, val in six.iteritems(params['kwargs']):
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method scan_artifact" % key
                )
            params[key] = val
        del params['kwargs']
        # verify the required parameter 'project_name' is set
        if ('project_name' not in params or
                params['project_name'] is None):
            raise ValueError("Missing the required parameter `project_name` when calling `scan_artifact`")  # noqa: E501
        # verify the required parameter 'repository_name' is set
        if ('repository_name' not in params or
                params['repository_name'] is None):
            raise ValueError("Missing the required parameter `repository_name` when calling `scan_artifact`")  # noqa: E501
        # verify the required parameter 'reference' is set
        if ('reference' not in params or
                params['reference'] is None):
            raise ValueError("Missing the required parameter `reference` when calling `scan_artifact`")  # noqa: E501

        if ('x_request_id' in params and
                len(params['x_request_id']) < 1):
            raise ValueError("Invalid value for parameter `x_request_id` when calling `scan_artifact`, length must be greater than or equal to `1`")  # noqa: E501
        collection_formats = {}

        path_params = {}
        if 'project_name' in params:
            path_params['project_name'] = params['project_name']  # noqa: E501
        if 'repository_name' in params:
            path_params['repository_name'] = params['repository_name']  # noqa: E501
        if 'reference' in params:
            path_params['reference'] = params['reference']  # noqa: E501

        query_params = []

        header_params = {}
        if 'x_request_id' in params:
            header_params['X-Request-Id'] = params['x_request_id']  # noqa: E501

        form_params = []
        local_var_files = {}

        body_params = None
        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.select_header_accept(
            ['application/json'])  # noqa: E501

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.select_header_content_type(  # noqa: E501
            ['application/json'])  # noqa: E501

        # Authentication setting
        auth_settings = ['basic']  # noqa: E501

        return self.api_client.call_api(
            '/projects/{project_name}/repositories/{repository_name}/artifacts/{reference}/scan', 'POST',
            path_params,
            query_params,
            header_params,
            body=body_params,
            post_params=form_params,
            files=local_var_files,
            response_type=None,  # noqa: E501
            auth_settings=auth_settings,
            async_req=params.get('async_req'),
            _return_http_data_only=params.get('_return_http_data_only'),
            _preload_content=params.get('_preload_content', True),
            _request_timeout=params.get('_request_timeout'),
            collection_formats=collection_formats)
