# mypy: ignore-errors
# The file was automatically generated by Lark v1.1.5
__version__ = "1.1.5"

#
#
#   Lark Stand-alone Generator Tool
# ----------------------------------
# Generates a stand-alone LALR(1) parser
#
# Git:    https://github.com/erezsh/lark
# Author: Erez Shinan (erezshin@gmail.com)
#
#
#    >>> LICENSE
#
#    This tool and its generated code use a separate license from Lark,
#    and are subject to the terms of the Mozilla Public License, v. 2.0.
#    If a copy of the MPL was not distributed with this
#    file, You can obtain one at https://mozilla.org/MPL/2.0/.
#
#    If you wish to purchase a commercial license for this tool and its
#    generated code, you may contact me via email or otherwise.
#
#    If MPL2 is incompatible with your free or open-source project,
#    contact me and we'll work it out.
#
#

from abc import ABC, abstractmethod
from collections.abc import Sequence
from types import ModuleType
from typing import (
    TypeVar, Generic, Type, Tuple, List, Dict, Iterator, Collection, Callable, Optional, FrozenSet, Any,
    Union, Iterable, IO, TYPE_CHECKING, overload,
    Pattern as REPattern, ClassVar, Set, Mapping
)


class LarkError(Exception):
    pass


class ConfigurationError(LarkError, ValueError):
    pass


def assert_config(value, options: Collection, msg='Got %r, expected one of %s'):
    if value not in options:
        raise ConfigurationError(msg % (value, options))


class GrammarError(LarkError):
    pass


class ParseError(LarkError):
    pass


class LexError(LarkError):
    pass

T = TypeVar('T')

class UnexpectedInput(LarkError):
    #--
    line: int
    column: int
    pos_in_stream = None
    state: Any
    _terminals_by_name = None

    def get_context(self, text: str, span: int=40) -> str:
        #--
        assert self.pos_in_stream is not None, self
        pos = self.pos_in_stream
        start = max(pos - span, 0)
        end = pos + span
        if not isinstance(text, bytes):
            before = text[start:pos].rsplit('\n', 1)[-1]
            after = text[pos:end].split('\n', 1)[0]
            return before + after + '\n' + ' ' * len(before.expandtabs()) + '^\n'
        else:
            before = text[start:pos].rsplit(b'\n', 1)[-1]
            after = text[pos:end].split(b'\n', 1)[0]
            return (before + after + b'\n' + b' ' * len(before.expandtabs()) + b'^\n').decode("ascii", "backslashreplace")

    def match_examples(self, parse_fn: 'Callable[[str], Tree]',
                             examples: Union[Mapping[T, Iterable[str]], Iterable[Tuple[T, Iterable[str]]]],
                             token_type_match_fallback: bool=False,
                             use_accepts: bool=True
                         ) -> Optional[T]:
        #--
        assert self.state is not None, "Not supported for this exception"

        if isinstance(examples, Mapping):
            examples = examples.items()

        candidate = (None, False)
        for i, (label, example) in enumerate(examples):
            assert not isinstance(example, str), "Expecting a list"

            for j, malformed in enumerate(example):
                try:
                    parse_fn(malformed)
                except UnexpectedInput as ut:
                    if ut.state == self.state:
                        if (
                            use_accepts
                            and isinstance(self, UnexpectedToken)
                            and isinstance(ut, UnexpectedToken)
                            and ut.accepts != self.accepts
                        ):
                            logger.debug("Different accepts with same state[%d]: %s != %s at example [%s][%s]" %
                                         (self.state, self.accepts, ut.accepts, i, j))
                            continue
                        if (
                            isinstance(self, (UnexpectedToken, UnexpectedEOF))
                            and isinstance(ut, (UnexpectedToken, UnexpectedEOF))
                        ):
                            if ut.token == self.token:  ##

                                logger.debug("Exact Match at example [%s][%s]" % (i, j))
                                return label

                            if token_type_match_fallback:
                                ##

                                if (ut.token.type == self.token.type) and not candidate[-1]:
                                    logger.debug("Token Type Fallback at example [%s][%s]" % (i, j))
                                    candidate = label, True

                        if candidate[0] is None:
                            logger.debug("Same State match at example [%s][%s]" % (i, j))
                            candidate = label, False

        return candidate[0]

    def _format_expected(self, expected):
        if self._terminals_by_name:
            d = self._terminals_by_name
            expected = [d[t_name].user_repr() if t_name in d else t_name for t_name in expected]
        return "Expected one of: \n\t* %s\n" % '\n\t* '.join(expected)


class UnexpectedEOF(ParseError, UnexpectedInput):
    #--
    expected: 'List[Token]'

    def __init__(self, expected, state=None, terminals_by_name=None):
        super(UnexpectedEOF, self).__init__()

        self.expected = expected
        self.state = state
        from .lexer import Token
        self.token = Token("<EOF>", "")  ##

        self.pos_in_stream = -1
        self.line = -1
        self.column = -1
        self._terminals_by_name = terminals_by_name


    def __str__(self):
        message = "Unexpected end-of-input. "
        message += self._format_expected(self.expected)
        return message


class UnexpectedCharacters(LexError, UnexpectedInput):
    #--

    allowed: Set[str]
    considered_tokens: Set[Any]

    def __init__(self, seq, lex_pos, line, column, allowed=None, considered_tokens=None, state=None, token_history=None,
                 terminals_by_name=None, considered_rules=None):
        super(UnexpectedCharacters, self).__init__()

        ##

        self.line = line
        self.column = column
        self.pos_in_stream = lex_pos
        self.state = state
        self._terminals_by_name = terminals_by_name

        self.allowed = allowed
        self.considered_tokens = considered_tokens
        self.considered_rules = considered_rules
        self.token_history = token_history

        if isinstance(seq, bytes):
            self.char = seq[lex_pos:lex_pos + 1].decode("ascii", "backslashreplace")
        else:
            self.char = seq[lex_pos]
        self._context = self.get_context(seq)


    def __str__(self):
        message = "No terminal matches '%s' in the current parser context, at line %d col %d" % (self.char, self.line, self.column)
        message += '\n\n' + self._context
        if self.allowed:
            message += self._format_expected(self.allowed)
        if self.token_history:
            message += '\nPrevious tokens: %s\n' % ', '.join(repr(t) for t in self.token_history)
        return message


class UnexpectedToken(ParseError, UnexpectedInput):
    #--

    expected: Set[str]
    considered_rules: Set[str]
    interactive_parser: 'InteractiveParser'

    def __init__(self, token, expected, considered_rules=None, state=None, interactive_parser=None, terminals_by_name=None, token_history=None):
        super(UnexpectedToken, self).__init__()

        ##

        self.line = getattr(token, 'line', '?')
        self.column = getattr(token, 'column', '?')
        self.pos_in_stream = getattr(token, 'start_pos', None)
        self.state = state

        self.token = token
        self.expected = expected  ##

        self._accepts = NO_VALUE
        self.considered_rules = considered_rules
        self.interactive_parser = interactive_parser
        self._terminals_by_name = terminals_by_name
        self.token_history = token_history


    @property
    def accepts(self) -> Set[str]:
        if self._accepts is NO_VALUE:
            self._accepts = self.interactive_parser and self.interactive_parser.accepts()
        return self._accepts

    def __str__(self):
        message = ("Unexpected token %r at line %s, column %s.\n%s"
                   % (self.token, self.line, self.column, self._format_expected(self.accepts or self.expected)))
        if self.token_history:
            message += "Previous tokens: %r\n" % self.token_history

        return message



class VisitError(LarkError):
    #--

    obj: 'Union[Tree, Token]'
    orig_exc: Exception

    def __init__(self, rule, obj, orig_exc):
        message = 'Error trying to process rule "%s":\n\n%s' % (rule, orig_exc)
        super(VisitError, self).__init__(message)

        self.rule = rule
        self.obj = obj
        self.orig_exc = orig_exc


class MissingVariableError(LarkError):
    pass


import sys, re
import logging

logger: logging.Logger = logging.getLogger("lark")
logger.addHandler(logging.StreamHandler())
##

##

logger.setLevel(logging.CRITICAL)


NO_VALUE = object()

T = TypeVar("T")


def classify(seq: Sequence, key: Optional[Callable] = None, value: Optional[Callable] = None) -> Dict:
    d: Dict[Any, Any] = {}
    for item in seq:
        k = key(item) if (key is not None) else item
        v = value(item) if (value is not None) else item
        if k in d:
            d[k].append(v)
        else:
            d[k] = [v]
    return d


def _deserialize(data: Any, namespace: Dict[str, Any], memo: Dict) -> Any:
    if isinstance(data, dict):
        if '__type__' in data:  ##

            class_ = namespace[data['__type__']]
            return class_.deserialize(data, memo)
        elif '@' in data:
            return memo[data['@']]
        return {key:_deserialize(value, namespace, memo) for key, value in data.items()}
    elif isinstance(data, list):
        return [_deserialize(value, namespace, memo) for value in data]
    return data


_T = TypeVar("_T", bound="Serialize")

class Serialize:
    #--

    def memo_serialize(self, types_to_memoize: List) -> Any:
        memo = SerializeMemoizer(types_to_memoize)
        return self.serialize(memo), memo.serialize()

    def serialize(self, memo = None) -> Dict[str, Any]:
        if memo and memo.in_types(self):
            return {'@': memo.memoized.get(self)}

        fields = getattr(self, '__serialize_fields__')
        res = {f: _serialize(getattr(self, f), memo) for f in fields}
        res['__type__'] = type(self).__name__
        if hasattr(self, '_serialize'):
            self._serialize(res, memo)  ##

        return res

    @classmethod
    def deserialize(cls: Type[_T], data: Dict[str, Any], memo: Dict[int, Any]) -> _T:
        namespace = getattr(cls, '__serialize_namespace__', [])
        namespace = {c.__name__:c for c in namespace}

        fields = getattr(cls, '__serialize_fields__')

        if '@' in data:
            return memo[data['@']]

        inst = cls.__new__(cls)
        for f in fields:
            try:
                setattr(inst, f, _deserialize(data[f], namespace, memo))
            except KeyError as e:
                raise KeyError("Cannot find key for class", cls, e)

        if hasattr(inst, '_deserialize'):
            inst._deserialize()  ##


        return inst


class SerializeMemoizer(Serialize):
    #--

    __serialize_fields__ = 'memoized',

    def __init__(self, types_to_memoize: List) -> None:
        self.types_to_memoize = tuple(types_to_memoize)
        self.memoized = Enumerator()

    def in_types(self, value: Serialize) -> bool:
        return isinstance(value, self.types_to_memoize)

    def serialize(self) -> Dict[int, Any]:  ##

        return _serialize(self.memoized.reversed(), None)

    @classmethod
    def deserialize(cls, data: Dict[int, Any], namespace: Dict[str, Any], memo: Dict[Any, Any]) -> Dict[int, Any]:  ##

        return _deserialize(data, namespace, memo)


try:
    import regex
    _has_regex = True
except ImportError:
    _has_regex = False

if sys.version_info >= (3, 11):
    import re._parser as sre_parse
    import re._constants as sre_constants
else:
    import sre_parse
    import sre_constants

categ_pattern = re.compile(r'\\p{[A-Za-z_]+}')

def get_regexp_width(expr: str) -> Union[Tuple[int, int], List[int]]:
    if _has_regex:
        ##

        ##

        ##

        regexp_final = re.sub(categ_pattern, 'A', expr)
    else:
        if re.search(categ_pattern, expr):
            raise ImportError('`regex` module must be installed in order to use Unicode categories.', expr)
        regexp_final = expr
    try:
        ##

        return [int(x) for x in sre_parse.parse(regexp_final).getwidth()]   ##

    except sre_constants.error:
        if not _has_regex:
            raise ValueError(expr)
        else:
            ##

            ##

            c = regex.compile(regexp_final)
            if c.match('') is None:
                ##

                return 1, int(sre_constants.MAXREPEAT)
            else:
                return 0, int(sre_constants.MAXREPEAT)


from collections import OrderedDict

class Meta:

    empty: bool
    line: int
    column: int
    start_pos: int
    end_line: int
    end_column: int
    end_pos: int
    orig_expansion: 'List[TerminalDef]'
    match_tree: bool

    def __init__(self):
        self.empty = True


_Leaf_T = TypeVar("_Leaf_T")
Branch = Union[_Leaf_T, 'Tree[_Leaf_T]']


class Tree(Generic[_Leaf_T]):
    #--

    data: str
    children: 'List[Branch[_Leaf_T]]'

    def __init__(self, data: str, children: 'List[Branch[_Leaf_T]]', meta: Optional[Meta]=None) -> None:
        self.data = data
        self.children = children
        self._meta = meta

    @property
    def meta(self) -> Meta:
        if self._meta is None:
            self._meta = Meta()
        return self._meta

    def __repr__(self):
        return 'Tree(%r, %r)' % (self.data, self.children)

    def _pretty_label(self):
        return self.data

    def _pretty(self, level, indent_str):
        yield f'{indent_str*level}{self._pretty_label()}'
        if len(self.children) == 1 and not isinstance(self.children[0], Tree):
            yield f'\t{self.children[0]}\n'
        else:
            yield '\n'
            for n in self.children:
                if isinstance(n, Tree):
                    yield from n._pretty(level+1, indent_str)
                else:
                    yield f'{indent_str*(level+1)}{n}\n'

    def pretty(self, indent_str: str='  ') -> str:
        #--
        return ''.join(self._pretty(0, indent_str))

    def __rich__(self, parent:'rich.tree.Tree'=None) -> 'rich.tree.Tree':
        #--
        return self._rich(parent)

    def _rich(self, parent):
        if parent:
            tree = parent.add(f'[bold]{self.data}[/bold]')
        else:
            import rich.tree
            tree = rich.tree.Tree(self.data)

        for c in self.children:
            if isinstance(c, Tree):
                c._rich(tree)
            else:
                tree.add(f'[green]{c}[/green]')

        return tree

    def __eq__(self, other):
        try:
            return self.data == other.data and self.children == other.children
        except AttributeError:
            return False

    def __ne__(self, other):
        return not (self == other)

    def __hash__(self) -> int:
        return hash((self.data, tuple(self.children)))

    def iter_subtrees(self) -> 'Iterator[Tree[_Leaf_T]]':
        #--
        queue = [self]
        subtrees = OrderedDict()
        for subtree in queue:
            subtrees[id(subtree)] = subtree
            ##

            queue += [c for c in reversed(subtree.children)  ##

                      if isinstance(c, Tree) and id(c) not in subtrees]

        del queue
        return reversed(list(subtrees.values()))

    def iter_subtrees_topdown(self):
        #--
        stack = [self]
        stack_append = stack.append
        stack_pop = stack.pop
        while stack:
            node = stack_pop()
            if not isinstance(node, Tree):
                continue
            yield node
            for child in reversed(node.children):
                stack_append(child)

    def find_pred(self, pred: 'Callable[[Tree[_Leaf_T]], bool]') -> 'Iterator[Tree[_Leaf_T]]':
        #--
        return filter(pred, self.iter_subtrees())

    def find_data(self, data: str) -> 'Iterator[Tree[_Leaf_T]]':
        #--
        return self.find_pred(lambda t: t.data == data)


from functools import wraps, update_wrapper
from inspect import getmembers, getmro

_Return_T = TypeVar('_Return_T')
_Return_V = TypeVar('_Return_V')
_Leaf_T = TypeVar('_Leaf_T')
_Leaf_U = TypeVar('_Leaf_U')
_R = TypeVar('_R')
_FUNC = Callable[..., _Return_T]
_DECORATED = Union[_FUNC, type]

class _DiscardType:
    #--

    def __repr__(self):
        return "lark.visitors.Discard"

Discard = _DiscardType()

##


class _Decoratable:
    #--

    @classmethod
    def _apply_v_args(cls, visit_wrapper):
        mro = getmro(cls)
        assert mro[0] is cls
        libmembers = {name for _cls in mro[1:] for name, _ in getmembers(_cls)}
        for name, value in getmembers(cls):

            ##

            if name.startswith('_') or (name in libmembers and name not in cls.__dict__):
                continue
            if not callable(value):
                continue

            ##

            if isinstance(cls.__dict__[name], _VArgsWrapper):
                continue

            setattr(cls, name, _VArgsWrapper(cls.__dict__[name], visit_wrapper))
        return cls

    def __class_getitem__(cls, _):
        return cls


class Transformer(_Decoratable, ABC, Generic[_Leaf_T, _Return_T]):
    #--
    __visit_tokens__ = True   ##


    def __init__(self,  visit_tokens: bool=True) -> None:
        self.__visit_tokens__ = visit_tokens

    def _call_userfunc(self, tree, new_children=None):
        ##

        children = new_children if new_children is not None else tree.children
        try:
            f = getattr(self, tree.data)
        except AttributeError:
            return self.__default__(tree.data, children, tree.meta)
        else:
            try:
                wrapper = getattr(f, 'visit_wrapper', None)
                if wrapper is not None:
                    return f.visit_wrapper(f, tree.data, children, tree.meta)
                else:
                    return f(children)
            except GrammarError:
                raise
            except Exception as e:
                raise VisitError(tree.data, tree, e)

    def _call_userfunc_token(self, token):
        try:
            f = getattr(self, token.type)
        except AttributeError:
            return self.__default_token__(token)
        else:
            try:
                return f(token)
            except GrammarError:
                raise
            except Exception as e:
                raise VisitError(token.type, token, e)

    def _transform_children(self, children):
        for c in children:
            if isinstance(c, Tree):
                res = self._transform_tree(c)
            elif self.__visit_tokens__ and isinstance(c, Token):
                res = self._call_userfunc_token(c)
            else:
                res = c

            if res is not Discard:
                yield res

    def _transform_tree(self, tree):
        children = list(self._transform_children(tree.children))
        return self._call_userfunc(tree, children)

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        #--
        return self._transform_tree(tree)

    def __mul__(
            self: 'Transformer[_Leaf_T, Tree[_Leaf_U]]',
            other: 'Union[Transformer[_Leaf_U, _Return_V], TransformerChain[_Leaf_U, _Return_V,]]'
    ) -> 'TransformerChain[_Leaf_T, _Return_V]':
        #--
        return TransformerChain(self, other)

    def __default__(self, data, children, meta):
        #--
        return Tree(data, children, meta)

    def __default_token__(self, token):
        #--
        return token


def merge_transformers(base_transformer=None, **transformers_to_merge):
    #--
    if base_transformer is None:
        base_transformer = Transformer()
    for prefix, transformer in transformers_to_merge.items():
        for method_name in dir(transformer):
            method = getattr(transformer, method_name)
            if not callable(method):
                continue
            if method_name.startswith("_") or method_name == "transform":
                continue
            prefixed_method = prefix + "__" + method_name
            if hasattr(base_transformer, prefixed_method):
                raise AttributeError("Cannot merge: method '%s' appears more than once" % prefixed_method)

            setattr(base_transformer, prefixed_method, method)

    return base_transformer


class InlineTransformer(Transformer):   ##

    def _call_userfunc(self, tree, new_children=None):
        ##

        children = new_children if new_children is not None else tree.children
        try:
            f = getattr(self, tree.data)
        except AttributeError:
            return self.__default__(tree.data, children, tree.meta)
        else:
            return f(*children)


class TransformerChain(Generic[_Leaf_T, _Return_T]):

    transformers: 'Tuple[Union[Transformer, TransformerChain], ...]'

    def __init__(self, *transformers: 'Union[Transformer, TransformerChain]') -> None:
        self.transformers = transformers

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        for t in self.transformers:
            tree = t.transform(tree)
        return cast(_Return_T, tree)

    def __mul__(
            self: 'TransformerChain[_Leaf_T, Tree[_Leaf_U]]',
            other: 'Union[Transformer[_Leaf_U, _Return_V], TransformerChain[_Leaf_U, _Return_V]]'
    ) -> 'TransformerChain[_Leaf_T, _Return_V]':
        return TransformerChain(*self.transformers + (other,))


class Transformer_InPlace(Transformer):
    #--
    def _transform_tree(self, tree):           ##

        return self._call_userfunc(tree)

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        for subtree in tree.iter_subtrees():
            subtree.children = list(self._transform_children(subtree.children))

        return self._transform_tree(tree)


class Transformer_NonRecursive(Transformer):
    #--

    def transform(self, tree: Tree[_Leaf_T]) -> _Return_T:
        ##

        rev_postfix = []
        q: List[Branch[_Leaf_T]] = [tree]
        while q:
            t = q.pop()
            rev_postfix.append(t)
            if isinstance(t, Tree):
                q += t.children

        ##

        stack: List = []
        for x in reversed(rev_postfix):
            if isinstance(x, Tree):
                size = len(x.children)
                if size:
                    args = stack[-size:]
                    del stack[-size:]
                else:
                    args = []

                res = self._call_userfunc(x, args)
                if res is not Discard:
                    stack.append(res)

            elif self.__visit_tokens__ and isinstance(x, Token):
                res = self._call_userfunc_token(x)
                if res is not Discard:
                    stack.append(res)
            else:
                stack.append(x)

        result, = stack  ##

        ##

        ##

        ##

        return cast(_Return_T, result)


class Transformer_InPlaceRecursive(Transformer):
    #--
    def _transform_tree(self, tree):
        tree.children = list(self._transform_children(tree.children))
        return self._call_userfunc(tree)


##


class VisitorBase:
    def _call_userfunc(self, tree):
        return getattr(self, tree.data, self.__default__)(tree)

    def __default__(self, tree):
        #--
        return tree

    def __class_getitem__(cls, _):
        return cls


class Visitor(VisitorBase, ABC, Generic[_Leaf_T]):
    #--

    def visit(self, tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        for subtree in tree.iter_subtrees():
            self._call_userfunc(subtree)
        return tree

    def visit_topdown(self, tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        for subtree in tree.iter_subtrees_topdown():
            self._call_userfunc(subtree)
        return tree


class Visitor_Recursive(VisitorBase, Generic[_Leaf_T]):
    #--

    def visit(self, tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        for child in tree.children:
            if isinstance(child, Tree):
                self.visit(child)

        self._call_userfunc(tree)
        return tree

    def visit_topdown(self,tree: Tree[_Leaf_T]) -> Tree[_Leaf_T]:
        #--
        self._call_userfunc(tree)

        for child in tree.children:
            if isinstance(child, Tree):
                self.visit_topdown(child)

        return tree


class Interpreter(_Decoratable, ABC, Generic[_Leaf_T, _Return_T]):
    #--

    def visit(self, tree: Tree[_Leaf_T]) -> _Return_T:
        ##

        ##

        ##

        return self._visit_tree(tree)

    def _visit_tree(self, tree: Tree[_Leaf_T]):
        f = getattr(self, tree.data)
        wrapper = getattr(f, 'visit_wrapper', None)
        if wrapper is not None:
            return f.visit_wrapper(f, tree.data, tree.children, tree.meta)
        else:
            return f(tree)

    def visit_children(self, tree: Tree[_Leaf_T]) -> List:
        return [self._visit_tree(child) if isinstance(child, Tree) else child
                for child in tree.children]

    def __getattr__(self, name):
        return self.__default__

    def __default__(self, tree):
        return self.visit_children(tree)


_InterMethod = Callable[[Type[Interpreter], _Return_T], _R]

def visit_children_decor(func: _InterMethod) -> _InterMethod:
    #--
    @wraps(func)
    def inner(cls, tree):
        values = cls.visit_children(tree)
        return func(cls, values)
    return inner

##


def _apply_v_args(obj, visit_wrapper):
    try:
        _apply = obj._apply_v_args
    except AttributeError:
        return _VArgsWrapper(obj, visit_wrapper)
    else:
        return _apply(visit_wrapper)


class _VArgsWrapper:
    #--
    base_func: Callable

    def __init__(self, func: Callable, visit_wrapper: Callable[[Callable, str, list, Any], Any]):
        if isinstance(func, _VArgsWrapper):
            func = func.base_func
        ##

        self.base_func = func  ##

        self.visit_wrapper = visit_wrapper
        update_wrapper(self, func)

    def __call__(self, *args, **kwargs):
        return self.base_func(*args, **kwargs)

    def __get__(self, instance, owner=None):
        try:
            ##

            ##

            g = type(self.base_func).__get__
        except AttributeError:
            return self
        else:
            return _VArgsWrapper(g(self.base_func, instance, owner), self.visit_wrapper)

    def __set_name__(self, owner, name):
        try:
            f = type(self.base_func).__set_name__
        except AttributeError:
            return
        else:
            f(self.base_func, owner, name)


def _vargs_inline(f, _data, children, _meta):
    return f(*children)
def _vargs_meta_inline(f, _data, children, meta):
    return f(meta, *children)
def _vargs_meta(f, _data, children, meta):
    return f(meta, children)
def _vargs_tree(f, data, children, meta):
    return f(Tree(data, children, meta))


def v_args(inline: bool = False, meta: bool = False, tree: bool = False, wrapper: Optional[Callable] = None) -> Callable[[_DECORATED], _DECORATED]:
    #--
    if tree and (meta or inline):
        raise ValueError("Visitor functions cannot combine 'tree' with 'meta' or 'inline'.")

    func = None
    if meta:
        if inline:
            func = _vargs_meta_inline
        else:
            func = _vargs_meta
    elif inline:
        func = _vargs_inline
    elif tree:
        func = _vargs_tree

    if wrapper is not None:
        if func is not None:
            raise ValueError("Cannot use 'wrapper' along with 'tree', 'meta' or 'inline'.")
        func = wrapper

    def _visitor_args_dec(obj):
        return _apply_v_args(obj, func)
    return _visitor_args_dec



TOKEN_DEFAULT_PRIORITY = 0


class Symbol(Serialize):
    __slots__ = ('name',)

    name: str
    is_term: ClassVar[bool] = NotImplemented

    def __init__(self, name: str) -> None:
        self.name = name

    def __eq__(self, other):
        assert isinstance(other, Symbol), other
        return self.is_term == other.is_term and self.name == other.name

    def __ne__(self, other):
        return not (self == other)

    def __hash__(self):
        return hash(self.name)

    def __repr__(self):
        return '%s(%r)' % (type(self).__name__, self.name)

    fullrepr = property(__repr__)

    def renamed(self, f):
        return type(self)(f(self.name))


class Terminal(Symbol):
    __serialize_fields__ = 'name', 'filter_out'

    is_term: ClassVar[bool] = True

    def __init__(self, name, filter_out=False):
        self.name = name
        self.filter_out = filter_out

    @property
    def fullrepr(self):
        return '%s(%r, %r)' % (type(self).__name__, self.name, self.filter_out)

    def renamed(self, f):
        return type(self)(f(self.name), self.filter_out)


class NonTerminal(Symbol):
    __serialize_fields__ = 'name',

    is_term: ClassVar[bool] = False


class RuleOptions(Serialize):
    __serialize_fields__ = 'keep_all_tokens', 'expand1', 'priority', 'template_source', 'empty_indices'

    keep_all_tokens: bool
    expand1: bool
    priority: Optional[int]
    template_source: Optional[str]
    empty_indices: Tuple[bool, ...]

    def __init__(self, keep_all_tokens: bool=False, expand1: bool=False, priority: Optional[int]=None, template_source: Optional[str]=None, empty_indices: Tuple[bool, ...]=()) -> None:
        self.keep_all_tokens = keep_all_tokens
        self.expand1 = expand1
        self.priority = priority
        self.template_source = template_source
        self.empty_indices = empty_indices

    def __repr__(self):
        return 'RuleOptions(%r, %r, %r, %r)' % (
            self.keep_all_tokens,
            self.expand1,
            self.priority,
            self.template_source
        )


class Rule(Serialize):
    #--
    __slots__ = ('origin', 'expansion', 'alias', 'options', 'order', '_hash')

    __serialize_fields__ = 'origin', 'expansion', 'order', 'alias', 'options'
    __serialize_namespace__ = Terminal, NonTerminal, RuleOptions

    def __init__(self, origin, expansion, order=0, alias=None, options=None):
        self.origin = origin
        self.expansion = expansion
        self.alias = alias
        self.order = order
        self.options = options or RuleOptions()
        self._hash = hash((self.origin, tuple(self.expansion)))

    def _deserialize(self):
        self._hash = hash((self.origin, tuple(self.expansion)))

    def __str__(self):
        return '<%s : %s>' % (self.origin.name, ' '.join(x.name for x in self.expansion))

    def __repr__(self):
        return 'Rule(%r, %r, %r, %r)' % (self.origin, self.expansion, self.alias, self.options)

    def __hash__(self):
        return self._hash

    def __eq__(self, other):
        if not isinstance(other, Rule):
            return False
        return self.origin == other.origin and self.expansion == other.expansion



from copy import copy


class Pattern(Serialize, ABC):

    value: str
    flags: Collection[str]
    raw: Optional[str]
    type: ClassVar[str]

    def __init__(self, value: str, flags: Collection[str]=(), raw: Optional[str]=None) -> None:
        self.value = value
        self.flags = frozenset(flags)
        self.raw = raw

    def __repr__(self):
        return repr(self.to_regexp())

    ##

    def __hash__(self):
        return hash((type(self), self.value, self.flags))

    def __eq__(self, other):
        return type(self) == type(other) and self.value == other.value and self.flags == other.flags

    @abstractmethod
    def to_regexp(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def min_width(self) -> int:
        raise NotImplementedError()

    @property
    @abstractmethod
    def max_width(self) -> int:
        raise NotImplementedError()

    def _get_flags(self, value):
        for f in self.flags:
            value = ('(?%s:%s)' % (f, value))
        return value


class PatternStr(Pattern):
    __serialize_fields__ = 'value', 'flags'

    type: ClassVar[str] = "str"

    def to_regexp(self) -> str:
        return self._get_flags(re.escape(self.value))

    @property
    def min_width(self) -> int:
        return len(self.value)

    @property
    def max_width(self) -> int:
        return len(self.value)


class PatternRE(Pattern):
    __serialize_fields__ = 'value', 'flags', '_width'

    type: ClassVar[str] = "re"

    def to_regexp(self) -> str:
        return self._get_flags(self.value)

    _width = None
    def _get_width(self):
        if self._width is None:
            self._width = get_regexp_width(self.to_regexp())
        return self._width

    @property
    def min_width(self) -> int:
        return self._get_width()[0]

    @property
    def max_width(self) -> int:
        return self._get_width()[1]


class TerminalDef(Serialize):
    __serialize_fields__ = 'name', 'pattern', 'priority'
    __serialize_namespace__ = PatternStr, PatternRE

    name: str
    pattern: Pattern
    priority: int

    def __init__(self, name: str, pattern: Pattern, priority: int=TOKEN_DEFAULT_PRIORITY) -> None:
        assert isinstance(pattern, Pattern), pattern
        self.name = name
        self.pattern = pattern
        self.priority = priority

    def __repr__(self):
        return '%s(%r, %r)' % (type(self).__name__, self.name, self.pattern)

    def user_repr(self) -> str:
        if self.name.startswith('__'): ##

            return self.pattern.raw or self.name
        else:
            return self.name

_T = TypeVar('_T', bound="Token")

class Token(str):
    #--
    __slots__ = ('type', 'start_pos', 'value', 'line', 'column', 'end_line', 'end_column', 'end_pos')

    __match_args__ = ('type', 'value')

    type: str
    start_pos: Optional[int]
    value: Any
    line: Optional[int]
    column: Optional[int]
    end_line: Optional[int]
    end_column: Optional[int]
    end_pos: Optional[int]


    @overload
    def __new__(
        cls,
        type: str,
        value: Any,
        start_pos: Optional[int]=None,
        line: Optional[int]=None,
        column: Optional[int]=None,
        end_line: Optional[int]=None,
        end_column: Optional[int]=None,
        end_pos: Optional[int]=None
    ) -> 'Token':
        ...

    @overload
    def __new__(
        cls,
        type_: str,
        value: Any,
        start_pos: Optional[int]=None,
        line: Optional[int]=None,
        column: Optional[int]=None,
        end_line: Optional[int]=None,
        end_column: Optional[int]=None,
        end_pos: Optional[int]=None
    ) -> 'Token':        ...

    def __new__(cls, *args, **kwargs):
        if "type_" in kwargs:
            warnings.warn("`type_` is deprecated use `type` instead", DeprecationWarning)

            if "type" in kwargs:
                raise TypeError("Error: using both 'type' and the deprecated 'type_' as arguments.")
            kwargs["type"] = kwargs.pop("type_")

        return cls._future_new(*args, **kwargs)


    @classmethod
    def _future_new(cls, type, value, start_pos=None, line=None, column=None, end_line=None, end_column=None, end_pos=None):
        inst = super(Token, cls).__new__(cls, value)

        inst.type = type
        inst.start_pos = start_pos
        inst.value = value
        inst.line = line
        inst.column = column
        inst.end_line = end_line
        inst.end_column = end_column
        inst.end_pos = end_pos
        return inst

    @overload
    def update(self, type: Optional[str]=None, value: Optional[Any]=None) -> 'Token':
        ...

    @overload
    def update(self, type_: Optional[str]=None, value: Optional[Any]=None) -> 'Token':
        ...

    def update(self, *args, **kwargs):
        if "type_" in kwargs:
            warnings.warn("`type_` is deprecated use `type` instead", DeprecationWarning)

            if "type" in kwargs:
                raise TypeError("Error: using both 'type' and the deprecated 'type_' as arguments.")
            kwargs["type"] = kwargs.pop("type_")

        return self._future_update(*args, **kwargs)

    def _future_update(self, type: Optional[str]=None, value: Optional[Any]=None) -> 'Token':
        return Token.new_borrow_pos(
            type if type is not None else self.type,
            value if value is not None else self.value,
            self
        )

    @classmethod
    def new_borrow_pos(cls: Type[_T], type_: str, value: Any, borrow_t: 'Token') -> _T:
        return cls(type_, value, borrow_t.start_pos, borrow_t.line, borrow_t.column, borrow_t.end_line, borrow_t.end_column, borrow_t.end_pos)

    def __reduce__(self):
        return (self.__class__, (self.type, self.value, self.start_pos, self.line, self.column))

    def __repr__(self):
        return 'Token(%r, %r)' % (self.type, self.value)

    def __deepcopy__(self, memo):
        return Token(self.type, self.value, self.start_pos, self.line, self.column)

    def __eq__(self, other):
        if isinstance(other, Token) and self.type != other.type:
            return False

        return str.__eq__(self, other)

    __hash__ = str.__hash__


class LineCounter:
    __slots__ = 'char_pos', 'line', 'column', 'line_start_pos', 'newline_char'

    def __init__(self, newline_char):
        self.newline_char = newline_char
        self.char_pos = 0
        self.line = 1
        self.column = 1
        self.line_start_pos = 0

    def __eq__(self, other):
        if not isinstance(other, LineCounter):
            return NotImplemented

        return self.char_pos == other.char_pos and self.newline_char == other.newline_char

    def feed(self, token: Token, test_newline=True):
        #--
        if test_newline:
            newlines = token.count(self.newline_char)
            if newlines:
                self.line += newlines
                self.line_start_pos = self.char_pos + token.rindex(self.newline_char) + 1

        self.char_pos += len(token)
        self.column = self.char_pos - self.line_start_pos + 1


class UnlessCallback:
    def __init__(self, scanner):
        self.scanner = scanner

    def __call__(self, t):
        res = self.scanner.match(t.value, 0)
        if res:
            _value, t.type = res
        return t


class CallChain:
    def __init__(self, callback1, callback2, cond):
        self.callback1 = callback1
        self.callback2 = callback2
        self.cond = cond

    def __call__(self, t):
        t2 = self.callback1(t)
        return self.callback2(t) if self.cond(t2) else t2


def _get_match(re_, regexp, s, flags):
    m = re_.match(regexp, s, flags)
    if m:
        return m.group(0)

def _create_unless(terminals, g_regex_flags, re_, use_bytes):
    tokens_by_type = classify(terminals, lambda t: type(t.pattern))
    assert len(tokens_by_type) <= 2, tokens_by_type.keys()
    embedded_strs = set()
    callback = {}
    for retok in tokens_by_type.get(PatternRE, []):
        unless = []
        for strtok in tokens_by_type.get(PatternStr, []):
            if strtok.priority != retok.priority:
                continue
            s = strtok.pattern.value
            if s == _get_match(re_, retok.pattern.to_regexp(), s, g_regex_flags):
                unless.append(strtok)
                if strtok.pattern.flags <= retok.pattern.flags:
                    embedded_strs.add(strtok)
        if unless:
            callback[retok.name] = UnlessCallback(Scanner(unless, g_regex_flags, re_, match_whole=True, use_bytes=use_bytes))

    new_terminals = [t for t in terminals if t not in embedded_strs]
    return new_terminals, callback


class Scanner:
    def __init__(self, terminals, g_regex_flags, re_, use_bytes, match_whole=False):
        self.terminals = terminals
        self.g_regex_flags = g_regex_flags
        self.re_ = re_
        self.use_bytes = use_bytes
        self.match_whole = match_whole

        self.allowed_types = {t.name for t in self.terminals}

        self._mres = self._build_mres(terminals, len(terminals))

    def _build_mres(self, terminals, max_size):
        ##

        ##

        ##

        postfix = '$' if self.match_whole else ''
        mres = []
        while terminals:
            pattern = u'|'.join(u'(?P<%s>%s)' % (t.name, t.pattern.to_regexp() + postfix) for t in terminals[:max_size])
            if self.use_bytes:
                pattern = pattern.encode('latin-1')
            try:
                mre = self.re_.compile(pattern, self.g_regex_flags)
            except AssertionError:  ##

                return self._build_mres(terminals, max_size//2)

            mres.append(mre)
            terminals = terminals[max_size:]
        return mres

    def match(self, text, pos):
        for mre in self._mres:
            m = mre.match(text, pos)
            if m:
                return m.group(0), m.lastgroup


def _regexp_has_newline(r: str):
    #--
    return '\n' in r or '\\n' in r or '\\s' in r or '[^' in r or ('(?s' in r and '.' in r)


class LexerState:
    #--

    __slots__ = 'text', 'line_ctr', 'last_token'

    def __init__(self, text, line_ctr=None, last_token=None):
        self.text = text
        self.line_ctr = line_ctr or LineCounter(b'\n' if isinstance(text, bytes) else '\n')
        self.last_token = last_token

    def __eq__(self, other):
        if not isinstance(other, LexerState):
            return NotImplemented

        return self.text is other.text and self.line_ctr == other.line_ctr and self.last_token == other.last_token

    def __copy__(self):
        return type(self)(self.text, copy(self.line_ctr), self.last_token)


class LexerThread:
    #--

    def __init__(self, lexer: 'Lexer', lexer_state: LexerState):
        self.lexer = lexer
        self.state = lexer_state

    @classmethod
    def from_text(cls, lexer: 'Lexer', text: str):
        return cls(lexer, LexerState(text))

    def lex(self, parser_state):
        return self.lexer.lex(self.state, parser_state)

    def __copy__(self):
        return type(self)(self.lexer, copy(self.state))

    _Token = Token


_Callback = Callable[[Token], Token]

class Lexer(ABC):
    #--
    @abstractmethod
    def lex(self, lexer_state: LexerState, parser_state: Any) -> Iterator[Token]:
        return NotImplemented

    def make_lexer_state(self, text):
        #--
        return LexerState(text)


class BasicLexer(Lexer):

    terminals: Collection[TerminalDef]
    ignore_types: FrozenSet[str]
    newline_types: FrozenSet[str]
    user_callbacks: Dict[str, _Callback]
    callback: Dict[str, _Callback]
    re: ModuleType

    def __init__(self, conf: 'LexerConf') -> None:
        terminals = list(conf.terminals)
        assert all(isinstance(t, TerminalDef) for t in terminals), terminals

        self.re = conf.re_module

        if not conf.skip_validation:
            ##

            for t in terminals:
                try:
                    self.re.compile(t.pattern.to_regexp(), conf.g_regex_flags)
                except self.re.error:
                    raise LexError("Cannot compile token %s: %s" % (t.name, t.pattern))

                if t.pattern.min_width == 0:
                    raise LexError("Lexer does not allow zero-width terminals. (%s: %s)" % (t.name, t.pattern))

            if not (set(conf.ignore) <= {t.name for t in terminals}):
                raise LexError("Ignore terminals are not defined: %s" % (set(conf.ignore) - {t.name for t in terminals}))

        ##

        self.newline_types = frozenset(t.name for t in terminals if _regexp_has_newline(t.pattern.to_regexp()))
        self.ignore_types = frozenset(conf.ignore)

        terminals.sort(key=lambda x: (-x.priority, -x.pattern.max_width, -len(x.pattern.value), x.name))
        self.terminals = terminals
        self.user_callbacks = conf.callbacks
        self.g_regex_flags = conf.g_regex_flags
        self.use_bytes = conf.use_bytes
        self.terminals_by_name = conf.terminals_by_name

        self._scanner = None

    def _build_scanner(self):
        terminals, self.callback = _create_unless(self.terminals, self.g_regex_flags, self.re, self.use_bytes)
        assert all(self.callback.values())

        for type_, f in self.user_callbacks.items():
            if type_ in self.callback:
                ##

                self.callback[type_] = CallChain(self.callback[type_], f, lambda t: t.type == type_)
            else:
                self.callback[type_] = f

        self._scanner = Scanner(terminals, self.g_regex_flags, self.re, self.use_bytes)

    @property
    def scanner(self):
        if self._scanner is None:
            self._build_scanner()
        return self._scanner

    def match(self, text, pos):
        return self.scanner.match(text, pos)

    def lex(self, state: LexerState, parser_state: Any) -> Iterator[Token]:
        with suppress(EOFError):
            while True:
                yield self.next_token(state, parser_state)

    def next_token(self, lex_state: LexerState, parser_state: Any=None) -> Token:
        line_ctr = lex_state.line_ctr
        while line_ctr.char_pos < len(lex_state.text):
            res = self.match(lex_state.text, line_ctr.char_pos)
            if not res:
                allowed = self.scanner.allowed_types - self.ignore_types
                if not allowed:
                    allowed = {"<END-OF-FILE>"}
                raise UnexpectedCharacters(lex_state.text, line_ctr.char_pos, line_ctr.line, line_ctr.column,
                                           allowed=allowed, token_history=lex_state.last_token and [lex_state.last_token],
                                           state=parser_state, terminals_by_name=self.terminals_by_name)

            value, type_ = res

            if type_ not in self.ignore_types:
                t = Token(type_, value, line_ctr.char_pos, line_ctr.line, line_ctr.column)
                line_ctr.feed(value, type_ in self.newline_types)
                t.end_line = line_ctr.line
                t.end_column = line_ctr.column
                t.end_pos = line_ctr.char_pos
                if t.type in self.callback:
                    t = self.callback[t.type](t)
                    if not isinstance(t, Token):
                        raise LexError("Callbacks must return a token (returned %r)" % t)
                lex_state.last_token = t
                return t
            else:
                if type_ in self.callback:
                    t2 = Token(type_, value, line_ctr.char_pos, line_ctr.line, line_ctr.column)
                    self.callback[type_](t2)
                line_ctr.feed(value, type_ in self.newline_types)

        ##

        raise EOFError(self)


class ContextualLexer(Lexer):

    lexers: Dict[str, BasicLexer]
    root_lexer: BasicLexer

    def __init__(self, conf: 'LexerConf', states: Dict[str, Collection[str]], always_accept: Collection[str]=()) -> None:
        terminals = list(conf.terminals)
        terminals_by_name = conf.terminals_by_name

        trad_conf = copy(conf)
        trad_conf.terminals = terminals

        lexer_by_tokens: Dict[FrozenSet[str], BasicLexer] = {}
        self.lexers = {}
        for state, accepts in states.items():
            key = frozenset(accepts)
            try:
                lexer = lexer_by_tokens[key]
            except KeyError:
                accepts = set(accepts) | set(conf.ignore) | set(always_accept)
                lexer_conf = copy(trad_conf)
                lexer_conf.terminals = [terminals_by_name[n] for n in accepts if n in terminals_by_name]
                lexer = BasicLexer(lexer_conf)
                lexer_by_tokens[key] = lexer

            self.lexers[state] = lexer

        assert trad_conf.terminals is terminals
        self.root_lexer = BasicLexer(trad_conf)

    def lex(self, lexer_state: LexerState, parser_state: Any) -> Iterator[Token]:
        try:
            while True:
                lexer = self.lexers[parser_state.position]
                yield lexer.next_token(lexer_state, parser_state)
        except EOFError:
            pass
        except UnexpectedCharacters as e:
            ##

            ##

            try:
                last_token = lexer_state.last_token  ##

                token = self.root_lexer.next_token(lexer_state, parser_state)
                raise UnexpectedToken(token, e.allowed, state=parser_state, token_history=[last_token], terminals_by_name=self.root_lexer.terminals_by_name)
            except UnexpectedCharacters:
                raise e  ##




_ParserArgType: 'TypeAlias' = 'Literal["earley", "lalr", "cyk", "auto"]'
_LexerArgType: 'TypeAlias' = 'Union[Literal["auto", "basic", "contextual", "dynamic", "dynamic_complete"], Type[Lexer]]'
_Callback = Callable[[Token], Token]

class LexerConf(Serialize):
    __serialize_fields__ = 'terminals', 'ignore', 'g_regex_flags', 'use_bytes', 'lexer_type'
    __serialize_namespace__ = TerminalDef,

    terminals: Collection[TerminalDef]
    re_module: ModuleType
    ignore: Collection[str]
    postlex: 'Optional[PostLex]'
    callbacks: Dict[str, _Callback]
    g_regex_flags: int
    skip_validation: bool
    use_bytes: bool
    lexer_type: Optional[_LexerArgType]

    def __init__(self, terminals: Collection[TerminalDef], re_module: ModuleType, ignore: Collection[str]=(), postlex: 'Optional[PostLex]'=None, callbacks: Optional[Dict[str, _Callback]]=None, g_regex_flags: int=0, skip_validation: bool=False, use_bytes: bool=False):
        self.terminals = terminals
        self.terminals_by_name = {t.name: t for t in self.terminals}
        assert len(self.terminals) == len(self.terminals_by_name)
        self.ignore = ignore
        self.postlex = postlex
        self.callbacks = callbacks or {}
        self.g_regex_flags = g_regex_flags
        self.re_module = re_module
        self.skip_validation = skip_validation
        self.use_bytes = use_bytes
        self.lexer_type = None

    def _deserialize(self):
        self.terminals_by_name = {t.name: t for t in self.terminals}

    def __deepcopy__(self, memo=None):
        return type(self)(
            deepcopy(self.terminals, memo),
            self.re_module,
            deepcopy(self.ignore, memo),
            deepcopy(self.postlex, memo),
            deepcopy(self.callbacks, memo),
            deepcopy(self.g_regex_flags, memo),
            deepcopy(self.skip_validation, memo),
            deepcopy(self.use_bytes, memo),
        )


class ParserConf(Serialize):
    __serialize_fields__ = 'rules', 'start', 'parser_type'

    def __init__(self, rules, callbacks, start):
        assert isinstance(start, list)
        self.rules = rules
        self.callbacks = callbacks
        self.start = start

        self.parser_type = None


from functools import partial, wraps
from itertools import product


class ExpandSingleChild:
    def __init__(self, node_builder):
        self.node_builder = node_builder

    def __call__(self, children):
        if len(children) == 1:
            return children[0]
        else:
            return self.node_builder(children)



class PropagatePositions:
    def __init__(self, node_builder, node_filter=None):
        self.node_builder = node_builder
        self.node_filter = node_filter

    def __call__(self, children):
        res = self.node_builder(children)

        if isinstance(res, Tree):
            ##

            ##

            ##

            ##


            res_meta = res.meta

            first_meta = self._pp_get_meta(children)
            if first_meta is not None:
                if not hasattr(res_meta, 'line'):
                    ##

                    res_meta.line = getattr(first_meta, 'container_line', first_meta.line)
                    res_meta.column = getattr(first_meta, 'container_column', first_meta.column)
                    res_meta.start_pos = getattr(first_meta, 'container_start_pos', first_meta.start_pos)
                    res_meta.empty = False

                res_meta.container_line = getattr(first_meta, 'container_line', first_meta.line)
                res_meta.container_column = getattr(first_meta, 'container_column', first_meta.column)

            last_meta = self._pp_get_meta(reversed(children))
            if last_meta is not None:
                if not hasattr(res_meta, 'end_line'):
                    res_meta.end_line = getattr(last_meta, 'container_end_line', last_meta.end_line)
                    res_meta.end_column = getattr(last_meta, 'container_end_column', last_meta.end_column)
                    res_meta.end_pos = getattr(last_meta, 'container_end_pos', last_meta.end_pos)
                    res_meta.empty = False

                res_meta.container_end_line = getattr(last_meta, 'container_end_line', last_meta.end_line)
                res_meta.container_end_column = getattr(last_meta, 'container_end_column', last_meta.end_column)

        return res

    def _pp_get_meta(self, children):
        for c in children:
            if self.node_filter is not None and not self.node_filter(c):
                continue
            if isinstance(c, Tree):
                if not c.meta.empty:
                    return c.meta
            elif isinstance(c, Token):
                return c
            elif hasattr(c, '__lark_meta__'):
                return c.__lark_meta__()

def make_propagate_positions(option):
    if callable(option):
        return partial(PropagatePositions, node_filter=option)
    elif option is True:
        return PropagatePositions
    elif option is False:
        return None

    raise ConfigurationError('Invalid option for propagate_positions: %r' % option)


class ChildFilter:
    def __init__(self, to_include, append_none, node_builder):
        self.node_builder = node_builder
        self.to_include = to_include
        self.append_none = append_none

    def __call__(self, children):
        filtered = []

        for i, to_expand, add_none in self.to_include:
            if add_none:
                filtered += [None] * add_none
            if to_expand:
                filtered += children[i].children
            else:
                filtered.append(children[i])

        if self.append_none:
            filtered += [None] * self.append_none

        return self.node_builder(filtered)


class ChildFilterLALR(ChildFilter):
    #--

    def __call__(self, children):
        filtered = []
        for i, to_expand, add_none in self.to_include:
            if add_none:
                filtered += [None] * add_none
            if to_expand:
                if filtered:
                    filtered += children[i].children
                else:   ##

                    filtered = children[i].children
            else:
                filtered.append(children[i])

        if self.append_none:
            filtered += [None] * self.append_none

        return self.node_builder(filtered)


class ChildFilterLALR_NoPlaceholders(ChildFilter):
    #--
    def __init__(self, to_include, node_builder):
        self.node_builder = node_builder
        self.to_include = to_include

    def __call__(self, children):
        filtered = []
        for i, to_expand in self.to_include:
            if to_expand:
                if filtered:
                    filtered += children[i].children
                else:   ##

                    filtered = children[i].children
            else:
                filtered.append(children[i])
        return self.node_builder(filtered)


def _should_expand(sym):
    return not sym.is_term and sym.name.startswith('_')


def maybe_create_child_filter(expansion, keep_all_tokens, ambiguous, _empty_indices: List[bool]):
    ##

    if _empty_indices:
        assert _empty_indices.count(False) == len(expansion)
        s = ''.join(str(int(b)) for b in _empty_indices)
        empty_indices = [len(ones) for ones in s.split('0')]
        assert len(empty_indices) == len(expansion)+1, (empty_indices, len(expansion))
    else:
        empty_indices = [0] * (len(expansion)+1)

    to_include = []
    nones_to_add = 0
    for i, sym in enumerate(expansion):
        nones_to_add += empty_indices[i]
        if keep_all_tokens or not (sym.is_term and sym.filter_out):
            to_include.append((i, _should_expand(sym), nones_to_add))
            nones_to_add = 0

    nones_to_add += empty_indices[len(expansion)]

    if _empty_indices or len(to_include) < len(expansion) or any(to_expand for i, to_expand,_ in to_include):
        if _empty_indices or ambiguous:
            return partial(ChildFilter if ambiguous else ChildFilterLALR, to_include, nones_to_add)
        else:
            ##

            return partial(ChildFilterLALR_NoPlaceholders, [(i, x) for i,x,_ in to_include])


class AmbiguousExpander:
    #--
    def __init__(self, to_expand, tree_class, node_builder):
        self.node_builder = node_builder
        self.tree_class = tree_class
        self.to_expand = to_expand

    def __call__(self, children):
        def _is_ambig_tree(t):
            return hasattr(t, 'data') and t.data == '_ambig'

        ##

        ##

        ##

        ##

        ambiguous = []
        for i, child in enumerate(children):
            if _is_ambig_tree(child):
                if i in self.to_expand:
                    ambiguous.append(i)

                child.expand_kids_by_data('_ambig')

        if not ambiguous:
            return self.node_builder(children)

        expand = [child.children if i in ambiguous else (child,) for i, child in enumerate(children)]
        return self.tree_class('_ambig', [self.node_builder(list(f)) for f in product(*expand)])


def maybe_create_ambiguous_expander(tree_class, expansion, keep_all_tokens):
    to_expand = [i for i, sym in enumerate(expansion)
                 if keep_all_tokens or ((not (sym.is_term and sym.filter_out)) and _should_expand(sym))]
    if to_expand:
        return partial(AmbiguousExpander, to_expand, tree_class)


class AmbiguousIntermediateExpander:
    #--

    def __init__(self, tree_class, node_builder):
        self.node_builder = node_builder
        self.tree_class = tree_class

    def __call__(self, children):
        def _is_iambig_tree(child):
            return hasattr(child, 'data') and child.data == '_iambig'

        def _collapse_iambig(children):
            #--

            ##

            ##

            if children and _is_iambig_tree(children[0]):
                iambig_node = children[0]
                result = []
                for grandchild in iambig_node.children:
                    collapsed = _collapse_iambig(grandchild.children)
                    if collapsed:
                        for child in collapsed:
                            child.children += children[1:]
                        result += collapsed
                    else:
                        new_tree = self.tree_class('_inter', grandchild.children + children[1:])
                        result.append(new_tree)
                return result

        collapsed = _collapse_iambig(children)
        if collapsed:
            processed_nodes = [self.node_builder(c.children) for c in collapsed]
            return self.tree_class('_ambig', processed_nodes)

        return self.node_builder(children)



def inplace_transformer(func):
    @wraps(func)
    def f(children):
        ##

        tree = Tree(func.__name__, children)
        return func(tree)
    return f


def apply_visit_wrapper(func, name, wrapper):
    if wrapper is _vargs_meta or wrapper is _vargs_meta_inline:
        raise NotImplementedError("Meta args not supported for internal transformer")

    @wraps(func)
    def f(children):
        return wrapper(func, name, children, None)
    return f


class ParseTreeBuilder:
    def __init__(self, rules, tree_class, propagate_positions=False, ambiguous=False, maybe_placeholders=False):
        self.tree_class = tree_class
        self.propagate_positions = propagate_positions
        self.ambiguous = ambiguous
        self.maybe_placeholders = maybe_placeholders

        self.rule_builders = list(self._init_builders(rules))

    def _init_builders(self, rules):
        propagate_positions = make_propagate_positions(self.propagate_positions)

        for rule in rules:
            options = rule.options
            keep_all_tokens = options.keep_all_tokens
            expand_single_child = options.expand1

            wrapper_chain = list(filter(None, [
                (expand_single_child and not rule.alias) and ExpandSingleChild,
                maybe_create_child_filter(rule.expansion, keep_all_tokens, self.ambiguous, options.empty_indices if self.maybe_placeholders else None),
                propagate_positions,
                self.ambiguous and maybe_create_ambiguous_expander(self.tree_class, rule.expansion, keep_all_tokens),
                self.ambiguous and partial(AmbiguousIntermediateExpander, self.tree_class)
            ]))

            yield rule, wrapper_chain

    def create_callback(self, transformer=None):
        callbacks = {}

        default_handler = getattr(transformer, '__default__', None)
        if default_handler:
            def default_callback(data, children):
                return default_handler(data, children, None)
        else:
            default_callback = self.tree_class

        for rule, wrapper_chain in self.rule_builders:

            user_callback_name = rule.alias or rule.options.template_source or rule.origin.name
            try:
                f = getattr(transformer, user_callback_name)
                wrapper = getattr(f, 'visit_wrapper', None)
                if wrapper is not None:
                    f = apply_visit_wrapper(f, user_callback_name, wrapper)
                elif isinstance(transformer, Transformer_InPlace):
                    f = inplace_transformer(f)
            except AttributeError:
                f = partial(default_callback, user_callback_name)

            for w in wrapper_chain:
                f = w(f)

            if rule in callbacks:
                raise GrammarError("Rule '%s' already exists" % (rule,))

            callbacks[rule] = f

        return callbacks



class LALR_Parser(Serialize):
    def __init__(self, parser_conf, debug=False):
        analysis = LALR_Analyzer(parser_conf, debug=debug)
        analysis.compute_lalr()
        callbacks = parser_conf.callbacks

        self._parse_table = analysis.parse_table
        self.parser_conf = parser_conf
        self.parser = _Parser(analysis.parse_table, callbacks, debug)

    @classmethod
    def deserialize(cls, data, memo, callbacks, debug=False):
        inst = cls.__new__(cls)
        inst._parse_table = IntParseTable.deserialize(data, memo)
        inst.parser = _Parser(inst._parse_table, callbacks, debug)
        return inst

    def serialize(self, memo: Any = None) -> Dict[str, Any]:
        return self._parse_table.serialize(memo)

    def parse_interactive(self, lexer, start):
        return self.parser.parse(lexer, start, start_interactive=True)

    def parse(self, lexer, start, on_error=None):
        try:
            return self.parser.parse(lexer, start)
        except UnexpectedInput as e:
            if on_error is None:
                raise

            while True:
                if isinstance(e, UnexpectedCharacters):
                    s = e.interactive_parser.lexer_thread.state
                    p = s.line_ctr.char_pos

                if not on_error(e):
                    raise e

                if isinstance(e, UnexpectedCharacters):
                    ##

                    if p == s.line_ctr.char_pos:
                        s.line_ctr.feed(s.text[p:p+1])

                try:
                    return e.interactive_parser.resume_parse()
                except UnexpectedToken as e2:
                    if (isinstance(e, UnexpectedToken)
                        and e.token.type == e2.token.type == '$END'
                        and e.interactive_parser == e2.interactive_parser):
                        ##

                        raise e2
                    e = e2
                except UnexpectedCharacters as e2:
                    e = e2


class ParseConf:
    __slots__ = 'parse_table', 'callbacks', 'start', 'start_state', 'end_state', 'states'

    def __init__(self, parse_table, callbacks, start):
        self.parse_table = parse_table

        self.start_state = self.parse_table.start_states[start]
        self.end_state = self.parse_table.end_states[start]
        self.states = self.parse_table.states

        self.callbacks = callbacks
        self.start = start


class ParserState:
    __slots__ = 'parse_conf', 'lexer', 'state_stack', 'value_stack'

    def __init__(self, parse_conf, lexer, state_stack=None, value_stack=None):
        self.parse_conf = parse_conf
        self.lexer = lexer
        self.state_stack = state_stack or [self.parse_conf.start_state]
        self.value_stack = value_stack or []

    @property
    def position(self):
        return self.state_stack[-1]

    ##

    def __eq__(self, other):
        if not isinstance(other, ParserState):
            return NotImplemented
        return len(self.state_stack) == len(other.state_stack) and self.position == other.position

    def __copy__(self):
        return type(self)(
            self.parse_conf,
            self.lexer, ##

            copy(self.state_stack),
            deepcopy(self.value_stack),
        )

    def copy(self):
        return copy(self)

    def feed_token(self, token, is_end=False):
        state_stack = self.state_stack
        value_stack = self.value_stack
        states = self.parse_conf.states
        end_state = self.parse_conf.end_state
        callbacks = self.parse_conf.callbacks

        while True:
            state = state_stack[-1]
            try:
                action, arg = states[state][token.type]
            except KeyError:
                expected = {s for s in states[state].keys() if s.isupper()}
                raise UnexpectedToken(token, expected, state=self, interactive_parser=None)

            assert arg != end_state

            if action is Shift:
                ##

                assert not is_end
                state_stack.append(arg)
                value_stack.append(token if token.type not in callbacks else callbacks[token.type](token))
                return
            else:
                ##

                rule = arg
                size = len(rule.expansion)
                if size:
                    s = value_stack[-size:]
                    del state_stack[-size:]
                    del value_stack[-size:]
                else:
                    s = []

                value = callbacks[rule](s)

                _action, new_state = states[state_stack[-1]][rule.origin.name]
                assert _action is Shift
                state_stack.append(new_state)
                value_stack.append(value)

                if is_end and state_stack[-1] == end_state:
                    return value_stack[-1]

class _Parser:
    def __init__(self, parse_table, callbacks, debug=False):
        self.parse_table = parse_table
        self.callbacks = callbacks
        self.debug = debug

    def parse(self, lexer, start, value_stack=None, state_stack=None, start_interactive=False):
        parse_conf = ParseConf(self.parse_table, self.callbacks, start)
        parser_state = ParserState(parse_conf, lexer, state_stack, value_stack)
        if start_interactive:
            return InteractiveParser(self, parser_state, parser_state.lexer)
        return self.parse_from_state(parser_state)


    def parse_from_state(self, state, last_token=None):
        #--
        try:
            token = last_token
            for token in state.lexer.lex(state):
                state.feed_token(token)

            end_token = Token.new_borrow_pos('$END', '', token) if token else Token('$END', '', 0, 1, 1)
            return state.feed_token(end_token, True)
        except UnexpectedInput as e:
            try:
                e.interactive_parser = InteractiveParser(self, state, state.lexer)
            except NameError:
                pass
            raise e
        except Exception as e:
            if self.debug:
                print("")
                print("STATE STACK DUMP")
                print("----------------")
                for i, s in enumerate(state.state_stack):
                    print('%d)' % i , s)
                print("")

            raise


class Action:
    def __init__(self, name):
        self.name = name
    def __str__(self):
        return self.name
    def __repr__(self):
        return str(self)

Shift = Action('Shift')
Reduce = Action('Reduce')


class ParseTable:
    def __init__(self, states, start_states, end_states):
        self.states = states
        self.start_states = start_states
        self.end_states = end_states

    def serialize(self, memo):
        tokens = Enumerator()

        states = {
            state: {tokens.get(token): ((1, arg.serialize(memo)) if action is Reduce else (0, arg))
                    for token, (action, arg) in actions.items()}
            for state, actions in self.states.items()
        }

        return {
            'tokens': tokens.reversed(),
            'states': states,
            'start_states': self.start_states,
            'end_states': self.end_states,
        }

    @classmethod
    def deserialize(cls, data, memo):
        tokens = data['tokens']
        states = {
            state: {tokens[token]: ((Reduce, Rule.deserialize(arg, memo)) if action==1 else (Shift, arg))
                    for token, (action, arg) in actions.items()}
            for state, actions in data['states'].items()
        }
        return cls(states, data['start_states'], data['end_states'])


class IntParseTable(ParseTable):

    @classmethod
    def from_ParseTable(cls, parse_table):
        enum = list(parse_table.states)
        state_to_idx = {s:i for i,s in enumerate(enum)}
        int_states = {}

        for s, la in parse_table.states.items():
            la = {k:(v[0], state_to_idx[v[1]]) if v[0] is Shift else v
                  for k,v in la.items()}
            int_states[ state_to_idx[s] ] = la


        start_states = {start:state_to_idx[s] for start, s in parse_table.start_states.items()}
        end_states = {start:state_to_idx[s] for start, s in parse_table.end_states.items()}
        return cls(int_states, start_states, end_states)



def _wrap_lexer(lexer_class):
    future_interface = getattr(lexer_class, '__future_interface__', False)
    if future_interface:
        return lexer_class
    else:
        class CustomLexerWrapper(Lexer):
            def __init__(self, lexer_conf):
                self.lexer = lexer_class(lexer_conf)
            def lex(self, lexer_state, parser_state):
                return self.lexer.lex(lexer_state.text)
        return CustomLexerWrapper


def _deserialize_parsing_frontend(data, memo, lexer_conf, callbacks, options):
    parser_conf = ParserConf.deserialize(data['parser_conf'], memo)
    cls = (options and options._plugins.get('LALR_Parser')) or LALR_Parser
    parser = cls.deserialize(data['parser'], memo, callbacks, options.debug)
    parser_conf.callbacks = callbacks
    return ParsingFrontend(lexer_conf, parser_conf, options, parser=parser)


_parser_creators: 'Dict[str, Callable[[LexerConf, Any, Any], Any]]' = {}


class ParsingFrontend(Serialize):
    __serialize_fields__ = 'lexer_conf', 'parser_conf', 'parser'

    def __init__(self, lexer_conf, parser_conf, options, parser=None):
        self.parser_conf = parser_conf
        self.lexer_conf = lexer_conf
        self.options = options

        ##

        if parser:  ##

            self.parser = parser
        else:
            create_parser = _parser_creators.get(parser_conf.parser_type)
            assert create_parser is not None, "{} is not supported in standalone mode".format(
                    parser_conf.parser_type
                )
            self.parser = create_parser(lexer_conf, parser_conf, options)

        ##

        lexer_type = lexer_conf.lexer_type
        self.skip_lexer = False
        if lexer_type in ('dynamic', 'dynamic_complete'):
            assert lexer_conf.postlex is None
            self.skip_lexer = True
            return

        try:
            create_lexer = {
                'basic': create_basic_lexer,
                'contextual': create_contextual_lexer,
            }[lexer_type]
        except KeyError:
            assert issubclass(lexer_type, Lexer), lexer_type
            self.lexer = _wrap_lexer(lexer_type)(lexer_conf)
        else:
            self.lexer = create_lexer(lexer_conf, self.parser, lexer_conf.postlex, options)

        if lexer_conf.postlex:
            self.lexer = PostLexConnector(self.lexer, lexer_conf.postlex)

    def _verify_start(self, start=None):
        if start is None:
            start_decls = self.parser_conf.start
            if len(start_decls) > 1:
                raise ConfigurationError("Lark initialized with more than 1 possible start rule. Must specify which start rule to parse", start_decls)
            start ,= start_decls
        elif start not in self.parser_conf.start:
            raise ConfigurationError("Unknown start rule %s. Must be one of %r" % (start, self.parser_conf.start))
        return start

    def _make_lexer_thread(self, text):
        cls = (self.options and self.options._plugins.get('LexerThread')) or LexerThread
        return text if self.skip_lexer else cls.from_text(self.lexer, text)

    def parse(self, text, start=None, on_error=None):
        chosen_start = self._verify_start(start)
        kw = {} if on_error is None else {'on_error': on_error}
        stream = self._make_lexer_thread(text)
        return self.parser.parse(stream, chosen_start, **kw)

    def parse_interactive(self, text=None, start=None):
        chosen_start = self._verify_start(start)
        if self.parser_conf.parser_type != 'lalr':
            raise ConfigurationError("parse_interactive() currently only works with parser='lalr' ")
        stream = self._make_lexer_thread(text)
        return self.parser.parse_interactive(stream, chosen_start)


def _validate_frontend_args(parser, lexer) -> None:
    assert_config(parser, ('lalr', 'earley', 'cyk'))
    if not isinstance(lexer, type):     ##

        expected = {
            'lalr': ('basic', 'contextual'),
            'earley': ('basic', 'dynamic', 'dynamic_complete'),
            'cyk': ('basic', ),
         }[parser]
        assert_config(lexer, expected, 'Parser %r does not support lexer %%r, expected one of %%s' % parser)


def _get_lexer_callbacks(transformer, terminals):
    result = {}
    for terminal in terminals:
        callback = getattr(transformer, terminal.name, None)
        if callback is not None:
            result[terminal.name] = callback
    return result

class PostLexConnector:
    def __init__(self, lexer, postlexer):
        self.lexer = lexer
        self.postlexer = postlexer

    def lex(self, lexer_state, parser_state):
        i = self.lexer.lex(lexer_state, parser_state)
        return self.postlexer.process(i)



def create_basic_lexer(lexer_conf, parser, postlex, options):
    cls = (options and options._plugins.get('BasicLexer')) or BasicLexer
    return cls(lexer_conf)

def create_contextual_lexer(lexer_conf, parser, postlex, options):
    cls = (options and options._plugins.get('ContextualLexer')) or ContextualLexer
    states = {idx:list(t.keys()) for idx, t in parser._parse_table.states.items()}
    always_accept = postlex.always_accept if postlex else ()
    return cls(lexer_conf, states, always_accept=always_accept)

def create_lalr_parser(lexer_conf, parser_conf, options=None):
    debug = options.debug if options else False
    cls = (options and options._plugins.get('LALR_Parser')) or LALR_Parser
    return cls(parser_conf, debug=debug)

_parser_creators['lalr'] = create_lalr_parser




class PostLex(ABC):
    @abstractmethod
    def process(self, stream: Iterator[Token]) -> Iterator[Token]:
        return stream

    always_accept: Iterable[str] = ()

class LarkOptions(Serialize):
    #--

    start: List[str]
    debug: bool
    transformer: 'Optional[Transformer]'
    propagate_positions: Union[bool, str]
    maybe_placeholders: bool
    cache: Union[bool, str]
    regex: bool
    g_regex_flags: int
    keep_all_tokens: bool
    tree_class: Any
    parser: _ParserArgType
    lexer: _LexerArgType
    ambiguity: 'Literal["auto", "resolve", "explicit", "forest"]'
    postlex: Optional[PostLex]
    priority: 'Optional[Literal["auto", "normal", "invert"]]'
    lexer_callbacks: Dict[str, Callable[[Token], Token]]
    use_bytes: bool
    edit_terminals: Optional[Callable[[TerminalDef], TerminalDef]]
    import_paths: 'List[Union[str, Callable[[Union[None, str, PackageResource], str], Tuple[str, str]]]]'
    source_path: Optional[str]

    OPTIONS_DOC = """
    **===  General Options  ===**

    start
            The start symbol. Either a string, or a list of strings for multiple possible starts (Default: "start")
    debug
            Display debug information and extra warnings. Use only when debugging (Default: ``False``)
            When used with Earley, it generates a forest graph as "sppf.png", if 'dot' is installed.
    transformer
            Applies the transformer to every parse tree (equivalent to applying it after the parse, but faster)
    propagate_positions
            Propagates (line, column, end_line, end_column) attributes into all tree branches.
            Accepts ``False``, ``True``, or a callable, which will filter which nodes to ignore when propagating.
    maybe_placeholders
            When ``True``, the ``[]`` operator returns ``None`` when not matched.
            When ``False``,  ``[]`` behaves like the ``?`` operator, and returns no value at all.
            (default= ``True``)
    cache
            Cache the results of the Lark grammar analysis, for x2 to x3 faster loading. LALR only for now.

            - When ``False``, does nothing (default)
            - When ``True``, caches to a temporary file in the local directory
            - When given a string, caches to the path pointed by the string
    regex
            When True, uses the ``regex`` module instead of the stdlib ``re``.
    g_regex_flags
            Flags that are applied to all terminals (both regex and strings)
    keep_all_tokens
            Prevent the tree builder from automagically removing "punctuation" tokens (Default: ``False``)
    tree_class
            Lark will produce trees comprised of instances of this class instead of the default ``lark.Tree``.

    **=== Algorithm Options ===**

    parser
            Decides which parser engine to use. Accepts "earley" or "lalr". (Default: "earley").
            (there is also a "cyk" option for legacy)
    lexer
            Decides whether or not to use a lexer stage

            - "auto" (default): Choose for me based on the parser
            - "basic": Use a basic lexer
            - "contextual": Stronger lexer (only works with parser="lalr")
            - "dynamic": Flexible and powerful (only with parser="earley")
            - "dynamic_complete": Same as dynamic, but tries *every* variation of tokenizing possible.
    ambiguity
            Decides how to handle ambiguity in the parse. Only relevant if parser="earley"

            - "resolve": The parser will automatically choose the simplest derivation
              (it chooses consistently: greedy for tokens, non-greedy for rules)
            - "explicit": The parser will return all derivations wrapped in "_ambig" tree nodes (i.e. a forest).
            - "forest": The parser will return the root of the shared packed parse forest.

    **=== Misc. / Domain Specific Options ===**

    postlex
            Lexer post-processing (Default: ``None``) Only works with the basic and contextual lexers.
    priority
            How priorities should be evaluated - "auto", ``None``, "normal", "invert" (Default: "auto")
    lexer_callbacks
            Dictionary of callbacks for the lexer. May alter tokens during lexing. Use with caution.
    use_bytes
            Accept an input of type ``bytes`` instead of ``str``.
    edit_terminals
            A callback for editing the terminals before parse.
    import_paths
            A List of either paths or loader functions to specify from where grammars are imported
    source_path
            Override the source of from where the grammar was loaded. Useful for relative imports and unconventional grammar loading
    **=== End of Options ===**
    """
    if __doc__:
        __doc__ += OPTIONS_DOC


    ##

    ##

    ##

    ##

    ##

    ##

    _defaults: Dict[str, Any] = {
        'debug': False,
        'keep_all_tokens': False,
        'tree_class': None,
        'cache': False,
        'postlex': None,
        'parser': 'earley',
        'lexer': 'auto',
        'transformer': None,
        'start': 'start',
        'priority': 'auto',
        'ambiguity': 'auto',
        'regex': False,
        'propagate_positions': False,
        'lexer_callbacks': {},
        'maybe_placeholders': True,
        'edit_terminals': None,
        'g_regex_flags': 0,
        'use_bytes': False,
        'import_paths': [],
        'source_path': None,
        '_plugins': {},
    }

    def __init__(self, options_dict: Dict[str, Any]) -> None:
        o = dict(options_dict)

        options = {}
        for name, default in self._defaults.items():
            if name in o:
                value = o.pop(name)
                if isinstance(default, bool) and name not in ('cache', 'use_bytes', 'propagate_positions'):
                    value = bool(value)
            else:
                value = default

            options[name] = value

        if isinstance(options['start'], str):
            options['start'] = [options['start']]

        self.__dict__['options'] = options


        assert_config(self.parser, ('earley', 'lalr', 'cyk', None))

        if self.parser == 'earley' and self.transformer:
            raise ConfigurationError('Cannot specify an embedded transformer when using the Earley algorithm. '
                             'Please use your transformer on the resulting parse tree, or use a different algorithm (i.e. LALR)')

        if o:
            raise ConfigurationError("Unknown options: %s" % o.keys())

    def __getattr__(self, name: str) -> Any:
        try:
            return self.__dict__['options'][name]
        except KeyError as e:
            raise AttributeError(e)

    def __setattr__(self, name: str, value: str) -> None:
        assert_config(name, self.options.keys(), "%r isn't a valid option. Expected one of: %s")
        self.options[name] = value

    def serialize(self, memo = None) -> Dict[str, Any]:
        return self.options

    @classmethod
    def deserialize(cls, data: Dict[str, Any], memo: Dict[int, Union[TerminalDef, Rule]]) -> "LarkOptions":
        return cls(data)


##

##

_LOAD_ALLOWED_OPTIONS = {'postlex', 'transformer', 'lexer_callbacks', 'use_bytes', 'debug', 'g_regex_flags', 'regex', 'propagate_positions', 'tree_class', '_plugins'}

_VALID_PRIORITY_OPTIONS = ('auto', 'normal', 'invert', None)
_VALID_AMBIGUITY_OPTIONS = ('auto', 'resolve', 'explicit', 'forest')


_T = TypeVar('_T', bound="Lark")

class Lark(Serialize):
    #--

    source_path: str
    source_grammar: str
    grammar: 'Grammar'
    options: LarkOptions
    lexer: Lexer
    terminals: Collection[TerminalDef]

    def __init__(self, grammar: 'Union[Grammar, str, IO[str]]', **options) -> None:
        self.options = LarkOptions(options)
        re_module: types.ModuleType

        ##

        use_regex = self.options.regex
        if use_regex:
            if _has_regex:
                re_module = regex
            else:
                raise ImportError('`regex` module must be installed if calling `Lark(regex=True)`.')
        else:
            re_module = re

        ##

        if self.options.source_path is None:
            try:
                self.source_path = grammar.name  ##

            except AttributeError:
                self.source_path = '<string>'
        else:
            self.source_path = self.options.source_path

        ##

        try:
            read = grammar.read  ##

        except AttributeError:
            pass
        else:
            grammar = read()

        cache_fn = None
        cache_md5 = None
        if isinstance(grammar, str):
            self.source_grammar = grammar
            if self.options.use_bytes:
                if not isascii(grammar):
                    raise ConfigurationError("Grammar must be ascii only, when use_bytes=True")

            if self.options.cache:
                if self.options.parser != 'lalr':
                    raise ConfigurationError("cache only works with parser='lalr' for now")

                unhashable = ('transformer', 'postlex', 'lexer_callbacks', 'edit_terminals', '_plugins')
                options_str = ''.join(k+str(v) for k, v in options.items() if k not in unhashable)
                from . import __version__
                s = grammar + options_str + __version__ + str(sys.version_info[:2])
                cache_md5 = md5_digest(s)

                if isinstance(self.options.cache, str):
                    cache_fn = self.options.cache
                else:
                    if self.options.cache is not True:
                        raise ConfigurationError("cache argument must be bool or str")

                    try:
                        username = getpass.getuser()
                    except Exception:
                        ##

                        ##

                        ##

                        username = "unknown"

                    cache_fn = tempfile.gettempdir() + "/.lark_cache_%s_%s_%s_%s.tmp" % (username, cache_md5, *sys.version_info[:2])

                old_options = self.options
                try:
                    with FS.open(cache_fn, 'rb') as f:
                        logger.debug('Loading grammar from cache: %s', cache_fn)
                        ##

                        for name in (set(options) - _LOAD_ALLOWED_OPTIONS):
                            del options[name]
                        file_md5 = f.readline().rstrip(b'\n')
                        cached_used_files = pickle.load(f)
                        if file_md5 == cache_md5.encode('utf8') and verify_used_files(cached_used_files):
                            cached_parser_data = pickle.load(f)
                            self._load(cached_parser_data, **options)
                            return
                except FileNotFoundError:
                    ##

                    pass
                except Exception: ##

                    logger.exception("Failed to load Lark from cache: %r. We will try to carry on.", cache_fn)

                    ##

                    ##

                    self.options = old_options


            ##

            self.grammar, used_files = load_grammar(grammar, self.source_path, self.options.import_paths, self.options.keep_all_tokens)
        else:
            assert isinstance(grammar, Grammar)
            self.grammar = grammar


        if self.options.lexer == 'auto':
            if self.options.parser == 'lalr':
                self.options.lexer = 'contextual'
            elif self.options.parser == 'earley':
                if self.options.postlex is not None:
                    logger.info("postlex can't be used with the dynamic lexer, so we use 'basic' instead. "
                                "Consider using lalr with contextual instead of earley")
                    self.options.lexer = 'basic'
                else:
                    self.options.lexer = 'dynamic'
            elif self.options.parser == 'cyk':
                self.options.lexer = 'basic'
            else:
                assert False, self.options.parser
        lexer = self.options.lexer
        if isinstance(lexer, type):
            assert issubclass(lexer, Lexer)     ##

        else:
            assert_config(lexer, ('basic', 'contextual', 'dynamic', 'dynamic_complete'))
            if self.options.postlex is not None and 'dynamic' in lexer:
                raise ConfigurationError("Can't use postlex with a dynamic lexer. Use basic or contextual instead")

        if self.options.ambiguity == 'auto':
            if self.options.parser == 'earley':
                self.options.ambiguity = 'resolve'
        else:
            assert_config(self.options.parser, ('earley', 'cyk'), "%r doesn't support disambiguation. Use one of these parsers instead: %s")

        if self.options.priority == 'auto':
            self.options.priority = 'normal'

        if self.options.priority not in _VALID_PRIORITY_OPTIONS:
            raise ConfigurationError("invalid priority option: %r. Must be one of %r" % (self.options.priority, _VALID_PRIORITY_OPTIONS))
        if self.options.ambiguity not in _VALID_AMBIGUITY_OPTIONS:
            raise ConfigurationError("invalid ambiguity option: %r. Must be one of %r" % (self.options.ambiguity, _VALID_AMBIGUITY_OPTIONS))

        if self.options.parser is None:
            terminals_to_keep = '*'
        elif self.options.postlex is not None:
            terminals_to_keep = set(self.options.postlex.always_accept)
        else:
            terminals_to_keep = set()

        ##

        self.terminals, self.rules, self.ignore_tokens = self.grammar.compile(self.options.start, terminals_to_keep)

        if self.options.edit_terminals:
            for t in self.terminals:
                self.options.edit_terminals(t)

        self._terminals_dict = {t.name: t for t in self.terminals}

        ##

        if self.options.priority == 'invert':
            for rule in self.rules:
                if rule.options.priority is not None:
                    rule.options.priority = -rule.options.priority
            for term in self.terminals:
                term.priority = -term.priority
        ##

        ##

        ##

        elif self.options.priority is None:
            for rule in self.rules:
                if rule.options.priority is not None:
                    rule.options.priority = None
            for term in self.terminals:
                term.priority = 0

        ##

        self.lexer_conf = LexerConf(
                self.terminals, re_module, self.ignore_tokens, self.options.postlex,
                self.options.lexer_callbacks, self.options.g_regex_flags, use_bytes=self.options.use_bytes
            )

        if self.options.parser:
            self.parser = self._build_parser()
        elif lexer:
            self.lexer = self._build_lexer()

        if cache_fn:
            logger.debug('Saving grammar to cache: %s', cache_fn)
            try:
                with FS.open(cache_fn, 'wb') as f:
                    assert cache_md5 is not None
                    f.write(cache_md5.encode('utf8') + b'\n')
                    pickle.dump(used_files, f)
                    self.save(f, _LOAD_ALLOWED_OPTIONS)
            except IOError as e:
                logger.exception("Failed to save Lark to cache: %r.", cache_fn, e)

    if __doc__:
        __doc__ += "\n\n" + LarkOptions.OPTIONS_DOC

    __serialize_fields__ = 'parser', 'rules', 'options'

    def _build_lexer(self, dont_ignore: bool=False) -> BasicLexer:
        lexer_conf = self.lexer_conf
        if dont_ignore:
            from copy import copy
            lexer_conf = copy(lexer_conf)
            lexer_conf.ignore = ()
        return BasicLexer(lexer_conf)

    def _prepare_callbacks(self) -> None:
        self._callbacks = {}
        ##

        if self.options.ambiguity != 'forest':
            self._parse_tree_builder = ParseTreeBuilder(
                    self.rules,
                    self.options.tree_class or Tree,
                    self.options.propagate_positions,
                    self.options.parser != 'lalr' and self.options.ambiguity == 'explicit',
                    self.options.maybe_placeholders
                )
            self._callbacks = self._parse_tree_builder.create_callback(self.options.transformer)
        self._callbacks.update(_get_lexer_callbacks(self.options.transformer, self.terminals))

    def _build_parser(self) -> "ParsingFrontend":
        self._prepare_callbacks()
        _validate_frontend_args(self.options.parser, self.options.lexer)
        parser_conf = ParserConf(self.rules, self._callbacks, self.options.start)
        return _construct_parsing_frontend(
            self.options.parser,
            self.options.lexer,
            self.lexer_conf,
            parser_conf,
            options=self.options
        )

    def save(self, f, exclude_options: Collection[str] = ()) -> None:
        #--
        data, m = self.memo_serialize([TerminalDef, Rule])
        if exclude_options:
            data["options"] = {n: v for n, v in data["options"].items() if n not in exclude_options}
        pickle.dump({'data': data, 'memo': m}, f, protocol=pickle.HIGHEST_PROTOCOL)

    @classmethod
    def load(cls: Type[_T], f) -> _T:
        #--
        inst = cls.__new__(cls)
        return inst._load(f)

    def _deserialize_lexer_conf(self, data: Dict[str, Any], memo: Dict[int, Union[TerminalDef, Rule]], options: LarkOptions) -> LexerConf:
        lexer_conf = LexerConf.deserialize(data['lexer_conf'], memo)
        lexer_conf.callbacks = options.lexer_callbacks or {}
        lexer_conf.re_module = regex if options.regex else re
        lexer_conf.use_bytes = options.use_bytes
        lexer_conf.g_regex_flags = options.g_regex_flags
        lexer_conf.skip_validation = True
        lexer_conf.postlex = options.postlex
        return lexer_conf

    def _load(self: _T, f: Any, **kwargs) -> _T:
        if isinstance(f, dict):
            d = f
        else:
            d = pickle.load(f)
        memo_json = d['memo']
        data = d['data']

        assert memo_json
        memo = SerializeMemoizer.deserialize(memo_json, {'Rule': Rule, 'TerminalDef': TerminalDef}, {})
        options = dict(data['options'])
        if (set(kwargs) - _LOAD_ALLOWED_OPTIONS) & set(LarkOptions._defaults):
            raise ConfigurationError("Some options are not allowed when loading a Parser: {}"
                             .format(set(kwargs) - _LOAD_ALLOWED_OPTIONS))
        options.update(kwargs)
        self.options = LarkOptions.deserialize(options, memo)
        self.rules = [Rule.deserialize(r, memo) for r in data['rules']]
        self.source_path = '<deserialized>'
        _validate_frontend_args(self.options.parser, self.options.lexer)
        self.lexer_conf = self._deserialize_lexer_conf(data['parser'], memo, self.options)
        self.terminals = self.lexer_conf.terminals
        self._prepare_callbacks()
        self._terminals_dict = {t.name: t for t in self.terminals}
        self.parser = _deserialize_parsing_frontend(
            data['parser'],
            memo,
            self.lexer_conf,
            self._callbacks,
            self.options,  ##

        )
        return self

    @classmethod
    def _load_from_dict(cls, data, memo, **kwargs):
        inst = cls.__new__(cls)
        return inst._load({'data': data, 'memo': memo}, **kwargs)

    @classmethod
    def open(cls: Type[_T], grammar_filename: str, rel_to: Optional[str]=None, **options) -> _T:
        #--
        if rel_to:
            basepath = os.path.dirname(rel_to)
            grammar_filename = os.path.join(basepath, grammar_filename)
        with open(grammar_filename, encoding='utf8') as f:
            return cls(f, **options)

    @classmethod
    def open_from_package(cls: Type[_T], package: str, grammar_path: str, search_paths: 'Sequence[str]'=[""], **options) -> _T:
        #--
        package_loader = FromPackageLoader(package, search_paths)
        full_path, text = package_loader(None, grammar_path)
        options.setdefault('source_path', full_path)
        options.setdefault('import_paths', [])
        options['import_paths'].append(package_loader)
        return cls(text, **options)

    def __repr__(self):
        return 'Lark(open(%r), parser=%r, lexer=%r, ...)' % (self.source_path, self.options.parser, self.options.lexer)


    def lex(self, text: str, dont_ignore: bool=False) -> Iterator[Token]:
        #--
        lexer: Lexer
        if not hasattr(self, 'lexer') or dont_ignore:
            lexer = self._build_lexer(dont_ignore)
        else:
            lexer = self.lexer
        lexer_thread = LexerThread.from_text(lexer, text)
        stream = lexer_thread.lex(None)
        if self.options.postlex:
            return self.options.postlex.process(stream)
        return stream

    def get_terminal(self, name: str) -> TerminalDef:
        #--
        return self._terminals_dict[name]

    def parse_interactive(self, text: Optional[str]=None, start: Optional[str]=None) -> 'InteractiveParser':
        #--
        return self.parser.parse_interactive(text, start=start)

    def parse(self, text: str, start: Optional[str]=None, on_error: 'Optional[Callable[[UnexpectedInput], bool]]'=None) -> 'ParseTree':
        #--
        return self.parser.parse(text, start=start, on_error=on_error)




class DedentError(LarkError):
    pass

class Indenter(PostLex, ABC):
    paren_level: int
    indent_level: List[int]

    def __init__(self) -> None:
        self.paren_level = 0
        self.indent_level = [0]
        assert self.tab_len > 0

    def handle_NL(self, token: Token) -> Iterator[Token]:
        if self.paren_level > 0:
            return

        yield token

        indent_str = token.rsplit('\n', 1)[1] ##

        indent = indent_str.count(' ') + indent_str.count('\t') * self.tab_len

        if indent > self.indent_level[-1]:
            self.indent_level.append(indent)
            yield Token.new_borrow_pos(self.INDENT_type, indent_str, token)
        else:
            while indent < self.indent_level[-1]:
                self.indent_level.pop()
                yield Token.new_borrow_pos(self.DEDENT_type, indent_str, token)

            if indent != self.indent_level[-1]:
                raise DedentError('Unexpected dedent to column %s. Expected dedent to %s' % (indent, self.indent_level[-1]))

    def _process(self, stream):
        for token in stream:
            if token.type == self.NL_type:
                yield from self.handle_NL(token)
            else:
                yield token

            if token.type in self.OPEN_PAREN_types:
                self.paren_level += 1
            elif token.type in self.CLOSE_PAREN_types:
                self.paren_level -= 1
                assert self.paren_level >= 0

        while len(self.indent_level) > 1:
            self.indent_level.pop()
            yield Token(self.DEDENT_type, '')

        assert self.indent_level == [0], self.indent_level

    def process(self, stream):
        self.paren_level = 0
        self.indent_level = [0]
        return self._process(stream)

    ##

    @property
    def always_accept(self):
        return (self.NL_type,)

    @property
    @abstractmethod
    def NL_type(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def OPEN_PAREN_types(self) -> List[str]:
        raise NotImplementedError()

    @property
    @abstractmethod
    def CLOSE_PAREN_types(self) -> List[str]:
        raise NotImplementedError()

    @property
    @abstractmethod
    def INDENT_type(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def DEDENT_type(self) -> str:
        raise NotImplementedError()

    @property
    @abstractmethod
    def tab_len(self) -> int:
        raise NotImplementedError()


class PythonIndenter(Indenter):
    NL_type = '_NEWLINE'
    OPEN_PAREN_types = ['LPAR', 'LSQB', 'LBRACE']
    CLOSE_PAREN_types = ['RPAR', 'RSQB', 'RBRACE']
    INDENT_type = '_INDENT'
    DEDENT_type = '_DEDENT'
    tab_len = 8


import pickle, zlib, base64
DATA = (
{'parser': {'lexer_conf': {'terminals': [{'@': 0}, {'@': 1}, {'@': 2}, {'@': 3}, {'@': 4}, {'@': 5}, {'@': 6}, {'@': 7}, {'@': 8}, {'@': 9}, {'@': 10}, {'@': 11}, {'@': 12}, {'@': 13}, {'@': 14}, {'@': 15}, {'@': 16}, {'@': 17}, {'@': 18}, {'@': 19}, {'@': 20}, {'@': 21}, {'@': 22}, {'@': 23}, {'@': 24}, {'@': 25}, {'@': 26}, {'@': 27}, {'@': 28}, {'@': 29}, {'@': 30}, {'@': 31}, {'@': 32}, {'@': 33}, {'@': 34}, {'@': 35}, {'@': 36}, {'@': 37}, {'@': 38}, {'@': 39}, {'@': 40}, {'@': 41}, {'@': 42}], 'ignore': ['__IGNORE_0', '__IGNORE_1'], 'g_regex_flags': 0, 'use_bytes': False, 'lexer_type': 'contextual', '__type__': 'LexerConf'}, 'parser_conf': {'rules': [{'@': 43}, {'@': 44}, {'@': 45}, {'@': 46}, {'@': 47}, {'@': 48}, {'@': 49}, {'@': 50}, {'@': 51}, {'@': 52}, {'@': 53}, {'@': 54}, {'@': 55}, {'@': 56}, {'@': 57}, {'@': 58}, {'@': 59}, {'@': 60}, {'@': 61}, {'@': 62}, {'@': 63}, {'@': 64}, {'@': 65}, {'@': 66}, {'@': 67}, {'@': 68}, {'@': 69}, {'@': 70}, {'@': 71}, {'@': 72}, {'@': 73}, {'@': 74}, {'@': 75}, {'@': 76}, {'@': 77}, {'@': 78}, {'@': 79}, {'@': 80}, {'@': 81}, {'@': 82}, {'@': 83}, {'@': 84}, {'@': 85}, {'@': 86}, {'@': 87}, {'@': 88}, {'@': 89}, {'@': 90}, {'@': 91}, {'@': 92}, {'@': 93}, {'@': 94}, {'@': 95}, {'@': 96}, {'@': 97}, {'@': 98}, {'@': 99}, {'@': 100}, {'@': 101}, {'@': 102}, {'@': 103}, {'@': 104}, {'@': 105}, {'@': 106}, {'@': 107}, {'@': 108}, {'@': 109}, {'@': 110}, {'@': 111}, {'@': 112}, {'@': 113}, {'@': 114}, {'@': 115}, {'@': 116}, {'@': 117}, {'@': 118}, {'@': 119}, {'@': 120}, {'@': 121}, {'@': 122}, {'@': 123}, {'@': 124}, {'@': 125}, {'@': 126}, {'@': 127}, {'@': 128}, {'@': 129}, {'@': 130}, {'@': 131}, {'@': 132}, {'@': 133}, {'@': 134}, {'@': 135}, {'@': 136}, {'@': 137}, {'@': 138}, {'@': 139}, {'@': 140}, {'@': 141}, {'@': 142}, {'@': 143}, {'@': 144}, {'@': 145}, {'@': 146}, {'@': 147}, {'@': 148}, {'@': 149}, {'@': 150}, {'@': 151}, {'@': 152}, {'@': 153}, {'@': 154}, {'@': 155}, {'@': 156}, {'@': 157}, {'@': 158}, {'@': 159}, {'@': 160}, {'@': 161}, {'@': 162}, {'@': 163}, {'@': 164}, {'@': 165}, {'@': 166}, {'@': 167}, {'@': 168}, {'@': 169}, {'@': 170}, {'@': 171}, {'@': 172}, {'@': 173}, {'@': 174}, {'@': 175}, {'@': 176}, {'@': 177}, {'@': 178}, {'@': 179}, {'@': 180}, {'@': 181}, {'@': 182}, {'@': 183}, {'@': 184}, {'@': 185}, {'@': 186}, {'@': 187}, {'@': 188}, {'@': 189}, {'@': 190}, {'@': 191}, {'@': 192}, {'@': 193}, {'@': 194}, {'@': 195}, {'@': 196}, {'@': 197}, {'@': 198}, {'@': 199}, {'@': 200}, {'@': 201}, {'@': 202}, {'@': 203}, {'@': 204}, {'@': 205}, {'@': 206}, {'@': 207}, {'@': 208}, {'@': 209}, {'@': 210}, {'@': 211}, {'@': 212}, {'@': 213}, {'@': 214}, {'@': 215}, {'@': 216}, {'@': 217}, {'@': 218}, {'@': 219}, {'@': 220}, {'@': 221}, {'@': 222}, {'@': 223}, {'@': 224}, {'@': 225}, {'@': 226}, {'@': 227}, {'@': 228}, {'@': 229}, {'@': 230}, {'@': 231}, {'@': 232}, {'@': 233}, {'@': 234}, {'@': 235}, {'@': 236}, {'@': 237}, {'@': 238}, {'@': 239}, {'@': 240}, {'@': 241}, {'@': 242}, {'@': 243}, {'@': 244}, {'@': 245}, {'@': 246}, {'@': 247}, {'@': 248}, {'@': 249}, {'@': 250}, {'@': 251}, {'@': 252}, {'@': 253}, {'@': 254}, {'@': 255}, {'@': 256}, {'@': 257}, {'@': 258}, {'@': 259}, {'@': 260}, {'@': 261}, {'@': 262}, {'@': 263}, {'@': 264}, {'@': 265}, {'@': 266}, {'@': 267}, {'@': 268}, {'@': 269}, {'@': 270}, {'@': 271}, {'@': 272}, {'@': 273}, {'@': 274}, {'@': 275}, {'@': 276}, {'@': 277}, {'@': 278}, {'@': 279}, {'@': 280}, {'@': 281}, {'@': 282}, {'@': 283}, {'@': 284}, {'@': 285}, {'@': 286}, {'@': 287}, {'@': 288}, {'@': 289}, {'@': 290}, {'@': 291}, {'@': 292}, {'@': 293}, {'@': 294}, {'@': 295}, {'@': 296}, {'@': 297}, {'@': 298}, {'@': 299}, {'@': 300}, {'@': 301}, {'@': 302}, {'@': 303}, {'@': 304}, {'@': 305}, {'@': 306}, {'@': 307}, {'@': 308}, {'@': 309}, {'@': 310}, {'@': 311}, {'@': 312}, {'@': 313}, {'@': 314}, {'@': 315}, {'@': 316}, {'@': 317}, {'@': 318}, {'@': 319}, {'@': 320}, {'@': 321}, {'@': 322}, {'@': 323}, {'@': 324}, {'@': 325}, {'@': 326}, {'@': 327}, {'@': 328}, {'@': 329}, {'@': 330}, {'@': 331}, {'@': 332}, {'@': 333}, {'@': 334}, {'@': 335}, {'@': 336}, {'@': 337}, {'@': 338}, {'@': 339}, {'@': 340}, {'@': 341}, {'@': 342}, {'@': 343}, {'@': 344}, {'@': 345}, {'@': 346}, {'@': 347}, {'@': 348}, {'@': 349}, {'@': 350}, {'@': 351}, {'@': 352}, {'@': 353}, {'@': 354}, {'@': 355}, {'@': 356}, {'@': 357}, {'@': 358}, {'@': 359}, {'@': 360}, {'@': 361}, {'@': 362}, {'@': 363}, {'@': 364}, {'@': 365}, {'@': 366}, {'@': 367}, {'@': 368}, {'@': 369}, {'@': 370}, {'@': 371}, {'@': 372}, {'@': 373}, {'@': 374}, {'@': 375}, {'@': 376}, {'@': 377}, {'@': 378}, {'@': 379}, {'@': 380}, {'@': 381}, {'@': 382}, {'@': 383}, {'@': 384}, {'@': 385}, {'@': 386}, {'@': 387}, {'@': 388}, {'@': 389}, {'@': 390}, {'@': 391}, {'@': 392}, {'@': 393}, {'@': 394}, {'@': 395}, {'@': 396}, {'@': 397}, {'@': 398}, {'@': 399}, {'@': 400}, {'@': 401}, {'@': 402}, {'@': 403}, {'@': 404}, {'@': 405}, {'@': 406}, {'@': 407}, {'@': 408}, {'@': 409}, {'@': 410}, {'@': 411}, {'@': 412}, {'@': 413}, {'@': 414}, {'@': 415}, {'@': 416}, {'@': 417}, {'@': 418}, {'@': 419}, {'@': 420}, {'@': 421}, {'@': 422}, {'@': 423}, {'@': 424}, {'@': 425}, {'@': 426}, {'@': 427}, {'@': 428}, {'@': 429}, {'@': 430}, {'@': 431}, {'@': 432}, {'@': 433}, {'@': 434}, {'@': 435}, {'@': 436}, {'@': 437}, {'@': 438}, {'@': 439}, {'@': 440}, {'@': 441}, {'@': 442}, {'@': 443}, {'@': 444}, {'@': 445}, {'@': 446}], 'start': ['start'], 'parser_type': 'lalr', '__type__': 'ParserConf'}, 'parser': {'tokens': {0: '__new_line_or_comment_plus_2', 1: 'QMARK', 2: '__ANON_4', 3: 'COLON', 4: 'LESSTHAN', 5: '__ANON_2', 6: 'STAR', 7: 'new_line_or_comment', 8: 'binary_operator', 9: 'PERCENT', 10: '__ANON_5', 11: '__ANON_6', 12: '__ANON_0', 13: 'PLUS', 14: '__ANON_7', 15: '__ANON_9', 16: 'binary_term', 17: '__ANON_8', 18: '__ANON_1', 19: 'MORETHAN', 20: 'SLASH', 21: 'MINUS', 22: '__ANON_14', 23: 'DOT', 24: 'LSQB', 25: 'EQUAL', 26: '__ANON_13', 27: 'RPAR', 28: 'COMMA', 29: 'IF', 30: 'RBRACE', 31: '__ANON_3', 32: '__ANON_12', 33: '__ANON_15', 34: 'RSQB', 35: '$END', 36: 'for_intro', 37: 'LBRACE', 38: 'FOR', 39: 'attr_splat_expr_term', 40: 'expr_term', 41: 'object_elem', 42: 'identifier', 43: '__ANON_10', 44: '__int_lit_plus_3', 45: 'function_call', 46: 'for_object_expr', 47: 'conditional', 48: 'LPAR', 49: 'heredoc_template', 50: 'expression', 51: 'full_splat_expr_term', 52: 'object', 53: 'operation', 54: 'binary_op', 55: 'for_tuple_expr', 56: '__ANON_11', 57: 'heredoc_template_trim', 58: 'unary_op', 59: 'DECIMAL', 60: 'float_lit', 61: 'STRING_LIT', 62: 'get_attr_expr_term', 63: 'int_lit', 64: 'index_expr_term', 65: 'BANG', 66: 'tuple', 67: 'EXP_MARK', 68: 'for_cond', 69: '__full_splat_star_7', 70: 'index', 71: 'get_attr', 72: 'IN', 73: '__body_star_0', 74: 'body', 75: 'block', 76: 'attribute', 77: 'new_line_and_or_comma', 78: '__tuple_star_4', 79: '__object_star_5', 80: '__block_star_1', 81: 'start', 82: 'attr_splat', 83: 'full_splat', 84: '__attr_splat_star_6', 85: 'arguments'}, 'states': {0: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 404), 4: (0, 634), 5: (0, 371), 6: (0, 66), 7: (0, 410), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 1: {22: (1, {'@': 159}), 19: (1, {'@': 159}), 23: (1, {'@': 159}), 21: (1, {'@': 159}), 24: (1, {'@': 159}), 3: (1, {'@': 159}), 11: (1, {'@': 159}), 14: (1, {'@': 159}), 17: (1, {'@': 159}), 4: (1, {'@': 159}), 10: (1, {'@': 159}), 15: (1, {'@': 159}), 6: (1, {'@': 159}), 25: (1, {'@': 159}), 2: (1, {'@': 159}), 9: (1, {'@': 159}), 13: (1, {'@': 159}), 26: (1, {'@': 159}), 20: (1, {'@': 159}), 1: (1, {'@': 159}), 5: (1, {'@': 159}), 27: (1, {'@': 159}), 28: (1, {'@': 159}), 29: (1, {'@': 159}), 30: (1, {'@': 159}), 12: (1, {'@': 159}), 31: (1, {'@': 159}), 18: (1, {'@': 159}), 32: (1, {'@': 159}), 33: (1, {'@': 159}), 34: (1, {'@': 159}), 35: (1, {'@': 159})}, 2: {36: (0, 94), 37: (0, 709), 38: (0, 112), 39: (0, 716), 24: (0, 711), 40: (0, 724), 41: (0, 336), 42: (0, 118), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 50: (0, 13), 30: (0, 126), 51: (0, 12), 52: (0, 27), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 3: {22: (1, {'@': 303}), 19: (1, {'@': 303}), 23: (1, {'@': 303}), 21: (1, {'@': 303}), 24: (1, {'@': 303}), 3: (1, {'@': 303}), 11: (1, {'@': 303}), 14: (1, {'@': 303}), 17: (1, {'@': 303}), 4: (1, {'@': 303}), 10: (1, {'@': 303}), 15: (1, {'@': 303}), 6: (1, {'@': 303}), 25: (1, {'@': 303}), 2: (1, {'@': 303}), 9: (1, {'@': 303}), 13: (1, {'@': 303}), 26: (1, {'@': 303}), 20: (1, {'@': 303}), 1: (1, {'@': 303}), 5: (1, {'@': 303}), 27: (1, {'@': 303}), 28: (1, {'@': 303}), 29: (1, {'@': 303}), 30: (1, {'@': 303}), 12: (1, {'@': 303}), 31: (1, {'@': 303}), 18: (1, {'@': 303}), 32: (1, {'@': 303}), 33: (1, {'@': 303}), 34: (1, {'@': 303}), 35: (1, {'@': 303})}, 4: {22: (1, {'@': 200}), 19: (1, {'@': 200}), 23: (1, {'@': 200}), 21: (1, {'@': 200}), 24: (1, {'@': 200}), 3: (1, {'@': 200}), 11: (1, {'@': 200}), 14: (1, {'@': 200}), 17: (1, {'@': 200}), 4: (1, {'@': 200}), 10: (1, {'@': 200}), 15: (1, {'@': 200}), 6: (1, {'@': 200}), 25: (1, {'@': 200}), 2: (1, {'@': 200}), 9: (1, {'@': 200}), 13: (1, {'@': 200}), 26: (1, {'@': 200}), 20: (1, {'@': 200}), 1: (1, {'@': 200}), 5: (1, {'@': 200}), 27: (1, {'@': 200}), 28: (1, {'@': 200}), 29: (1, {'@': 200}), 30: (1, {'@': 200}), 12: (1, {'@': 200}), 31: (1, {'@': 200}), 18: (1, {'@': 200}), 32: (1, {'@': 200}), 33: (1, {'@': 200}), 34: (1, {'@': 200}), 35: (1, {'@': 200})}, 5: {22: (1, {'@': 255}), 19: (1, {'@': 255}), 23: (1, {'@': 255}), 21: (1, {'@': 255}), 24: (1, {'@': 255}), 3: (1, {'@': 255}), 11: (1, {'@': 255}), 14: (1, {'@': 255}), 17: (1, {'@': 255}), 4: (1, {'@': 255}), 10: (1, {'@': 255}), 15: (1, {'@': 255}), 6: (1, {'@': 255}), 25: (1, {'@': 255}), 2: (1, {'@': 255}), 9: (1, {'@': 255}), 13: (1, {'@': 255}), 26: (1, {'@': 255}), 20: (1, {'@': 255}), 1: (1, {'@': 255}), 5: (1, {'@': 255}), 27: (1, {'@': 255}), 28: (1, {'@': 255}), 29: (1, {'@': 255}), 30: (1, {'@': 255}), 12: (1, {'@': 255}), 31: (1, {'@': 255}), 18: (1, {'@': 255}), 32: (1, {'@': 255}), 33: (1, {'@': 255}), 34: (1, {'@': 255}), 35: (1, {'@': 255})}, 6: {22: (1, {'@': 105}), 19: (1, {'@': 105}), 23: (1, {'@': 105}), 21: (1, {'@': 105}), 24: (1, {'@': 105}), 3: (1, {'@': 105}), 11: (1, {'@': 105}), 14: (1, {'@': 105}), 17: (1, {'@': 105}), 4: (1, {'@': 105}), 10: (1, {'@': 105}), 15: (1, {'@': 105}), 6: (1, {'@': 105}), 25: (1, {'@': 105}), 2: (1, {'@': 105}), 9: (1, {'@': 105}), 13: (1, {'@': 105}), 26: (1, {'@': 105}), 20: (1, {'@': 105}), 1: (1, {'@': 105}), 5: (1, {'@': 105}), 27: (1, {'@': 105}), 28: (1, {'@': 105}), 29: (1, {'@': 105}), 30: (1, {'@': 105}), 12: (1, {'@': 105}), 31: (1, {'@': 105}), 18: (1, {'@': 105}), 32: (1, {'@': 105}), 33: (1, {'@': 105}), 34: (1, {'@': 105}), 35: (1, {'@': 105})}, 7: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 68}), 25: (1, {'@': 68}), 34: (1, {'@': 68}), 5: (1, {'@': 68}), 27: (1, {'@': 68}), 28: (1, {'@': 68}), 29: (1, {'@': 68}), 30: (1, {'@': 68}), 12: (1, {'@': 68}), 31: (1, {'@': 68}), 35: (1, {'@': 68}), 18: (1, {'@': 68}), 32: (1, {'@': 68}), 33: (1, {'@': 68})}, 8: {22: (1, {'@': 114}), 19: (1, {'@': 114}), 23: (1, {'@': 114}), 21: (1, {'@': 114}), 24: (1, {'@': 114}), 3: (1, {'@': 114}), 11: (1, {'@': 114}), 14: (1, {'@': 114}), 17: (1, {'@': 114}), 4: (1, {'@': 114}), 10: (1, {'@': 114}), 15: (1, {'@': 114}), 6: (1, {'@': 114}), 25: (1, {'@': 114}), 2: (1, {'@': 114}), 9: (1, {'@': 114}), 13: (1, {'@': 114}), 26: (1, {'@': 114}), 20: (1, {'@': 114}), 1: (1, {'@': 114}), 5: (1, {'@': 114}), 27: (1, {'@': 114}), 28: (1, {'@': 114}), 29: (1, {'@': 114}), 30: (1, {'@': 114}), 12: (1, {'@': 114}), 31: (1, {'@': 114}), 18: (1, {'@': 114}), 32: (1, {'@': 114}), 33: (1, {'@': 114}), 34: (1, {'@': 114}), 35: (1, {'@': 114})}, 9: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 69}), 25: (1, {'@': 69}), 34: (1, {'@': 69}), 5: (1, {'@': 69}), 27: (1, {'@': 69}), 28: (1, {'@': 69}), 29: (1, {'@': 69}), 30: (1, {'@': 69}), 12: (1, {'@': 69}), 31: (1, {'@': 69}), 35: (1, {'@': 69}), 18: (1, {'@': 69}), 32: (1, {'@': 69}), 33: (1, {'@': 69})}, 10: {22: (1, {'@': 207}), 19: (1, {'@': 207}), 23: (1, {'@': 207}), 21: (1, {'@': 207}), 24: (1, {'@': 207}), 3: (1, {'@': 207}), 11: (1, {'@': 207}), 14: (1, {'@': 207}), 17: (1, {'@': 207}), 4: (1, {'@': 207}), 10: (1, {'@': 207}), 15: (1, {'@': 207}), 6: (1, {'@': 207}), 25: (1, {'@': 207}), 2: (1, {'@': 207}), 9: (1, {'@': 207}), 13: (1, {'@': 207}), 26: (1, {'@': 207}), 20: (1, {'@': 207}), 1: (1, {'@': 207}), 5: (1, {'@': 207}), 27: (1, {'@': 207}), 28: (1, {'@': 207}), 29: (1, {'@': 207}), 30: (1, {'@': 207}), 12: (1, {'@': 207}), 31: (1, {'@': 207}), 18: (1, {'@': 207}), 32: (1, {'@': 207}), 33: (1, {'@': 207}), 34: (1, {'@': 207}), 35: (1, {'@': 207})}, 11: {0: (0, 452), 30: (0, 707), 7: (0, 501), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 12: {22: (1, {'@': 107}), 19: (1, {'@': 107}), 23: (1, {'@': 107}), 21: (1, {'@': 107}), 24: (1, {'@': 107}), 3: (1, {'@': 107}), 11: (1, {'@': 107}), 14: (1, {'@': 107}), 17: (1, {'@': 107}), 4: (1, {'@': 107}), 10: (1, {'@': 107}), 15: (1, {'@': 107}), 6: (1, {'@': 107}), 25: (1, {'@': 107}), 2: (1, {'@': 107}), 9: (1, {'@': 107}), 13: (1, {'@': 107}), 26: (1, {'@': 107}), 20: (1, {'@': 107}), 1: (1, {'@': 107}), 5: (1, {'@': 107}), 27: (1, {'@': 107}), 28: (1, {'@': 107}), 29: (1, {'@': 107}), 30: (1, {'@': 107}), 12: (1, {'@': 107}), 31: (1, {'@': 107}), 18: (1, {'@': 107}), 32: (1, {'@': 107}), 33: (1, {'@': 107}), 34: (1, {'@': 107}), 35: (1, {'@': 107})}, 13: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 25: (0, 320), 21: (0, 16), 19: (0, 42), 3: (0, 269), 20: (0, 48), 9: (0, 83)}, 14: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 613), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 15: {48: (1, {'@': 347}), 65: (1, {'@': 347}), 56: (1, {'@': 347}), 12: (1, {'@': 347}), 31: (1, {'@': 347}), 59: (1, {'@': 347}), 5: (1, {'@': 347}), 43: (1, {'@': 347}), 21: (1, {'@': 347}), 24: (1, {'@': 347}), 61: (1, {'@': 347}), 18: (1, {'@': 347}), 37: (1, {'@': 347})}, 16: {48: (1, {'@': 82}), 65: (1, {'@': 82}), 56: (1, {'@': 82}), 12: (1, {'@': 82}), 31: (1, {'@': 82}), 59: (1, {'@': 82}), 5: (1, {'@': 82}), 43: (1, {'@': 82}), 21: (1, {'@': 82}), 24: (1, {'@': 82}), 61: (1, {'@': 82}), 18: (1, {'@': 82}), 37: (1, {'@': 82})}, 17: {19: (1, {'@': 71}), 21: (1, {'@': 71}), 3: (1, {'@': 71}), 11: (1, {'@': 71}), 14: (1, {'@': 71}), 17: (1, {'@': 71}), 4: (1, {'@': 71}), 10: (1, {'@': 71}), 15: (1, {'@': 71}), 6: (1, {'@': 71}), 25: (1, {'@': 71}), 2: (1, {'@': 71}), 9: (1, {'@': 71}), 13: (1, {'@': 71}), 20: (1, {'@': 71}), 1: (1, {'@': 71}), 34: (1, {'@': 71}), 5: (1, {'@': 71}), 27: (1, {'@': 71}), 28: (1, {'@': 71}), 29: (1, {'@': 71}), 30: (1, {'@': 71}), 12: (1, {'@': 71}), 31: (1, {'@': 71}), 35: (1, {'@': 71}), 18: (1, {'@': 71}), 32: (1, {'@': 71}), 33: (1, {'@': 71})}, 18: {22: (1, {'@': 153}), 19: (1, {'@': 153}), 23: (1, {'@': 153}), 21: (1, {'@': 153}), 24: (1, {'@': 153}), 3: (1, {'@': 153}), 11: (1, {'@': 153}), 14: (1, {'@': 153}), 17: (1, {'@': 153}), 4: (1, {'@': 153}), 10: (1, {'@': 153}), 15: (1, {'@': 153}), 6: (1, {'@': 153}), 25: (1, {'@': 153}), 2: (1, {'@': 153}), 9: (1, {'@': 153}), 13: (1, {'@': 153}), 26: (1, {'@': 153}), 20: (1, {'@': 153}), 1: (1, {'@': 153}), 5: (1, {'@': 153}), 27: (1, {'@': 153}), 28: (1, {'@': 153}), 29: (1, {'@': 153}), 30: (1, {'@': 153}), 12: (1, {'@': 153}), 31: (1, {'@': 153}), 18: (1, {'@': 153}), 32: (1, {'@': 153}), 33: (1, {'@': 153}), 34: (1, {'@': 153}), 35: (1, {'@': 153})}, 19: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 684), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 20: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 63}), 25: (1, {'@': 63}), 34: (1, {'@': 63}), 5: (1, {'@': 63}), 27: (1, {'@': 63}), 28: (1, {'@': 63}), 29: (1, {'@': 63}), 30: (1, {'@': 63}), 12: (1, {'@': 63}), 31: (1, {'@': 63}), 35: (1, {'@': 63}), 18: (1, {'@': 63}), 32: (1, {'@': 63}), 33: (1, {'@': 63})}, 21: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 509), 5: (0, 371), 30: (0, 514)}, 22: {3: (0, 592), 0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 599), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 23: {67: (1, {'@': 429}), 59: (1, {'@': 429}), 22: (1, {'@': 429}), 19: (1, {'@': 429}), 23: (1, {'@': 429}), 21: (1, {'@': 429}), 24: (1, {'@': 429}), 3: (1, {'@': 429}), 11: (1, {'@': 429}), 14: (1, {'@': 429}), 17: (1, {'@': 429}), 4: (1, {'@': 429}), 10: (1, {'@': 429}), 15: (1, {'@': 429}), 6: (1, {'@': 429}), 25: (1, {'@': 429}), 2: (1, {'@': 429}), 9: (1, {'@': 429}), 13: (1, {'@': 429}), 26: (1, {'@': 429}), 20: (1, {'@': 429}), 1: (1, {'@': 429}), 5: (1, {'@': 429}), 27: (1, {'@': 429}), 28: (1, {'@': 429}), 29: (1, {'@': 429}), 30: (1, {'@': 429}), 12: (1, {'@': 429}), 31: (1, {'@': 429}), 18: (1, {'@': 429}), 32: (1, {'@': 429}), 33: (1, {'@': 429}), 34: (1, {'@': 429}), 35: (1, {'@': 429})}, 24: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 524), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 25: {48: (1, {'@': 395}), 65: (1, {'@': 395}), 56: (1, {'@': 395}), 12: (1, {'@': 395}), 31: (1, {'@': 395}), 59: (1, {'@': 395}), 5: (1, {'@': 395}), 43: (1, {'@': 395}), 21: (1, {'@': 395}), 24: (1, {'@': 395}), 61: (1, {'@': 395}), 18: (1, {'@': 395}), 37: (1, {'@': 395})}, 26: {19: (1, {'@': 75}), 21: (1, {'@': 75}), 3: (1, {'@': 75}), 11: (1, {'@': 75}), 14: (1, {'@': 75}), 17: (1, {'@': 75}), 4: (1, {'@': 75}), 10: (1, {'@': 75}), 15: (1, {'@': 75}), 6: (1, {'@': 75}), 25: (1, {'@': 75}), 2: (1, {'@': 75}), 9: (1, {'@': 75}), 13: (1, {'@': 75}), 20: (1, {'@': 75}), 1: (1, {'@': 75}), 34: (1, {'@': 75}), 5: (1, {'@': 75}), 27: (1, {'@': 75}), 28: (1, {'@': 75}), 29: (1, {'@': 75}), 30: (1, {'@': 75}), 12: (1, {'@': 75}), 31: (1, {'@': 75}), 35: (1, {'@': 75}), 18: (1, {'@': 75}), 32: (1, {'@': 75}), 33: (1, {'@': 75})}, 27: {22: (1, {'@': 99}), 19: (1, {'@': 99}), 23: (1, {'@': 99}), 21: (1, {'@': 99}), 24: (1, {'@': 99}), 3: (1, {'@': 99}), 11: (1, {'@': 99}), 14: (1, {'@': 99}), 17: (1, {'@': 99}), 4: (1, {'@': 99}), 10: (1, {'@': 99}), 15: (1, {'@': 99}), 6: (1, {'@': 99}), 25: (1, {'@': 99}), 2: (1, {'@': 99}), 9: (1, {'@': 99}), 13: (1, {'@': 99}), 26: (1, {'@': 99}), 20: (1, {'@': 99}), 1: (1, {'@': 99}), 5: (1, {'@': 99}), 27: (1, {'@': 99}), 28: (1, {'@': 99}), 29: (1, {'@': 99}), 30: (1, {'@': 99}), 12: (1, {'@': 99}), 31: (1, {'@': 99}), 18: (1, {'@': 99}), 32: (1, {'@': 99}), 33: (1, {'@': 99}), 34: (1, {'@': 99}), 35: (1, {'@': 99})}, 28: {22: (1, {'@': 296}), 19: (1, {'@': 296}), 23: (1, {'@': 296}), 21: (1, {'@': 296}), 24: (1, {'@': 296}), 3: (1, {'@': 296}), 11: (1, {'@': 296}), 14: (1, {'@': 296}), 17: (1, {'@': 296}), 4: (1, {'@': 296}), 10: (1, {'@': 296}), 15: (1, {'@': 296}), 6: (1, {'@': 296}), 25: (1, {'@': 296}), 2: (1, {'@': 296}), 9: (1, {'@': 296}), 13: (1, {'@': 296}), 26: (1, {'@': 296}), 20: (1, {'@': 296}), 1: (1, {'@': 296}), 5: (1, {'@': 296}), 27: (1, {'@': 296}), 28: (1, {'@': 296}), 29: (1, {'@': 296}), 30: (1, {'@': 296}), 12: (1, {'@': 296}), 31: (1, {'@': 296}), 18: (1, {'@': 296}), 32: (1, {'@': 296}), 33: (1, {'@': 296}), 34: (1, {'@': 296}), 35: (1, {'@': 296})}, 29: {22: (1, {'@': 261}), 19: (1, {'@': 261}), 23: (1, {'@': 261}), 21: (1, {'@': 261}), 24: (1, {'@': 261}), 3: (1, {'@': 261}), 11: (1, {'@': 261}), 14: (1, {'@': 261}), 17: (1, {'@': 261}), 4: (1, {'@': 261}), 10: (1, {'@': 261}), 15: (1, {'@': 261}), 6: (1, {'@': 261}), 25: (1, {'@': 261}), 2: (1, {'@': 261}), 9: (1, {'@': 261}), 13: (1, {'@': 261}), 26: (1, {'@': 261}), 20: (1, {'@': 261}), 1: (1, {'@': 261}), 5: (1, {'@': 261}), 27: (1, {'@': 261}), 28: (1, {'@': 261}), 29: (1, {'@': 261}), 30: (1, {'@': 261}), 12: (1, {'@': 261}), 31: (1, {'@': 261}), 18: (1, {'@': 261}), 32: (1, {'@': 261}), 33: (1, {'@': 261}), 34: (1, {'@': 261}), 35: (1, {'@': 261})}, 30: {22: (1, {'@': 95}), 19: (1, {'@': 95}), 23: (1, {'@': 95}), 21: (1, {'@': 95}), 24: (1, {'@': 95}), 3: (1, {'@': 95}), 11: (1, {'@': 95}), 14: (1, {'@': 95}), 17: (1, {'@': 95}), 4: (1, {'@': 95}), 10: (1, {'@': 95}), 15: (1, {'@': 95}), 6: (1, {'@': 95}), 25: (1, {'@': 95}), 2: (1, {'@': 95}), 9: (1, {'@': 95}), 13: (1, {'@': 95}), 26: (1, {'@': 95}), 20: (1, {'@': 95}), 1: (1, {'@': 95}), 5: (1, {'@': 95}), 27: (1, {'@': 95}), 28: (1, {'@': 95}), 29: (1, {'@': 95}), 30: (1, {'@': 95}), 12: (1, {'@': 95}), 31: (1, {'@': 95}), 18: (1, {'@': 95}), 32: (1, {'@': 95}), 33: (1, {'@': 95}), 34: (1, {'@': 95}), 35: (1, {'@': 95})}, 31: {48: (1, {'@': 86}), 65: (1, {'@': 86}), 56: (1, {'@': 86}), 12: (1, {'@': 86}), 31: (1, {'@': 86}), 59: (1, {'@': 86}), 5: (1, {'@': 86}), 43: (1, {'@': 86}), 21: (1, {'@': 86}), 24: (1, {'@': 86}), 61: (1, {'@': 86}), 18: (1, {'@': 86}), 37: (1, {'@': 86})}, 32: {7: (0, 86), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 92)}, 33: {22: (1, {'@': 271}), 19: (1, {'@': 271}), 23: (1, {'@': 271}), 21: (1, {'@': 271}), 24: (1, {'@': 271}), 3: (1, {'@': 271}), 11: (1, {'@': 271}), 14: (1, {'@': 271}), 17: (1, {'@': 271}), 4: (1, {'@': 271}), 10: (1, {'@': 271}), 15: (1, {'@': 271}), 6: (1, {'@': 271}), 25: (1, {'@': 271}), 2: (1, {'@': 271}), 9: (1, {'@': 271}), 13: (1, {'@': 271}), 26: (1, {'@': 271}), 20: (1, {'@': 271}), 1: (1, {'@': 271}), 5: (1, {'@': 271}), 27: (1, {'@': 271}), 28: (1, {'@': 271}), 29: (1, {'@': 271}), 30: (1, {'@': 271}), 12: (1, {'@': 271}), 31: (1, {'@': 271}), 18: (1, {'@': 271}), 32: (1, {'@': 271}), 33: (1, {'@': 271}), 34: (1, {'@': 271}), 35: (1, {'@': 271})}, 34: {48: (1, {'@': 367}), 65: (1, {'@': 367}), 56: (1, {'@': 367}), 12: (1, {'@': 367}), 31: (1, {'@': 367}), 59: (1, {'@': 367}), 5: (1, {'@': 367}), 43: (1, {'@': 367}), 21: (1, {'@': 367}), 24: (1, {'@': 367}), 61: (1, {'@': 367}), 18: (1, {'@': 367}), 37: (1, {'@': 367})}, 35: {22: (1, {'@': 97}), 19: (1, {'@': 97}), 23: (1, {'@': 97}), 21: (1, {'@': 97}), 24: (1, {'@': 97}), 3: (1, {'@': 97}), 11: (1, {'@': 97}), 14: (1, {'@': 97}), 17: (1, {'@': 97}), 4: (1, {'@': 97}), 10: (1, {'@': 97}), 15: (1, {'@': 97}), 6: (1, {'@': 97}), 25: (1, {'@': 97}), 2: (1, {'@': 97}), 9: (1, {'@': 97}), 13: (1, {'@': 97}), 26: (1, {'@': 97}), 20: (1, {'@': 97}), 1: (1, {'@': 97}), 5: (1, {'@': 97}), 27: (1, {'@': 97}), 28: (1, {'@': 97}), 29: (1, {'@': 97}), 30: (1, {'@': 97}), 12: (1, {'@': 97}), 31: (1, {'@': 97}), 18: (1, {'@': 97}), 32: (1, {'@': 97}), 33: (1, {'@': 97}), 34: (1, {'@': 97}), 35: (1, {'@': 97})}, 36: {22: (1, {'@': 143}), 19: (1, {'@': 143}), 23: (1, {'@': 143}), 21: (1, {'@': 143}), 24: (1, {'@': 143}), 3: (1, {'@': 143}), 11: (1, {'@': 143}), 14: (1, {'@': 143}), 17: (1, {'@': 143}), 4: (1, {'@': 143}), 10: (1, {'@': 143}), 15: (1, {'@': 143}), 6: (1, {'@': 143}), 25: (1, {'@': 143}), 2: (1, {'@': 143}), 9: (1, {'@': 143}), 13: (1, {'@': 143}), 26: (1, {'@': 143}), 20: (1, {'@': 143}), 1: (1, {'@': 143}), 5: (1, {'@': 143}), 27: (1, {'@': 143}), 28: (1, {'@': 143}), 29: (1, {'@': 143}), 30: (1, {'@': 143}), 12: (1, {'@': 143}), 31: (1, {'@': 143}), 18: (1, {'@': 143}), 32: (1, {'@': 143}), 33: (1, {'@': 143}), 34: (1, {'@': 143}), 35: (1, {'@': 143})}, 37: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 66}), 25: (1, {'@': 66}), 34: (1, {'@': 66}), 5: (1, {'@': 66}), 27: (1, {'@': 66}), 28: (1, {'@': 66}), 29: (1, {'@': 66}), 30: (1, {'@': 66}), 12: (1, {'@': 66}), 31: (1, {'@': 66}), 35: (1, {'@': 66}), 18: (1, {'@': 66}), 32: (1, {'@': 66}), 33: (1, {'@': 66})}, 38: {30: (0, 520)}, 39: {30: (0, 97)}, 40: {22: (1, {'@': 102}), 19: (1, {'@': 102}), 23: (1, {'@': 102}), 21: (1, {'@': 102}), 24: (1, {'@': 102}), 3: (1, {'@': 102}), 11: (1, {'@': 102}), 14: (1, {'@': 102}), 17: (1, {'@': 102}), 4: (1, {'@': 102}), 10: (1, {'@': 102}), 15: (1, {'@': 102}), 6: (1, {'@': 102}), 25: (1, {'@': 102}), 2: (1, {'@': 102}), 9: (1, {'@': 102}), 13: (1, {'@': 102}), 26: (1, {'@': 102}), 20: (1, {'@': 102}), 1: (1, {'@': 102}), 5: (1, {'@': 102}), 27: (1, {'@': 102}), 28: (1, {'@': 102}), 29: (1, {'@': 102}), 30: (1, {'@': 102}), 12: (1, {'@': 102}), 31: (1, {'@': 102}), 18: (1, {'@': 102}), 32: (1, {'@': 102}), 33: (1, {'@': 102}), 34: (1, {'@': 102}), 35: (1, {'@': 102})}, 41: {22: (1, {'@': 272}), 19: (1, {'@': 272}), 23: (1, {'@': 272}), 21: (1, {'@': 272}), 24: (1, {'@': 272}), 3: (1, {'@': 272}), 11: (1, {'@': 272}), 14: (1, {'@': 272}), 17: (1, {'@': 272}), 4: (1, {'@': 272}), 10: (1, {'@': 272}), 15: (1, {'@': 272}), 6: (1, {'@': 272}), 25: (1, {'@': 272}), 2: (1, {'@': 272}), 9: (1, {'@': 272}), 13: (1, {'@': 272}), 26: (1, {'@': 272}), 20: (1, {'@': 272}), 1: (1, {'@': 272}), 5: (1, {'@': 272}), 27: (1, {'@': 272}), 28: (1, {'@': 272}), 29: (1, {'@': 272}), 30: (1, {'@': 272}), 12: (1, {'@': 272}), 31: (1, {'@': 272}), 18: (1, {'@': 272}), 32: (1, {'@': 272}), 33: (1, {'@': 272}), 34: (1, {'@': 272}), 35: (1, {'@': 272})}, 42: {48: (1, {'@': 79}), 65: (1, {'@': 79}), 56: (1, {'@': 79}), 12: (1, {'@': 79}), 31: (1, {'@': 79}), 59: (1, {'@': 79}), 5: (1, {'@': 79}), 43: (1, {'@': 79}), 21: (1, {'@': 79}), 24: (1, {'@': 79}), 61: (1, {'@': 79}), 18: (1, {'@': 79}), 37: (1, {'@': 79})}, 43: {34: (0, 236)}, 44: {22: (1, {'@': 294}), 19: (1, {'@': 294}), 23: (1, {'@': 294}), 21: (1, {'@': 294}), 24: (1, {'@': 294}), 3: (1, {'@': 294}), 11: (1, {'@': 294}), 14: (1, {'@': 294}), 17: (1, {'@': 294}), 4: (1, {'@': 294}), 10: (1, {'@': 294}), 15: (1, {'@': 294}), 6: (1, {'@': 294}), 25: (1, {'@': 294}), 2: (1, {'@': 294}), 9: (1, {'@': 294}), 13: (1, {'@': 294}), 26: (1, {'@': 294}), 20: (1, {'@': 294}), 1: (1, {'@': 294}), 5: (1, {'@': 294}), 27: (1, {'@': 294}), 28: (1, {'@': 294}), 29: (1, {'@': 294}), 30: (1, {'@': 294}), 12: (1, {'@': 294}), 31: (1, {'@': 294}), 18: (1, {'@': 294}), 32: (1, {'@': 294}), 33: (1, {'@': 294}), 34: (1, {'@': 294}), 35: (1, {'@': 294})}, 45: {22: (1, {'@': 96}), 19: (1, {'@': 96}), 23: (1, {'@': 96}), 21: (1, {'@': 96}), 24: (1, {'@': 96}), 3: (1, {'@': 96}), 11: (1, {'@': 96}), 14: (1, {'@': 96}), 17: (1, {'@': 96}), 4: (1, {'@': 96}), 10: (1, {'@': 96}), 15: (1, {'@': 96}), 6: (1, {'@': 96}), 25: (1, {'@': 96}), 2: (1, {'@': 96}), 9: (1, {'@': 96}), 13: (1, {'@': 96}), 26: (1, {'@': 96}), 20: (1, {'@': 96}), 1: (1, {'@': 96}), 5: (1, {'@': 96}), 27: (1, {'@': 96}), 28: (1, {'@': 96}), 29: (1, {'@': 96}), 30: (1, {'@': 96}), 12: (1, {'@': 96}), 31: (1, {'@': 96}), 18: (1, {'@': 96}), 32: (1, {'@': 96}), 33: (1, {'@': 96}), 34: (1, {'@': 96}), 35: (1, {'@': 96})}, 46: {0: (0, 452), 68: (0, 538), 29: (0, 327), 7: (0, 487), 12: (0, 405), 30: (0, 497), 18: (0, 356), 5: (0, 371)}, 47: {22: (1, {'@': 274}), 19: (1, {'@': 274}), 23: (1, {'@': 274}), 21: (1, {'@': 274}), 24: (1, {'@': 274}), 3: (1, {'@': 274}), 11: (1, {'@': 274}), 14: (1, {'@': 274}), 17: (1, {'@': 274}), 4: (1, {'@': 274}), 10: (1, {'@': 274}), 15: (1, {'@': 274}), 6: (1, {'@': 274}), 25: (1, {'@': 274}), 2: (1, {'@': 274}), 9: (1, {'@': 274}), 13: (1, {'@': 274}), 26: (1, {'@': 274}), 20: (1, {'@': 274}), 1: (1, {'@': 274}), 5: (1, {'@': 274}), 27: (1, {'@': 274}), 28: (1, {'@': 274}), 29: (1, {'@': 274}), 30: (1, {'@': 274}), 12: (1, {'@': 274}), 31: (1, {'@': 274}), 18: (1, {'@': 274}), 32: (1, {'@': 274}), 33: (1, {'@': 274}), 34: (1, {'@': 274}), 35: (1, {'@': 274})}, 48: {48: (1, {'@': 84}), 65: (1, {'@': 84}), 56: (1, {'@': 84}), 12: (1, {'@': 84}), 31: (1, {'@': 84}), 59: (1, {'@': 84}), 5: (1, {'@': 84}), 43: (1, {'@': 84}), 21: (1, {'@': 84}), 24: (1, {'@': 84}), 61: (1, {'@': 84}), 18: (1, {'@': 84}), 37: (1, {'@': 84})}, 49: {22: (1, {'@': 101}), 19: (1, {'@': 101}), 23: (1, {'@': 101}), 21: (1, {'@': 101}), 24: (1, {'@': 101}), 3: (1, {'@': 101}), 11: (1, {'@': 101}), 14: (1, {'@': 101}), 17: (1, {'@': 101}), 4: (1, {'@': 101}), 10: (1, {'@': 101}), 15: (1, {'@': 101}), 6: (1, {'@': 101}), 25: (1, {'@': 101}), 2: (1, {'@': 101}), 9: (1, {'@': 101}), 13: (1, {'@': 101}), 26: (1, {'@': 101}), 20: (1, {'@': 101}), 1: (1, {'@': 101}), 5: (1, {'@': 101}), 27: (1, {'@': 101}), 28: (1, {'@': 101}), 29: (1, {'@': 101}), 30: (1, {'@': 101}), 12: (1, {'@': 101}), 31: (1, {'@': 101}), 18: (1, {'@': 101}), 32: (1, {'@': 101}), 33: (1, {'@': 101}), 34: (1, {'@': 101}), 35: (1, {'@': 101})}, 50: {7: (0, 591), 0: (0, 452), 30: (0, 489), 29: (0, 327), 12: (0, 405), 68: (0, 554), 18: (0, 356), 5: (0, 371)}, 51: {22: (1, {'@': 299}), 19: (1, {'@': 299}), 23: (1, {'@': 299}), 21: (1, {'@': 299}), 24: (1, {'@': 299}), 3: (1, {'@': 299}), 11: (1, {'@': 299}), 14: (1, {'@': 299}), 17: (1, {'@': 299}), 4: (1, {'@': 299}), 10: (1, {'@': 299}), 15: (1, {'@': 299}), 6: (1, {'@': 299}), 25: (1, {'@': 299}), 2: (1, {'@': 299}), 9: (1, {'@': 299}), 13: (1, {'@': 299}), 26: (1, {'@': 299}), 20: (1, {'@': 299}), 1: (1, {'@': 299}), 5: (1, {'@': 299}), 27: (1, {'@': 299}), 28: (1, {'@': 299}), 29: (1, {'@': 299}), 30: (1, {'@': 299}), 12: (1, {'@': 299}), 31: (1, {'@': 299}), 18: (1, {'@': 299}), 32: (1, {'@': 299}), 33: (1, {'@': 299}), 34: (1, {'@': 299}), 35: (1, {'@': 299})}, 52: {0: (0, 452), 30: (0, 526), 7: (0, 531), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 53: {22: (1, {'@': 231}), 19: (1, {'@': 231}), 23: (1, {'@': 231}), 21: (1, {'@': 231}), 24: (1, {'@': 231}), 3: (1, {'@': 231}), 11: (1, {'@': 231}), 14: (1, {'@': 231}), 17: (1, {'@': 231}), 4: (1, {'@': 231}), 10: (1, {'@': 231}), 15: (1, {'@': 231}), 6: (1, {'@': 231}), 25: (1, {'@': 231}), 2: (1, {'@': 231}), 9: (1, {'@': 231}), 13: (1, {'@': 231}), 26: (1, {'@': 231}), 20: (1, {'@': 231}), 1: (1, {'@': 231}), 5: (1, {'@': 231}), 27: (1, {'@': 231}), 28: (1, {'@': 231}), 29: (1, {'@': 231}), 30: (1, {'@': 231}), 12: (1, {'@': 231}), 31: (1, {'@': 231}), 18: (1, {'@': 231}), 32: (1, {'@': 231}), 33: (1, {'@': 231}), 34: (1, {'@': 231}), 35: (1, {'@': 231})}, 54: {30: (0, 225)}, 55: {30: (0, 101)}, 56: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 7: (0, 281), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 50: (0, 182), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 57: {22: (1, {'@': 180}), 19: (1, {'@': 180}), 23: (1, {'@': 180}), 21: (1, {'@': 180}), 24: (1, {'@': 180}), 3: (1, {'@': 180}), 11: (1, {'@': 180}), 14: (1, {'@': 180}), 17: (1, {'@': 180}), 4: (1, {'@': 180}), 10: (1, {'@': 180}), 15: (1, {'@': 180}), 6: (1, {'@': 180}), 25: (1, {'@': 180}), 2: (1, {'@': 180}), 9: (1, {'@': 180}), 13: (1, {'@': 180}), 26: (1, {'@': 180}), 20: (1, {'@': 180}), 1: (1, {'@': 180}), 5: (1, {'@': 180}), 27: (1, {'@': 180}), 28: (1, {'@': 180}), 29: (1, {'@': 180}), 30: (1, {'@': 180}), 12: (1, {'@': 180}), 31: (1, {'@': 180}), 18: (1, {'@': 180}), 32: (1, {'@': 180}), 33: (1, {'@': 180}), 34: (1, {'@': 180}), 35: (1, {'@': 180})}, 58: {30: (0, 535)}, 59: {22: (1, {'@': 98}), 19: (1, {'@': 98}), 23: (1, {'@': 98}), 21: (1, {'@': 98}), 24: (1, {'@': 98}), 3: (1, {'@': 98}), 11: (1, {'@': 98}), 14: (1, {'@': 98}), 17: (1, {'@': 98}), 4: (1, {'@': 98}), 10: (1, {'@': 98}), 15: (1, {'@': 98}), 6: (1, {'@': 98}), 25: (1, {'@': 98}), 2: (1, {'@': 98}), 9: (1, {'@': 98}), 13: (1, {'@': 98}), 26: (1, {'@': 98}), 20: (1, {'@': 98}), 1: (1, {'@': 98}), 5: (1, {'@': 98}), 27: (1, {'@': 98}), 28: (1, {'@': 98}), 29: (1, {'@': 98}), 30: (1, {'@': 98}), 12: (1, {'@': 98}), 31: (1, {'@': 98}), 18: (1, {'@': 98}), 32: (1, {'@': 98}), 33: (1, {'@': 98}), 34: (1, {'@': 98}), 35: (1, {'@': 98})}, 60: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 50: (0, 154), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 61: {22: (1, {'@': 300}), 19: (1, {'@': 300}), 23: (1, {'@': 300}), 21: (1, {'@': 300}), 24: (1, {'@': 300}), 3: (1, {'@': 300}), 11: (1, {'@': 300}), 14: (1, {'@': 300}), 17: (1, {'@': 300}), 4: (1, {'@': 300}), 10: (1, {'@': 300}), 15: (1, {'@': 300}), 6: (1, {'@': 300}), 25: (1, {'@': 300}), 2: (1, {'@': 300}), 9: (1, {'@': 300}), 13: (1, {'@': 300}), 26: (1, {'@': 300}), 20: (1, {'@': 300}), 1: (1, {'@': 300}), 5: (1, {'@': 300}), 27: (1, {'@': 300}), 28: (1, {'@': 300}), 29: (1, {'@': 300}), 30: (1, {'@': 300}), 12: (1, {'@': 300}), 31: (1, {'@': 300}), 18: (1, {'@': 300}), 32: (1, {'@': 300}), 33: (1, {'@': 300}), 34: (1, {'@': 300}), 35: (1, {'@': 300})}, 62: {69: (0, 158), 24: (0, 56), 23: (0, 696), 70: (0, 198), 71: (0, 202), 22: (1, {'@': 192}), 5: (1, {'@': 192}), 21: (1, {'@': 192}), 3: (1, {'@': 192}), 27: (1, {'@': 192}), 11: (1, {'@': 192}), 17: (1, {'@': 192}), 28: (1, {'@': 192}), 29: (1, {'@': 192}), 30: (1, {'@': 192}), 6: (1, {'@': 192}), 25: (1, {'@': 192}), 12: (1, {'@': 192}), 31: (1, {'@': 192}), 13: (1, {'@': 192}), 18: (1, {'@': 192}), 32: (1, {'@': 192}), 33: (1, {'@': 192}), 34: (1, {'@': 192}), 19: (1, {'@': 192}), 14: (1, {'@': 192}), 4: (1, {'@': 192}), 10: (1, {'@': 192}), 15: (1, {'@': 192}), 2: (1, {'@': 192}), 9: (1, {'@': 192}), 26: (1, {'@': 192}), 35: (1, {'@': 192}), 20: (1, {'@': 192}), 1: (1, {'@': 192})}, 63: {22: (1, {'@': 266}), 19: (1, {'@': 266}), 23: (1, {'@': 266}), 21: (1, {'@': 266}), 24: (1, {'@': 266}), 3: (1, {'@': 266}), 11: (1, {'@': 266}), 14: (1, {'@': 266}), 17: (1, {'@': 266}), 4: (1, {'@': 266}), 10: (1, {'@': 266}), 15: (1, {'@': 266}), 6: (1, {'@': 266}), 25: (1, {'@': 266}), 2: (1, {'@': 266}), 9: (1, {'@': 266}), 13: (1, {'@': 266}), 26: (1, {'@': 266}), 20: (1, {'@': 266}), 1: (1, {'@': 266}), 5: (1, {'@': 266}), 27: (1, {'@': 266}), 28: (1, {'@': 266}), 29: (1, {'@': 266}), 30: (1, {'@': 266}), 12: (1, {'@': 266}), 31: (1, {'@': 266}), 18: (1, {'@': 266}), 32: (1, {'@': 266}), 33: (1, {'@': 266}), 34: (1, {'@': 266}), 35: (1, {'@': 266})}, 64: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 593), 5: (0, 371), 30: (0, 3)}, 65: {30: (0, 106)}, 66: {48: (1, {'@': 83}), 65: (1, {'@': 83}), 56: (1, {'@': 83}), 12: (1, {'@': 83}), 31: (1, {'@': 83}), 59: (1, {'@': 83}), 5: (1, {'@': 83}), 43: (1, {'@': 83}), 21: (1, {'@': 83}), 24: (1, {'@': 83}), 61: (1, {'@': 83}), 18: (1, {'@': 83}), 37: (1, {'@': 83})}, 67: {22: (1, {'@': 181}), 19: (1, {'@': 181}), 23: (1, {'@': 181}), 21: (1, {'@': 181}), 24: (1, {'@': 181}), 3: (1, {'@': 181}), 11: (1, {'@': 181}), 14: (1, {'@': 181}), 17: (1, {'@': 181}), 4: (1, {'@': 181}), 10: (1, {'@': 181}), 15: (1, {'@': 181}), 6: (1, {'@': 181}), 25: (1, {'@': 181}), 2: (1, {'@': 181}), 9: (1, {'@': 181}), 13: (1, {'@': 181}), 26: (1, {'@': 181}), 20: (1, {'@': 181}), 1: (1, {'@': 181}), 5: (1, {'@': 181}), 27: (1, {'@': 181}), 28: (1, {'@': 181}), 29: (1, {'@': 181}), 30: (1, {'@': 181}), 12: (1, {'@': 181}), 31: (1, {'@': 181}), 18: (1, {'@': 181}), 32: (1, {'@': 181}), 33: (1, {'@': 181}), 34: (1, {'@': 181}), 35: (1, {'@': 181})}, 68: {22: (1, {'@': 289}), 19: (1, {'@': 289}), 23: (1, {'@': 289}), 21: (1, {'@': 289}), 24: (1, {'@': 289}), 3: (1, {'@': 289}), 11: (1, {'@': 289}), 14: (1, {'@': 289}), 17: (1, {'@': 289}), 4: (1, {'@': 289}), 10: (1, {'@': 289}), 15: (1, {'@': 289}), 6: (1, {'@': 289}), 25: (1, {'@': 289}), 2: (1, {'@': 289}), 9: (1, {'@': 289}), 13: (1, {'@': 289}), 26: (1, {'@': 289}), 20: (1, {'@': 289}), 1: (1, {'@': 289}), 5: (1, {'@': 289}), 27: (1, {'@': 289}), 28: (1, {'@': 289}), 29: (1, {'@': 289}), 30: (1, {'@': 289}), 12: (1, {'@': 289}), 31: (1, {'@': 289}), 18: (1, {'@': 289}), 32: (1, {'@': 289}), 33: (1, {'@': 289}), 34: (1, {'@': 289}), 35: (1, {'@': 289})}, 69: {30: (0, 539)}, 70: {37: (0, 709), 24: (0, 711), 0: (0, 452), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 5: (0, 371), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 284), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59), 7: (0, 293)}, 71: {68: (0, 500), 0: (0, 452), 7: (0, 507), 29: (0, 327), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 512)}, 72: {22: (1, {'@': 179}), 19: (1, {'@': 179}), 23: (1, {'@': 179}), 21: (1, {'@': 179}), 24: (1, {'@': 179}), 3: (1, {'@': 179}), 11: (1, {'@': 179}), 14: (1, {'@': 179}), 17: (1, {'@': 179}), 4: (1, {'@': 179}), 10: (1, {'@': 179}), 15: (1, {'@': 179}), 6: (1, {'@': 179}), 25: (1, {'@': 179}), 2: (1, {'@': 179}), 9: (1, {'@': 179}), 13: (1, {'@': 179}), 26: (1, {'@': 179}), 20: (1, {'@': 179}), 1: (1, {'@': 179}), 5: (1, {'@': 179}), 27: (1, {'@': 179}), 28: (1, {'@': 179}), 29: (1, {'@': 179}), 30: (1, {'@': 179}), 12: (1, {'@': 179}), 31: (1, {'@': 179}), 18: (1, {'@': 179}), 32: (1, {'@': 179}), 33: (1, {'@': 179}), 34: (1, {'@': 179}), 35: (1, {'@': 179})}, 73: {28: (0, 305), 0: (0, 452), 72: (0, 519), 7: (0, 523), 5: (0, 371), 12: (0, 405), 18: (0, 356)}, 74: {22: (1, {'@': 315}), 19: (1, {'@': 315}), 23: (1, {'@': 315}), 21: (1, {'@': 315}), 24: (1, {'@': 315}), 3: (1, {'@': 315}), 11: (1, {'@': 315}), 14: (1, {'@': 315}), 17: (1, {'@': 315}), 4: (1, {'@': 315}), 10: (1, {'@': 315}), 15: (1, {'@': 315}), 6: (1, {'@': 315}), 25: (1, {'@': 315}), 2: (1, {'@': 315}), 9: (1, {'@': 315}), 13: (1, {'@': 315}), 26: (1, {'@': 315}), 20: (1, {'@': 315}), 1: (1, {'@': 315}), 5: (1, {'@': 315}), 27: (1, {'@': 315}), 28: (1, {'@': 315}), 29: (1, {'@': 315}), 30: (1, {'@': 315}), 12: (1, {'@': 315}), 31: (1, {'@': 315}), 18: (1, {'@': 315}), 32: (1, {'@': 315}), 33: (1, {'@': 315}), 34: (1, {'@': 315}), 35: (1, {'@': 315})}, 75: {7: (0, 110), 0: (0, 452), 68: (0, 114), 29: (0, 327), 30: (0, 122), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 76: {22: (1, {'@': 193}), 19: (1, {'@': 193}), 23: (1, {'@': 193}), 21: (1, {'@': 193}), 24: (1, {'@': 193}), 3: (1, {'@': 193}), 11: (1, {'@': 193}), 14: (1, {'@': 193}), 17: (1, {'@': 193}), 4: (1, {'@': 193}), 10: (1, {'@': 193}), 15: (1, {'@': 193}), 6: (1, {'@': 193}), 25: (1, {'@': 193}), 2: (1, {'@': 193}), 9: (1, {'@': 193}), 13: (1, {'@': 193}), 26: (1, {'@': 193}), 20: (1, {'@': 193}), 1: (1, {'@': 193}), 5: (1, {'@': 193}), 27: (1, {'@': 193}), 28: (1, {'@': 193}), 29: (1, {'@': 193}), 30: (1, {'@': 193}), 12: (1, {'@': 193}), 31: (1, {'@': 193}), 18: (1, {'@': 193}), 32: (1, {'@': 193}), 33: (1, {'@': 193}), 34: (1, {'@': 193}), 35: (1, {'@': 193})}, 77: {22: (1, {'@': 441}), 5: (1, {'@': 441}), 21: (1, {'@': 441}), 3: (1, {'@': 441}), 24: (1, {'@': 441}), 27: (1, {'@': 441}), 11: (1, {'@': 441}), 17: (1, {'@': 441}), 28: (1, {'@': 441}), 29: (1, {'@': 441}), 30: (1, {'@': 441}), 6: (1, {'@': 441}), 25: (1, {'@': 441}), 12: (1, {'@': 441}), 31: (1, {'@': 441}), 13: (1, {'@': 441}), 18: (1, {'@': 441}), 32: (1, {'@': 441}), 33: (1, {'@': 441}), 34: (1, {'@': 441}), 19: (1, {'@': 441}), 23: (1, {'@': 441}), 14: (1, {'@': 441}), 4: (1, {'@': 441}), 10: (1, {'@': 441}), 15: (1, {'@': 441}), 2: (1, {'@': 441}), 9: (1, {'@': 441}), 26: (1, {'@': 441}), 35: (1, {'@': 441}), 20: (1, {'@': 441}), 1: (1, {'@': 441})}, 78: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 641), 3: (0, 522), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 79: {30: (0, 167)}, 80: {22: (1, {'@': 182}), 19: (1, {'@': 182}), 23: (1, {'@': 182}), 21: (1, {'@': 182}), 24: (1, {'@': 182}), 3: (1, {'@': 182}), 11: (1, {'@': 182}), 14: (1, {'@': 182}), 17: (1, {'@': 182}), 4: (1, {'@': 182}), 10: (1, {'@': 182}), 15: (1, {'@': 182}), 6: (1, {'@': 182}), 25: (1, {'@': 182}), 2: (1, {'@': 182}), 9: (1, {'@': 182}), 13: (1, {'@': 182}), 26: (1, {'@': 182}), 20: (1, {'@': 182}), 1: (1, {'@': 182}), 5: (1, {'@': 182}), 27: (1, {'@': 182}), 28: (1, {'@': 182}), 29: (1, {'@': 182}), 30: (1, {'@': 182}), 12: (1, {'@': 182}), 31: (1, {'@': 182}), 18: (1, {'@': 182}), 32: (1, {'@': 182}), 33: (1, {'@': 182}), 34: (1, {'@': 182}), 35: (1, {'@': 182})}, 81: {22: (1, {'@': 313}), 19: (1, {'@': 313}), 23: (1, {'@': 313}), 21: (1, {'@': 313}), 24: (1, {'@': 313}), 3: (1, {'@': 313}), 11: (1, {'@': 313}), 14: (1, {'@': 313}), 17: (1, {'@': 313}), 4: (1, {'@': 313}), 10: (1, {'@': 313}), 15: (1, {'@': 313}), 6: (1, {'@': 313}), 25: (1, {'@': 313}), 2: (1, {'@': 313}), 9: (1, {'@': 313}), 13: (1, {'@': 313}), 26: (1, {'@': 313}), 20: (1, {'@': 313}), 1: (1, {'@': 313}), 5: (1, {'@': 313}), 27: (1, {'@': 313}), 28: (1, {'@': 313}), 29: (1, {'@': 313}), 30: (1, {'@': 313}), 12: (1, {'@': 313}), 31: (1, {'@': 313}), 18: (1, {'@': 313}), 32: (1, {'@': 313}), 33: (1, {'@': 313}), 34: (1, {'@': 313}), 35: (1, {'@': 313})}, 82: {22: (1, {'@': 295}), 19: (1, {'@': 295}), 23: (1, {'@': 295}), 21: (1, {'@': 295}), 24: (1, {'@': 295}), 3: (1, {'@': 295}), 11: (1, {'@': 295}), 14: (1, {'@': 295}), 17: (1, {'@': 295}), 4: (1, {'@': 295}), 10: (1, {'@': 295}), 15: (1, {'@': 295}), 6: (1, {'@': 295}), 25: (1, {'@': 295}), 2: (1, {'@': 295}), 9: (1, {'@': 295}), 13: (1, {'@': 295}), 26: (1, {'@': 295}), 20: (1, {'@': 295}), 1: (1, {'@': 295}), 5: (1, {'@': 295}), 27: (1, {'@': 295}), 28: (1, {'@': 295}), 29: (1, {'@': 295}), 30: (1, {'@': 295}), 12: (1, {'@': 295}), 31: (1, {'@': 295}), 18: (1, {'@': 295}), 32: (1, {'@': 295}), 33: (1, {'@': 295}), 34: (1, {'@': 295}), 35: (1, {'@': 295})}, 83: {48: (1, {'@': 85}), 65: (1, {'@': 85}), 56: (1, {'@': 85}), 12: (1, {'@': 85}), 31: (1, {'@': 85}), 59: (1, {'@': 85}), 5: (1, {'@': 85}), 43: (1, {'@': 85}), 21: (1, {'@': 85}), 24: (1, {'@': 85}), 61: (1, {'@': 85}), 18: (1, {'@': 85}), 37: (1, {'@': 85})}, 84: {31: (0, 348), 61: (0, 697), 37: (0, 722), 42: (0, 732)}, 85: {22: (1, {'@': 304}), 19: (1, {'@': 304}), 23: (1, {'@': 304}), 21: (1, {'@': 304}), 24: (1, {'@': 304}), 3: (1, {'@': 304}), 11: (1, {'@': 304}), 14: (1, {'@': 304}), 17: (1, {'@': 304}), 4: (1, {'@': 304}), 10: (1, {'@': 304}), 15: (1, {'@': 304}), 6: (1, {'@': 304}), 25: (1, {'@': 304}), 2: (1, {'@': 304}), 9: (1, {'@': 304}), 13: (1, {'@': 304}), 26: (1, {'@': 304}), 20: (1, {'@': 304}), 1: (1, {'@': 304}), 5: (1, {'@': 304}), 27: (1, {'@': 304}), 28: (1, {'@': 304}), 29: (1, {'@': 304}), 30: (1, {'@': 304}), 12: (1, {'@': 304}), 31: (1, {'@': 304}), 18: (1, {'@': 304}), 32: (1, {'@': 304}), 33: (1, {'@': 304}), 34: (1, {'@': 304}), 35: (1, {'@': 304})}, 86: {30: (0, 544)}, 87: {48: (1, {'@': 77}), 65: (1, {'@': 77}), 56: (1, {'@': 77}), 12: (1, {'@': 77}), 31: (1, {'@': 77}), 59: (1, {'@': 77}), 5: (1, {'@': 77}), 43: (1, {'@': 77}), 21: (1, {'@': 77}), 24: (1, {'@': 77}), 61: (1, {'@': 77}), 18: (1, {'@': 77}), 37: (1, {'@': 77})}, 88: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 720), 7: (0, 130)}, 89: {44: (0, 679), 59: (0, 23)}, 90: {34: (0, 231)}, 91: {0: (0, 452), 18: (0, 356), 7: (0, 463), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 366}), 65: (1, {'@': 366}), 56: (1, {'@': 366}), 31: (1, {'@': 366}), 59: (1, {'@': 366}), 43: (1, {'@': 366}), 21: (1, {'@': 366}), 24: (1, {'@': 366}), 61: (1, {'@': 366}), 37: (1, {'@': 366})}, 92: {22: (1, {'@': 292}), 19: (1, {'@': 292}), 23: (1, {'@': 292}), 21: (1, {'@': 292}), 24: (1, {'@': 292}), 3: (1, {'@': 292}), 11: (1, {'@': 292}), 14: (1, {'@': 292}), 17: (1, {'@': 292}), 4: (1, {'@': 292}), 10: (1, {'@': 292}), 15: (1, {'@': 292}), 6: (1, {'@': 292}), 25: (1, {'@': 292}), 2: (1, {'@': 292}), 9: (1, {'@': 292}), 13: (1, {'@': 292}), 26: (1, {'@': 292}), 20: (1, {'@': 292}), 1: (1, {'@': 292}), 5: (1, {'@': 292}), 27: (1, {'@': 292}), 28: (1, {'@': 292}), 29: (1, {'@': 292}), 30: (1, {'@': 292}), 12: (1, {'@': 292}), 31: (1, {'@': 292}), 18: (1, {'@': 292}), 32: (1, {'@': 292}), 33: (1, {'@': 292}), 34: (1, {'@': 292}), 35: (1, {'@': 292})}, 93: {48: (1, {'@': 80}), 65: (1, {'@': 80}), 56: (1, {'@': 80}), 12: (1, {'@': 80}), 31: (1, {'@': 80}), 59: (1, {'@': 80}), 5: (1, {'@': 80}), 43: (1, {'@': 80}), 21: (1, {'@': 80}), 24: (1, {'@': 80}), 61: (1, {'@': 80}), 18: (1, {'@': 80}), 37: (1, {'@': 80})}, 94: {0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 7: (0, 217), 5: (0, 371), 50: (0, 238), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 95: {22: (1, {'@': 196}), 19: (1, {'@': 196}), 23: (1, {'@': 196}), 21: (1, {'@': 196}), 24: (1, {'@': 196}), 3: (1, {'@': 196}), 11: (1, {'@': 196}), 14: (1, {'@': 196}), 17: (1, {'@': 196}), 4: (1, {'@': 196}), 10: (1, {'@': 196}), 15: (1, {'@': 196}), 6: (1, {'@': 196}), 25: (1, {'@': 196}), 2: (1, {'@': 196}), 9: (1, {'@': 196}), 13: (1, {'@': 196}), 26: (1, {'@': 196}), 20: (1, {'@': 196}), 1: (1, {'@': 196}), 5: (1, {'@': 196}), 27: (1, {'@': 196}), 28: (1, {'@': 196}), 29: (1, {'@': 196}), 30: (1, {'@': 196}), 12: (1, {'@': 196}), 31: (1, {'@': 196}), 18: (1, {'@': 196}), 32: (1, {'@': 196}), 33: (1, {'@': 196}), 34: (1, {'@': 196}), 35: (1, {'@': 196})}, 96: {22: (1, {'@': 283}), 19: (1, {'@': 283}), 23: (1, {'@': 283}), 21: (1, {'@': 283}), 24: (1, {'@': 283}), 3: (1, {'@': 283}), 11: (1, {'@': 283}), 14: (1, {'@': 283}), 17: (1, {'@': 283}), 4: (1, {'@': 283}), 10: (1, {'@': 283}), 15: (1, {'@': 283}), 6: (1, {'@': 283}), 25: (1, {'@': 283}), 2: (1, {'@': 283}), 9: (1, {'@': 283}), 13: (1, {'@': 283}), 26: (1, {'@': 283}), 20: (1, {'@': 283}), 1: (1, {'@': 283}), 5: (1, {'@': 283}), 27: (1, {'@': 283}), 28: (1, {'@': 283}), 29: (1, {'@': 283}), 30: (1, {'@': 283}), 12: (1, {'@': 283}), 31: (1, {'@': 283}), 18: (1, {'@': 283}), 32: (1, {'@': 283}), 33: (1, {'@': 283}), 34: (1, {'@': 283}), 35: (1, {'@': 283})}, 97: {22: (1, {'@': 293}), 19: (1, {'@': 293}), 23: (1, {'@': 293}), 21: (1, {'@': 293}), 24: (1, {'@': 293}), 3: (1, {'@': 293}), 11: (1, {'@': 293}), 14: (1, {'@': 293}), 17: (1, {'@': 293}), 4: (1, {'@': 293}), 10: (1, {'@': 293}), 15: (1, {'@': 293}), 6: (1, {'@': 293}), 25: (1, {'@': 293}), 2: (1, {'@': 293}), 9: (1, {'@': 293}), 13: (1, {'@': 293}), 26: (1, {'@': 293}), 20: (1, {'@': 293}), 1: (1, {'@': 293}), 5: (1, {'@': 293}), 27: (1, {'@': 293}), 28: (1, {'@': 293}), 29: (1, {'@': 293}), 30: (1, {'@': 293}), 12: (1, {'@': 293}), 31: (1, {'@': 293}), 18: (1, {'@': 293}), 32: (1, {'@': 293}), 33: (1, {'@': 293}), 34: (1, {'@': 293}), 35: (1, {'@': 293})}, 98: {48: (1, {'@': 88}), 65: (1, {'@': 88}), 56: (1, {'@': 88}), 12: (1, {'@': 88}), 31: (1, {'@': 88}), 59: (1, {'@': 88}), 5: (1, {'@': 88}), 43: (1, {'@': 88}), 21: (1, {'@': 88}), 24: (1, {'@': 88}), 61: (1, {'@': 88}), 18: (1, {'@': 88}), 37: (1, {'@': 88})}, 99: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 81), 7: (0, 109)}, 100: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 259), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 101: {22: (1, {'@': 298}), 19: (1, {'@': 298}), 23: (1, {'@': 298}), 21: (1, {'@': 298}), 24: (1, {'@': 298}), 3: (1, {'@': 298}), 11: (1, {'@': 298}), 14: (1, {'@': 298}), 17: (1, {'@': 298}), 4: (1, {'@': 298}), 10: (1, {'@': 298}), 15: (1, {'@': 298}), 6: (1, {'@': 298}), 25: (1, {'@': 298}), 2: (1, {'@': 298}), 9: (1, {'@': 298}), 13: (1, {'@': 298}), 26: (1, {'@': 298}), 20: (1, {'@': 298}), 1: (1, {'@': 298}), 5: (1, {'@': 298}), 27: (1, {'@': 298}), 28: (1, {'@': 298}), 29: (1, {'@': 298}), 30: (1, {'@': 298}), 12: (1, {'@': 298}), 31: (1, {'@': 298}), 18: (1, {'@': 298}), 32: (1, {'@': 298}), 33: (1, {'@': 298}), 34: (1, {'@': 298}), 35: (1, {'@': 298})}, 102: {48: (1, {'@': 81}), 65: (1, {'@': 81}), 56: (1, {'@': 81}), 12: (1, {'@': 81}), 31: (1, {'@': 81}), 59: (1, {'@': 81}), 5: (1, {'@': 81}), 43: (1, {'@': 81}), 21: (1, {'@': 81}), 24: (1, {'@': 81}), 61: (1, {'@': 81}), 18: (1, {'@': 81}), 37: (1, {'@': 81})}, 103: {0: (0, 452), 30: (0, 598), 7: (0, 484), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 104: {30: (0, 147)}, 105: {68: (0, 430), 0: (0, 452), 30: (0, 600), 29: (0, 327), 7: (0, 134), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 106: {22: (1, {'@': 288}), 19: (1, {'@': 288}), 23: (1, {'@': 288}), 21: (1, {'@': 288}), 24: (1, {'@': 288}), 3: (1, {'@': 288}), 11: (1, {'@': 288}), 14: (1, {'@': 288}), 17: (1, {'@': 288}), 4: (1, {'@': 288}), 10: (1, {'@': 288}), 15: (1, {'@': 288}), 6: (1, {'@': 288}), 25: (1, {'@': 288}), 2: (1, {'@': 288}), 9: (1, {'@': 288}), 13: (1, {'@': 288}), 26: (1, {'@': 288}), 20: (1, {'@': 288}), 1: (1, {'@': 288}), 5: (1, {'@': 288}), 27: (1, {'@': 288}), 28: (1, {'@': 288}), 29: (1, {'@': 288}), 30: (1, {'@': 288}), 12: (1, {'@': 288}), 31: (1, {'@': 288}), 18: (1, {'@': 288}), 32: (1, {'@': 288}), 33: (1, {'@': 288}), 34: (1, {'@': 288}), 35: (1, {'@': 288})}, 107: {48: (1, {'@': 87}), 65: (1, {'@': 87}), 56: (1, {'@': 87}), 12: (1, {'@': 87}), 31: (1, {'@': 87}), 59: (1, {'@': 87}), 5: (1, {'@': 87}), 43: (1, {'@': 87}), 21: (1, {'@': 87}), 24: (1, {'@': 87}), 61: (1, {'@': 87}), 18: (1, {'@': 87}), 37: (1, {'@': 87})}, 108: {22: (1, {'@': 318}), 19: (1, {'@': 318}), 23: (1, {'@': 318}), 21: (1, {'@': 318}), 24: (1, {'@': 318}), 3: (1, {'@': 318}), 11: (1, {'@': 318}), 14: (1, {'@': 318}), 17: (1, {'@': 318}), 4: (1, {'@': 318}), 10: (1, {'@': 318}), 15: (1, {'@': 318}), 6: (1, {'@': 318}), 25: (1, {'@': 318}), 2: (1, {'@': 318}), 9: (1, {'@': 318}), 13: (1, {'@': 318}), 26: (1, {'@': 318}), 20: (1, {'@': 318}), 1: (1, {'@': 318}), 5: (1, {'@': 318}), 27: (1, {'@': 318}), 28: (1, {'@': 318}), 29: (1, {'@': 318}), 30: (1, {'@': 318}), 12: (1, {'@': 318}), 31: (1, {'@': 318}), 18: (1, {'@': 318}), 32: (1, {'@': 318}), 33: (1, {'@': 318}), 34: (1, {'@': 318}), 35: (1, {'@': 318})}, 109: {30: (0, 150)}, 110: {30: (0, 548)}, 111: {30: (0, 234)}, 112: {0: (0, 452), 7: (0, 738), 42: (0, 73), 5: (0, 371), 12: (0, 405), 31: (0, 348), 18: (0, 356)}, 113: {22: (1, {'@': 314}), 19: (1, {'@': 314}), 23: (1, {'@': 314}), 21: (1, {'@': 314}), 24: (1, {'@': 314}), 3: (1, {'@': 314}), 11: (1, {'@': 314}), 14: (1, {'@': 314}), 17: (1, {'@': 314}), 4: (1, {'@': 314}), 10: (1, {'@': 314}), 15: (1, {'@': 314}), 6: (1, {'@': 314}), 25: (1, {'@': 314}), 2: (1, {'@': 314}), 9: (1, {'@': 314}), 13: (1, {'@': 314}), 26: (1, {'@': 314}), 20: (1, {'@': 314}), 1: (1, {'@': 314}), 5: (1, {'@': 314}), 27: (1, {'@': 314}), 28: (1, {'@': 314}), 29: (1, {'@': 314}), 30: (1, {'@': 314}), 12: (1, {'@': 314}), 31: (1, {'@': 314}), 18: (1, {'@': 314}), 32: (1, {'@': 314}), 33: (1, {'@': 314}), 34: (1, {'@': 314}), 35: (1, {'@': 314})}, 114: {7: (0, 550), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 552)}, 115: {73: (0, 475), 31: (0, 348), 74: (0, 480), 42: (0, 363), 75: (0, 355), 76: (0, 397), 30: (1, {'@': 48})}, 116: {30: (0, 428)}, 117: {48: (1, {'@': 391}), 65: (1, {'@': 391}), 56: (1, {'@': 391}), 12: (1, {'@': 391}), 31: (1, {'@': 391}), 59: (1, {'@': 391}), 5: (1, {'@': 391}), 43: (1, {'@': 391}), 21: (1, {'@': 391}), 24: (1, {'@': 391}), 61: (1, {'@': 391}), 18: (1, {'@': 391}), 37: (1, {'@': 391})}, 118: {48: (0, 735), 25: (0, 100), 3: (0, 119), 22: (1, {'@': 103}), 19: (1, {'@': 103}), 23: (1, {'@': 103}), 21: (1, {'@': 103}), 24: (1, {'@': 103}), 11: (1, {'@': 103}), 14: (1, {'@': 103}), 17: (1, {'@': 103}), 4: (1, {'@': 103}), 10: (1, {'@': 103}), 15: (1, {'@': 103}), 6: (1, {'@': 103}), 2: (1, {'@': 103}), 9: (1, {'@': 103}), 13: (1, {'@': 103}), 26: (1, {'@': 103}), 20: (1, {'@': 103}), 1: (1, {'@': 103})}, 119: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 308), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 120: {30: (0, 155)}, 121: {0: (0, 452), 18: (0, 356), 30: (0, 425), 7: (0, 426), 12: (0, 405), 5: (0, 371)}, 122: {22: (1, {'@': 280}), 19: (1, {'@': 280}), 23: (1, {'@': 280}), 21: (1, {'@': 280}), 24: (1, {'@': 280}), 3: (1, {'@': 280}), 11: (1, {'@': 280}), 14: (1, {'@': 280}), 17: (1, {'@': 280}), 4: (1, {'@': 280}), 10: (1, {'@': 280}), 15: (1, {'@': 280}), 6: (1, {'@': 280}), 25: (1, {'@': 280}), 2: (1, {'@': 280}), 9: (1, {'@': 280}), 13: (1, {'@': 280}), 26: (1, {'@': 280}), 20: (1, {'@': 280}), 1: (1, {'@': 280}), 5: (1, {'@': 280}), 27: (1, {'@': 280}), 28: (1, {'@': 280}), 29: (1, {'@': 280}), 30: (1, {'@': 280}), 12: (1, {'@': 280}), 31: (1, {'@': 280}), 18: (1, {'@': 280}), 32: (1, {'@': 280}), 33: (1, {'@': 280}), 34: (1, {'@': 280}), 35: (1, {'@': 280})}, 123: {3: (0, 617)}, 124: {0: (0, 452), 37: (0, 709), 7: (0, 140), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 289), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 125: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 714), 48: (1, {'@': 402}), 65: (1, {'@': 402}), 56: (1, {'@': 402}), 31: (1, {'@': 402}), 59: (1, {'@': 402}), 43: (1, {'@': 402}), 21: (1, {'@': 402}), 24: (1, {'@': 402}), 61: (1, {'@': 402}), 37: (1, {'@': 402})}, 126: {22: (1, {'@': 148}), 19: (1, {'@': 148}), 23: (1, {'@': 148}), 21: (1, {'@': 148}), 24: (1, {'@': 148}), 3: (1, {'@': 148}), 11: (1, {'@': 148}), 14: (1, {'@': 148}), 17: (1, {'@': 148}), 4: (1, {'@': 148}), 10: (1, {'@': 148}), 15: (1, {'@': 148}), 6: (1, {'@': 148}), 25: (1, {'@': 148}), 2: (1, {'@': 148}), 9: (1, {'@': 148}), 13: (1, {'@': 148}), 26: (1, {'@': 148}), 20: (1, {'@': 148}), 1: (1, {'@': 148}), 5: (1, {'@': 148}), 27: (1, {'@': 148}), 28: (1, {'@': 148}), 29: (1, {'@': 148}), 30: (1, {'@': 148}), 12: (1, {'@': 148}), 31: (1, {'@': 148}), 18: (1, {'@': 148}), 32: (1, {'@': 148}), 33: (1, {'@': 148}), 34: (1, {'@': 148}), 35: (1, {'@': 148})}, 127: {0: (0, 452), 7: (0, 174), 18: (0, 356), 12: (0, 405), 30: (0, 229), 5: (0, 371)}, 128: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 438), 48: (1, {'@': 384}), 65: (1, {'@': 384}), 56: (1, {'@': 384}), 31: (1, {'@': 384}), 59: (1, {'@': 384}), 43: (1, {'@': 384}), 21: (1, {'@': 384}), 24: (1, {'@': 384}), 61: (1, {'@': 384}), 37: (1, {'@': 384})}, 129: {27: (0, 618)}, 130: {30: (0, 557)}, 131: {30: (1, {'@': 54}), 31: (1, {'@': 54}), 35: (1, {'@': 54}), 18: (1, {'@': 54}), 12: (1, {'@': 54}), 5: (1, {'@': 54})}, 132: {0: (0, 452), 7: (0, 265), 77: (0, 510), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 682), 28: (0, 257)}, 133: {22: (1, {'@': 161}), 19: (1, {'@': 161}), 23: (1, {'@': 161}), 21: (1, {'@': 161}), 24: (1, {'@': 161}), 3: (1, {'@': 161}), 11: (1, {'@': 161}), 14: (1, {'@': 161}), 17: (1, {'@': 161}), 4: (1, {'@': 161}), 10: (1, {'@': 161}), 15: (1, {'@': 161}), 6: (1, {'@': 161}), 25: (1, {'@': 161}), 2: (1, {'@': 161}), 9: (1, {'@': 161}), 13: (1, {'@': 161}), 26: (1, {'@': 161}), 20: (1, {'@': 161}), 1: (1, {'@': 161}), 5: (1, {'@': 161}), 27: (1, {'@': 161}), 28: (1, {'@': 161}), 29: (1, {'@': 161}), 30: (1, {'@': 161}), 12: (1, {'@': 161}), 31: (1, {'@': 161}), 18: (1, {'@': 161}), 32: (1, {'@': 161}), 33: (1, {'@': 161}), 34: (1, {'@': 161}), 35: (1, {'@': 161})}, 134: {30: (0, 41)}, 135: {22: (1, {'@': 285}), 19: (1, {'@': 285}), 23: (1, {'@': 285}), 21: (1, {'@': 285}), 24: (1, {'@': 285}), 3: (1, {'@': 285}), 11: (1, {'@': 285}), 14: (1, {'@': 285}), 17: (1, {'@': 285}), 4: (1, {'@': 285}), 10: (1, {'@': 285}), 15: (1, {'@': 285}), 6: (1, {'@': 285}), 25: (1, {'@': 285}), 2: (1, {'@': 285}), 9: (1, {'@': 285}), 13: (1, {'@': 285}), 26: (1, {'@': 285}), 20: (1, {'@': 285}), 1: (1, {'@': 285}), 5: (1, {'@': 285}), 27: (1, {'@': 285}), 28: (1, {'@': 285}), 29: (1, {'@': 285}), 30: (1, {'@': 285}), 12: (1, {'@': 285}), 31: (1, {'@': 285}), 18: (1, {'@': 285}), 32: (1, {'@': 285}), 33: (1, {'@': 285}), 34: (1, {'@': 285}), 35: (1, {'@': 285})}, 136: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 624), 48: (1, {'@': 386}), 65: (1, {'@': 386}), 56: (1, {'@': 386}), 31: (1, {'@': 386}), 59: (1, {'@': 386}), 43: (1, {'@': 386}), 21: (1, {'@': 386}), 24: (1, {'@': 386}), 61: (1, {'@': 386}), 37: (1, {'@': 386})}, 137: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 555), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 7: (0, 304), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 34: (0, 325), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 138: {0: (0, 452), 7: (0, 715), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 400}), 65: (1, {'@': 400}), 56: (1, {'@': 400}), 31: (1, {'@': 400}), 59: (1, {'@': 400}), 43: (1, {'@': 400}), 21: (1, {'@': 400}), 24: (1, {'@': 400}), 61: (1, {'@': 400}), 37: (1, {'@': 400})}, 139: {48: (1, {'@': 389}), 65: (1, {'@': 389}), 56: (1, {'@': 389}), 12: (1, {'@': 389}), 31: (1, {'@': 389}), 59: (1, {'@': 389}), 5: (1, {'@': 389}), 43: (1, {'@': 389}), 21: (1, {'@': 389}), 24: (1, {'@': 389}), 61: (1, {'@': 389}), 18: (1, {'@': 389}), 37: (1, {'@': 389})}, 140: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 50: (0, 648), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 141: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 70}), 25: (1, {'@': 70}), 34: (1, {'@': 70}), 5: (1, {'@': 70}), 27: (1, {'@': 70}), 28: (1, {'@': 70}), 29: (1, {'@': 70}), 30: (1, {'@': 70}), 12: (1, {'@': 70}), 31: (1, {'@': 70}), 35: (1, {'@': 70}), 18: (1, {'@': 70}), 32: (1, {'@': 70}), 33: (1, {'@': 70})}, 142: {30: (0, 561)}, 143: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 5: (1, {'@': 89}), 3: (1, {'@': 89}), 12: (1, {'@': 89}), 18: (1, {'@': 89}), 34: (1, {'@': 89}), 27: (1, {'@': 89}), 28: (1, {'@': 89}), 29: (1, {'@': 89}), 30: (1, {'@': 89}), 25: (1, {'@': 89}), 31: (1, {'@': 89}), 35: (1, {'@': 89}), 32: (1, {'@': 89}), 33: (1, {'@': 89})}, 144: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 627), 48: (1, {'@': 380}), 65: (1, {'@': 380}), 56: (1, {'@': 380}), 31: (1, {'@': 380}), 59: (1, {'@': 380}), 43: (1, {'@': 380}), 21: (1, {'@': 380}), 24: (1, {'@': 380}), 61: (1, {'@': 380}), 37: (1, {'@': 380})}, 145: {22: (1, {'@': 331}), 19: (1, {'@': 331}), 23: (1, {'@': 331}), 21: (1, {'@': 331}), 24: (1, {'@': 331}), 3: (1, {'@': 331}), 11: (1, {'@': 331}), 14: (1, {'@': 331}), 17: (1, {'@': 331}), 4: (1, {'@': 331}), 10: (1, {'@': 331}), 15: (1, {'@': 331}), 6: (1, {'@': 331}), 25: (1, {'@': 331}), 2: (1, {'@': 331}), 9: (1, {'@': 331}), 13: (1, {'@': 331}), 26: (1, {'@': 331}), 20: (1, {'@': 331}), 1: (1, {'@': 331}), 5: (1, {'@': 331}), 27: (1, {'@': 331}), 28: (1, {'@': 331}), 29: (1, {'@': 331}), 30: (1, {'@': 331}), 12: (1, {'@': 331}), 31: (1, {'@': 331}), 18: (1, {'@': 331}), 32: (1, {'@': 331}), 33: (1, {'@': 331}), 34: (1, {'@': 331}), 35: (1, {'@': 331})}, 146: {3: (0, 717)}, 147: {22: (1, {'@': 286}), 19: (1, {'@': 286}), 23: (1, {'@': 286}), 21: (1, {'@': 286}), 24: (1, {'@': 286}), 3: (1, {'@': 286}), 11: (1, {'@': 286}), 14: (1, {'@': 286}), 17: (1, {'@': 286}), 4: (1, {'@': 286}), 10: (1, {'@': 286}), 15: (1, {'@': 286}), 6: (1, {'@': 286}), 25: (1, {'@': 286}), 2: (1, {'@': 286}), 9: (1, {'@': 286}), 13: (1, {'@': 286}), 26: (1, {'@': 286}), 20: (1, {'@': 286}), 1: (1, {'@': 286}), 5: (1, {'@': 286}), 27: (1, {'@': 286}), 28: (1, {'@': 286}), 29: (1, {'@': 286}), 30: (1, {'@': 286}), 12: (1, {'@': 286}), 31: (1, {'@': 286}), 18: (1, {'@': 286}), 32: (1, {'@': 286}), 33: (1, {'@': 286}), 34: (1, {'@': 286}), 35: (1, {'@': 286})}, 148: {0: (0, 452), 7: (0, 495), 18: (0, 356), 12: (0, 405), 28: (0, 271), 34: (0, 319), 5: (0, 371)}, 149: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 9), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 150: {22: (1, {'@': 312}), 19: (1, {'@': 312}), 23: (1, {'@': 312}), 21: (1, {'@': 312}), 24: (1, {'@': 312}), 3: (1, {'@': 312}), 11: (1, {'@': 312}), 14: (1, {'@': 312}), 17: (1, {'@': 312}), 4: (1, {'@': 312}), 10: (1, {'@': 312}), 15: (1, {'@': 312}), 6: (1, {'@': 312}), 25: (1, {'@': 312}), 2: (1, {'@': 312}), 9: (1, {'@': 312}), 13: (1, {'@': 312}), 26: (1, {'@': 312}), 20: (1, {'@': 312}), 1: (1, {'@': 312}), 5: (1, {'@': 312}), 27: (1, {'@': 312}), 28: (1, {'@': 312}), 29: (1, {'@': 312}), 30: (1, {'@': 312}), 12: (1, {'@': 312}), 31: (1, {'@': 312}), 18: (1, {'@': 312}), 32: (1, {'@': 312}), 33: (1, {'@': 312}), 34: (1, {'@': 312}), 35: (1, {'@': 312})}, 151: {3: (0, 633)}, 152: {22: (1, {'@': 142}), 19: (1, {'@': 142}), 23: (1, {'@': 142}), 21: (1, {'@': 142}), 24: (1, {'@': 142}), 3: (1, {'@': 142}), 11: (1, {'@': 142}), 14: (1, {'@': 142}), 17: (1, {'@': 142}), 4: (1, {'@': 142}), 10: (1, {'@': 142}), 15: (1, {'@': 142}), 6: (1, {'@': 142}), 25: (1, {'@': 142}), 2: (1, {'@': 142}), 9: (1, {'@': 142}), 13: (1, {'@': 142}), 26: (1, {'@': 142}), 20: (1, {'@': 142}), 1: (1, {'@': 142}), 5: (1, {'@': 142}), 27: (1, {'@': 142}), 28: (1, {'@': 142}), 29: (1, {'@': 142}), 30: (1, {'@': 142}), 12: (1, {'@': 142}), 31: (1, {'@': 142}), 18: (1, {'@': 142}), 32: (1, {'@': 142}), 33: (1, {'@': 142}), 34: (1, {'@': 142}), 35: (1, {'@': 142})}, 153: {0: (0, 452), 68: (0, 563), 34: (0, 95), 29: (0, 327), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 90)}, 154: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 181), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 7: (0, 219), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 155: {22: (1, {'@': 307}), 19: (1, {'@': 307}), 23: (1, {'@': 307}), 21: (1, {'@': 307}), 24: (1, {'@': 307}), 3: (1, {'@': 307}), 11: (1, {'@': 307}), 14: (1, {'@': 307}), 17: (1, {'@': 307}), 4: (1, {'@': 307}), 10: (1, {'@': 307}), 15: (1, {'@': 307}), 6: (1, {'@': 307}), 25: (1, {'@': 307}), 2: (1, {'@': 307}), 9: (1, {'@': 307}), 13: (1, {'@': 307}), 26: (1, {'@': 307}), 20: (1, {'@': 307}), 1: (1, {'@': 307}), 5: (1, {'@': 307}), 27: (1, {'@': 307}), 28: (1, {'@': 307}), 29: (1, {'@': 307}), 30: (1, {'@': 307}), 12: (1, {'@': 307}), 31: (1, {'@': 307}), 18: (1, {'@': 307}), 32: (1, {'@': 307}), 33: (1, {'@': 307}), 34: (1, {'@': 307}), 35: (1, {'@': 307})}, 156: {22: (1, {'@': 287}), 19: (1, {'@': 287}), 23: (1, {'@': 287}), 21: (1, {'@': 287}), 24: (1, {'@': 287}), 3: (1, {'@': 287}), 11: (1, {'@': 287}), 14: (1, {'@': 287}), 17: (1, {'@': 287}), 4: (1, {'@': 287}), 10: (1, {'@': 287}), 15: (1, {'@': 287}), 6: (1, {'@': 287}), 25: (1, {'@': 287}), 2: (1, {'@': 287}), 9: (1, {'@': 287}), 13: (1, {'@': 287}), 26: (1, {'@': 287}), 20: (1, {'@': 287}), 1: (1, {'@': 287}), 5: (1, {'@': 287}), 27: (1, {'@': 287}), 28: (1, {'@': 287}), 29: (1, {'@': 287}), 30: (1, {'@': 287}), 12: (1, {'@': 287}), 31: (1, {'@': 287}), 18: (1, {'@': 287}), 32: (1, {'@': 287}), 33: (1, {'@': 287}), 34: (1, {'@': 287}), 35: (1, {'@': 287})}, 157: {48: (1, {'@': 353}), 65: (1, {'@': 353}), 56: (1, {'@': 353}), 12: (1, {'@': 353}), 31: (1, {'@': 353}), 59: (1, {'@': 353}), 5: (1, {'@': 353}), 43: (1, {'@': 353}), 21: (1, {'@': 353}), 24: (1, {'@': 353}), 61: (1, {'@': 353}), 18: (1, {'@': 353}), 37: (1, {'@': 353})}, 158: {24: (0, 56), 23: (0, 696), 71: (0, 558), 70: (0, 614), 22: (1, {'@': 191}), 5: (1, {'@': 191}), 21: (1, {'@': 191}), 3: (1, {'@': 191}), 27: (1, {'@': 191}), 11: (1, {'@': 191}), 17: (1, {'@': 191}), 28: (1, {'@': 191}), 29: (1, {'@': 191}), 30: (1, {'@': 191}), 6: (1, {'@': 191}), 25: (1, {'@': 191}), 12: (1, {'@': 191}), 31: (1, {'@': 191}), 13: (1, {'@': 191}), 18: (1, {'@': 191}), 32: (1, {'@': 191}), 33: (1, {'@': 191}), 34: (1, {'@': 191}), 19: (1, {'@': 191}), 14: (1, {'@': 191}), 4: (1, {'@': 191}), 10: (1, {'@': 191}), 15: (1, {'@': 191}), 2: (1, {'@': 191}), 9: (1, {'@': 191}), 26: (1, {'@': 191}), 35: (1, {'@': 191}), 20: (1, {'@': 191}), 1: (1, {'@': 191})}, 159: {30: (0, 566)}, 160: {37: (0, 709), 24: (0, 711), 0: (0, 452), 39: (0, 716), 42: (0, 718), 7: (0, 14), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 5: (0, 371), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 37), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 161: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 237), 5: (0, 371), 30: (0, 479)}, 162: {22: (1, {'@': 332}), 19: (1, {'@': 332}), 23: (1, {'@': 332}), 21: (1, {'@': 332}), 24: (1, {'@': 332}), 3: (1, {'@': 332}), 11: (1, {'@': 332}), 14: (1, {'@': 332}), 17: (1, {'@': 332}), 4: (1, {'@': 332}), 10: (1, {'@': 332}), 15: (1, {'@': 332}), 6: (1, {'@': 332}), 25: (1, {'@': 332}), 2: (1, {'@': 332}), 9: (1, {'@': 332}), 13: (1, {'@': 332}), 26: (1, {'@': 332}), 20: (1, {'@': 332}), 1: (1, {'@': 332}), 5: (1, {'@': 332}), 27: (1, {'@': 332}), 28: (1, {'@': 332}), 29: (1, {'@': 332}), 30: (1, {'@': 332}), 12: (1, {'@': 332}), 31: (1, {'@': 332}), 18: (1, {'@': 332}), 32: (1, {'@': 332}), 33: (1, {'@': 332}), 34: (1, {'@': 332}), 35: (1, {'@': 332})}, 163: {22: (1, {'@': 306}), 19: (1, {'@': 306}), 23: (1, {'@': 306}), 21: (1, {'@': 306}), 24: (1, {'@': 306}), 3: (1, {'@': 306}), 11: (1, {'@': 306}), 14: (1, {'@': 306}), 17: (1, {'@': 306}), 4: (1, {'@': 306}), 10: (1, {'@': 306}), 15: (1, {'@': 306}), 6: (1, {'@': 306}), 25: (1, {'@': 306}), 2: (1, {'@': 306}), 9: (1, {'@': 306}), 13: (1, {'@': 306}), 26: (1, {'@': 306}), 20: (1, {'@': 306}), 1: (1, {'@': 306}), 5: (1, {'@': 306}), 27: (1, {'@': 306}), 28: (1, {'@': 306}), 29: (1, {'@': 306}), 30: (1, {'@': 306}), 12: (1, {'@': 306}), 31: (1, {'@': 306}), 18: (1, {'@': 306}), 32: (1, {'@': 306}), 33: (1, {'@': 306}), 34: (1, {'@': 306}), 35: (1, {'@': 306})}, 164: {48: (1, {'@': 393}), 65: (1, {'@': 393}), 56: (1, {'@': 393}), 12: (1, {'@': 393}), 31: (1, {'@': 393}), 59: (1, {'@': 393}), 5: (1, {'@': 393}), 43: (1, {'@': 393}), 21: (1, {'@': 393}), 24: (1, {'@': 393}), 61: (1, {'@': 393}), 18: (1, {'@': 393}), 37: (1, {'@': 393})}, 165: {22: (1, {'@': 166}), 19: (1, {'@': 166}), 23: (1, {'@': 166}), 21: (1, {'@': 166}), 24: (1, {'@': 166}), 3: (1, {'@': 166}), 11: (1, {'@': 166}), 14: (1, {'@': 166}), 17: (1, {'@': 166}), 4: (1, {'@': 166}), 10: (1, {'@': 166}), 15: (1, {'@': 166}), 6: (1, {'@': 166}), 25: (1, {'@': 166}), 2: (1, {'@': 166}), 9: (1, {'@': 166}), 13: (1, {'@': 166}), 26: (1, {'@': 166}), 20: (1, {'@': 166}), 1: (1, {'@': 166}), 5: (1, {'@': 166}), 27: (1, {'@': 166}), 28: (1, {'@': 166}), 29: (1, {'@': 166}), 30: (1, {'@': 166}), 12: (1, {'@': 166}), 31: (1, {'@': 166}), 18: (1, {'@': 166}), 32: (1, {'@': 166}), 33: (1, {'@': 166}), 34: (1, {'@': 166}), 35: (1, {'@': 166})}, 166: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 78), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 167: {22: (1, {'@': 309}), 19: (1, {'@': 309}), 23: (1, {'@': 309}), 21: (1, {'@': 309}), 24: (1, {'@': 309}), 3: (1, {'@': 309}), 11: (1, {'@': 309}), 14: (1, {'@': 309}), 17: (1, {'@': 309}), 4: (1, {'@': 309}), 10: (1, {'@': 309}), 15: (1, {'@': 309}), 6: (1, {'@': 309}), 25: (1, {'@': 309}), 2: (1, {'@': 309}), 9: (1, {'@': 309}), 13: (1, {'@': 309}), 26: (1, {'@': 309}), 20: (1, {'@': 309}), 1: (1, {'@': 309}), 5: (1, {'@': 309}), 27: (1, {'@': 309}), 28: (1, {'@': 309}), 29: (1, {'@': 309}), 30: (1, {'@': 309}), 12: (1, {'@': 309}), 31: (1, {'@': 309}), 18: (1, {'@': 309}), 32: (1, {'@': 309}), 33: (1, {'@': 309}), 34: (1, {'@': 309}), 35: (1, {'@': 309})}, 168: {48: (1, {'@': 397}), 65: (1, {'@': 397}), 56: (1, {'@': 397}), 12: (1, {'@': 397}), 31: (1, {'@': 397}), 59: (1, {'@': 397}), 5: (1, {'@': 397}), 43: (1, {'@': 397}), 21: (1, {'@': 397}), 24: (1, {'@': 397}), 61: (1, {'@': 397}), 18: (1, {'@': 397}), 37: (1, {'@': 397})}, 169: {23: (0, 663), 71: (0, 230), 22: (1, {'@': 189}), 5: (1, {'@': 189}), 21: (1, {'@': 189}), 3: (1, {'@': 189}), 24: (1, {'@': 189}), 27: (1, {'@': 189}), 11: (1, {'@': 189}), 17: (1, {'@': 189}), 28: (1, {'@': 189}), 29: (1, {'@': 189}), 30: (1, {'@': 189}), 6: (1, {'@': 189}), 25: (1, {'@': 189}), 12: (1, {'@': 189}), 31: (1, {'@': 189}), 13: (1, {'@': 189}), 18: (1, {'@': 189}), 32: (1, {'@': 189}), 33: (1, {'@': 189}), 34: (1, {'@': 189}), 19: (1, {'@': 189}), 14: (1, {'@': 189}), 4: (1, {'@': 189}), 10: (1, {'@': 189}), 15: (1, {'@': 189}), 2: (1, {'@': 189}), 9: (1, {'@': 189}), 26: (1, {'@': 189}), 35: (1, {'@': 189}), 20: (1, {'@': 189}), 1: (1, {'@': 189})}, 170: {34: (0, 450)}, 171: {0: (0, 452), 7: (0, 547), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 458)}, 172: {22: (1, {'@': 319}), 19: (1, {'@': 319}), 23: (1, {'@': 319}), 21: (1, {'@': 319}), 24: (1, {'@': 319}), 3: (1, {'@': 319}), 11: (1, {'@': 319}), 14: (1, {'@': 319}), 17: (1, {'@': 319}), 4: (1, {'@': 319}), 10: (1, {'@': 319}), 15: (1, {'@': 319}), 6: (1, {'@': 319}), 25: (1, {'@': 319}), 2: (1, {'@': 319}), 9: (1, {'@': 319}), 13: (1, {'@': 319}), 26: (1, {'@': 319}), 20: (1, {'@': 319}), 1: (1, {'@': 319}), 5: (1, {'@': 319}), 27: (1, {'@': 319}), 28: (1, {'@': 319}), 29: (1, {'@': 319}), 30: (1, {'@': 319}), 12: (1, {'@': 319}), 31: (1, {'@': 319}), 18: (1, {'@': 319}), 32: (1, {'@': 319}), 33: (1, {'@': 319}), 34: (1, {'@': 319}), 35: (1, {'@': 319})}, 173: {0: (0, 452), 29: (0, 327), 7: (0, 652), 18: (0, 356), 12: (0, 405), 30: (0, 658), 68: (0, 661), 5: (0, 371)}, 174: {30: (0, 358)}, 175: {22: (1, {'@': 91}), 19: (1, {'@': 91}), 23: (1, {'@': 91}), 21: (1, {'@': 91}), 24: (1, {'@': 91}), 3: (1, {'@': 91}), 11: (1, {'@': 91}), 14: (1, {'@': 91}), 17: (1, {'@': 91}), 4: (1, {'@': 91}), 10: (1, {'@': 91}), 15: (1, {'@': 91}), 6: (1, {'@': 91}), 25: (1, {'@': 91}), 2: (1, {'@': 91}), 9: (1, {'@': 91}), 13: (1, {'@': 91}), 26: (1, {'@': 91}), 20: (1, {'@': 91}), 1: (1, {'@': 91}), 5: (1, {'@': 91}), 27: (1, {'@': 91}), 28: (1, {'@': 91}), 29: (1, {'@': 91}), 30: (1, {'@': 91}), 12: (1, {'@': 91}), 31: (1, {'@': 91}), 18: (1, {'@': 91}), 32: (1, {'@': 91}), 33: (1, {'@': 91}), 34: (1, {'@': 91}), 35: (1, {'@': 91})}, 176: {0: (0, 452), 3: (0, 573), 1: (0, 654), 2: (0, 581), 7: (0, 579), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 177: {30: (0, 343)}, 178: {68: (0, 161), 0: (0, 452), 29: (0, 327), 18: (0, 356), 12: (0, 405), 7: (0, 743), 5: (0, 371), 30: (0, 745)}, 179: {59: (0, 465), 22: (1, {'@': 111}), 19: (1, {'@': 111}), 23: (1, {'@': 111}), 21: (1, {'@': 111}), 24: (1, {'@': 111}), 3: (1, {'@': 111}), 11: (1, {'@': 111}), 14: (1, {'@': 111}), 17: (1, {'@': 111}), 4: (1, {'@': 111}), 10: (1, {'@': 111}), 15: (1, {'@': 111}), 6: (1, {'@': 111}), 25: (1, {'@': 111}), 2: (1, {'@': 111}), 9: (1, {'@': 111}), 13: (1, {'@': 111}), 26: (1, {'@': 111}), 20: (1, {'@': 111}), 1: (1, {'@': 111}), 5: (1, {'@': 111}), 27: (1, {'@': 111}), 28: (1, {'@': 111}), 29: (1, {'@': 111}), 30: (1, {'@': 111}), 12: (1, {'@': 111}), 31: (1, {'@': 111}), 18: (1, {'@': 111}), 32: (1, {'@': 111}), 33: (1, {'@': 111}), 34: (1, {'@': 111}), 35: (1, {'@': 111})}, 180: {30: (0, 47)}, 181: {0: (0, 452), 7: (0, 210), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 352}), 65: (1, {'@': 352}), 56: (1, {'@': 352}), 31: (1, {'@': 352}), 59: (1, {'@': 352}), 43: (1, {'@': 352}), 21: (1, {'@': 352}), 24: (1, {'@': 352}), 61: (1, {'@': 352}), 37: (1, {'@': 352})}, 182: {0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 34: (0, 296), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 7: (0, 611), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 183: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 638), 4: (0, 634), 7: (0, 646), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 184: {22: (1, {'@': 227}), 19: (1, {'@': 227}), 23: (1, {'@': 227}), 21: (1, {'@': 227}), 24: (1, {'@': 227}), 3: (1, {'@': 227}), 11: (1, {'@': 227}), 14: (1, {'@': 227}), 17: (1, {'@': 227}), 4: (1, {'@': 227}), 10: (1, {'@': 227}), 15: (1, {'@': 227}), 6: (1, {'@': 227}), 25: (1, {'@': 227}), 2: (1, {'@': 227}), 9: (1, {'@': 227}), 13: (1, {'@': 227}), 26: (1, {'@': 227}), 20: (1, {'@': 227}), 1: (1, {'@': 227}), 5: (1, {'@': 227}), 27: (1, {'@': 227}), 28: (1, {'@': 227}), 29: (1, {'@': 227}), 30: (1, {'@': 227}), 12: (1, {'@': 227}), 31: (1, {'@': 227}), 18: (1, {'@': 227}), 32: (1, {'@': 227}), 33: (1, {'@': 227}), 34: (1, {'@': 227}), 35: (1, {'@': 227})}, 185: {30: (1, {'@': 51}), 31: (1, {'@': 51}), 35: (1, {'@': 51}), 18: (1, {'@': 51}), 12: (1, {'@': 51}), 5: (1, {'@': 51})}, 186: {22: (1, {'@': 269}), 19: (1, {'@': 269}), 23: (1, {'@': 269}), 21: (1, {'@': 269}), 24: (1, {'@': 269}), 3: (1, {'@': 269}), 11: (1, {'@': 269}), 14: (1, {'@': 269}), 17: (1, {'@': 269}), 4: (1, {'@': 269}), 10: (1, {'@': 269}), 15: (1, {'@': 269}), 6: (1, {'@': 269}), 25: (1, {'@': 269}), 2: (1, {'@': 269}), 9: (1, {'@': 269}), 13: (1, {'@': 269}), 26: (1, {'@': 269}), 20: (1, {'@': 269}), 1: (1, {'@': 269}), 5: (1, {'@': 269}), 27: (1, {'@': 269}), 28: (1, {'@': 269}), 29: (1, {'@': 269}), 30: (1, {'@': 269}), 12: (1, {'@': 269}), 31: (1, {'@': 269}), 18: (1, {'@': 269}), 32: (1, {'@': 269}), 33: (1, {'@': 269}), 34: (1, {'@': 269}), 35: (1, {'@': 269})}, 187: {22: (1, {'@': 147}), 19: (1, {'@': 147}), 23: (1, {'@': 147}), 21: (1, {'@': 147}), 24: (1, {'@': 147}), 3: (1, {'@': 147}), 11: (1, {'@': 147}), 14: (1, {'@': 147}), 17: (1, {'@': 147}), 4: (1, {'@': 147}), 10: (1, {'@': 147}), 15: (1, {'@': 147}), 6: (1, {'@': 147}), 25: (1, {'@': 147}), 2: (1, {'@': 147}), 9: (1, {'@': 147}), 13: (1, {'@': 147}), 26: (1, {'@': 147}), 20: (1, {'@': 147}), 1: (1, {'@': 147}), 5: (1, {'@': 147}), 27: (1, {'@': 147}), 28: (1, {'@': 147}), 29: (1, {'@': 147}), 30: (1, {'@': 147}), 12: (1, {'@': 147}), 31: (1, {'@': 147}), 18: (1, {'@': 147}), 32: (1, {'@': 147}), 33: (1, {'@': 147}), 34: (1, {'@': 147}), 35: (1, {'@': 147})}, 188: {0: (0, 452), 18: (0, 356), 12: (0, 405), 30: (0, 727), 5: (0, 371), 7: (0, 672)}, 189: {22: (1, {'@': 248}), 19: (1, {'@': 248}), 23: (1, {'@': 248}), 21: (1, {'@': 248}), 24: (1, {'@': 248}), 3: (1, {'@': 248}), 11: (1, {'@': 248}), 14: (1, {'@': 248}), 17: (1, {'@': 248}), 4: (1, {'@': 248}), 10: (1, {'@': 248}), 15: (1, {'@': 248}), 6: (1, {'@': 248}), 25: (1, {'@': 248}), 2: (1, {'@': 248}), 9: (1, {'@': 248}), 13: (1, {'@': 248}), 26: (1, {'@': 248}), 20: (1, {'@': 248}), 1: (1, {'@': 248}), 5: (1, {'@': 248}), 27: (1, {'@': 248}), 28: (1, {'@': 248}), 29: (1, {'@': 248}), 30: (1, {'@': 248}), 12: (1, {'@': 248}), 31: (1, {'@': 248}), 18: (1, {'@': 248}), 32: (1, {'@': 248}), 33: (1, {'@': 248}), 34: (1, {'@': 248}), 35: (1, {'@': 248})}, 190: {3: (0, 584)}, 191: {48: (1, {'@': 349}), 65: (1, {'@': 349}), 56: (1, {'@': 349}), 12: (1, {'@': 349}), 31: (1, {'@': 349}), 59: (1, {'@': 349}), 5: (1, {'@': 349}), 43: (1, {'@': 349}), 21: (1, {'@': 349}), 24: (1, {'@': 349}), 61: (1, {'@': 349}), 18: (1, {'@': 349}), 37: (1, {'@': 349})}, 192: {22: (1, {'@': 184}), 5: (1, {'@': 184}), 21: (1, {'@': 184}), 3: (1, {'@': 184}), 24: (1, {'@': 184}), 27: (1, {'@': 184}), 11: (1, {'@': 184}), 17: (1, {'@': 184}), 29: (1, {'@': 184}), 30: (1, {'@': 184}), 28: (1, {'@': 184}), 6: (1, {'@': 184}), 25: (1, {'@': 184}), 12: (1, {'@': 184}), 31: (1, {'@': 184}), 13: (1, {'@': 184}), 18: (1, {'@': 184}), 32: (1, {'@': 184}), 33: (1, {'@': 184}), 34: (1, {'@': 184}), 19: (1, {'@': 184}), 23: (1, {'@': 184}), 14: (1, {'@': 184}), 4: (1, {'@': 184}), 10: (1, {'@': 184}), 15: (1, {'@': 184}), 2: (1, {'@': 184}), 9: (1, {'@': 184}), 26: (1, {'@': 184}), 35: (1, {'@': 184}), 20: (1, {'@': 184}), 1: (1, {'@': 184})}, 193: {0: (0, 452), 1: (0, 654), 2: (0, 581), 32: (0, 46), 68: (0, 64), 29: (0, 327), 7: (0, 71), 30: (0, 85), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 20: (0, 48), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42)}, 194: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 123), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 3: (0, 128), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 195: {72: (0, 316), 0: (0, 452), 7: (0, 529), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 196: {30: (0, 505)}, 197: {30: (0, 691)}, 198: {22: (1, {'@': 444}), 5: (1, {'@': 444}), 21: (1, {'@': 444}), 3: (1, {'@': 444}), 24: (1, {'@': 444}), 27: (1, {'@': 444}), 11: (1, {'@': 444}), 17: (1, {'@': 444}), 29: (1, {'@': 444}), 30: (1, {'@': 444}), 28: (1, {'@': 444}), 6: (1, {'@': 444}), 25: (1, {'@': 444}), 12: (1, {'@': 444}), 31: (1, {'@': 444}), 13: (1, {'@': 444}), 18: (1, {'@': 444}), 32: (1, {'@': 444}), 33: (1, {'@': 444}), 34: (1, {'@': 444}), 19: (1, {'@': 444}), 23: (1, {'@': 444}), 14: (1, {'@': 444}), 4: (1, {'@': 444}), 10: (1, {'@': 444}), 15: (1, {'@': 444}), 2: (1, {'@': 444}), 9: (1, {'@': 444}), 26: (1, {'@': 444}), 35: (1, {'@': 444}), 20: (1, {'@': 444}), 1: (1, {'@': 444})}, 199: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 597), 55: (0, 740), 7: (0, 508), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 200: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 436}), 5: (1, {'@': 436}), 27: (1, {'@': 436}), 18: (1, {'@': 436}), 32: (1, {'@': 436}), 28: (1, {'@': 436}), 34: (1, {'@': 436})}, 201: {22: (1, {'@': 262}), 19: (1, {'@': 262}), 23: (1, {'@': 262}), 21: (1, {'@': 262}), 24: (1, {'@': 262}), 3: (1, {'@': 262}), 11: (1, {'@': 262}), 14: (1, {'@': 262}), 17: (1, {'@': 262}), 4: (1, {'@': 262}), 10: (1, {'@': 262}), 15: (1, {'@': 262}), 6: (1, {'@': 262}), 25: (1, {'@': 262}), 2: (1, {'@': 262}), 9: (1, {'@': 262}), 13: (1, {'@': 262}), 26: (1, {'@': 262}), 20: (1, {'@': 262}), 1: (1, {'@': 262}), 5: (1, {'@': 262}), 27: (1, {'@': 262}), 28: (1, {'@': 262}), 29: (1, {'@': 262}), 30: (1, {'@': 262}), 12: (1, {'@': 262}), 31: (1, {'@': 262}), 18: (1, {'@': 262}), 32: (1, {'@': 262}), 33: (1, {'@': 262}), 34: (1, {'@': 262}), 35: (1, {'@': 262})}, 202: {22: (1, {'@': 443}), 5: (1, {'@': 443}), 21: (1, {'@': 443}), 3: (1, {'@': 443}), 24: (1, {'@': 443}), 27: (1, {'@': 443}), 11: (1, {'@': 443}), 17: (1, {'@': 443}), 29: (1, {'@': 443}), 30: (1, {'@': 443}), 28: (1, {'@': 443}), 6: (1, {'@': 443}), 25: (1, {'@': 443}), 12: (1, {'@': 443}), 31: (1, {'@': 443}), 13: (1, {'@': 443}), 18: (1, {'@': 443}), 32: (1, {'@': 443}), 33: (1, {'@': 443}), 34: (1, {'@': 443}), 19: (1, {'@': 443}), 23: (1, {'@': 443}), 14: (1, {'@': 443}), 4: (1, {'@': 443}), 10: (1, {'@': 443}), 15: (1, {'@': 443}), 2: (1, {'@': 443}), 9: (1, {'@': 443}), 26: (1, {'@': 443}), 35: (1, {'@': 443}), 20: (1, {'@': 443}), 1: (1, {'@': 443})}, 203: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 0), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 204: {22: (1, {'@': 233}), 19: (1, {'@': 233}), 23: (1, {'@': 233}), 21: (1, {'@': 233}), 24: (1, {'@': 233}), 3: (1, {'@': 233}), 11: (1, {'@': 233}), 14: (1, {'@': 233}), 17: (1, {'@': 233}), 4: (1, {'@': 233}), 10: (1, {'@': 233}), 15: (1, {'@': 233}), 6: (1, {'@': 233}), 25: (1, {'@': 233}), 2: (1, {'@': 233}), 9: (1, {'@': 233}), 13: (1, {'@': 233}), 26: (1, {'@': 233}), 20: (1, {'@': 233}), 1: (1, {'@': 233}), 5: (1, {'@': 233}), 27: (1, {'@': 233}), 28: (1, {'@': 233}), 29: (1, {'@': 233}), 30: (1, {'@': 233}), 12: (1, {'@': 233}), 31: (1, {'@': 233}), 18: (1, {'@': 233}), 32: (1, {'@': 233}), 33: (1, {'@': 233}), 34: (1, {'@': 233}), 35: (1, {'@': 233})}, 205: {7: (0, 420), 0: (0, 452), 72: (0, 499), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 206: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 375), 5: (0, 371), 30: (0, 29)}, 207: {3: (0, 502)}, 208: {30: (0, 345)}, 209: {27: (0, 620)}, 210: {48: (1, {'@': 351}), 65: (1, {'@': 351}), 56: (1, {'@': 351}), 12: (1, {'@': 351}), 31: (1, {'@': 351}), 59: (1, {'@': 351}), 5: (1, {'@': 351}), 43: (1, {'@': 351}), 21: (1, {'@': 351}), 24: (1, {'@': 351}), 61: (1, {'@': 351}), 18: (1, {'@': 351}), 37: (1, {'@': 351})}, 211: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 292), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 212: {0: (0, 452), 68: (0, 52), 29: (0, 327), 7: (0, 58), 12: (0, 405), 18: (0, 356), 30: (0, 63), 5: (0, 371)}, 213: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 139), 48: (1, {'@': 390}), 65: (1, {'@': 390}), 56: (1, {'@': 390}), 31: (1, {'@': 390}), 59: (1, {'@': 390}), 43: (1, {'@': 390}), 21: (1, {'@': 390}), 24: (1, {'@': 390}), 61: (1, {'@': 390}), 37: (1, {'@': 390})}, 214: {30: (0, 349), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 353)}, 215: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 625), 27: (0, 629), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 216: {48: (1, {'@': 345}), 65: (1, {'@': 345}), 56: (1, {'@': 345}), 12: (1, {'@': 345}), 31: (1, {'@': 345}), 59: (1, {'@': 345}), 5: (1, {'@': 345}), 43: (1, {'@': 345}), 21: (1, {'@': 345}), 24: (1, {'@': 345}), 61: (1, {'@': 345}), 18: (1, {'@': 345}), 37: (1, {'@': 345})}, 217: {37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 42: (0, 718), 43: (0, 730), 44: (0, 731), 50: (0, 252), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 218: {0: (0, 452), 7: (0, 466), 12: (0, 405), 18: (0, 356), 30: (0, 145), 5: (0, 371)}, 219: {3: (0, 610)}, 220: {22: (1, {'@': 185}), 5: (1, {'@': 185}), 21: (1, {'@': 185}), 3: (1, {'@': 185}), 24: (1, {'@': 185}), 27: (1, {'@': 185}), 11: (1, {'@': 185}), 17: (1, {'@': 185}), 29: (1, {'@': 185}), 30: (1, {'@': 185}), 28: (1, {'@': 185}), 6: (1, {'@': 185}), 25: (1, {'@': 185}), 12: (1, {'@': 185}), 31: (1, {'@': 185}), 13: (1, {'@': 185}), 18: (1, {'@': 185}), 32: (1, {'@': 185}), 33: (1, {'@': 185}), 34: (1, {'@': 185}), 19: (1, {'@': 185}), 23: (1, {'@': 185}), 14: (1, {'@': 185}), 4: (1, {'@': 185}), 10: (1, {'@': 185}), 15: (1, {'@': 185}), 2: (1, {'@': 185}), 9: (1, {'@': 185}), 26: (1, {'@': 185}), 35: (1, {'@': 185}), 20: (1, {'@': 185}), 1: (1, {'@': 185})}, 221: {22: (1, {'@': 238}), 19: (1, {'@': 238}), 23: (1, {'@': 238}), 21: (1, {'@': 238}), 24: (1, {'@': 238}), 3: (1, {'@': 238}), 11: (1, {'@': 238}), 14: (1, {'@': 238}), 17: (1, {'@': 238}), 4: (1, {'@': 238}), 10: (1, {'@': 238}), 15: (1, {'@': 238}), 6: (1, {'@': 238}), 25: (1, {'@': 238}), 2: (1, {'@': 238}), 9: (1, {'@': 238}), 13: (1, {'@': 238}), 26: (1, {'@': 238}), 20: (1, {'@': 238}), 1: (1, {'@': 238}), 5: (1, {'@': 238}), 27: (1, {'@': 238}), 28: (1, {'@': 238}), 29: (1, {'@': 238}), 30: (1, {'@': 238}), 12: (1, {'@': 238}), 31: (1, {'@': 238}), 18: (1, {'@': 238}), 32: (1, {'@': 238}), 33: (1, {'@': 238}), 34: (1, {'@': 238}), 35: (1, {'@': 238})}, 222: {48: (1, {'@': 361}), 65: (1, {'@': 361}), 56: (1, {'@': 361}), 12: (1, {'@': 361}), 31: (1, {'@': 361}), 59: (1, {'@': 361}), 5: (1, {'@': 361}), 43: (1, {'@': 361}), 21: (1, {'@': 361}), 24: (1, {'@': 361}), 61: (1, {'@': 361}), 18: (1, {'@': 361}), 37: (1, {'@': 361})}, 223: {0: (0, 452), 29: (0, 327), 18: (0, 356), 12: (0, 405), 68: (0, 121), 5: (0, 371), 7: (0, 116), 30: (0, 477)}, 224: {30: (0, 747), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 69)}, 225: {0: (0, 452), 7: (0, 540), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 226: {0: (0, 452), 34: (0, 447), 12: (0, 405), 18: (0, 356), 7: (0, 606), 5: (0, 371)}, 227: {3: (0, 704)}, 228: {48: (1, {'@': 359}), 65: (1, {'@': 359}), 56: (1, {'@': 359}), 12: (1, {'@': 359}), 31: (1, {'@': 359}), 59: (1, {'@': 359}), 5: (1, {'@': 359}), 43: (1, {'@': 359}), 21: (1, {'@': 359}), 24: (1, {'@': 359}), 61: (1, {'@': 359}), 18: (1, {'@': 359}), 37: (1, {'@': 359})}, 229: {22: (1, {'@': 240}), 19: (1, {'@': 240}), 23: (1, {'@': 240}), 21: (1, {'@': 240}), 24: (1, {'@': 240}), 3: (1, {'@': 240}), 11: (1, {'@': 240}), 14: (1, {'@': 240}), 17: (1, {'@': 240}), 4: (1, {'@': 240}), 10: (1, {'@': 240}), 15: (1, {'@': 240}), 6: (1, {'@': 240}), 25: (1, {'@': 240}), 2: (1, {'@': 240}), 9: (1, {'@': 240}), 13: (1, {'@': 240}), 26: (1, {'@': 240}), 20: (1, {'@': 240}), 1: (1, {'@': 240}), 5: (1, {'@': 240}), 27: (1, {'@': 240}), 28: (1, {'@': 240}), 29: (1, {'@': 240}), 30: (1, {'@': 240}), 12: (1, {'@': 240}), 31: (1, {'@': 240}), 18: (1, {'@': 240}), 32: (1, {'@': 240}), 33: (1, {'@': 240}), 34: (1, {'@': 240}), 35: (1, {'@': 240})}, 230: {22: (1, {'@': 442}), 5: (1, {'@': 442}), 21: (1, {'@': 442}), 3: (1, {'@': 442}), 24: (1, {'@': 442}), 27: (1, {'@': 442}), 11: (1, {'@': 442}), 17: (1, {'@': 442}), 28: (1, {'@': 442}), 29: (1, {'@': 442}), 30: (1, {'@': 442}), 6: (1, {'@': 442}), 25: (1, {'@': 442}), 12: (1, {'@': 442}), 31: (1, {'@': 442}), 13: (1, {'@': 442}), 18: (1, {'@': 442}), 32: (1, {'@': 442}), 33: (1, {'@': 442}), 34: (1, {'@': 442}), 19: (1, {'@': 442}), 23: (1, {'@': 442}), 14: (1, {'@': 442}), 4: (1, {'@': 442}), 10: (1, {'@': 442}), 15: (1, {'@': 442}), 2: (1, {'@': 442}), 9: (1, {'@': 442}), 26: (1, {'@': 442}), 35: (1, {'@': 442}), 20: (1, {'@': 442}), 1: (1, {'@': 442})}, 231: {22: (1, {'@': 195}), 19: (1, {'@': 195}), 23: (1, {'@': 195}), 21: (1, {'@': 195}), 24: (1, {'@': 195}), 3: (1, {'@': 195}), 11: (1, {'@': 195}), 14: (1, {'@': 195}), 17: (1, {'@': 195}), 4: (1, {'@': 195}), 10: (1, {'@': 195}), 15: (1, {'@': 195}), 6: (1, {'@': 195}), 25: (1, {'@': 195}), 2: (1, {'@': 195}), 9: (1, {'@': 195}), 13: (1, {'@': 195}), 26: (1, {'@': 195}), 20: (1, {'@': 195}), 1: (1, {'@': 195}), 5: (1, {'@': 195}), 27: (1, {'@': 195}), 28: (1, {'@': 195}), 29: (1, {'@': 195}), 30: (1, {'@': 195}), 12: (1, {'@': 195}), 31: (1, {'@': 195}), 18: (1, {'@': 195}), 32: (1, {'@': 195}), 33: (1, {'@': 195}), 34: (1, {'@': 195}), 35: (1, {'@': 195})}, 232: {0: (0, 452), 7: (0, 736), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 358}), 65: (1, {'@': 358}), 56: (1, {'@': 358}), 31: (1, {'@': 358}), 59: (1, {'@': 358}), 43: (1, {'@': 358}), 21: (1, {'@': 358}), 24: (1, {'@': 358}), 61: (1, {'@': 358}), 37: (1, {'@': 358})}, 233: {22: (1, {'@': 246}), 19: (1, {'@': 246}), 23: (1, {'@': 246}), 21: (1, {'@': 246}), 24: (1, {'@': 246}), 3: (1, {'@': 246}), 11: (1, {'@': 246}), 14: (1, {'@': 246}), 17: (1, {'@': 246}), 4: (1, {'@': 246}), 10: (1, {'@': 246}), 15: (1, {'@': 246}), 6: (1, {'@': 246}), 25: (1, {'@': 246}), 2: (1, {'@': 246}), 9: (1, {'@': 246}), 13: (1, {'@': 246}), 26: (1, {'@': 246}), 20: (1, {'@': 246}), 1: (1, {'@': 246}), 5: (1, {'@': 246}), 27: (1, {'@': 246}), 28: (1, {'@': 246}), 29: (1, {'@': 246}), 30: (1, {'@': 246}), 12: (1, {'@': 246}), 31: (1, {'@': 246}), 18: (1, {'@': 246}), 32: (1, {'@': 246}), 33: (1, {'@': 246}), 34: (1, {'@': 246}), 35: (1, {'@': 246})}, 234: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 639)}, 235: {0: (0, 452), 7: (0, 43), 18: (0, 356), 12: (0, 405), 5: (0, 371), 34: (0, 451)}, 236: {22: (1, {'@': 197}), 19: (1, {'@': 197}), 23: (1, {'@': 197}), 21: (1, {'@': 197}), 24: (1, {'@': 197}), 3: (1, {'@': 197}), 11: (1, {'@': 197}), 14: (1, {'@': 197}), 17: (1, {'@': 197}), 4: (1, {'@': 197}), 10: (1, {'@': 197}), 15: (1, {'@': 197}), 6: (1, {'@': 197}), 25: (1, {'@': 197}), 2: (1, {'@': 197}), 9: (1, {'@': 197}), 13: (1, {'@': 197}), 26: (1, {'@': 197}), 20: (1, {'@': 197}), 1: (1, {'@': 197}), 5: (1, {'@': 197}), 27: (1, {'@': 197}), 28: (1, {'@': 197}), 29: (1, {'@': 197}), 30: (1, {'@': 197}), 12: (1, {'@': 197}), 31: (1, {'@': 197}), 18: (1, {'@': 197}), 32: (1, {'@': 197}), 33: (1, {'@': 197}), 34: (1, {'@': 197}), 35: (1, {'@': 197})}, 237: {30: (0, 361)}, 238: {33: (0, 582), 1: (0, 654), 2: (0, 581), 4: (0, 634), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 20: (0, 48), 15: (0, 107), 16: (0, 26), 17: (0, 31), 21: (0, 16), 19: (0, 42)}, 239: {0: (0, 452), 7: (0, 650), 18: (0, 356), 12: (0, 405), 34: (0, 656), 5: (0, 371)}, 240: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 337), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 241: {0: (0, 452), 32: (0, 318), 28: (0, 323), 7: (0, 333), 12: (0, 405), 18: (0, 356), 5: (0, 371), 27: (1, {'@': 172})}, 242: {22: (1, {'@': 136}), 19: (1, {'@': 136}), 23: (1, {'@': 136}), 21: (1, {'@': 136}), 24: (1, {'@': 136}), 3: (1, {'@': 136}), 11: (1, {'@': 136}), 14: (1, {'@': 136}), 17: (1, {'@': 136}), 4: (1, {'@': 136}), 10: (1, {'@': 136}), 15: (1, {'@': 136}), 6: (1, {'@': 136}), 25: (1, {'@': 136}), 2: (1, {'@': 136}), 9: (1, {'@': 136}), 13: (1, {'@': 136}), 26: (1, {'@': 136}), 20: (1, {'@': 136}), 1: (1, {'@': 136}), 5: (1, {'@': 136}), 27: (1, {'@': 136}), 28: (1, {'@': 136}), 29: (1, {'@': 136}), 30: (1, {'@': 136}), 12: (1, {'@': 136}), 31: (1, {'@': 136}), 18: (1, {'@': 136}), 32: (1, {'@': 136}), 33: (1, {'@': 136}), 34: (1, {'@': 136}), 35: (1, {'@': 136})}, 243: {22: (1, {'@': 325}), 19: (1, {'@': 325}), 23: (1, {'@': 325}), 21: (1, {'@': 325}), 24: (1, {'@': 325}), 3: (1, {'@': 325}), 11: (1, {'@': 325}), 14: (1, {'@': 325}), 17: (1, {'@': 325}), 4: (1, {'@': 325}), 10: (1, {'@': 325}), 15: (1, {'@': 325}), 6: (1, {'@': 325}), 25: (1, {'@': 325}), 2: (1, {'@': 325}), 9: (1, {'@': 325}), 13: (1, {'@': 325}), 26: (1, {'@': 325}), 20: (1, {'@': 325}), 1: (1, {'@': 325}), 5: (1, {'@': 325}), 27: (1, {'@': 325}), 28: (1, {'@': 325}), 29: (1, {'@': 325}), 30: (1, {'@': 325}), 12: (1, {'@': 325}), 31: (1, {'@': 325}), 18: (1, {'@': 325}), 32: (1, {'@': 325}), 33: (1, {'@': 325}), 34: (1, {'@': 325}), 35: (1, {'@': 325})}, 244: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 118), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 50: (0, 13), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 41: (0, 673), 63: (0, 45), 64: (0, 49), 30: (0, 488), 65: (0, 737), 66: (0, 59)}, 245: {22: (1, {'@': 139}), 19: (1, {'@': 139}), 23: (1, {'@': 139}), 21: (1, {'@': 139}), 24: (1, {'@': 139}), 3: (1, {'@': 139}), 11: (1, {'@': 139}), 14: (1, {'@': 139}), 17: (1, {'@': 139}), 4: (1, {'@': 139}), 10: (1, {'@': 139}), 15: (1, {'@': 139}), 6: (1, {'@': 139}), 25: (1, {'@': 139}), 2: (1, {'@': 139}), 9: (1, {'@': 139}), 13: (1, {'@': 139}), 26: (1, {'@': 139}), 20: (1, {'@': 139}), 1: (1, {'@': 139}), 5: (1, {'@': 139}), 27: (1, {'@': 139}), 28: (1, {'@': 139}), 29: (1, {'@': 139}), 30: (1, {'@': 139}), 12: (1, {'@': 139}), 31: (1, {'@': 139}), 18: (1, {'@': 139}), 32: (1, {'@': 139}), 33: (1, {'@': 139}), 34: (1, {'@': 139}), 35: (1, {'@': 139})}, 246: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 515), 34: (0, 299), 29: (0, 327), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 19: (0, 42), 68: (0, 297), 18: (0, 356), 17: (0, 31), 21: (0, 16), 20: (0, 48)}, 247: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 438}), 5: (1, {'@': 438}), 27: (1, {'@': 438}), 18: (1, {'@': 438}), 32: (1, {'@': 438}), 28: (1, {'@': 438}), 34: (1, {'@': 438})}, 248: {0: (0, 452), 68: (0, 468), 34: (0, 630), 29: (0, 327), 18: (0, 356), 12: (0, 405), 7: (0, 635), 5: (0, 371)}, 249: {22: (1, {'@': 137}), 19: (1, {'@': 137}), 23: (1, {'@': 137}), 21: (1, {'@': 137}), 24: (1, {'@': 137}), 3: (1, {'@': 137}), 11: (1, {'@': 137}), 14: (1, {'@': 137}), 17: (1, {'@': 137}), 4: (1, {'@': 137}), 10: (1, {'@': 137}), 15: (1, {'@': 137}), 6: (1, {'@': 137}), 25: (1, {'@': 137}), 2: (1, {'@': 137}), 9: (1, {'@': 137}), 13: (1, {'@': 137}), 26: (1, {'@': 137}), 20: (1, {'@': 137}), 1: (1, {'@': 137}), 5: (1, {'@': 137}), 27: (1, {'@': 137}), 28: (1, {'@': 137}), 29: (1, {'@': 137}), 30: (1, {'@': 137}), 12: (1, {'@': 137}), 31: (1, {'@': 137}), 18: (1, {'@': 137}), 32: (1, {'@': 137}), 33: (1, {'@': 137}), 34: (1, {'@': 137}), 35: (1, {'@': 137})}, 250: {22: (1, {'@': 125}), 19: (1, {'@': 125}), 23: (1, {'@': 125}), 21: (1, {'@': 125}), 24: (1, {'@': 125}), 3: (1, {'@': 125}), 11: (1, {'@': 125}), 14: (1, {'@': 125}), 17: (1, {'@': 125}), 4: (1, {'@': 125}), 10: (1, {'@': 125}), 15: (1, {'@': 125}), 6: (1, {'@': 125}), 25: (1, {'@': 125}), 2: (1, {'@': 125}), 9: (1, {'@': 125}), 13: (1, {'@': 125}), 26: (1, {'@': 125}), 20: (1, {'@': 125}), 1: (1, {'@': 125}), 5: (1, {'@': 125}), 27: (1, {'@': 125}), 28: (1, {'@': 125}), 29: (1, {'@': 125}), 30: (1, {'@': 125}), 12: (1, {'@': 125}), 31: (1, {'@': 125}), 18: (1, {'@': 125}), 32: (1, {'@': 125}), 33: (1, {'@': 125}), 34: (1, {'@': 125}), 35: (1, {'@': 125})}, 251: {0: (0, 452), 7: (0, 265), 77: (0, 492), 18: (0, 356), 12: (0, 405), 30: (0, 498), 5: (0, 371), 28: (0, 257)}, 252: {33: (0, 256), 1: (0, 654), 2: (0, 581), 4: (0, 634), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 253: {7: (0, 460), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 412}), 65: (1, {'@': 412}), 56: (1, {'@': 412}), 31: (1, {'@': 412}), 59: (1, {'@': 412}), 43: (1, {'@': 412}), 21: (1, {'@': 412}), 24: (1, {'@': 412}), 61: (1, {'@': 412}), 37: (1, {'@': 412})}, 254: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 34: (0, 594), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 607), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 255: {22: (1, {'@': 144}), 19: (1, {'@': 144}), 23: (1, {'@': 144}), 21: (1, {'@': 144}), 24: (1, {'@': 144}), 3: (1, {'@': 144}), 11: (1, {'@': 144}), 14: (1, {'@': 144}), 17: (1, {'@': 144}), 4: (1, {'@': 144}), 10: (1, {'@': 144}), 15: (1, {'@': 144}), 6: (1, {'@': 144}), 25: (1, {'@': 144}), 2: (1, {'@': 144}), 9: (1, {'@': 144}), 13: (1, {'@': 144}), 26: (1, {'@': 144}), 20: (1, {'@': 144}), 1: (1, {'@': 144}), 5: (1, {'@': 144}), 27: (1, {'@': 144}), 28: (1, {'@': 144}), 29: (1, {'@': 144}), 30: (1, {'@': 144}), 12: (1, {'@': 144}), 31: (1, {'@': 144}), 18: (1, {'@': 144}), 32: (1, {'@': 144}), 33: (1, {'@': 144}), 34: (1, {'@': 144}), 35: (1, {'@': 144})}, 256: {0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 7: (0, 689), 42: (0, 718), 50: (0, 586), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 257: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 545), 30: (1, {'@': 56}), 48: (1, {'@': 56}), 65: (1, {'@': 56}), 56: (1, {'@': 56}), 31: (1, {'@': 56}), 59: (1, {'@': 56}), 43: (1, {'@': 56}), 21: (1, {'@': 56}), 24: (1, {'@': 56}), 61: (1, {'@': 56}), 37: (1, {'@': 56})}, 258: {22: (1, {'@': 149}), 19: (1, {'@': 149}), 23: (1, {'@': 149}), 21: (1, {'@': 149}), 24: (1, {'@': 149}), 3: (1, {'@': 149}), 11: (1, {'@': 149}), 14: (1, {'@': 149}), 17: (1, {'@': 149}), 4: (1, {'@': 149}), 10: (1, {'@': 149}), 15: (1, {'@': 149}), 6: (1, {'@': 149}), 25: (1, {'@': 149}), 2: (1, {'@': 149}), 9: (1, {'@': 149}), 13: (1, {'@': 149}), 26: (1, {'@': 149}), 20: (1, {'@': 149}), 1: (1, {'@': 149}), 5: (1, {'@': 149}), 27: (1, {'@': 149}), 28: (1, {'@': 149}), 29: (1, {'@': 149}), 30: (1, {'@': 149}), 12: (1, {'@': 149}), 31: (1, {'@': 149}), 18: (1, {'@': 149}), 32: (1, {'@': 149}), 33: (1, {'@': 149}), 34: (1, {'@': 149}), 35: (1, {'@': 149})}, 259: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 30: (1, {'@': 154}), 12: (1, {'@': 154}), 5: (1, {'@': 154}), 18: (1, {'@': 154}), 28: (1, {'@': 154})}, 260: {22: (1, {'@': 131}), 19: (1, {'@': 131}), 23: (1, {'@': 131}), 21: (1, {'@': 131}), 24: (1, {'@': 131}), 3: (1, {'@': 131}), 11: (1, {'@': 131}), 14: (1, {'@': 131}), 17: (1, {'@': 131}), 4: (1, {'@': 131}), 10: (1, {'@': 131}), 15: (1, {'@': 131}), 6: (1, {'@': 131}), 25: (1, {'@': 131}), 2: (1, {'@': 131}), 9: (1, {'@': 131}), 13: (1, {'@': 131}), 26: (1, {'@': 131}), 20: (1, {'@': 131}), 1: (1, {'@': 131}), 5: (1, {'@': 131}), 27: (1, {'@': 131}), 28: (1, {'@': 131}), 29: (1, {'@': 131}), 30: (1, {'@': 131}), 12: (1, {'@': 131}), 31: (1, {'@': 131}), 18: (1, {'@': 131}), 32: (1, {'@': 131}), 33: (1, {'@': 131}), 34: (1, {'@': 131}), 35: (1, {'@': 131})}, 261: {22: (1, {'@': 152}), 19: (1, {'@': 152}), 23: (1, {'@': 152}), 21: (1, {'@': 152}), 24: (1, {'@': 152}), 3: (1, {'@': 152}), 11: (1, {'@': 152}), 14: (1, {'@': 152}), 17: (1, {'@': 152}), 4: (1, {'@': 152}), 10: (1, {'@': 152}), 15: (1, {'@': 152}), 6: (1, {'@': 152}), 25: (1, {'@': 152}), 2: (1, {'@': 152}), 9: (1, {'@': 152}), 13: (1, {'@': 152}), 26: (1, {'@': 152}), 20: (1, {'@': 152}), 1: (1, {'@': 152}), 5: (1, {'@': 152}), 27: (1, {'@': 152}), 28: (1, {'@': 152}), 29: (1, {'@': 152}), 30: (1, {'@': 152}), 12: (1, {'@': 152}), 31: (1, {'@': 152}), 18: (1, {'@': 152}), 32: (1, {'@': 152}), 33: (1, {'@': 152}), 34: (1, {'@': 152}), 35: (1, {'@': 152})}, 262: {22: (1, {'@': 199}), 19: (1, {'@': 199}), 23: (1, {'@': 199}), 21: (1, {'@': 199}), 24: (1, {'@': 199}), 3: (1, {'@': 199}), 11: (1, {'@': 199}), 14: (1, {'@': 199}), 17: (1, {'@': 199}), 4: (1, {'@': 199}), 10: (1, {'@': 199}), 15: (1, {'@': 199}), 6: (1, {'@': 199}), 25: (1, {'@': 199}), 2: (1, {'@': 199}), 9: (1, {'@': 199}), 13: (1, {'@': 199}), 26: (1, {'@': 199}), 20: (1, {'@': 199}), 1: (1, {'@': 199}), 5: (1, {'@': 199}), 27: (1, {'@': 199}), 28: (1, {'@': 199}), 29: (1, {'@': 199}), 30: (1, {'@': 199}), 12: (1, {'@': 199}), 31: (1, {'@': 199}), 18: (1, {'@': 199}), 32: (1, {'@': 199}), 33: (1, {'@': 199}), 34: (1, {'@': 199}), 35: (1, {'@': 199})}, 263: {34: (0, 329)}, 264: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 30: (1, {'@': 414}), 5: (1, {'@': 414}), 18: (1, {'@': 414}), 12: (1, {'@': 414}), 34: (1, {'@': 414})}, 265: {30: (1, {'@': 55}), 48: (1, {'@': 55}), 65: (1, {'@': 55}), 56: (1, {'@': 55}), 31: (1, {'@': 55}), 59: (1, {'@': 55}), 43: (1, {'@': 55}), 21: (1, {'@': 55}), 24: (1, {'@': 55}), 61: (1, {'@': 55}), 37: (1, {'@': 55})}, 266: {22: (1, {'@': 127}), 19: (1, {'@': 127}), 23: (1, {'@': 127}), 21: (1, {'@': 127}), 24: (1, {'@': 127}), 3: (1, {'@': 127}), 11: (1, {'@': 127}), 14: (1, {'@': 127}), 17: (1, {'@': 127}), 4: (1, {'@': 127}), 10: (1, {'@': 127}), 15: (1, {'@': 127}), 6: (1, {'@': 127}), 25: (1, {'@': 127}), 2: (1, {'@': 127}), 9: (1, {'@': 127}), 13: (1, {'@': 127}), 26: (1, {'@': 127}), 20: (1, {'@': 127}), 1: (1, {'@': 127}), 5: (1, {'@': 127}), 27: (1, {'@': 127}), 28: (1, {'@': 127}), 29: (1, {'@': 127}), 30: (1, {'@': 127}), 12: (1, {'@': 127}), 31: (1, {'@': 127}), 18: (1, {'@': 127}), 32: (1, {'@': 127}), 33: (1, {'@': 127}), 34: (1, {'@': 127}), 35: (1, {'@': 127})}, 267: {22: (1, {'@': 133}), 19: (1, {'@': 133}), 23: (1, {'@': 133}), 21: (1, {'@': 133}), 24: (1, {'@': 133}), 3: (1, {'@': 133}), 11: (1, {'@': 133}), 14: (1, {'@': 133}), 17: (1, {'@': 133}), 4: (1, {'@': 133}), 10: (1, {'@': 133}), 15: (1, {'@': 133}), 6: (1, {'@': 133}), 25: (1, {'@': 133}), 2: (1, {'@': 133}), 9: (1, {'@': 133}), 13: (1, {'@': 133}), 26: (1, {'@': 133}), 20: (1, {'@': 133}), 1: (1, {'@': 133}), 5: (1, {'@': 133}), 27: (1, {'@': 133}), 28: (1, {'@': 133}), 29: (1, {'@': 133}), 30: (1, {'@': 133}), 12: (1, {'@': 133}), 31: (1, {'@': 133}), 18: (1, {'@': 133}), 32: (1, {'@': 133}), 33: (1, {'@': 133}), 34: (1, {'@': 133}), 35: (1, {'@': 133})}, 268: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 433}), 5: (1, {'@': 433}), 27: (1, {'@': 433}), 18: (1, {'@': 433}), 32: (1, {'@': 433}), 28: (1, {'@': 433}), 34: (1, {'@': 433})}, 269: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 504), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 270: {0: (0, 452), 28: (0, 309), 34: (0, 260), 12: (0, 405), 18: (0, 356), 5: (0, 371), 7: (0, 263)}, 271: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 338), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 7: (0, 580), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 34: (0, 588), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 272: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 50: (0, 141), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 7: (0, 149), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 273: {0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 7: (0, 541), 13: (0, 98), 14: (0, 102), 3: (0, 546), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 274: {0: (0, 452), 30: (0, 243), 29: (0, 327), 7: (0, 290), 12: (0, 405), 68: (0, 422), 18: (0, 356), 5: (0, 371)}, 275: {22: (1, {'@': 134}), 19: (1, {'@': 134}), 23: (1, {'@': 134}), 21: (1, {'@': 134}), 24: (1, {'@': 134}), 3: (1, {'@': 134}), 11: (1, {'@': 134}), 14: (1, {'@': 134}), 17: (1, {'@': 134}), 4: (1, {'@': 134}), 10: (1, {'@': 134}), 15: (1, {'@': 134}), 6: (1, {'@': 134}), 25: (1, {'@': 134}), 2: (1, {'@': 134}), 9: (1, {'@': 134}), 13: (1, {'@': 134}), 26: (1, {'@': 134}), 20: (1, {'@': 134}), 1: (1, {'@': 134}), 5: (1, {'@': 134}), 27: (1, {'@': 134}), 28: (1, {'@': 134}), 29: (1, {'@': 134}), 30: (1, {'@': 134}), 12: (1, {'@': 134}), 31: (1, {'@': 134}), 18: (1, {'@': 134}), 32: (1, {'@': 134}), 33: (1, {'@': 134}), 34: (1, {'@': 134}), 35: (1, {'@': 134})}, 276: {3: (0, 470)}, 277: {0: (0, 452), 1: (0, 654), 2: (0, 581), 78: (0, 241), 28: (0, 324), 32: (0, 335), 7: (0, 577), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 27: (1, {'@': 178})}, 278: {22: (1, {'@': 217}), 19: (1, {'@': 217}), 23: (1, {'@': 217}), 21: (1, {'@': 217}), 24: (1, {'@': 217}), 3: (1, {'@': 217}), 11: (1, {'@': 217}), 14: (1, {'@': 217}), 17: (1, {'@': 217}), 4: (1, {'@': 217}), 10: (1, {'@': 217}), 15: (1, {'@': 217}), 6: (1, {'@': 217}), 25: (1, {'@': 217}), 2: (1, {'@': 217}), 9: (1, {'@': 217}), 13: (1, {'@': 217}), 26: (1, {'@': 217}), 20: (1, {'@': 217}), 1: (1, {'@': 217}), 5: (1, {'@': 217}), 27: (1, {'@': 217}), 28: (1, {'@': 217}), 29: (1, {'@': 217}), 30: (1, {'@': 217}), 12: (1, {'@': 217}), 31: (1, {'@': 217}), 18: (1, {'@': 217}), 32: (1, {'@': 217}), 33: (1, {'@': 217}), 34: (1, {'@': 217}), 35: (1, {'@': 217})}, 279: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 676), 4: (0, 634), 5: (0, 371), 7: (0, 511), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 280: {22: (1, {'@': 203}), 19: (1, {'@': 203}), 23: (1, {'@': 203}), 21: (1, {'@': 203}), 24: (1, {'@': 203}), 3: (1, {'@': 203}), 11: (1, {'@': 203}), 14: (1, {'@': 203}), 17: (1, {'@': 203}), 4: (1, {'@': 203}), 10: (1, {'@': 203}), 15: (1, {'@': 203}), 6: (1, {'@': 203}), 25: (1, {'@': 203}), 2: (1, {'@': 203}), 9: (1, {'@': 203}), 13: (1, {'@': 203}), 26: (1, {'@': 203}), 20: (1, {'@': 203}), 1: (1, {'@': 203}), 5: (1, {'@': 203}), 27: (1, {'@': 203}), 28: (1, {'@': 203}), 29: (1, {'@': 203}), 30: (1, {'@': 203}), 12: (1, {'@': 203}), 31: (1, {'@': 203}), 18: (1, {'@': 203}), 32: (1, {'@': 203}), 33: (1, {'@': 203}), 34: (1, {'@': 203}), 35: (1, {'@': 203})}, 281: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 604), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 282: {22: (1, {'@': 213}), 19: (1, {'@': 213}), 23: (1, {'@': 213}), 21: (1, {'@': 213}), 24: (1, {'@': 213}), 3: (1, {'@': 213}), 11: (1, {'@': 213}), 14: (1, {'@': 213}), 17: (1, {'@': 213}), 4: (1, {'@': 213}), 10: (1, {'@': 213}), 15: (1, {'@': 213}), 6: (1, {'@': 213}), 25: (1, {'@': 213}), 2: (1, {'@': 213}), 9: (1, {'@': 213}), 13: (1, {'@': 213}), 26: (1, {'@': 213}), 20: (1, {'@': 213}), 1: (1, {'@': 213}), 5: (1, {'@': 213}), 27: (1, {'@': 213}), 28: (1, {'@': 213}), 29: (1, {'@': 213}), 30: (1, {'@': 213}), 12: (1, {'@': 213}), 31: (1, {'@': 213}), 18: (1, {'@': 213}), 32: (1, {'@': 213}), 33: (1, {'@': 213}), 34: (1, {'@': 213}), 35: (1, {'@': 213})}, 283: {27: (1, {'@': 175}), 5: (1, {'@': 175}), 18: (1, {'@': 175}), 12: (1, {'@': 175})}, 284: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 5: (1, {'@': 90}), 3: (1, {'@': 90}), 12: (1, {'@': 90}), 18: (1, {'@': 90}), 34: (1, {'@': 90}), 27: (1, {'@': 90}), 28: (1, {'@': 90}), 29: (1, {'@': 90}), 30: (1, {'@': 90}), 25: (1, {'@': 90}), 31: (1, {'@': 90}), 35: (1, {'@': 90}), 32: (1, {'@': 90}), 33: (1, {'@': 90})}, 285: {22: (1, {'@': 140}), 19: (1, {'@': 140}), 23: (1, {'@': 140}), 21: (1, {'@': 140}), 24: (1, {'@': 140}), 3: (1, {'@': 140}), 11: (1, {'@': 140}), 14: (1, {'@': 140}), 17: (1, {'@': 140}), 4: (1, {'@': 140}), 10: (1, {'@': 140}), 15: (1, {'@': 140}), 6: (1, {'@': 140}), 25: (1, {'@': 140}), 2: (1, {'@': 140}), 9: (1, {'@': 140}), 13: (1, {'@': 140}), 26: (1, {'@': 140}), 20: (1, {'@': 140}), 1: (1, {'@': 140}), 5: (1, {'@': 140}), 27: (1, {'@': 140}), 28: (1, {'@': 140}), 29: (1, {'@': 140}), 30: (1, {'@': 140}), 12: (1, {'@': 140}), 31: (1, {'@': 140}), 18: (1, {'@': 140}), 32: (1, {'@': 140}), 33: (1, {'@': 140}), 34: (1, {'@': 140}), 35: (1, {'@': 140})}, 286: {0: (0, 452), 37: (0, 709), 7: (0, 464), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 247), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 34: (0, 476), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 287: {0: (0, 452), 34: (0, 457), 18: (0, 356), 12: (0, 405), 7: (0, 640), 5: (0, 371)}, 288: {22: (1, {'@': 138}), 19: (1, {'@': 138}), 23: (1, {'@': 138}), 21: (1, {'@': 138}), 24: (1, {'@': 138}), 3: (1, {'@': 138}), 11: (1, {'@': 138}), 14: (1, {'@': 138}), 17: (1, {'@': 138}), 4: (1, {'@': 138}), 10: (1, {'@': 138}), 15: (1, {'@': 138}), 6: (1, {'@': 138}), 25: (1, {'@': 138}), 2: (1, {'@': 138}), 9: (1, {'@': 138}), 13: (1, {'@': 138}), 26: (1, {'@': 138}), 20: (1, {'@': 138}), 1: (1, {'@': 138}), 5: (1, {'@': 138}), 27: (1, {'@': 138}), 28: (1, {'@': 138}), 29: (1, {'@': 138}), 30: (1, {'@': 138}), 12: (1, {'@': 138}), 31: (1, {'@': 138}), 18: (1, {'@': 138}), 32: (1, {'@': 138}), 33: (1, {'@': 138}), 34: (1, {'@': 138}), 35: (1, {'@': 138})}, 289: {32: (0, 274), 0: (0, 452), 1: (0, 654), 2: (0, 581), 29: (0, 327), 68: (0, 218), 4: (0, 634), 5: (0, 371), 6: (0, 66), 9: (0, 83), 8: (0, 70), 10: (0, 87), 7: (0, 223), 11: (0, 93), 12: (0, 405), 30: (0, 162), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 290: {0: (0, 452), 30: (0, 559), 68: (0, 564), 29: (0, 327), 18: (0, 356), 12: (0, 405), 7: (0, 572), 5: (0, 371)}, 291: {22: (1, {'@': 162}), 19: (1, {'@': 162}), 23: (1, {'@': 162}), 21: (1, {'@': 162}), 24: (1, {'@': 162}), 3: (1, {'@': 162}), 11: (1, {'@': 162}), 14: (1, {'@': 162}), 17: (1, {'@': 162}), 4: (1, {'@': 162}), 10: (1, {'@': 162}), 15: (1, {'@': 162}), 6: (1, {'@': 162}), 25: (1, {'@': 162}), 2: (1, {'@': 162}), 9: (1, {'@': 162}), 13: (1, {'@': 162}), 26: (1, {'@': 162}), 20: (1, {'@': 162}), 1: (1, {'@': 162}), 5: (1, {'@': 162}), 27: (1, {'@': 162}), 28: (1, {'@': 162}), 29: (1, {'@': 162}), 30: (1, {'@': 162}), 12: (1, {'@': 162}), 31: (1, {'@': 162}), 18: (1, {'@': 162}), 32: (1, {'@': 162}), 33: (1, {'@': 162}), 34: (1, {'@': 162}), 35: (1, {'@': 162})}, 292: {68: (0, 516), 0: (0, 452), 1: (0, 654), 2: (0, 581), 32: (0, 521), 29: (0, 327), 7: (0, 542), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 30: (0, 549), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 293: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 143), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 294: {34: (0, 437), 0: (0, 452), 28: (0, 441), 7: (0, 473), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 295: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 608), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 7: (0, 207), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 296: {22: (1, {'@': 186}), 5: (1, {'@': 186}), 21: (1, {'@': 186}), 3: (1, {'@': 186}), 24: (1, {'@': 186}), 27: (1, {'@': 186}), 11: (1, {'@': 186}), 17: (1, {'@': 186}), 29: (1, {'@': 186}), 30: (1, {'@': 186}), 28: (1, {'@': 186}), 6: (1, {'@': 186}), 25: (1, {'@': 186}), 12: (1, {'@': 186}), 31: (1, {'@': 186}), 13: (1, {'@': 186}), 18: (1, {'@': 186}), 32: (1, {'@': 186}), 33: (1, {'@': 186}), 34: (1, {'@': 186}), 19: (1, {'@': 186}), 23: (1, {'@': 186}), 14: (1, {'@': 186}), 4: (1, {'@': 186}), 10: (1, {'@': 186}), 15: (1, {'@': 186}), 2: (1, {'@': 186}), 9: (1, {'@': 186}), 26: (1, {'@': 186}), 35: (1, {'@': 186}), 20: (1, {'@': 186}), 1: (1, {'@': 186})}, 297: {0: (0, 452), 7: (0, 461), 18: (0, 356), 12: (0, 405), 34: (0, 434), 5: (0, 371)}, 298: {33: (0, 124), 1: (0, 654), 2: (0, 581), 4: (0, 634), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 299: {22: (1, {'@': 206}), 19: (1, {'@': 206}), 23: (1, {'@': 206}), 21: (1, {'@': 206}), 24: (1, {'@': 206}), 3: (1, {'@': 206}), 11: (1, {'@': 206}), 14: (1, {'@': 206}), 17: (1, {'@': 206}), 4: (1, {'@': 206}), 10: (1, {'@': 206}), 15: (1, {'@': 206}), 6: (1, {'@': 206}), 25: (1, {'@': 206}), 2: (1, {'@': 206}), 9: (1, {'@': 206}), 13: (1, {'@': 206}), 26: (1, {'@': 206}), 20: (1, {'@': 206}), 1: (1, {'@': 206}), 5: (1, {'@': 206}), 27: (1, {'@': 206}), 28: (1, {'@': 206}), 29: (1, {'@': 206}), 30: (1, {'@': 206}), 12: (1, {'@': 206}), 31: (1, {'@': 206}), 18: (1, {'@': 206}), 32: (1, {'@': 206}), 33: (1, {'@': 206}), 34: (1, {'@': 206}), 35: (1, {'@': 206})}, 300: {34: (0, 448)}, 301: {28: (0, 569), 0: (0, 452), 72: (0, 605), 7: (0, 596), 5: (0, 371), 12: (0, 405), 18: (0, 356)}, 302: {37: (0, 709), 24: (0, 711), 0: (0, 452), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 5: (0, 371), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 7), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 7: (0, 24), 65: (0, 737), 66: (0, 59)}, 303: {22: (1, {'@': 123}), 19: (1, {'@': 123}), 23: (1, {'@': 123}), 21: (1, {'@': 123}), 24: (1, {'@': 123}), 3: (1, {'@': 123}), 11: (1, {'@': 123}), 14: (1, {'@': 123}), 17: (1, {'@': 123}), 4: (1, {'@': 123}), 10: (1, {'@': 123}), 15: (1, {'@': 123}), 6: (1, {'@': 123}), 25: (1, {'@': 123}), 2: (1, {'@': 123}), 9: (1, {'@': 123}), 13: (1, {'@': 123}), 26: (1, {'@': 123}), 20: (1, {'@': 123}), 1: (1, {'@': 123}), 5: (1, {'@': 123}), 27: (1, {'@': 123}), 28: (1, {'@': 123}), 29: (1, {'@': 123}), 30: (1, {'@': 123}), 12: (1, {'@': 123}), 31: (1, {'@': 123}), 18: (1, {'@': 123}), 32: (1, {'@': 123}), 33: (1, {'@': 123}), 34: (1, {'@': 123}), 35: (1, {'@': 123})}, 304: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 50: (0, 268), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 34: (0, 250), 65: (0, 737), 66: (0, 59)}, 305: {42: (0, 649), 31: (0, 348)}, 306: {27: (0, 291)}, 307: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 664), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 308: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 30: (1, {'@': 155}), 12: (1, {'@': 155}), 5: (1, {'@': 155}), 18: (1, {'@': 155}), 28: (1, {'@': 155})}, 309: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 50: (0, 200), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 7: (0, 615), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 34: (0, 621), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 310: {0: (0, 452), 7: (0, 294), 28: (0, 286), 12: (0, 405), 34: (0, 313), 18: (0, 356), 5: (0, 371)}, 311: {22: (1, {'@': 220}), 19: (1, {'@': 220}), 23: (1, {'@': 220}), 21: (1, {'@': 220}), 24: (1, {'@': 220}), 3: (1, {'@': 220}), 11: (1, {'@': 220}), 14: (1, {'@': 220}), 17: (1, {'@': 220}), 4: (1, {'@': 220}), 10: (1, {'@': 220}), 15: (1, {'@': 220}), 6: (1, {'@': 220}), 25: (1, {'@': 220}), 2: (1, {'@': 220}), 9: (1, {'@': 220}), 13: (1, {'@': 220}), 26: (1, {'@': 220}), 20: (1, {'@': 220}), 1: (1, {'@': 220}), 5: (1, {'@': 220}), 27: (1, {'@': 220}), 28: (1, {'@': 220}), 29: (1, {'@': 220}), 30: (1, {'@': 220}), 12: (1, {'@': 220}), 31: (1, {'@': 220}), 18: (1, {'@': 220}), 32: (1, {'@': 220}), 33: (1, {'@': 220}), 34: (1, {'@': 220}), 35: (1, {'@': 220})}, 312: {22: (1, {'@': 165}), 19: (1, {'@': 165}), 23: (1, {'@': 165}), 21: (1, {'@': 165}), 24: (1, {'@': 165}), 3: (1, {'@': 165}), 11: (1, {'@': 165}), 14: (1, {'@': 165}), 17: (1, {'@': 165}), 4: (1, {'@': 165}), 10: (1, {'@': 165}), 15: (1, {'@': 165}), 6: (1, {'@': 165}), 25: (1, {'@': 165}), 2: (1, {'@': 165}), 9: (1, {'@': 165}), 13: (1, {'@': 165}), 26: (1, {'@': 165}), 20: (1, {'@': 165}), 1: (1, {'@': 165}), 5: (1, {'@': 165}), 27: (1, {'@': 165}), 28: (1, {'@': 165}), 29: (1, {'@': 165}), 30: (1, {'@': 165}), 12: (1, {'@': 165}), 31: (1, {'@': 165}), 18: (1, {'@': 165}), 32: (1, {'@': 165}), 33: (1, {'@': 165}), 34: (1, {'@': 165}), 35: (1, {'@': 165})}, 313: {22: (1, {'@': 120}), 19: (1, {'@': 120}), 23: (1, {'@': 120}), 21: (1, {'@': 120}), 24: (1, {'@': 120}), 3: (1, {'@': 120}), 11: (1, {'@': 120}), 14: (1, {'@': 120}), 17: (1, {'@': 120}), 4: (1, {'@': 120}), 10: (1, {'@': 120}), 15: (1, {'@': 120}), 6: (1, {'@': 120}), 25: (1, {'@': 120}), 2: (1, {'@': 120}), 9: (1, {'@': 120}), 13: (1, {'@': 120}), 26: (1, {'@': 120}), 20: (1, {'@': 120}), 1: (1, {'@': 120}), 5: (1, {'@': 120}), 27: (1, {'@': 120}), 28: (1, {'@': 120}), 29: (1, {'@': 120}), 30: (1, {'@': 120}), 12: (1, {'@': 120}), 31: (1, {'@': 120}), 18: (1, {'@': 120}), 32: (1, {'@': 120}), 33: (1, {'@': 120}), 34: (1, {'@': 120}), 35: (1, {'@': 120})}, 314: {0: (0, 452), 34: (0, 332), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 300)}, 315: {22: (1, {'@': 164}), 19: (1, {'@': 164}), 23: (1, {'@': 164}), 21: (1, {'@': 164}), 24: (1, {'@': 164}), 3: (1, {'@': 164}), 11: (1, {'@': 164}), 14: (1, {'@': 164}), 17: (1, {'@': 164}), 4: (1, {'@': 164}), 10: (1, {'@': 164}), 15: (1, {'@': 164}), 6: (1, {'@': 164}), 25: (1, {'@': 164}), 2: (1, {'@': 164}), 9: (1, {'@': 164}), 13: (1, {'@': 164}), 26: (1, {'@': 164}), 20: (1, {'@': 164}), 1: (1, {'@': 164}), 5: (1, {'@': 164}), 27: (1, {'@': 164}), 28: (1, {'@': 164}), 29: (1, {'@': 164}), 30: (1, {'@': 164}), 12: (1, {'@': 164}), 31: (1, {'@': 164}), 18: (1, {'@': 164}), 32: (1, {'@': 164}), 33: (1, {'@': 164}), 34: (1, {'@': 164}), 35: (1, {'@': 164})}, 316: {0: (0, 452), 37: (0, 709), 24: (0, 711), 7: (0, 690), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 467), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 317: {34: (0, 644)}, 318: {0: (0, 452), 7: (0, 670), 18: (0, 356), 12: (0, 405), 5: (0, 371), 27: (1, {'@': 170})}, 319: {22: (1, {'@': 124}), 19: (1, {'@': 124}), 23: (1, {'@': 124}), 21: (1, {'@': 124}), 24: (1, {'@': 124}), 3: (1, {'@': 124}), 11: (1, {'@': 124}), 14: (1, {'@': 124}), 17: (1, {'@': 124}), 4: (1, {'@': 124}), 10: (1, {'@': 124}), 15: (1, {'@': 124}), 6: (1, {'@': 124}), 25: (1, {'@': 124}), 2: (1, {'@': 124}), 9: (1, {'@': 124}), 13: (1, {'@': 124}), 26: (1, {'@': 124}), 20: (1, {'@': 124}), 1: (1, {'@': 124}), 5: (1, {'@': 124}), 27: (1, {'@': 124}), 28: (1, {'@': 124}), 29: (1, {'@': 124}), 30: (1, {'@': 124}), 12: (1, {'@': 124}), 31: (1, {'@': 124}), 18: (1, {'@': 124}), 32: (1, {'@': 124}), 33: (1, {'@': 124}), 34: (1, {'@': 124}), 35: (1, {'@': 124})}, 320: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 506), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 321: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 50: (0, 279), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 322: {59: (0, 465), 22: (1, {'@': 187}), 5: (1, {'@': 187}), 21: (1, {'@': 187}), 3: (1, {'@': 187}), 24: (1, {'@': 187}), 27: (1, {'@': 187}), 11: (1, {'@': 187}), 17: (1, {'@': 187}), 29: (1, {'@': 187}), 30: (1, {'@': 187}), 28: (1, {'@': 187}), 6: (1, {'@': 187}), 25: (1, {'@': 187}), 12: (1, {'@': 187}), 31: (1, {'@': 187}), 13: (1, {'@': 187}), 18: (1, {'@': 187}), 32: (1, {'@': 187}), 33: (1, {'@': 187}), 34: (1, {'@': 187}), 19: (1, {'@': 187}), 23: (1, {'@': 187}), 14: (1, {'@': 187}), 4: (1, {'@': 187}), 10: (1, {'@': 187}), 15: (1, {'@': 187}), 2: (1, {'@': 187}), 9: (1, {'@': 187}), 26: (1, {'@': 187}), 35: (1, {'@': 187}), 20: (1, {'@': 187}), 1: (1, {'@': 187})}, 323: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 247), 47: (0, 746), 7: (0, 681), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59), 27: (1, {'@': 168})}, 324: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 555), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 7: (0, 669), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59), 27: (1, {'@': 174})}, 325: {22: (1, {'@': 126}), 19: (1, {'@': 126}), 23: (1, {'@': 126}), 21: (1, {'@': 126}), 24: (1, {'@': 126}), 3: (1, {'@': 126}), 11: (1, {'@': 126}), 14: (1, {'@': 126}), 17: (1, {'@': 126}), 4: (1, {'@': 126}), 10: (1, {'@': 126}), 15: (1, {'@': 126}), 6: (1, {'@': 126}), 25: (1, {'@': 126}), 2: (1, {'@': 126}), 9: (1, {'@': 126}), 13: (1, {'@': 126}), 26: (1, {'@': 126}), 20: (1, {'@': 126}), 1: (1, {'@': 126}), 5: (1, {'@': 126}), 27: (1, {'@': 126}), 28: (1, {'@': 126}), 29: (1, {'@': 126}), 30: (1, {'@': 126}), 12: (1, {'@': 126}), 31: (1, {'@': 126}), 18: (1, {'@': 126}), 32: (1, {'@': 126}), 33: (1, {'@': 126}), 34: (1, {'@': 126}), 35: (1, {'@': 126})}, 326: {30: (0, 113)}, 327: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 264), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59), 7: (0, 307)}, 328: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 248), 29: (0, 327), 34: (0, 282), 4: (0, 634), 5: (0, 371), 68: (0, 287), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 329: {22: (1, {'@': 130}), 19: (1, {'@': 130}), 23: (1, {'@': 130}), 21: (1, {'@': 130}), 24: (1, {'@': 130}), 3: (1, {'@': 130}), 11: (1, {'@': 130}), 14: (1, {'@': 130}), 17: (1, {'@': 130}), 4: (1, {'@': 130}), 10: (1, {'@': 130}), 15: (1, {'@': 130}), 6: (1, {'@': 130}), 25: (1, {'@': 130}), 2: (1, {'@': 130}), 9: (1, {'@': 130}), 13: (1, {'@': 130}), 26: (1, {'@': 130}), 20: (1, {'@': 130}), 1: (1, {'@': 130}), 5: (1, {'@': 130}), 27: (1, {'@': 130}), 28: (1, {'@': 130}), 29: (1, {'@': 130}), 30: (1, {'@': 130}), 12: (1, {'@': 130}), 31: (1, {'@': 130}), 18: (1, {'@': 130}), 32: (1, {'@': 130}), 33: (1, {'@': 130}), 34: (1, {'@': 130}), 35: (1, {'@': 130})}, 330: {27: (0, 315)}, 331: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 578), 47: (0, 746), 31: (0, 348), 49: (0, 748), 34: (0, 602), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 332: {22: (1, {'@': 219}), 19: (1, {'@': 219}), 23: (1, {'@': 219}), 21: (1, {'@': 219}), 24: (1, {'@': 219}), 3: (1, {'@': 219}), 11: (1, {'@': 219}), 14: (1, {'@': 219}), 17: (1, {'@': 219}), 4: (1, {'@': 219}), 10: (1, {'@': 219}), 15: (1, {'@': 219}), 6: (1, {'@': 219}), 25: (1, {'@': 219}), 2: (1, {'@': 219}), 9: (1, {'@': 219}), 13: (1, {'@': 219}), 26: (1, {'@': 219}), 20: (1, {'@': 219}), 1: (1, {'@': 219}), 5: (1, {'@': 219}), 27: (1, {'@': 219}), 28: (1, {'@': 219}), 29: (1, {'@': 219}), 30: (1, {'@': 219}), 12: (1, {'@': 219}), 31: (1, {'@': 219}), 18: (1, {'@': 219}), 32: (1, {'@': 219}), 33: (1, {'@': 219}), 34: (1, {'@': 219}), 35: (1, {'@': 219})}, 333: {28: (0, 583), 27: (1, {'@': 171}), 5: (1, {'@': 171}), 18: (1, {'@': 171}), 12: (1, {'@': 171})}, 334: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 7: (0, 537), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 555), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 34: (0, 285), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 335: {0: (0, 452), 7: (0, 283), 18: (0, 356), 12: (0, 405), 5: (0, 371), 27: (1, {'@': 176})}, 336: {0: (0, 452), 77: (0, 587), 30: (0, 187), 12: (0, 405), 79: (0, 132), 28: (0, 257), 7: (0, 265), 18: (0, 356), 5: (0, 371)}, 337: {0: (0, 452), 7: (0, 153), 1: (0, 654), 2: (0, 581), 29: (0, 327), 68: (0, 235), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 34: (0, 262)}, 338: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 432}), 5: (1, {'@': 432}), 27: (1, {'@': 432}), 18: (1, {'@': 432}), 32: (1, {'@': 432}), 28: (1, {'@': 432}), 34: (1, {'@': 432})}, 339: {37: (0, 709), 24: (0, 711), 0: (0, 452), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 5: (0, 371), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 338), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 7: (0, 444), 65: (0, 737), 66: (0, 59)}, 340: {48: (1, {'@': 373}), 65: (1, {'@': 373}), 56: (1, {'@': 373}), 12: (1, {'@': 373}), 31: (1, {'@': 373}), 59: (1, {'@': 373}), 5: (1, {'@': 373}), 43: (1, {'@': 373}), 21: (1, {'@': 373}), 24: (1, {'@': 373}), 61: (1, {'@': 373}), 18: (1, {'@': 373}), 37: (1, {'@': 373})}, 341: {}, 342: {22: (1, {'@': 308}), 19: (1, {'@': 308}), 23: (1, {'@': 308}), 21: (1, {'@': 308}), 24: (1, {'@': 308}), 3: (1, {'@': 308}), 11: (1, {'@': 308}), 14: (1, {'@': 308}), 17: (1, {'@': 308}), 4: (1, {'@': 308}), 10: (1, {'@': 308}), 15: (1, {'@': 308}), 6: (1, {'@': 308}), 25: (1, {'@': 308}), 2: (1, {'@': 308}), 9: (1, {'@': 308}), 13: (1, {'@': 308}), 26: (1, {'@': 308}), 20: (1, {'@': 308}), 1: (1, {'@': 308}), 5: (1, {'@': 308}), 27: (1, {'@': 308}), 28: (1, {'@': 308}), 29: (1, {'@': 308}), 30: (1, {'@': 308}), 12: (1, {'@': 308}), 31: (1, {'@': 308}), 18: (1, {'@': 308}), 32: (1, {'@': 308}), 33: (1, {'@': 308}), 34: (1, {'@': 308}), 35: (1, {'@': 308})}, 343: {22: (1, {'@': 232}), 19: (1, {'@': 232}), 23: (1, {'@': 232}), 21: (1, {'@': 232}), 24: (1, {'@': 232}), 3: (1, {'@': 232}), 11: (1, {'@': 232}), 14: (1, {'@': 232}), 17: (1, {'@': 232}), 4: (1, {'@': 232}), 10: (1, {'@': 232}), 15: (1, {'@': 232}), 6: (1, {'@': 232}), 25: (1, {'@': 232}), 2: (1, {'@': 232}), 9: (1, {'@': 232}), 13: (1, {'@': 232}), 26: (1, {'@': 232}), 20: (1, {'@': 232}), 1: (1, {'@': 232}), 5: (1, {'@': 232}), 27: (1, {'@': 232}), 28: (1, {'@': 232}), 29: (1, {'@': 232}), 30: (1, {'@': 232}), 12: (1, {'@': 232}), 31: (1, {'@': 232}), 18: (1, {'@': 232}), 32: (1, {'@': 232}), 33: (1, {'@': 232}), 34: (1, {'@': 232}), 35: (1, {'@': 232})}, 344: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 159), 30: (0, 163)}, 345: {22: (1, {'@': 237}), 19: (1, {'@': 237}), 23: (1, {'@': 237}), 21: (1, {'@': 237}), 24: (1, {'@': 237}), 3: (1, {'@': 237}), 11: (1, {'@': 237}), 14: (1, {'@': 237}), 17: (1, {'@': 237}), 4: (1, {'@': 237}), 10: (1, {'@': 237}), 15: (1, {'@': 237}), 6: (1, {'@': 237}), 25: (1, {'@': 237}), 2: (1, {'@': 237}), 9: (1, {'@': 237}), 13: (1, {'@': 237}), 26: (1, {'@': 237}), 20: (1, {'@': 237}), 1: (1, {'@': 237}), 5: (1, {'@': 237}), 27: (1, {'@': 237}), 28: (1, {'@': 237}), 29: (1, {'@': 237}), 30: (1, {'@': 237}), 12: (1, {'@': 237}), 31: (1, {'@': 237}), 18: (1, {'@': 237}), 32: (1, {'@': 237}), 33: (1, {'@': 237}), 34: (1, {'@': 237}), 35: (1, {'@': 237})}, 346: {22: (1, {'@': 222}), 19: (1, {'@': 222}), 23: (1, {'@': 222}), 21: (1, {'@': 222}), 24: (1, {'@': 222}), 3: (1, {'@': 222}), 11: (1, {'@': 222}), 14: (1, {'@': 222}), 17: (1, {'@': 222}), 4: (1, {'@': 222}), 10: (1, {'@': 222}), 15: (1, {'@': 222}), 6: (1, {'@': 222}), 25: (1, {'@': 222}), 2: (1, {'@': 222}), 9: (1, {'@': 222}), 13: (1, {'@': 222}), 26: (1, {'@': 222}), 20: (1, {'@': 222}), 1: (1, {'@': 222}), 5: (1, {'@': 222}), 27: (1, {'@': 222}), 28: (1, {'@': 222}), 29: (1, {'@': 222}), 30: (1, {'@': 222}), 12: (1, {'@': 222}), 31: (1, {'@': 222}), 18: (1, {'@': 222}), 32: (1, {'@': 222}), 33: (1, {'@': 222}), 34: (1, {'@': 222}), 35: (1, {'@': 222})}, 347: {48: (1, {'@': 387}), 65: (1, {'@': 387}), 56: (1, {'@': 387}), 12: (1, {'@': 387}), 31: (1, {'@': 387}), 59: (1, {'@': 387}), 5: (1, {'@': 387}), 43: (1, {'@': 387}), 21: (1, {'@': 387}), 24: (1, {'@': 387}), 61: (1, {'@': 387}), 18: (1, {'@': 387}), 37: (1, {'@': 387})}, 348: {22: (1, {'@': 59}), 19: (1, {'@': 59}), 3: (1, {'@': 59}), 23: (1, {'@': 59}), 21: (1, {'@': 59}), 24: (1, {'@': 59}), 11: (1, {'@': 59}), 14: (1, {'@': 59}), 17: (1, {'@': 59}), 4: (1, {'@': 59}), 10: (1, {'@': 59}), 48: (1, {'@': 59}), 15: (1, {'@': 59}), 6: (1, {'@': 59}), 25: (1, {'@': 59}), 2: (1, {'@': 59}), 9: (1, {'@': 59}), 13: (1, {'@': 59}), 26: (1, {'@': 59}), 20: (1, {'@': 59}), 1: (1, {'@': 59}), 5: (1, {'@': 59}), 27: (1, {'@': 59}), 28: (1, {'@': 59}), 29: (1, {'@': 59}), 30: (1, {'@': 59}), 12: (1, {'@': 59}), 31: (1, {'@': 59}), 18: (1, {'@': 59}), 32: (1, {'@': 59}), 33: (1, {'@': 59}), 34: (1, {'@': 59}), 35: (1, {'@': 59}), 61: (1, {'@': 59}), 37: (1, {'@': 59}), 72: (1, {'@': 59})}, 349: {22: (1, {'@': 236}), 19: (1, {'@': 236}), 23: (1, {'@': 236}), 21: (1, {'@': 236}), 24: (1, {'@': 236}), 3: (1, {'@': 236}), 11: (1, {'@': 236}), 14: (1, {'@': 236}), 17: (1, {'@': 236}), 4: (1, {'@': 236}), 10: (1, {'@': 236}), 15: (1, {'@': 236}), 6: (1, {'@': 236}), 25: (1, {'@': 236}), 2: (1, {'@': 236}), 9: (1, {'@': 236}), 13: (1, {'@': 236}), 26: (1, {'@': 236}), 20: (1, {'@': 236}), 1: (1, {'@': 236}), 5: (1, {'@': 236}), 27: (1, {'@': 236}), 28: (1, {'@': 236}), 29: (1, {'@': 236}), 30: (1, {'@': 236}), 12: (1, {'@': 236}), 31: (1, {'@': 236}), 18: (1, {'@': 236}), 32: (1, {'@': 236}), 33: (1, {'@': 236}), 34: (1, {'@': 236}), 35: (1, {'@': 236})}, 350: {30: (0, 389)}, 351: {73: (0, 475), 31: (0, 348), 42: (0, 363), 75: (0, 355), 76: (0, 397), 74: (0, 54), 30: (1, {'@': 48})}, 352: {22: (1, {'@': 310}), 19: (1, {'@': 310}), 23: (1, {'@': 310}), 21: (1, {'@': 310}), 24: (1, {'@': 310}), 3: (1, {'@': 310}), 11: (1, {'@': 310}), 14: (1, {'@': 310}), 17: (1, {'@': 310}), 4: (1, {'@': 310}), 10: (1, {'@': 310}), 15: (1, {'@': 310}), 6: (1, {'@': 310}), 25: (1, {'@': 310}), 2: (1, {'@': 310}), 9: (1, {'@': 310}), 13: (1, {'@': 310}), 26: (1, {'@': 310}), 20: (1, {'@': 310}), 1: (1, {'@': 310}), 5: (1, {'@': 310}), 27: (1, {'@': 310}), 28: (1, {'@': 310}), 29: (1, {'@': 310}), 30: (1, {'@': 310}), 12: (1, {'@': 310}), 31: (1, {'@': 310}), 18: (1, {'@': 310}), 32: (1, {'@': 310}), 33: (1, {'@': 310}), 34: (1, {'@': 310}), 35: (1, {'@': 310})}, 353: {30: (0, 362)}, 354: {22: (1, {'@': 225}), 19: (1, {'@': 225}), 23: (1, {'@': 225}), 21: (1, {'@': 225}), 24: (1, {'@': 225}), 3: (1, {'@': 225}), 11: (1, {'@': 225}), 14: (1, {'@': 225}), 17: (1, {'@': 225}), 4: (1, {'@': 225}), 10: (1, {'@': 225}), 15: (1, {'@': 225}), 6: (1, {'@': 225}), 25: (1, {'@': 225}), 2: (1, {'@': 225}), 9: (1, {'@': 225}), 13: (1, {'@': 225}), 26: (1, {'@': 225}), 20: (1, {'@': 225}), 1: (1, {'@': 225}), 5: (1, {'@': 225}), 27: (1, {'@': 225}), 28: (1, {'@': 225}), 29: (1, {'@': 225}), 30: (1, {'@': 225}), 12: (1, {'@': 225}), 31: (1, {'@': 225}), 18: (1, {'@': 225}), 32: (1, {'@': 225}), 33: (1, {'@': 225}), 34: (1, {'@': 225}), 35: (1, {'@': 225})}, 355: {30: (1, {'@': 416}), 31: (1, {'@': 416}), 35: (1, {'@': 416}), 18: (1, {'@': 416}), 12: (1, {'@': 416}), 5: (1, {'@': 416})}, 356: {3: (1, {'@': 424}), 5: (1, {'@': 424}), 18: (1, {'@': 424}), 12: (1, {'@': 424}), 30: (1, {'@': 424}), 29: (1, {'@': 424}), 48: (1, {'@': 424}), 65: (1, {'@': 424}), 56: (1, {'@': 424}), 31: (1, {'@': 424}), 59: (1, {'@': 424}), 43: (1, {'@': 424}), 21: (1, {'@': 424}), 24: (1, {'@': 424}), 61: (1, {'@': 424}), 37: (1, {'@': 424}), 72: (1, {'@': 424}), 34: (1, {'@': 424}), 27: (1, {'@': 424}), 35: (1, {'@': 424}), 28: (1, {'@': 424}), 38: (1, {'@': 424})}, 357: {22: (1, {'@': 316}), 19: (1, {'@': 316}), 23: (1, {'@': 316}), 21: (1, {'@': 316}), 24: (1, {'@': 316}), 3: (1, {'@': 316}), 11: (1, {'@': 316}), 14: (1, {'@': 316}), 17: (1, {'@': 316}), 4: (1, {'@': 316}), 10: (1, {'@': 316}), 15: (1, {'@': 316}), 6: (1, {'@': 316}), 25: (1, {'@': 316}), 2: (1, {'@': 316}), 9: (1, {'@': 316}), 13: (1, {'@': 316}), 26: (1, {'@': 316}), 20: (1, {'@': 316}), 1: (1, {'@': 316}), 5: (1, {'@': 316}), 27: (1, {'@': 316}), 28: (1, {'@': 316}), 29: (1, {'@': 316}), 30: (1, {'@': 316}), 12: (1, {'@': 316}), 31: (1, {'@': 316}), 18: (1, {'@': 316}), 32: (1, {'@': 316}), 33: (1, {'@': 316}), 34: (1, {'@': 316}), 35: (1, {'@': 316})}, 358: {22: (1, {'@': 239}), 19: (1, {'@': 239}), 23: (1, {'@': 239}), 21: (1, {'@': 239}), 24: (1, {'@': 239}), 3: (1, {'@': 239}), 11: (1, {'@': 239}), 14: (1, {'@': 239}), 17: (1, {'@': 239}), 4: (1, {'@': 239}), 10: (1, {'@': 239}), 15: (1, {'@': 239}), 6: (1, {'@': 239}), 25: (1, {'@': 239}), 2: (1, {'@': 239}), 9: (1, {'@': 239}), 13: (1, {'@': 239}), 26: (1, {'@': 239}), 20: (1, {'@': 239}), 1: (1, {'@': 239}), 5: (1, {'@': 239}), 27: (1, {'@': 239}), 28: (1, {'@': 239}), 29: (1, {'@': 239}), 30: (1, {'@': 239}), 12: (1, {'@': 239}), 31: (1, {'@': 239}), 18: (1, {'@': 239}), 32: (1, {'@': 239}), 33: (1, {'@': 239}), 34: (1, {'@': 239}), 35: (1, {'@': 239})}, 359: {22: (1, {'@': 228}), 19: (1, {'@': 228}), 23: (1, {'@': 228}), 21: (1, {'@': 228}), 24: (1, {'@': 228}), 3: (1, {'@': 228}), 11: (1, {'@': 228}), 14: (1, {'@': 228}), 17: (1, {'@': 228}), 4: (1, {'@': 228}), 10: (1, {'@': 228}), 15: (1, {'@': 228}), 6: (1, {'@': 228}), 25: (1, {'@': 228}), 2: (1, {'@': 228}), 9: (1, {'@': 228}), 13: (1, {'@': 228}), 26: (1, {'@': 228}), 20: (1, {'@': 228}), 1: (1, {'@': 228}), 5: (1, {'@': 228}), 27: (1, {'@': 228}), 28: (1, {'@': 228}), 29: (1, {'@': 228}), 30: (1, {'@': 228}), 12: (1, {'@': 228}), 31: (1, {'@': 228}), 18: (1, {'@': 228}), 32: (1, {'@': 228}), 33: (1, {'@': 228}), 34: (1, {'@': 228}), 35: (1, {'@': 228})}, 360: {22: (1, {'@': 320}), 19: (1, {'@': 320}), 23: (1, {'@': 320}), 21: (1, {'@': 320}), 24: (1, {'@': 320}), 3: (1, {'@': 320}), 11: (1, {'@': 320}), 14: (1, {'@': 320}), 17: (1, {'@': 320}), 4: (1, {'@': 320}), 10: (1, {'@': 320}), 15: (1, {'@': 320}), 6: (1, {'@': 320}), 25: (1, {'@': 320}), 2: (1, {'@': 320}), 9: (1, {'@': 320}), 13: (1, {'@': 320}), 26: (1, {'@': 320}), 20: (1, {'@': 320}), 1: (1, {'@': 320}), 5: (1, {'@': 320}), 27: (1, {'@': 320}), 28: (1, {'@': 320}), 29: (1, {'@': 320}), 30: (1, {'@': 320}), 12: (1, {'@': 320}), 31: (1, {'@': 320}), 18: (1, {'@': 320}), 32: (1, {'@': 320}), 33: (1, {'@': 320}), 34: (1, {'@': 320}), 35: (1, {'@': 320})}, 361: {22: (1, {'@': 242}), 19: (1, {'@': 242}), 23: (1, {'@': 242}), 21: (1, {'@': 242}), 24: (1, {'@': 242}), 3: (1, {'@': 242}), 11: (1, {'@': 242}), 14: (1, {'@': 242}), 17: (1, {'@': 242}), 4: (1, {'@': 242}), 10: (1, {'@': 242}), 15: (1, {'@': 242}), 6: (1, {'@': 242}), 25: (1, {'@': 242}), 2: (1, {'@': 242}), 9: (1, {'@': 242}), 13: (1, {'@': 242}), 26: (1, {'@': 242}), 20: (1, {'@': 242}), 1: (1, {'@': 242}), 5: (1, {'@': 242}), 27: (1, {'@': 242}), 28: (1, {'@': 242}), 29: (1, {'@': 242}), 30: (1, {'@': 242}), 12: (1, {'@': 242}), 31: (1, {'@': 242}), 18: (1, {'@': 242}), 32: (1, {'@': 242}), 33: (1, {'@': 242}), 34: (1, {'@': 242}), 35: (1, {'@': 242})}, 362: {22: (1, {'@': 235}), 19: (1, {'@': 235}), 23: (1, {'@': 235}), 21: (1, {'@': 235}), 24: (1, {'@': 235}), 3: (1, {'@': 235}), 11: (1, {'@': 235}), 14: (1, {'@': 235}), 17: (1, {'@': 235}), 4: (1, {'@': 235}), 10: (1, {'@': 235}), 15: (1, {'@': 235}), 6: (1, {'@': 235}), 25: (1, {'@': 235}), 2: (1, {'@': 235}), 9: (1, {'@': 235}), 13: (1, {'@': 235}), 26: (1, {'@': 235}), 20: (1, {'@': 235}), 1: (1, {'@': 235}), 5: (1, {'@': 235}), 27: (1, {'@': 235}), 28: (1, {'@': 235}), 29: (1, {'@': 235}), 30: (1, {'@': 235}), 12: (1, {'@': 235}), 31: (1, {'@': 235}), 18: (1, {'@': 235}), 32: (1, {'@': 235}), 33: (1, {'@': 235}), 34: (1, {'@': 235}), 35: (1, {'@': 235})}, 363: {31: (0, 348), 61: (0, 411), 42: (0, 414), 25: (0, 407), 37: (0, 719), 80: (0, 84)}, 364: {35: (1, {'@': 45})}, 365: {30: (0, 172)}, 366: {22: (1, {'@': 251}), 19: (1, {'@': 251}), 23: (1, {'@': 251}), 21: (1, {'@': 251}), 24: (1, {'@': 251}), 3: (1, {'@': 251}), 11: (1, {'@': 251}), 14: (1, {'@': 251}), 17: (1, {'@': 251}), 4: (1, {'@': 251}), 10: (1, {'@': 251}), 15: (1, {'@': 251}), 6: (1, {'@': 251}), 25: (1, {'@': 251}), 2: (1, {'@': 251}), 9: (1, {'@': 251}), 13: (1, {'@': 251}), 26: (1, {'@': 251}), 20: (1, {'@': 251}), 1: (1, {'@': 251}), 5: (1, {'@': 251}), 27: (1, {'@': 251}), 28: (1, {'@': 251}), 29: (1, {'@': 251}), 30: (1, {'@': 251}), 12: (1, {'@': 251}), 31: (1, {'@': 251}), 18: (1, {'@': 251}), 32: (1, {'@': 251}), 33: (1, {'@': 251}), 34: (1, {'@': 251}), 35: (1, {'@': 251})}, 367: {22: (1, {'@': 249}), 19: (1, {'@': 249}), 23: (1, {'@': 249}), 21: (1, {'@': 249}), 24: (1, {'@': 249}), 3: (1, {'@': 249}), 11: (1, {'@': 249}), 14: (1, {'@': 249}), 17: (1, {'@': 249}), 4: (1, {'@': 249}), 10: (1, {'@': 249}), 15: (1, {'@': 249}), 6: (1, {'@': 249}), 25: (1, {'@': 249}), 2: (1, {'@': 249}), 9: (1, {'@': 249}), 13: (1, {'@': 249}), 26: (1, {'@': 249}), 20: (1, {'@': 249}), 1: (1, {'@': 249}), 5: (1, {'@': 249}), 27: (1, {'@': 249}), 28: (1, {'@': 249}), 29: (1, {'@': 249}), 30: (1, {'@': 249}), 12: (1, {'@': 249}), 31: (1, {'@': 249}), 18: (1, {'@': 249}), 32: (1, {'@': 249}), 33: (1, {'@': 249}), 34: (1, {'@': 249}), 35: (1, {'@': 249})}, 368: {22: (1, {'@': 321}), 19: (1, {'@': 321}), 23: (1, {'@': 321}), 21: (1, {'@': 321}), 24: (1, {'@': 321}), 3: (1, {'@': 321}), 11: (1, {'@': 321}), 14: (1, {'@': 321}), 17: (1, {'@': 321}), 4: (1, {'@': 321}), 10: (1, {'@': 321}), 15: (1, {'@': 321}), 6: (1, {'@': 321}), 25: (1, {'@': 321}), 2: (1, {'@': 321}), 9: (1, {'@': 321}), 13: (1, {'@': 321}), 26: (1, {'@': 321}), 20: (1, {'@': 321}), 1: (1, {'@': 321}), 5: (1, {'@': 321}), 27: (1, {'@': 321}), 28: (1, {'@': 321}), 29: (1, {'@': 321}), 30: (1, {'@': 321}), 12: (1, {'@': 321}), 31: (1, {'@': 321}), 18: (1, {'@': 321}), 32: (1, {'@': 321}), 33: (1, {'@': 321}), 34: (1, {'@': 321}), 35: (1, {'@': 321})}, 369: {22: (1, {'@': 250}), 19: (1, {'@': 250}), 23: (1, {'@': 250}), 21: (1, {'@': 250}), 24: (1, {'@': 250}), 3: (1, {'@': 250}), 11: (1, {'@': 250}), 14: (1, {'@': 250}), 17: (1, {'@': 250}), 4: (1, {'@': 250}), 10: (1, {'@': 250}), 15: (1, {'@': 250}), 6: (1, {'@': 250}), 25: (1, {'@': 250}), 2: (1, {'@': 250}), 9: (1, {'@': 250}), 13: (1, {'@': 250}), 26: (1, {'@': 250}), 20: (1, {'@': 250}), 1: (1, {'@': 250}), 5: (1, {'@': 250}), 27: (1, {'@': 250}), 28: (1, {'@': 250}), 29: (1, {'@': 250}), 30: (1, {'@': 250}), 12: (1, {'@': 250}), 31: (1, {'@': 250}), 18: (1, {'@': 250}), 32: (1, {'@': 250}), 33: (1, {'@': 250}), 34: (1, {'@': 250}), 35: (1, {'@': 250})}, 370: {48: (1, {'@': 341}), 65: (1, {'@': 341}), 56: (1, {'@': 341}), 12: (1, {'@': 341}), 31: (1, {'@': 341}), 59: (1, {'@': 341}), 5: (1, {'@': 341}), 43: (1, {'@': 341}), 21: (1, {'@': 341}), 24: (1, {'@': 341}), 61: (1, {'@': 341}), 18: (1, {'@': 341}), 37: (1, {'@': 341})}, 371: {3: (1, {'@': 425}), 5: (1, {'@': 425}), 18: (1, {'@': 425}), 12: (1, {'@': 425}), 30: (1, {'@': 425}), 29: (1, {'@': 425}), 48: (1, {'@': 425}), 65: (1, {'@': 425}), 56: (1, {'@': 425}), 31: (1, {'@': 425}), 59: (1, {'@': 425}), 43: (1, {'@': 425}), 21: (1, {'@': 425}), 24: (1, {'@': 425}), 61: (1, {'@': 425}), 37: (1, {'@': 425}), 72: (1, {'@': 425}), 34: (1, {'@': 425}), 27: (1, {'@': 425}), 35: (1, {'@': 425}), 28: (1, {'@': 425}), 38: (1, {'@': 425})}, 372: {22: (1, {'@': 323}), 19: (1, {'@': 323}), 23: (1, {'@': 323}), 21: (1, {'@': 323}), 24: (1, {'@': 323}), 3: (1, {'@': 323}), 11: (1, {'@': 323}), 14: (1, {'@': 323}), 17: (1, {'@': 323}), 4: (1, {'@': 323}), 10: (1, {'@': 323}), 15: (1, {'@': 323}), 6: (1, {'@': 323}), 25: (1, {'@': 323}), 2: (1, {'@': 323}), 9: (1, {'@': 323}), 13: (1, {'@': 323}), 26: (1, {'@': 323}), 20: (1, {'@': 323}), 1: (1, {'@': 323}), 5: (1, {'@': 323}), 27: (1, {'@': 323}), 28: (1, {'@': 323}), 29: (1, {'@': 323}), 30: (1, {'@': 323}), 12: (1, {'@': 323}), 31: (1, {'@': 323}), 18: (1, {'@': 323}), 32: (1, {'@': 323}), 33: (1, {'@': 323}), 34: (1, {'@': 323}), 35: (1, {'@': 323})}, 373: {30: (0, 367)}, 374: {48: (1, {'@': 337}), 65: (1, {'@': 337}), 56: (1, {'@': 337}), 12: (1, {'@': 337}), 31: (1, {'@': 337}), 59: (1, {'@': 337}), 5: (1, {'@': 337}), 43: (1, {'@': 337}), 21: (1, {'@': 337}), 24: (1, {'@': 337}), 61: (1, {'@': 337}), 18: (1, {'@': 337}), 37: (1, {'@': 337})}, 375: {30: (0, 517)}, 376: {22: (1, {'@': 326}), 19: (1, {'@': 326}), 23: (1, {'@': 326}), 21: (1, {'@': 326}), 24: (1, {'@': 326}), 3: (1, {'@': 326}), 11: (1, {'@': 326}), 14: (1, {'@': 326}), 17: (1, {'@': 326}), 4: (1, {'@': 326}), 10: (1, {'@': 326}), 15: (1, {'@': 326}), 6: (1, {'@': 326}), 25: (1, {'@': 326}), 2: (1, {'@': 326}), 9: (1, {'@': 326}), 13: (1, {'@': 326}), 26: (1, {'@': 326}), 20: (1, {'@': 326}), 1: (1, {'@': 326}), 5: (1, {'@': 326}), 27: (1, {'@': 326}), 28: (1, {'@': 326}), 29: (1, {'@': 326}), 30: (1, {'@': 326}), 12: (1, {'@': 326}), 31: (1, {'@': 326}), 18: (1, {'@': 326}), 32: (1, {'@': 326}), 33: (1, {'@': 326}), 34: (1, {'@': 326}), 35: (1, {'@': 326})}, 377: {22: (1, {'@': 253}), 19: (1, {'@': 253}), 23: (1, {'@': 253}), 21: (1, {'@': 253}), 24: (1, {'@': 253}), 3: (1, {'@': 253}), 11: (1, {'@': 253}), 14: (1, {'@': 253}), 17: (1, {'@': 253}), 4: (1, {'@': 253}), 10: (1, {'@': 253}), 15: (1, {'@': 253}), 6: (1, {'@': 253}), 25: (1, {'@': 253}), 2: (1, {'@': 253}), 9: (1, {'@': 253}), 13: (1, {'@': 253}), 26: (1, {'@': 253}), 20: (1, {'@': 253}), 1: (1, {'@': 253}), 5: (1, {'@': 253}), 27: (1, {'@': 253}), 28: (1, {'@': 253}), 29: (1, {'@': 253}), 30: (1, {'@': 253}), 12: (1, {'@': 253}), 31: (1, {'@': 253}), 18: (1, {'@': 253}), 32: (1, {'@': 253}), 33: (1, {'@': 253}), 34: (1, {'@': 253}), 35: (1, {'@': 253})}, 378: {48: (1, {'@': 335}), 65: (1, {'@': 335}), 56: (1, {'@': 335}), 12: (1, {'@': 335}), 31: (1, {'@': 335}), 59: (1, {'@': 335}), 5: (1, {'@': 335}), 43: (1, {'@': 335}), 21: (1, {'@': 335}), 24: (1, {'@': 335}), 61: (1, {'@': 335}), 18: (1, {'@': 335}), 37: (1, {'@': 335})}, 379: {3: (1, {'@': 427}), 5: (1, {'@': 427}), 18: (1, {'@': 427}), 12: (1, {'@': 427}), 30: (1, {'@': 427}), 29: (1, {'@': 427}), 48: (1, {'@': 427}), 65: (1, {'@': 427}), 56: (1, {'@': 427}), 31: (1, {'@': 427}), 59: (1, {'@': 427}), 43: (1, {'@': 427}), 21: (1, {'@': 427}), 24: (1, {'@': 427}), 61: (1, {'@': 427}), 37: (1, {'@': 427}), 72: (1, {'@': 427}), 34: (1, {'@': 427}), 27: (1, {'@': 427}), 35: (1, {'@': 427}), 28: (1, {'@': 427}), 38: (1, {'@': 427})}, 380: {3: (1, {'@': 428}), 5: (1, {'@': 428}), 18: (1, {'@': 428}), 12: (1, {'@': 428}), 30: (1, {'@': 428}), 29: (1, {'@': 428}), 48: (1, {'@': 428}), 65: (1, {'@': 428}), 56: (1, {'@': 428}), 31: (1, {'@': 428}), 59: (1, {'@': 428}), 43: (1, {'@': 428}), 21: (1, {'@': 428}), 24: (1, {'@': 428}), 61: (1, {'@': 428}), 37: (1, {'@': 428}), 72: (1, {'@': 428}), 34: (1, {'@': 428}), 27: (1, {'@': 428}), 35: (1, {'@': 428}), 28: (1, {'@': 428}), 38: (1, {'@': 428})}, 381: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 176), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 382: {22: (1, {'@': 256}), 19: (1, {'@': 256}), 23: (1, {'@': 256}), 21: (1, {'@': 256}), 24: (1, {'@': 256}), 3: (1, {'@': 256}), 11: (1, {'@': 256}), 14: (1, {'@': 256}), 17: (1, {'@': 256}), 4: (1, {'@': 256}), 10: (1, {'@': 256}), 15: (1, {'@': 256}), 6: (1, {'@': 256}), 25: (1, {'@': 256}), 2: (1, {'@': 256}), 9: (1, {'@': 256}), 13: (1, {'@': 256}), 26: (1, {'@': 256}), 20: (1, {'@': 256}), 1: (1, {'@': 256}), 5: (1, {'@': 256}), 27: (1, {'@': 256}), 28: (1, {'@': 256}), 29: (1, {'@': 256}), 30: (1, {'@': 256}), 12: (1, {'@': 256}), 31: (1, {'@': 256}), 18: (1, {'@': 256}), 32: (1, {'@': 256}), 33: (1, {'@': 256}), 34: (1, {'@': 256}), 35: (1, {'@': 256})}, 383: {0: (0, 452), 7: (0, 391), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 334}), 65: (1, {'@': 334}), 56: (1, {'@': 334}), 31: (1, {'@': 334}), 59: (1, {'@': 334}), 43: (1, {'@': 334}), 21: (1, {'@': 334}), 24: (1, {'@': 334}), 61: (1, {'@': 334}), 37: (1, {'@': 334})}, 384: {0: (0, 452), 7: (0, 15), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 348}), 65: (1, {'@': 348}), 56: (1, {'@': 348}), 31: (1, {'@': 348}), 59: (1, {'@': 348}), 43: (1, {'@': 348}), 21: (1, {'@': 348}), 24: (1, {'@': 348}), 61: (1, {'@': 348}), 37: (1, {'@': 348})}, 385: {22: (1, {'@': 263}), 19: (1, {'@': 263}), 23: (1, {'@': 263}), 21: (1, {'@': 263}), 24: (1, {'@': 263}), 3: (1, {'@': 263}), 11: (1, {'@': 263}), 14: (1, {'@': 263}), 17: (1, {'@': 263}), 4: (1, {'@': 263}), 10: (1, {'@': 263}), 15: (1, {'@': 263}), 6: (1, {'@': 263}), 25: (1, {'@': 263}), 2: (1, {'@': 263}), 9: (1, {'@': 263}), 13: (1, {'@': 263}), 26: (1, {'@': 263}), 20: (1, {'@': 263}), 1: (1, {'@': 263}), 5: (1, {'@': 263}), 27: (1, {'@': 263}), 28: (1, {'@': 263}), 29: (1, {'@': 263}), 30: (1, {'@': 263}), 12: (1, {'@': 263}), 31: (1, {'@': 263}), 18: (1, {'@': 263}), 32: (1, {'@': 263}), 33: (1, {'@': 263}), 34: (1, {'@': 263}), 35: (1, {'@': 263})}, 386: {30: (1, {'@': 417}), 31: (1, {'@': 417}), 35: (1, {'@': 417}), 18: (1, {'@': 417}), 12: (1, {'@': 417}), 5: (1, {'@': 417})}, 387: {3: (0, 213)}, 388: {22: (1, {'@': 277}), 19: (1, {'@': 277}), 23: (1, {'@': 277}), 21: (1, {'@': 277}), 24: (1, {'@': 277}), 3: (1, {'@': 277}), 11: (1, {'@': 277}), 14: (1, {'@': 277}), 17: (1, {'@': 277}), 4: (1, {'@': 277}), 10: (1, {'@': 277}), 15: (1, {'@': 277}), 6: (1, {'@': 277}), 25: (1, {'@': 277}), 2: (1, {'@': 277}), 9: (1, {'@': 277}), 13: (1, {'@': 277}), 26: (1, {'@': 277}), 20: (1, {'@': 277}), 1: (1, {'@': 277}), 5: (1, {'@': 277}), 27: (1, {'@': 277}), 28: (1, {'@': 277}), 29: (1, {'@': 277}), 30: (1, {'@': 277}), 12: (1, {'@': 277}), 31: (1, {'@': 277}), 18: (1, {'@': 277}), 32: (1, {'@': 277}), 33: (1, {'@': 277}), 34: (1, {'@': 277}), 35: (1, {'@': 277})}, 389: {22: (1, {'@': 221}), 19: (1, {'@': 221}), 23: (1, {'@': 221}), 21: (1, {'@': 221}), 24: (1, {'@': 221}), 3: (1, {'@': 221}), 11: (1, {'@': 221}), 14: (1, {'@': 221}), 17: (1, {'@': 221}), 4: (1, {'@': 221}), 10: (1, {'@': 221}), 15: (1, {'@': 221}), 6: (1, {'@': 221}), 25: (1, {'@': 221}), 2: (1, {'@': 221}), 9: (1, {'@': 221}), 13: (1, {'@': 221}), 26: (1, {'@': 221}), 20: (1, {'@': 221}), 1: (1, {'@': 221}), 5: (1, {'@': 221}), 27: (1, {'@': 221}), 28: (1, {'@': 221}), 29: (1, {'@': 221}), 30: (1, {'@': 221}), 12: (1, {'@': 221}), 31: (1, {'@': 221}), 18: (1, {'@': 221}), 32: (1, {'@': 221}), 33: (1, {'@': 221}), 34: (1, {'@': 221}), 35: (1, {'@': 221})}, 390: {48: (1, {'@': 343}), 65: (1, {'@': 343}), 56: (1, {'@': 343}), 12: (1, {'@': 343}), 31: (1, {'@': 343}), 59: (1, {'@': 343}), 5: (1, {'@': 343}), 43: (1, {'@': 343}), 21: (1, {'@': 343}), 24: (1, {'@': 343}), 61: (1, {'@': 343}), 18: (1, {'@': 343}), 37: (1, {'@': 343})}, 391: {48: (1, {'@': 333}), 65: (1, {'@': 333}), 56: (1, {'@': 333}), 12: (1, {'@': 333}), 31: (1, {'@': 333}), 59: (1, {'@': 333}), 5: (1, {'@': 333}), 43: (1, {'@': 333}), 21: (1, {'@': 333}), 24: (1, {'@': 333}), 61: (1, {'@': 333}), 18: (1, {'@': 333}), 37: (1, {'@': 333})}, 392: {30: (1, {'@': 418}), 31: (1, {'@': 418}), 35: (1, {'@': 418}), 18: (1, {'@': 418}), 12: (1, {'@': 418}), 5: (1, {'@': 418})}, 393: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 384), 4: (0, 634), 7: (0, 190), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 394: {0: (0, 452), 7: (0, 117), 12: (0, 405), 18: (0, 356), 5: (0, 371), 48: (1, {'@': 392}), 65: (1, {'@': 392}), 56: (1, {'@': 392}), 31: (1, {'@': 392}), 59: (1, {'@': 392}), 43: (1, {'@': 392}), 21: (1, {'@': 392}), 24: (1, {'@': 392}), 61: (1, {'@': 392}), 37: (1, {'@': 392})}, 395: {0: (0, 452), 7: (0, 370), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 342}), 65: (1, {'@': 342}), 56: (1, {'@': 342}), 31: (1, {'@': 342}), 59: (1, {'@': 342}), 43: (1, {'@': 342}), 21: (1, {'@': 342}), 24: (1, {'@': 342}), 61: (1, {'@': 342}), 37: (1, {'@': 342})}, 396: {0: (0, 452), 7: (0, 739), 18: (0, 356), 12: (0, 405), 5: (0, 371), 35: (1, {'@': 44})}, 397: {30: (1, {'@': 415}), 31: (1, {'@': 415}), 35: (1, {'@': 415}), 18: (1, {'@': 415}), 12: (1, {'@': 415}), 5: (1, {'@': 415})}, 398: {22: (1, {'@': 259}), 19: (1, {'@': 259}), 23: (1, {'@': 259}), 21: (1, {'@': 259}), 24: (1, {'@': 259}), 3: (1, {'@': 259}), 11: (1, {'@': 259}), 14: (1, {'@': 259}), 17: (1, {'@': 259}), 4: (1, {'@': 259}), 10: (1, {'@': 259}), 15: (1, {'@': 259}), 6: (1, {'@': 259}), 25: (1, {'@': 259}), 2: (1, {'@': 259}), 9: (1, {'@': 259}), 13: (1, {'@': 259}), 26: (1, {'@': 259}), 20: (1, {'@': 259}), 1: (1, {'@': 259}), 5: (1, {'@': 259}), 27: (1, {'@': 259}), 28: (1, {'@': 259}), 29: (1, {'@': 259}), 30: (1, {'@': 259}), 12: (1, {'@': 259}), 31: (1, {'@': 259}), 18: (1, {'@': 259}), 32: (1, {'@': 259}), 33: (1, {'@': 259}), 34: (1, {'@': 259}), 35: (1, {'@': 259})}, 399: {48: (1, {'@': 339}), 65: (1, {'@': 339}), 56: (1, {'@': 339}), 12: (1, {'@': 339}), 31: (1, {'@': 339}), 59: (1, {'@': 339}), 5: (1, {'@': 339}), 43: (1, {'@': 339}), 21: (1, {'@': 339}), 24: (1, {'@': 339}), 61: (1, {'@': 339}), 18: (1, {'@': 339}), 37: (1, {'@': 339})}, 400: {3: (1, {'@': 426}), 5: (1, {'@': 426}), 18: (1, {'@': 426}), 12: (1, {'@': 426}), 30: (1, {'@': 426}), 29: (1, {'@': 426}), 48: (1, {'@': 426}), 65: (1, {'@': 426}), 56: (1, {'@': 426}), 31: (1, {'@': 426}), 59: (1, {'@': 426}), 43: (1, {'@': 426}), 21: (1, {'@': 426}), 24: (1, {'@': 426}), 61: (1, {'@': 426}), 37: (1, {'@': 426}), 72: (1, {'@': 426}), 34: (1, {'@': 426}), 27: (1, {'@': 426}), 35: (1, {'@': 426}), 28: (1, {'@': 426}), 38: (1, {'@': 426})}, 401: {0: (0, 452), 7: (0, 347), 12: (0, 405), 18: (0, 356), 5: (0, 371), 48: (1, {'@': 388}), 65: (1, {'@': 388}), 56: (1, {'@': 388}), 31: (1, {'@': 388}), 59: (1, {'@': 388}), 43: (1, {'@': 388}), 21: (1, {'@': 388}), 24: (1, {'@': 388}), 61: (1, {'@': 388}), 37: (1, {'@': 388})}, 402: {0: (0, 452), 7: (0, 374), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 338}), 65: (1, {'@': 338}), 56: (1, {'@': 338}), 31: (1, {'@': 338}), 59: (1, {'@': 338}), 43: (1, {'@': 338}), 21: (1, {'@': 338}), 24: (1, {'@': 338}), 61: (1, {'@': 338}), 37: (1, {'@': 338})}, 403: {48: (1, {'@': 369}), 65: (1, {'@': 369}), 56: (1, {'@': 369}), 12: (1, {'@': 369}), 31: (1, {'@': 369}), 59: (1, {'@': 369}), 5: (1, {'@': 369}), 43: (1, {'@': 369}), 21: (1, {'@': 369}), 24: (1, {'@': 369}), 61: (1, {'@': 369}), 18: (1, {'@': 369}), 37: (1, {'@': 369})}, 404: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 378), 5: (0, 371), 48: (1, {'@': 336}), 65: (1, {'@': 336}), 56: (1, {'@': 336}), 31: (1, {'@': 336}), 59: (1, {'@': 336}), 43: (1, {'@': 336}), 21: (1, {'@': 336}), 24: (1, {'@': 336}), 61: (1, {'@': 336}), 37: (1, {'@': 336})}, 405: {3: (1, {'@': 423}), 5: (1, {'@': 423}), 18: (1, {'@': 423}), 12: (1, {'@': 423}), 30: (1, {'@': 423}), 29: (1, {'@': 423}), 48: (1, {'@': 423}), 65: (1, {'@': 423}), 56: (1, {'@': 423}), 31: (1, {'@': 423}), 59: (1, {'@': 423}), 43: (1, {'@': 423}), 21: (1, {'@': 423}), 24: (1, {'@': 423}), 61: (1, {'@': 423}), 37: (1, {'@': 423}), 72: (1, {'@': 423}), 34: (1, {'@': 423}), 27: (1, {'@': 423}), 35: (1, {'@': 423}), 28: (1, {'@': 423}), 38: (1, {'@': 423})}, 406: {0: (0, 452), 18: (0, 356), 7: (0, 222), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 362}), 65: (1, {'@': 362}), 56: (1, {'@': 362}), 31: (1, {'@': 362}), 59: (1, {'@': 362}), 43: (1, {'@': 362}), 21: (1, {'@': 362}), 24: (1, {'@': 362}), 61: (1, {'@': 362}), 37: (1, {'@': 362})}, 407: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 50: (0, 721), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 408: {48: (1, {'@': 405}), 65: (1, {'@': 405}), 56: (1, {'@': 405}), 12: (1, {'@': 405}), 31: (1, {'@': 405}), 59: (1, {'@': 405}), 5: (1, {'@': 405}), 43: (1, {'@': 405}), 21: (1, {'@': 405}), 24: (1, {'@': 405}), 61: (1, {'@': 405}), 18: (1, {'@': 405}), 37: (1, {'@': 405})}, 409: {30: (0, 692)}, 410: {3: (0, 383)}, 411: {61: (1, {'@': 420}), 31: (1, {'@': 420}), 37: (1, {'@': 420})}, 412: {48: (1, {'@': 381}), 65: (1, {'@': 381}), 56: (1, {'@': 381}), 12: (1, {'@': 381}), 31: (1, {'@': 381}), 59: (1, {'@': 381}), 5: (1, {'@': 381}), 43: (1, {'@': 381}), 21: (1, {'@': 381}), 24: (1, {'@': 381}), 61: (1, {'@': 381}), 18: (1, {'@': 381}), 37: (1, {'@': 381})}, 413: {0: (0, 452), 7: (0, 228), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 360}), 65: (1, {'@': 360}), 56: (1, {'@': 360}), 31: (1, {'@': 360}), 59: (1, {'@': 360}), 43: (1, {'@': 360}), 21: (1, {'@': 360}), 24: (1, {'@': 360}), 61: (1, {'@': 360}), 37: (1, {'@': 360})}, 414: {61: (1, {'@': 419}), 31: (1, {'@': 419}), 37: (1, {'@': 419})}, 415: {48: (1, {'@': 377}), 65: (1, {'@': 377}), 56: (1, {'@': 377}), 12: (1, {'@': 377}), 31: (1, {'@': 377}), 59: (1, {'@': 377}), 5: (1, {'@': 377}), 43: (1, {'@': 377}), 21: (1, {'@': 377}), 24: (1, {'@': 377}), 61: (1, {'@': 377}), 18: (1, {'@': 377}), 37: (1, {'@': 377})}, 416: {3: (0, 232)}, 417: {48: (1, {'@': 375}), 65: (1, {'@': 375}), 56: (1, {'@': 375}), 12: (1, {'@': 375}), 31: (1, {'@': 375}), 59: (1, {'@': 375}), 5: (1, {'@': 375}), 43: (1, {'@': 375}), 21: (1, {'@': 375}), 24: (1, {'@': 375}), 61: (1, {'@': 375}), 18: (1, {'@': 375}), 37: (1, {'@': 375})}, 418: {0: (0, 452), 7: (0, 208), 68: (0, 214), 29: (0, 327), 30: (0, 221), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 419: {0: (0, 452), 7: (0, 340), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 374}), 65: (1, {'@': 374}), 56: (1, {'@': 374}), 31: (1, {'@': 374}), 59: (1, {'@': 374}), 43: (1, {'@': 374}), 21: (1, {'@': 374}), 24: (1, {'@': 374}), 61: (1, {'@': 374}), 37: (1, {'@': 374})}, 420: {0: (0, 452), 72: (0, 433), 7: (0, 445), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 421: {22: (1, {'@': 324}), 19: (1, {'@': 324}), 23: (1, {'@': 324}), 21: (1, {'@': 324}), 24: (1, {'@': 324}), 3: (1, {'@': 324}), 11: (1, {'@': 324}), 14: (1, {'@': 324}), 17: (1, {'@': 324}), 4: (1, {'@': 324}), 10: (1, {'@': 324}), 15: (1, {'@': 324}), 6: (1, {'@': 324}), 25: (1, {'@': 324}), 2: (1, {'@': 324}), 9: (1, {'@': 324}), 13: (1, {'@': 324}), 26: (1, {'@': 324}), 20: (1, {'@': 324}), 1: (1, {'@': 324}), 5: (1, {'@': 324}), 27: (1, {'@': 324}), 28: (1, {'@': 324}), 29: (1, {'@': 324}), 30: (1, {'@': 324}), 12: (1, {'@': 324}), 31: (1, {'@': 324}), 18: (1, {'@': 324}), 32: (1, {'@': 324}), 33: (1, {'@': 324}), 34: (1, {'@': 324}), 35: (1, {'@': 324})}, 422: {0: (0, 452), 7: (0, 565), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 421)}, 423: {22: (1, {'@': 330}), 19: (1, {'@': 330}), 23: (1, {'@': 330}), 21: (1, {'@': 330}), 24: (1, {'@': 330}), 3: (1, {'@': 330}), 11: (1, {'@': 330}), 14: (1, {'@': 330}), 17: (1, {'@': 330}), 4: (1, {'@': 330}), 10: (1, {'@': 330}), 15: (1, {'@': 330}), 6: (1, {'@': 330}), 25: (1, {'@': 330}), 2: (1, {'@': 330}), 9: (1, {'@': 330}), 13: (1, {'@': 330}), 26: (1, {'@': 330}), 20: (1, {'@': 330}), 1: (1, {'@': 330}), 5: (1, {'@': 330}), 27: (1, {'@': 330}), 28: (1, {'@': 330}), 29: (1, {'@': 330}), 30: (1, {'@': 330}), 12: (1, {'@': 330}), 31: (1, {'@': 330}), 18: (1, {'@': 330}), 32: (1, {'@': 330}), 33: (1, {'@': 330}), 34: (1, {'@': 330}), 35: (1, {'@': 330})}, 424: {30: (1, {'@': 49}), 31: (1, {'@': 49}), 35: (1, {'@': 49}), 18: (1, {'@': 49}), 12: (1, {'@': 49}), 5: (1, {'@': 49})}, 425: {22: (1, {'@': 327}), 19: (1, {'@': 327}), 23: (1, {'@': 327}), 21: (1, {'@': 327}), 24: (1, {'@': 327}), 3: (1, {'@': 327}), 11: (1, {'@': 327}), 14: (1, {'@': 327}), 17: (1, {'@': 327}), 4: (1, {'@': 327}), 10: (1, {'@': 327}), 15: (1, {'@': 327}), 6: (1, {'@': 327}), 25: (1, {'@': 327}), 2: (1, {'@': 327}), 9: (1, {'@': 327}), 13: (1, {'@': 327}), 26: (1, {'@': 327}), 20: (1, {'@': 327}), 1: (1, {'@': 327}), 5: (1, {'@': 327}), 27: (1, {'@': 327}), 28: (1, {'@': 327}), 29: (1, {'@': 327}), 30: (1, {'@': 327}), 12: (1, {'@': 327}), 31: (1, {'@': 327}), 18: (1, {'@': 327}), 32: (1, {'@': 327}), 33: (1, {'@': 327}), 34: (1, {'@': 327}), 35: (1, {'@': 327})}, 426: {30: (0, 376)}, 427: {7: (0, 105), 0: (0, 452), 1: (0, 654), 2: (0, 581), 68: (0, 571), 32: (0, 493), 29: (0, 327), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 30: (0, 575), 20: (0, 48)}, 428: {22: (1, {'@': 328}), 19: (1, {'@': 328}), 23: (1, {'@': 328}), 21: (1, {'@': 328}), 24: (1, {'@': 328}), 3: (1, {'@': 328}), 11: (1, {'@': 328}), 14: (1, {'@': 328}), 17: (1, {'@': 328}), 4: (1, {'@': 328}), 10: (1, {'@': 328}), 15: (1, {'@': 328}), 6: (1, {'@': 328}), 25: (1, {'@': 328}), 2: (1, {'@': 328}), 9: (1, {'@': 328}), 13: (1, {'@': 328}), 26: (1, {'@': 328}), 20: (1, {'@': 328}), 1: (1, {'@': 328}), 5: (1, {'@': 328}), 27: (1, {'@': 328}), 28: (1, {'@': 328}), 29: (1, {'@': 328}), 30: (1, {'@': 328}), 12: (1, {'@': 328}), 31: (1, {'@': 328}), 18: (1, {'@': 328}), 32: (1, {'@': 328}), 33: (1, {'@': 328}), 34: (1, {'@': 328}), 35: (1, {'@': 328})}, 429: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 138), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 7: (0, 146), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 430: {0: (0, 452), 30: (0, 33), 18: (0, 356), 12: (0, 405), 7: (0, 38), 5: (0, 371)}, 431: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 7: (0, 19), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 491), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 432: {0: (0, 452), 7: (0, 196), 29: (0, 327), 18: (0, 356), 30: (0, 398), 12: (0, 405), 5: (0, 371), 68: (0, 21)}, 433: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 7: (0, 381), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 393), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 434: {22: (1, {'@': 205}), 19: (1, {'@': 205}), 23: (1, {'@': 205}), 21: (1, {'@': 205}), 24: (1, {'@': 205}), 3: (1, {'@': 205}), 11: (1, {'@': 205}), 14: (1, {'@': 205}), 17: (1, {'@': 205}), 4: (1, {'@': 205}), 10: (1, {'@': 205}), 15: (1, {'@': 205}), 6: (1, {'@': 205}), 25: (1, {'@': 205}), 2: (1, {'@': 205}), 9: (1, {'@': 205}), 13: (1, {'@': 205}), 26: (1, {'@': 205}), 20: (1, {'@': 205}), 1: (1, {'@': 205}), 5: (1, {'@': 205}), 27: (1, {'@': 205}), 28: (1, {'@': 205}), 29: (1, {'@': 205}), 30: (1, {'@': 205}), 12: (1, {'@': 205}), 31: (1, {'@': 205}), 18: (1, {'@': 205}), 32: (1, {'@': 205}), 33: (1, {'@': 205}), 34: (1, {'@': 205}), 35: (1, {'@': 205})}, 435: {22: (1, {'@': 241}), 19: (1, {'@': 241}), 23: (1, {'@': 241}), 21: (1, {'@': 241}), 24: (1, {'@': 241}), 3: (1, {'@': 241}), 11: (1, {'@': 241}), 14: (1, {'@': 241}), 17: (1, {'@': 241}), 4: (1, {'@': 241}), 10: (1, {'@': 241}), 15: (1, {'@': 241}), 6: (1, {'@': 241}), 25: (1, {'@': 241}), 2: (1, {'@': 241}), 9: (1, {'@': 241}), 13: (1, {'@': 241}), 26: (1, {'@': 241}), 20: (1, {'@': 241}), 1: (1, {'@': 241}), 5: (1, {'@': 241}), 27: (1, {'@': 241}), 28: (1, {'@': 241}), 29: (1, {'@': 241}), 30: (1, {'@': 241}), 12: (1, {'@': 241}), 31: (1, {'@': 241}), 18: (1, {'@': 241}), 32: (1, {'@': 241}), 33: (1, {'@': 241}), 34: (1, {'@': 241}), 35: (1, {'@': 241})}, 436: {37: (0, 709), 24: (0, 711), 50: (0, 429), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 437: {22: (1, {'@': 117}), 19: (1, {'@': 117}), 23: (1, {'@': 117}), 21: (1, {'@': 117}), 24: (1, {'@': 117}), 3: (1, {'@': 117}), 11: (1, {'@': 117}), 14: (1, {'@': 117}), 17: (1, {'@': 117}), 4: (1, {'@': 117}), 10: (1, {'@': 117}), 15: (1, {'@': 117}), 6: (1, {'@': 117}), 25: (1, {'@': 117}), 2: (1, {'@': 117}), 9: (1, {'@': 117}), 13: (1, {'@': 117}), 26: (1, {'@': 117}), 20: (1, {'@': 117}), 1: (1, {'@': 117}), 5: (1, {'@': 117}), 27: (1, {'@': 117}), 28: (1, {'@': 117}), 29: (1, {'@': 117}), 30: (1, {'@': 117}), 12: (1, {'@': 117}), 31: (1, {'@': 117}), 18: (1, {'@': 117}), 32: (1, {'@': 117}), 33: (1, {'@': 117}), 34: (1, {'@': 117}), 35: (1, {'@': 117})}, 438: {48: (1, {'@': 383}), 65: (1, {'@': 383}), 56: (1, {'@': 383}), 12: (1, {'@': 383}), 31: (1, {'@': 383}), 59: (1, {'@': 383}), 5: (1, {'@': 383}), 43: (1, {'@': 383}), 21: (1, {'@': 383}), 24: (1, {'@': 383}), 61: (1, {'@': 383}), 18: (1, {'@': 383}), 37: (1, {'@': 383})}, 439: {0: (0, 452), 18: (0, 356), 7: (0, 364), 12: (0, 405), 5: (0, 371), 35: (1, {'@': 46})}, 440: {30: (0, 135), 0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 142), 5: (0, 371)}, 441: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 50: (0, 200), 43: (0, 730), 44: (0, 731), 21: (0, 734), 7: (0, 616), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 34: (0, 623), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 442: {22: (1, {'@': 302}), 19: (1, {'@': 302}), 23: (1, {'@': 302}), 21: (1, {'@': 302}), 24: (1, {'@': 302}), 3: (1, {'@': 302}), 11: (1, {'@': 302}), 14: (1, {'@': 302}), 17: (1, {'@': 302}), 4: (1, {'@': 302}), 10: (1, {'@': 302}), 15: (1, {'@': 302}), 6: (1, {'@': 302}), 25: (1, {'@': 302}), 2: (1, {'@': 302}), 9: (1, {'@': 302}), 13: (1, {'@': 302}), 26: (1, {'@': 302}), 20: (1, {'@': 302}), 1: (1, {'@': 302}), 5: (1, {'@': 302}), 27: (1, {'@': 302}), 28: (1, {'@': 302}), 29: (1, {'@': 302}), 30: (1, {'@': 302}), 12: (1, {'@': 302}), 31: (1, {'@': 302}), 18: (1, {'@': 302}), 32: (1, {'@': 302}), 33: (1, {'@': 302}), 34: (1, {'@': 302}), 35: (1, {'@': 302})}, 443: {32: (0, 551), 0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 432), 29: (0, 327), 30: (0, 201), 68: (0, 206), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 444: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 578), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 445: {72: (0, 462)}, 446: {73: (0, 475), 31: (0, 348), 74: (0, 396), 42: (0, 363), 75: (0, 355), 76: (0, 397), 35: (1, {'@': 48}), 5: (1, {'@': 48}), 18: (1, {'@': 48}), 12: (1, {'@': 48})}, 447: {22: (1, {'@': 201}), 19: (1, {'@': 201}), 23: (1, {'@': 201}), 21: (1, {'@': 201}), 24: (1, {'@': 201}), 3: (1, {'@': 201}), 11: (1, {'@': 201}), 14: (1, {'@': 201}), 17: (1, {'@': 201}), 4: (1, {'@': 201}), 10: (1, {'@': 201}), 15: (1, {'@': 201}), 6: (1, {'@': 201}), 25: (1, {'@': 201}), 2: (1, {'@': 201}), 9: (1, {'@': 201}), 13: (1, {'@': 201}), 26: (1, {'@': 201}), 20: (1, {'@': 201}), 1: (1, {'@': 201}), 5: (1, {'@': 201}), 27: (1, {'@': 201}), 28: (1, {'@': 201}), 29: (1, {'@': 201}), 30: (1, {'@': 201}), 12: (1, {'@': 201}), 31: (1, {'@': 201}), 18: (1, {'@': 201}), 32: (1, {'@': 201}), 33: (1, {'@': 201}), 34: (1, {'@': 201}), 35: (1, {'@': 201})}, 448: {22: (1, {'@': 218}), 19: (1, {'@': 218}), 23: (1, {'@': 218}), 21: (1, {'@': 218}), 24: (1, {'@': 218}), 3: (1, {'@': 218}), 11: (1, {'@': 218}), 14: (1, {'@': 218}), 17: (1, {'@': 218}), 4: (1, {'@': 218}), 10: (1, {'@': 218}), 15: (1, {'@': 218}), 6: (1, {'@': 218}), 25: (1, {'@': 218}), 2: (1, {'@': 218}), 9: (1, {'@': 218}), 13: (1, {'@': 218}), 26: (1, {'@': 218}), 20: (1, {'@': 218}), 1: (1, {'@': 218}), 5: (1, {'@': 218}), 27: (1, {'@': 218}), 28: (1, {'@': 218}), 29: (1, {'@': 218}), 30: (1, {'@': 218}), 12: (1, {'@': 218}), 31: (1, {'@': 218}), 18: (1, {'@': 218}), 32: (1, {'@': 218}), 33: (1, {'@': 218}), 34: (1, {'@': 218}), 35: (1, {'@': 218})}, 449: {22: (1, {'@': 188}), 5: (1, {'@': 188}), 21: (1, {'@': 188}), 3: (1, {'@': 188}), 24: (1, {'@': 188}), 27: (1, {'@': 188}), 11: (1, {'@': 188}), 17: (1, {'@': 188}), 29: (1, {'@': 188}), 30: (1, {'@': 188}), 28: (1, {'@': 188}), 6: (1, {'@': 188}), 25: (1, {'@': 188}), 12: (1, {'@': 188}), 31: (1, {'@': 188}), 13: (1, {'@': 188}), 18: (1, {'@': 188}), 32: (1, {'@': 188}), 33: (1, {'@': 188}), 34: (1, {'@': 188}), 19: (1, {'@': 188}), 23: (1, {'@': 188}), 14: (1, {'@': 188}), 4: (1, {'@': 188}), 10: (1, {'@': 188}), 15: (1, {'@': 188}), 2: (1, {'@': 188}), 9: (1, {'@': 188}), 26: (1, {'@': 188}), 35: (1, {'@': 188}), 20: (1, {'@': 188}), 1: (1, {'@': 188})}, 450: {22: (1, {'@': 183}), 5: (1, {'@': 183}), 21: (1, {'@': 183}), 3: (1, {'@': 183}), 24: (1, {'@': 183}), 27: (1, {'@': 183}), 11: (1, {'@': 183}), 17: (1, {'@': 183}), 29: (1, {'@': 183}), 30: (1, {'@': 183}), 28: (1, {'@': 183}), 6: (1, {'@': 183}), 25: (1, {'@': 183}), 12: (1, {'@': 183}), 31: (1, {'@': 183}), 13: (1, {'@': 183}), 18: (1, {'@': 183}), 32: (1, {'@': 183}), 33: (1, {'@': 183}), 34: (1, {'@': 183}), 19: (1, {'@': 183}), 23: (1, {'@': 183}), 14: (1, {'@': 183}), 4: (1, {'@': 183}), 10: (1, {'@': 183}), 15: (1, {'@': 183}), 2: (1, {'@': 183}), 9: (1, {'@': 183}), 26: (1, {'@': 183}), 35: (1, {'@': 183}), 20: (1, {'@': 183}), 1: (1, {'@': 183})}, 451: {22: (1, {'@': 198}), 19: (1, {'@': 198}), 23: (1, {'@': 198}), 21: (1, {'@': 198}), 24: (1, {'@': 198}), 3: (1, {'@': 198}), 11: (1, {'@': 198}), 14: (1, {'@': 198}), 17: (1, {'@': 198}), 4: (1, {'@': 198}), 10: (1, {'@': 198}), 15: (1, {'@': 198}), 6: (1, {'@': 198}), 25: (1, {'@': 198}), 2: (1, {'@': 198}), 9: (1, {'@': 198}), 13: (1, {'@': 198}), 26: (1, {'@': 198}), 20: (1, {'@': 198}), 1: (1, {'@': 198}), 5: (1, {'@': 198}), 27: (1, {'@': 198}), 28: (1, {'@': 198}), 29: (1, {'@': 198}), 30: (1, {'@': 198}), 12: (1, {'@': 198}), 31: (1, {'@': 198}), 18: (1, {'@': 198}), 32: (1, {'@': 198}), 33: (1, {'@': 198}), 34: (1, {'@': 198}), 35: (1, {'@': 198})}, 452: {18: (0, 379), 12: (0, 400), 5: (0, 380), 3: (1, {'@': 58}), 30: (1, {'@': 58}), 29: (1, {'@': 58}), 48: (1, {'@': 58}), 65: (1, {'@': 58}), 56: (1, {'@': 58}), 31: (1, {'@': 58}), 59: (1, {'@': 58}), 43: (1, {'@': 58}), 21: (1, {'@': 58}), 24: (1, {'@': 58}), 61: (1, {'@': 58}), 37: (1, {'@': 58}), 72: (1, {'@': 58}), 34: (1, {'@': 58}), 27: (1, {'@': 58}), 35: (1, {'@': 58}), 28: (1, {'@': 58}), 38: (1, {'@': 58})}, 453: {3: (0, 406)}, 454: {34: (0, 609)}, 455: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 560), 48: (1, {'@': 364}), 65: (1, {'@': 364}), 56: (1, {'@': 364}), 31: (1, {'@': 364}), 59: (1, {'@': 364}), 43: (1, {'@': 364}), 21: (1, {'@': 364}), 24: (1, {'@': 364}), 61: (1, {'@': 364}), 37: (1, {'@': 364})}, 456: {30: (0, 82)}, 457: {22: (1, {'@': 212}), 19: (1, {'@': 212}), 23: (1, {'@': 212}), 21: (1, {'@': 212}), 24: (1, {'@': 212}), 3: (1, {'@': 212}), 11: (1, {'@': 212}), 14: (1, {'@': 212}), 17: (1, {'@': 212}), 4: (1, {'@': 212}), 10: (1, {'@': 212}), 15: (1, {'@': 212}), 6: (1, {'@': 212}), 25: (1, {'@': 212}), 2: (1, {'@': 212}), 9: (1, {'@': 212}), 13: (1, {'@': 212}), 26: (1, {'@': 212}), 20: (1, {'@': 212}), 1: (1, {'@': 212}), 5: (1, {'@': 212}), 27: (1, {'@': 212}), 28: (1, {'@': 212}), 29: (1, {'@': 212}), 30: (1, {'@': 212}), 12: (1, {'@': 212}), 31: (1, {'@': 212}), 18: (1, {'@': 212}), 32: (1, {'@': 212}), 33: (1, {'@': 212}), 34: (1, {'@': 212}), 35: (1, {'@': 212})}, 458: {22: (1, {'@': 247}), 19: (1, {'@': 247}), 23: (1, {'@': 247}), 21: (1, {'@': 247}), 24: (1, {'@': 247}), 3: (1, {'@': 247}), 11: (1, {'@': 247}), 14: (1, {'@': 247}), 17: (1, {'@': 247}), 4: (1, {'@': 247}), 10: (1, {'@': 247}), 15: (1, {'@': 247}), 6: (1, {'@': 247}), 25: (1, {'@': 247}), 2: (1, {'@': 247}), 9: (1, {'@': 247}), 13: (1, {'@': 247}), 26: (1, {'@': 247}), 20: (1, {'@': 247}), 1: (1, {'@': 247}), 5: (1, {'@': 247}), 27: (1, {'@': 247}), 28: (1, {'@': 247}), 29: (1, {'@': 247}), 30: (1, {'@': 247}), 12: (1, {'@': 247}), 31: (1, {'@': 247}), 18: (1, {'@': 247}), 32: (1, {'@': 247}), 33: (1, {'@': 247}), 34: (1, {'@': 247}), 35: (1, {'@': 247})}, 459: {0: (0, 452), 29: (0, 327), 68: (0, 99), 18: (0, 356), 12: (0, 405), 30: (0, 74), 7: (0, 326), 5: (0, 371)}, 460: {48: (1, {'@': 411}), 65: (1, {'@': 411}), 56: (1, {'@': 411}), 12: (1, {'@': 411}), 31: (1, {'@': 411}), 59: (1, {'@': 411}), 5: (1, {'@': 411}), 43: (1, {'@': 411}), 21: (1, {'@': 411}), 24: (1, {'@': 411}), 61: (1, {'@': 411}), 18: (1, {'@': 411}), 37: (1, {'@': 411})}, 461: {34: (0, 612)}, 462: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 22), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 7: (0, 203), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 463: {48: (1, {'@': 365}), 65: (1, {'@': 365}), 56: (1, {'@': 365}), 12: (1, {'@': 365}), 31: (1, {'@': 365}), 59: (1, {'@': 365}), 5: (1, {'@': 365}), 43: (1, {'@': 365}), 21: (1, {'@': 365}), 24: (1, {'@': 365}), 61: (1, {'@': 365}), 18: (1, {'@': 365}), 37: (1, {'@': 365})}, 464: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 607), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 34: (0, 631), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 465: {67: (1, {'@': 430}), 59: (1, {'@': 430}), 22: (1, {'@': 430}), 19: (1, {'@': 430}), 23: (1, {'@': 430}), 21: (1, {'@': 430}), 24: (1, {'@': 430}), 3: (1, {'@': 430}), 11: (1, {'@': 430}), 14: (1, {'@': 430}), 17: (1, {'@': 430}), 4: (1, {'@': 430}), 10: (1, {'@': 430}), 15: (1, {'@': 430}), 6: (1, {'@': 430}), 25: (1, {'@': 430}), 2: (1, {'@': 430}), 9: (1, {'@': 430}), 13: (1, {'@': 430}), 26: (1, {'@': 430}), 20: (1, {'@': 430}), 1: (1, {'@': 430}), 5: (1, {'@': 430}), 27: (1, {'@': 430}), 28: (1, {'@': 430}), 29: (1, {'@': 430}), 30: (1, {'@': 430}), 12: (1, {'@': 430}), 31: (1, {'@': 430}), 18: (1, {'@': 430}), 32: (1, {'@': 430}), 33: (1, {'@': 430}), 34: (1, {'@': 430}), 35: (1, {'@': 430})}, 466: {30: (0, 423)}, 467: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 401), 7: (0, 694), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 468: {34: (0, 485), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 651)}, 469: {7: (0, 418), 0: (0, 452), 29: (0, 327), 12: (0, 405), 30: (0, 435), 18: (0, 356), 68: (0, 127), 5: (0, 371)}, 470: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 543), 5: (0, 371), 48: (1, {'@': 410}), 65: (1, {'@': 410}), 56: (1, {'@': 410}), 31: (1, {'@': 410}), 59: (1, {'@': 410}), 43: (1, {'@': 410}), 21: (1, {'@': 410}), 24: (1, {'@': 410}), 61: (1, {'@': 410}), 37: (1, {'@': 410})}, 471: {0: (0, 452), 7: (0, 698), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 356}), 65: (1, {'@': 356}), 56: (1, {'@': 356}), 31: (1, {'@': 356}), 59: (1, {'@': 356}), 43: (1, {'@': 356}), 21: (1, {'@': 356}), 24: (1, {'@': 356}), 61: (1, {'@': 356}), 37: (1, {'@': 356})}, 472: {3: (0, 693)}, 473: {34: (0, 481)}, 474: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 408), 48: (1, {'@': 406}), 65: (1, {'@': 406}), 56: (1, {'@': 406}), 31: (1, {'@': 406}), 59: (1, {'@': 406}), 43: (1, {'@': 406}), 21: (1, {'@': 406}), 24: (1, {'@': 406}), 61: (1, {'@': 406}), 37: (1, {'@': 406})}, 475: {31: (0, 348), 76: (0, 386), 42: (0, 363), 75: (0, 392), 30: (1, {'@': 47}), 35: (1, {'@': 47}), 5: (1, {'@': 47}), 18: (1, {'@': 47}), 12: (1, {'@': 47})}, 476: {22: (1, {'@': 119}), 19: (1, {'@': 119}), 23: (1, {'@': 119}), 21: (1, {'@': 119}), 24: (1, {'@': 119}), 3: (1, {'@': 119}), 11: (1, {'@': 119}), 14: (1, {'@': 119}), 17: (1, {'@': 119}), 4: (1, {'@': 119}), 10: (1, {'@': 119}), 15: (1, {'@': 119}), 6: (1, {'@': 119}), 25: (1, {'@': 119}), 2: (1, {'@': 119}), 9: (1, {'@': 119}), 13: (1, {'@': 119}), 26: (1, {'@': 119}), 20: (1, {'@': 119}), 1: (1, {'@': 119}), 5: (1, {'@': 119}), 27: (1, {'@': 119}), 28: (1, {'@': 119}), 29: (1, {'@': 119}), 30: (1, {'@': 119}), 12: (1, {'@': 119}), 31: (1, {'@': 119}), 18: (1, {'@': 119}), 32: (1, {'@': 119}), 33: (1, {'@': 119}), 34: (1, {'@': 119}), 35: (1, {'@': 119})}, 477: {22: (1, {'@': 329}), 19: (1, {'@': 329}), 23: (1, {'@': 329}), 21: (1, {'@': 329}), 24: (1, {'@': 329}), 3: (1, {'@': 329}), 11: (1, {'@': 329}), 14: (1, {'@': 329}), 17: (1, {'@': 329}), 4: (1, {'@': 329}), 10: (1, {'@': 329}), 15: (1, {'@': 329}), 6: (1, {'@': 329}), 25: (1, {'@': 329}), 2: (1, {'@': 329}), 9: (1, {'@': 329}), 13: (1, {'@': 329}), 26: (1, {'@': 329}), 20: (1, {'@': 329}), 1: (1, {'@': 329}), 5: (1, {'@': 329}), 27: (1, {'@': 329}), 28: (1, {'@': 329}), 29: (1, {'@': 329}), 30: (1, {'@': 329}), 12: (1, {'@': 329}), 31: (1, {'@': 329}), 18: (1, {'@': 329}), 32: (1, {'@': 329}), 33: (1, {'@': 329}), 34: (1, {'@': 329}), 35: (1, {'@': 329})}, 478: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 20), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 479: {22: (1, {'@': 243}), 19: (1, {'@': 243}), 23: (1, {'@': 243}), 21: (1, {'@': 243}), 24: (1, {'@': 243}), 3: (1, {'@': 243}), 11: (1, {'@': 243}), 14: (1, {'@': 243}), 17: (1, {'@': 243}), 4: (1, {'@': 243}), 10: (1, {'@': 243}), 15: (1, {'@': 243}), 6: (1, {'@': 243}), 25: (1, {'@': 243}), 2: (1, {'@': 243}), 9: (1, {'@': 243}), 13: (1, {'@': 243}), 26: (1, {'@': 243}), 20: (1, {'@': 243}), 1: (1, {'@': 243}), 5: (1, {'@': 243}), 27: (1, {'@': 243}), 28: (1, {'@': 243}), 29: (1, {'@': 243}), 30: (1, {'@': 243}), 12: (1, {'@': 243}), 31: (1, {'@': 243}), 18: (1, {'@': 243}), 32: (1, {'@': 243}), 33: (1, {'@': 243}), 34: (1, {'@': 243}), 35: (1, {'@': 243})}, 480: {30: (0, 643)}, 481: {22: (1, {'@': 116}), 19: (1, {'@': 116}), 23: (1, {'@': 116}), 21: (1, {'@': 116}), 24: (1, {'@': 116}), 3: (1, {'@': 116}), 11: (1, {'@': 116}), 14: (1, {'@': 116}), 17: (1, {'@': 116}), 4: (1, {'@': 116}), 10: (1, {'@': 116}), 15: (1, {'@': 116}), 6: (1, {'@': 116}), 25: (1, {'@': 116}), 2: (1, {'@': 116}), 9: (1, {'@': 116}), 13: (1, {'@': 116}), 26: (1, {'@': 116}), 20: (1, {'@': 116}), 1: (1, {'@': 116}), 5: (1, {'@': 116}), 27: (1, {'@': 116}), 28: (1, {'@': 116}), 29: (1, {'@': 116}), 30: (1, {'@': 116}), 12: (1, {'@': 116}), 31: (1, {'@': 116}), 18: (1, {'@': 116}), 32: (1, {'@': 116}), 33: (1, {'@': 116}), 34: (1, {'@': 116}), 35: (1, {'@': 116})}, 482: {22: (1, {'@': 244}), 19: (1, {'@': 244}), 23: (1, {'@': 244}), 21: (1, {'@': 244}), 24: (1, {'@': 244}), 3: (1, {'@': 244}), 11: (1, {'@': 244}), 14: (1, {'@': 244}), 17: (1, {'@': 244}), 4: (1, {'@': 244}), 10: (1, {'@': 244}), 15: (1, {'@': 244}), 6: (1, {'@': 244}), 25: (1, {'@': 244}), 2: (1, {'@': 244}), 9: (1, {'@': 244}), 13: (1, {'@': 244}), 26: (1, {'@': 244}), 20: (1, {'@': 244}), 1: (1, {'@': 244}), 5: (1, {'@': 244}), 27: (1, {'@': 244}), 28: (1, {'@': 244}), 29: (1, {'@': 244}), 30: (1, {'@': 244}), 12: (1, {'@': 244}), 31: (1, {'@': 244}), 18: (1, {'@': 244}), 32: (1, {'@': 244}), 33: (1, {'@': 244}), 34: (1, {'@': 244}), 35: (1, {'@': 244})}, 483: {33: (0, 653), 1: (0, 654), 2: (0, 581), 4: (0, 634), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 484: {30: (0, 357)}, 485: {22: (1, {'@': 208}), 19: (1, {'@': 208}), 23: (1, {'@': 208}), 21: (1, {'@': 208}), 24: (1, {'@': 208}), 3: (1, {'@': 208}), 11: (1, {'@': 208}), 14: (1, {'@': 208}), 17: (1, {'@': 208}), 4: (1, {'@': 208}), 10: (1, {'@': 208}), 15: (1, {'@': 208}), 6: (1, {'@': 208}), 25: (1, {'@': 208}), 2: (1, {'@': 208}), 9: (1, {'@': 208}), 13: (1, {'@': 208}), 26: (1, {'@': 208}), 20: (1, {'@': 208}), 1: (1, {'@': 208}), 5: (1, {'@': 208}), 27: (1, {'@': 208}), 28: (1, {'@': 208}), 29: (1, {'@': 208}), 30: (1, {'@': 208}), 12: (1, {'@': 208}), 31: (1, {'@': 208}), 18: (1, {'@': 208}), 32: (1, {'@': 208}), 33: (1, {'@': 208}), 34: (1, {'@': 208}), 35: (1, {'@': 208})}, 486: {30: (0, 366)}, 487: {0: (0, 452), 68: (0, 32), 29: (0, 327), 7: (0, 39), 30: (0, 44), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 488: {22: (1, {'@': 151}), 19: (1, {'@': 151}), 23: (1, {'@': 151}), 21: (1, {'@': 151}), 24: (1, {'@': 151}), 3: (1, {'@': 151}), 11: (1, {'@': 151}), 14: (1, {'@': 151}), 17: (1, {'@': 151}), 4: (1, {'@': 151}), 10: (1, {'@': 151}), 15: (1, {'@': 151}), 6: (1, {'@': 151}), 25: (1, {'@': 151}), 2: (1, {'@': 151}), 9: (1, {'@': 151}), 13: (1, {'@': 151}), 26: (1, {'@': 151}), 20: (1, {'@': 151}), 1: (1, {'@': 151}), 5: (1, {'@': 151}), 27: (1, {'@': 151}), 28: (1, {'@': 151}), 29: (1, {'@': 151}), 30: (1, {'@': 151}), 12: (1, {'@': 151}), 31: (1, {'@': 151}), 18: (1, {'@': 151}), 32: (1, {'@': 151}), 33: (1, {'@': 151}), 34: (1, {'@': 151}), 35: (1, {'@': 151})}, 489: {22: (1, {'@': 311}), 19: (1, {'@': 311}), 23: (1, {'@': 311}), 21: (1, {'@': 311}), 24: (1, {'@': 311}), 3: (1, {'@': 311}), 11: (1, {'@': 311}), 14: (1, {'@': 311}), 17: (1, {'@': 311}), 4: (1, {'@': 311}), 10: (1, {'@': 311}), 15: (1, {'@': 311}), 6: (1, {'@': 311}), 25: (1, {'@': 311}), 2: (1, {'@': 311}), 9: (1, {'@': 311}), 13: (1, {'@': 311}), 26: (1, {'@': 311}), 20: (1, {'@': 311}), 1: (1, {'@': 311}), 5: (1, {'@': 311}), 27: (1, {'@': 311}), 28: (1, {'@': 311}), 29: (1, {'@': 311}), 30: (1, {'@': 311}), 12: (1, {'@': 311}), 31: (1, {'@': 311}), 18: (1, {'@': 311}), 32: (1, {'@': 311}), 33: (1, {'@': 311}), 34: (1, {'@': 311}), 35: (1, {'@': 311})}, 490: {30: (0, 369), 0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 373), 5: (0, 371)}, 491: {0: (0, 452), 1: (0, 654), 2: (0, 581), 3: (0, 556), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 7: (0, 472), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 492: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 118), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 50: (0, 13), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 41: (0, 680), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 30: (0, 258), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 493: {0: (0, 452), 29: (0, 327), 30: (0, 186), 12: (0, 405), 7: (0, 212), 68: (0, 224), 18: (0, 356), 5: (0, 371)}, 494: {3: (0, 471), 0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 227), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 495: {34: (0, 303)}, 496: {22: (1, {'@': 252}), 19: (1, {'@': 252}), 23: (1, {'@': 252}), 21: (1, {'@': 252}), 24: (1, {'@': 252}), 3: (1, {'@': 252}), 11: (1, {'@': 252}), 14: (1, {'@': 252}), 17: (1, {'@': 252}), 4: (1, {'@': 252}), 10: (1, {'@': 252}), 15: (1, {'@': 252}), 6: (1, {'@': 252}), 25: (1, {'@': 252}), 2: (1, {'@': 252}), 9: (1, {'@': 252}), 13: (1, {'@': 252}), 26: (1, {'@': 252}), 20: (1, {'@': 252}), 1: (1, {'@': 252}), 5: (1, {'@': 252}), 27: (1, {'@': 252}), 28: (1, {'@': 252}), 29: (1, {'@': 252}), 30: (1, {'@': 252}), 12: (1, {'@': 252}), 31: (1, {'@': 252}), 18: (1, {'@': 252}), 32: (1, {'@': 252}), 33: (1, {'@': 252}), 34: (1, {'@': 252}), 35: (1, {'@': 252})}, 497: {22: (1, {'@': 297}), 19: (1, {'@': 297}), 23: (1, {'@': 297}), 21: (1, {'@': 297}), 24: (1, {'@': 297}), 3: (1, {'@': 297}), 11: (1, {'@': 297}), 14: (1, {'@': 297}), 17: (1, {'@': 297}), 4: (1, {'@': 297}), 10: (1, {'@': 297}), 15: (1, {'@': 297}), 6: (1, {'@': 297}), 25: (1, {'@': 297}), 2: (1, {'@': 297}), 9: (1, {'@': 297}), 13: (1, {'@': 297}), 26: (1, {'@': 297}), 20: (1, {'@': 297}), 1: (1, {'@': 297}), 5: (1, {'@': 297}), 27: (1, {'@': 297}), 28: (1, {'@': 297}), 29: (1, {'@': 297}), 30: (1, {'@': 297}), 12: (1, {'@': 297}), 31: (1, {'@': 297}), 18: (1, {'@': 297}), 32: (1, {'@': 297}), 33: (1, {'@': 297}), 34: (1, {'@': 297}), 35: (1, {'@': 297})}, 498: {22: (1, {'@': 150}), 19: (1, {'@': 150}), 23: (1, {'@': 150}), 21: (1, {'@': 150}), 24: (1, {'@': 150}), 3: (1, {'@': 150}), 11: (1, {'@': 150}), 14: (1, {'@': 150}), 17: (1, {'@': 150}), 4: (1, {'@': 150}), 10: (1, {'@': 150}), 15: (1, {'@': 150}), 6: (1, {'@': 150}), 25: (1, {'@': 150}), 2: (1, {'@': 150}), 9: (1, {'@': 150}), 13: (1, {'@': 150}), 26: (1, {'@': 150}), 20: (1, {'@': 150}), 1: (1, {'@': 150}), 5: (1, {'@': 150}), 27: (1, {'@': 150}), 28: (1, {'@': 150}), 29: (1, {'@': 150}), 30: (1, {'@': 150}), 12: (1, {'@': 150}), 31: (1, {'@': 150}), 18: (1, {'@': 150}), 32: (1, {'@': 150}), 33: (1, {'@': 150}), 34: (1, {'@': 150}), 35: (1, {'@': 150})}, 499: {0: (0, 452), 37: (0, 709), 50: (0, 494), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 7: (0, 60), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 500: {0: (0, 452), 30: (0, 51), 7: (0, 55), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 501: {30: (0, 377)}, 502: {0: (0, 452), 7: (0, 403), 12: (0, 405), 18: (0, 356), 5: (0, 371), 48: (1, {'@': 370}), 65: (1, {'@': 370}), 56: (1, {'@': 370}), 31: (1, {'@': 370}), 59: (1, {'@': 370}), 43: (1, {'@': 370}), 21: (1, {'@': 370}), 24: (1, {'@': 370}), 61: (1, {'@': 370}), 37: (1, {'@': 370})}, 503: {0: (0, 452), 3: (0, 144), 1: (0, 654), 2: (0, 581), 7: (0, 151), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 504: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 30: (1, {'@': 157}), 12: (1, {'@': 157}), 5: (1, {'@': 157}), 18: (1, {'@': 157}), 28: (1, {'@': 157})}, 505: {22: (1, {'@': 258}), 19: (1, {'@': 258}), 23: (1, {'@': 258}), 21: (1, {'@': 258}), 24: (1, {'@': 258}), 3: (1, {'@': 258}), 11: (1, {'@': 258}), 14: (1, {'@': 258}), 17: (1, {'@': 258}), 4: (1, {'@': 258}), 10: (1, {'@': 258}), 15: (1, {'@': 258}), 6: (1, {'@': 258}), 25: (1, {'@': 258}), 2: (1, {'@': 258}), 9: (1, {'@': 258}), 13: (1, {'@': 258}), 26: (1, {'@': 258}), 20: (1, {'@': 258}), 1: (1, {'@': 258}), 5: (1, {'@': 258}), 27: (1, {'@': 258}), 28: (1, {'@': 258}), 29: (1, {'@': 258}), 30: (1, {'@': 258}), 12: (1, {'@': 258}), 31: (1, {'@': 258}), 18: (1, {'@': 258}), 32: (1, {'@': 258}), 33: (1, {'@': 258}), 34: (1, {'@': 258}), 35: (1, {'@': 258})}, 506: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 30: (1, {'@': 156}), 12: (1, {'@': 156}), 5: (1, {'@': 156}), 18: (1, {'@': 156}), 28: (1, {'@': 156})}, 507: {30: (0, 61)}, 508: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 50: (0, 595), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 509: {30: (0, 382)}, 510: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 118), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 50: (0, 13), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 41: (0, 680), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 30: (0, 255), 65: (0, 737), 66: (0, 59)}, 511: {3: (0, 474)}, 512: {22: (1, {'@': 301}), 19: (1, {'@': 301}), 23: (1, {'@': 301}), 21: (1, {'@': 301}), 24: (1, {'@': 301}), 3: (1, {'@': 301}), 11: (1, {'@': 301}), 14: (1, {'@': 301}), 17: (1, {'@': 301}), 4: (1, {'@': 301}), 10: (1, {'@': 301}), 15: (1, {'@': 301}), 6: (1, {'@': 301}), 25: (1, {'@': 301}), 2: (1, {'@': 301}), 9: (1, {'@': 301}), 13: (1, {'@': 301}), 26: (1, {'@': 301}), 20: (1, {'@': 301}), 1: (1, {'@': 301}), 5: (1, {'@': 301}), 27: (1, {'@': 301}), 28: (1, {'@': 301}), 29: (1, {'@': 301}), 30: (1, {'@': 301}), 12: (1, {'@': 301}), 31: (1, {'@': 301}), 18: (1, {'@': 301}), 32: (1, {'@': 301}), 33: (1, {'@': 301}), 34: (1, {'@': 301}), 35: (1, {'@': 301})}, 513: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 674), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 3: (0, 160), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 514: {22: (1, {'@': 257}), 19: (1, {'@': 257}), 23: (1, {'@': 257}), 21: (1, {'@': 257}), 24: (1, {'@': 257}), 3: (1, {'@': 257}), 11: (1, {'@': 257}), 14: (1, {'@': 257}), 17: (1, {'@': 257}), 4: (1, {'@': 257}), 10: (1, {'@': 257}), 15: (1, {'@': 257}), 6: (1, {'@': 257}), 25: (1, {'@': 257}), 2: (1, {'@': 257}), 9: (1, {'@': 257}), 13: (1, {'@': 257}), 26: (1, {'@': 257}), 20: (1, {'@': 257}), 1: (1, {'@': 257}), 5: (1, {'@': 257}), 27: (1, {'@': 257}), 28: (1, {'@': 257}), 29: (1, {'@': 257}), 30: (1, {'@': 257}), 12: (1, {'@': 257}), 31: (1, {'@': 257}), 18: (1, {'@': 257}), 32: (1, {'@': 257}), 33: (1, {'@': 257}), 34: (1, {'@': 257}), 35: (1, {'@': 257})}, 515: {0: (0, 452), 68: (0, 226), 29: (0, 327), 34: (0, 280), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 454)}, 516: {0: (0, 452), 7: (0, 65), 18: (0, 356), 12: (0, 405), 30: (0, 68), 5: (0, 371)}, 517: {22: (1, {'@': 260}), 19: (1, {'@': 260}), 23: (1, {'@': 260}), 21: (1, {'@': 260}), 24: (1, {'@': 260}), 3: (1, {'@': 260}), 11: (1, {'@': 260}), 14: (1, {'@': 260}), 17: (1, {'@': 260}), 4: (1, {'@': 260}), 10: (1, {'@': 260}), 15: (1, {'@': 260}), 6: (1, {'@': 260}), 25: (1, {'@': 260}), 2: (1, {'@': 260}), 9: (1, {'@': 260}), 13: (1, {'@': 260}), 26: (1, {'@': 260}), 20: (1, {'@': 260}), 1: (1, {'@': 260}), 5: (1, {'@': 260}), 27: (1, {'@': 260}), 28: (1, {'@': 260}), 29: (1, {'@': 260}), 30: (1, {'@': 260}), 12: (1, {'@': 260}), 31: (1, {'@': 260}), 18: (1, {'@': 260}), 32: (1, {'@': 260}), 33: (1, {'@': 260}), 34: (1, {'@': 260}), 35: (1, {'@': 260})}, 518: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 129), 5: (0, 371), 27: (0, 133)}, 519: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 7: (0, 321), 50: (0, 666), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 520: {22: (1, {'@': 270}), 19: (1, {'@': 270}), 23: (1, {'@': 270}), 21: (1, {'@': 270}), 24: (1, {'@': 270}), 3: (1, {'@': 270}), 11: (1, {'@': 270}), 14: (1, {'@': 270}), 17: (1, {'@': 270}), 4: (1, {'@': 270}), 10: (1, {'@': 270}), 15: (1, {'@': 270}), 6: (1, {'@': 270}), 25: (1, {'@': 270}), 2: (1, {'@': 270}), 9: (1, {'@': 270}), 13: (1, {'@': 270}), 26: (1, {'@': 270}), 20: (1, {'@': 270}), 1: (1, {'@': 270}), 5: (1, {'@': 270}), 27: (1, {'@': 270}), 28: (1, {'@': 270}), 29: (1, {'@': 270}), 30: (1, {'@': 270}), 12: (1, {'@': 270}), 31: (1, {'@': 270}), 18: (1, {'@': 270}), 32: (1, {'@': 270}), 33: (1, {'@': 270}), 34: (1, {'@': 270}), 35: (1, {'@': 270})}, 521: {0: (0, 452), 29: (0, 327), 7: (0, 75), 12: (0, 405), 68: (0, 88), 30: (0, 96), 18: (0, 356), 5: (0, 371)}, 522: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 34), 48: (1, {'@': 368}), 65: (1, {'@': 368}), 56: (1, {'@': 368}), 31: (1, {'@': 368}), 59: (1, {'@': 368}), 43: (1, {'@': 368}), 21: (1, {'@': 368}), 24: (1, {'@': 368}), 61: (1, {'@': 368}), 37: (1, {'@': 368})}, 523: {72: (0, 585)}, 524: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 67}), 25: (1, {'@': 67}), 34: (1, {'@': 67}), 5: (1, {'@': 67}), 27: (1, {'@': 67}), 28: (1, {'@': 67}), 29: (1, {'@': 67}), 30: (1, {'@': 67}), 12: (1, {'@': 67}), 31: (1, {'@': 67}), 35: (1, {'@': 67}), 18: (1, {'@': 67}), 32: (1, {'@': 67}), 33: (1, {'@': 67})}, 525: {0: (0, 452), 1: (0, 654), 32: (0, 723), 2: (0, 581), 7: (0, 729), 29: (0, 327), 68: (0, 733), 4: (0, 634), 5: (0, 371), 30: (0, 741), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 526: {22: (1, {'@': 264}), 19: (1, {'@': 264}), 23: (1, {'@': 264}), 21: (1, {'@': 264}), 24: (1, {'@': 264}), 3: (1, {'@': 264}), 11: (1, {'@': 264}), 14: (1, {'@': 264}), 17: (1, {'@': 264}), 4: (1, {'@': 264}), 10: (1, {'@': 264}), 15: (1, {'@': 264}), 6: (1, {'@': 264}), 25: (1, {'@': 264}), 2: (1, {'@': 264}), 9: (1, {'@': 264}), 13: (1, {'@': 264}), 26: (1, {'@': 264}), 20: (1, {'@': 264}), 1: (1, {'@': 264}), 5: (1, {'@': 264}), 27: (1, {'@': 264}), 28: (1, {'@': 264}), 29: (1, {'@': 264}), 30: (1, {'@': 264}), 12: (1, {'@': 264}), 31: (1, {'@': 264}), 18: (1, {'@': 264}), 32: (1, {'@': 264}), 33: (1, {'@': 264}), 34: (1, {'@': 264}), 35: (1, {'@': 264})}, 527: {48: (1, {'@': 407}), 65: (1, {'@': 407}), 56: (1, {'@': 407}), 12: (1, {'@': 407}), 31: (1, {'@': 407}), 59: (1, {'@': 407}), 5: (1, {'@': 407}), 43: (1, {'@': 407}), 21: (1, {'@': 407}), 24: (1, {'@': 407}), 61: (1, {'@': 407}), 18: (1, {'@': 407}), 37: (1, {'@': 407})}, 528: {34: (0, 249)}, 529: {72: (0, 589)}, 530: {22: (1, {'@': 275}), 19: (1, {'@': 275}), 23: (1, {'@': 275}), 21: (1, {'@': 275}), 24: (1, {'@': 275}), 3: (1, {'@': 275}), 11: (1, {'@': 275}), 14: (1, {'@': 275}), 17: (1, {'@': 275}), 4: (1, {'@': 275}), 10: (1, {'@': 275}), 15: (1, {'@': 275}), 6: (1, {'@': 275}), 25: (1, {'@': 275}), 2: (1, {'@': 275}), 9: (1, {'@': 275}), 13: (1, {'@': 275}), 26: (1, {'@': 275}), 20: (1, {'@': 275}), 1: (1, {'@': 275}), 5: (1, {'@': 275}), 27: (1, {'@': 275}), 28: (1, {'@': 275}), 29: (1, {'@': 275}), 30: (1, {'@': 275}), 12: (1, {'@': 275}), 31: (1, {'@': 275}), 18: (1, {'@': 275}), 32: (1, {'@': 275}), 33: (1, {'@': 275}), 34: (1, {'@': 275}), 35: (1, {'@': 275})}, 531: {30: (0, 385)}, 532: {22: (1, {'@': 194}), 19: (1, {'@': 194}), 23: (1, {'@': 194}), 21: (1, {'@': 194}), 24: (1, {'@': 194}), 3: (1, {'@': 194}), 11: (1, {'@': 194}), 14: (1, {'@': 194}), 17: (1, {'@': 194}), 4: (1, {'@': 194}), 10: (1, {'@': 194}), 15: (1, {'@': 194}), 6: (1, {'@': 194}), 25: (1, {'@': 194}), 2: (1, {'@': 194}), 9: (1, {'@': 194}), 13: (1, {'@': 194}), 26: (1, {'@': 194}), 20: (1, {'@': 194}), 1: (1, {'@': 194}), 5: (1, {'@': 194}), 27: (1, {'@': 194}), 28: (1, {'@': 194}), 29: (1, {'@': 194}), 30: (1, {'@': 194}), 12: (1, {'@': 194}), 31: (1, {'@': 194}), 18: (1, {'@': 194}), 32: (1, {'@': 194}), 33: (1, {'@': 194}), 34: (1, {'@': 194}), 35: (1, {'@': 194})}, 533: {37: (0, 709), 24: (0, 711), 0: (0, 452), 39: (0, 716), 42: (0, 718), 7: (0, 331), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 5: (0, 371), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 338), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 34: (0, 242), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 534: {48: (1, {'@': 403}), 65: (1, {'@': 403}), 56: (1, {'@': 403}), 12: (1, {'@': 403}), 31: (1, {'@': 403}), 59: (1, {'@': 403}), 5: (1, {'@': 403}), 43: (1, {'@': 403}), 21: (1, {'@': 403}), 24: (1, {'@': 403}), 61: (1, {'@': 403}), 18: (1, {'@': 403}), 37: (1, {'@': 403})}, 535: {22: (1, {'@': 265}), 19: (1, {'@': 265}), 23: (1, {'@': 265}), 21: (1, {'@': 265}), 24: (1, {'@': 265}), 3: (1, {'@': 265}), 11: (1, {'@': 265}), 14: (1, {'@': 265}), 17: (1, {'@': 265}), 4: (1, {'@': 265}), 10: (1, {'@': 265}), 15: (1, {'@': 265}), 6: (1, {'@': 265}), 25: (1, {'@': 265}), 2: (1, {'@': 265}), 9: (1, {'@': 265}), 13: (1, {'@': 265}), 26: (1, {'@': 265}), 20: (1, {'@': 265}), 1: (1, {'@': 265}), 5: (1, {'@': 265}), 27: (1, {'@': 265}), 28: (1, {'@': 265}), 29: (1, {'@': 265}), 30: (1, {'@': 265}), 12: (1, {'@': 265}), 31: (1, {'@': 265}), 18: (1, {'@': 265}), 32: (1, {'@': 265}), 33: (1, {'@': 265}), 34: (1, {'@': 265}), 35: (1, {'@': 265})}, 536: {0: (0, 452), 7: (0, 317), 29: (0, 327), 34: (0, 278), 18: (0, 356), 12: (0, 405), 68: (0, 239), 5: (0, 371)}, 537: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 34: (0, 245), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 50: (0, 268), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 538: {7: (0, 456), 0: (0, 452), 30: (0, 28), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 539: {22: (1, {'@': 267}), 19: (1, {'@': 267}), 23: (1, {'@': 267}), 21: (1, {'@': 267}), 24: (1, {'@': 267}), 3: (1, {'@': 267}), 11: (1, {'@': 267}), 14: (1, {'@': 267}), 17: (1, {'@': 267}), 4: (1, {'@': 267}), 10: (1, {'@': 267}), 15: (1, {'@': 267}), 6: (1, {'@': 267}), 25: (1, {'@': 267}), 2: (1, {'@': 267}), 9: (1, {'@': 267}), 13: (1, {'@': 267}), 26: (1, {'@': 267}), 20: (1, {'@': 267}), 1: (1, {'@': 267}), 5: (1, {'@': 267}), 27: (1, {'@': 267}), 28: (1, {'@': 267}), 29: (1, {'@': 267}), 30: (1, {'@': 267}), 12: (1, {'@': 267}), 31: (1, {'@': 267}), 18: (1, {'@': 267}), 32: (1, {'@': 267}), 33: (1, {'@': 267}), 34: (1, {'@': 267}), 35: (1, {'@': 267})}, 540: {30: (1, {'@': 53}), 31: (1, {'@': 53}), 35: (1, {'@': 53}), 18: (1, {'@': 53}), 12: (1, {'@': 53}), 5: (1, {'@': 53})}, 541: {3: (0, 125)}, 542: {0: (0, 452), 68: (0, 440), 30: (0, 156), 29: (0, 327), 18: (0, 356), 12: (0, 405), 7: (0, 104), 5: (0, 371)}, 543: {48: (1, {'@': 409}), 65: (1, {'@': 409}), 56: (1, {'@': 409}), 12: (1, {'@': 409}), 31: (1, {'@': 409}), 59: (1, {'@': 409}), 5: (1, {'@': 409}), 43: (1, {'@': 409}), 21: (1, {'@': 409}), 24: (1, {'@': 409}), 61: (1, {'@': 409}), 18: (1, {'@': 409}), 37: (1, {'@': 409})}, 544: {22: (1, {'@': 291}), 19: (1, {'@': 291}), 23: (1, {'@': 291}), 21: (1, {'@': 291}), 24: (1, {'@': 291}), 3: (1, {'@': 291}), 11: (1, {'@': 291}), 14: (1, {'@': 291}), 17: (1, {'@': 291}), 4: (1, {'@': 291}), 10: (1, {'@': 291}), 15: (1, {'@': 291}), 6: (1, {'@': 291}), 25: (1, {'@': 291}), 2: (1, {'@': 291}), 9: (1, {'@': 291}), 13: (1, {'@': 291}), 26: (1, {'@': 291}), 20: (1, {'@': 291}), 1: (1, {'@': 291}), 5: (1, {'@': 291}), 27: (1, {'@': 291}), 28: (1, {'@': 291}), 29: (1, {'@': 291}), 30: (1, {'@': 291}), 12: (1, {'@': 291}), 31: (1, {'@': 291}), 18: (1, {'@': 291}), 32: (1, {'@': 291}), 33: (1, {'@': 291}), 34: (1, {'@': 291}), 35: (1, {'@': 291})}, 545: {30: (1, {'@': 57}), 48: (1, {'@': 57}), 65: (1, {'@': 57}), 56: (1, {'@': 57}), 31: (1, {'@': 57}), 59: (1, {'@': 57}), 43: (1, {'@': 57}), 21: (1, {'@': 57}), 24: (1, {'@': 57}), 61: (1, {'@': 57}), 37: (1, {'@': 57})}, 546: {0: (0, 452), 7: (0, 534), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 404}), 65: (1, {'@': 404}), 56: (1, {'@': 404}), 31: (1, {'@': 404}), 59: (1, {'@': 404}), 43: (1, {'@': 404}), 21: (1, {'@': 404}), 24: (1, {'@': 404}), 61: (1, {'@': 404}), 37: (1, {'@': 404})}, 547: {30: (0, 233)}, 548: {22: (1, {'@': 279}), 19: (1, {'@': 279}), 23: (1, {'@': 279}), 21: (1, {'@': 279}), 24: (1, {'@': 279}), 3: (1, {'@': 279}), 11: (1, {'@': 279}), 14: (1, {'@': 279}), 17: (1, {'@': 279}), 4: (1, {'@': 279}), 10: (1, {'@': 279}), 15: (1, {'@': 279}), 6: (1, {'@': 279}), 25: (1, {'@': 279}), 2: (1, {'@': 279}), 9: (1, {'@': 279}), 13: (1, {'@': 279}), 26: (1, {'@': 279}), 20: (1, {'@': 279}), 1: (1, {'@': 279}), 5: (1, {'@': 279}), 27: (1, {'@': 279}), 28: (1, {'@': 279}), 29: (1, {'@': 279}), 30: (1, {'@': 279}), 12: (1, {'@': 279}), 31: (1, {'@': 279}), 18: (1, {'@': 279}), 32: (1, {'@': 279}), 33: (1, {'@': 279}), 34: (1, {'@': 279}), 35: (1, {'@': 279})}, 549: {22: (1, {'@': 290}), 19: (1, {'@': 290}), 23: (1, {'@': 290}), 21: (1, {'@': 290}), 24: (1, {'@': 290}), 3: (1, {'@': 290}), 11: (1, {'@': 290}), 14: (1, {'@': 290}), 17: (1, {'@': 290}), 4: (1, {'@': 290}), 10: (1, {'@': 290}), 15: (1, {'@': 290}), 6: (1, {'@': 290}), 25: (1, {'@': 290}), 2: (1, {'@': 290}), 9: (1, {'@': 290}), 13: (1, {'@': 290}), 26: (1, {'@': 290}), 20: (1, {'@': 290}), 1: (1, {'@': 290}), 5: (1, {'@': 290}), 27: (1, {'@': 290}), 28: (1, {'@': 290}), 29: (1, {'@': 290}), 30: (1, {'@': 290}), 12: (1, {'@': 290}), 31: (1, {'@': 290}), 18: (1, {'@': 290}), 32: (1, {'@': 290}), 33: (1, {'@': 290}), 34: (1, {'@': 290}), 35: (1, {'@': 290})}, 550: {30: (0, 388)}, 551: {7: (0, 574), 0: (0, 452), 30: (0, 5), 29: (0, 327), 12: (0, 405), 68: (0, 11), 18: (0, 356), 5: (0, 371)}, 552: {22: (1, {'@': 278}), 19: (1, {'@': 278}), 23: (1, {'@': 278}), 21: (1, {'@': 278}), 24: (1, {'@': 278}), 3: (1, {'@': 278}), 11: (1, {'@': 278}), 14: (1, {'@': 278}), 17: (1, {'@': 278}), 4: (1, {'@': 278}), 10: (1, {'@': 278}), 15: (1, {'@': 278}), 6: (1, {'@': 278}), 25: (1, {'@': 278}), 2: (1, {'@': 278}), 9: (1, {'@': 278}), 13: (1, {'@': 278}), 26: (1, {'@': 278}), 20: (1, {'@': 278}), 1: (1, {'@': 278}), 5: (1, {'@': 278}), 27: (1, {'@': 278}), 28: (1, {'@': 278}), 29: (1, {'@': 278}), 30: (1, {'@': 278}), 12: (1, {'@': 278}), 31: (1, {'@': 278}), 18: (1, {'@': 278}), 32: (1, {'@': 278}), 33: (1, {'@': 278}), 34: (1, {'@': 278}), 35: (1, {'@': 278})}, 553: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 34: (0, 267), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 247), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 7: (0, 254), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 554: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 79), 5: (0, 371), 30: (0, 352)}, 555: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 434}), 5: (1, {'@': 434}), 27: (1, {'@': 434}), 18: (1, {'@': 434}), 32: (1, {'@': 434}), 28: (1, {'@': 434}), 34: (1, {'@': 434})}, 556: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 25), 48: (1, {'@': 396}), 65: (1, {'@': 396}), 56: (1, {'@': 396}), 31: (1, {'@': 396}), 59: (1, {'@': 396}), 43: (1, {'@': 396}), 21: (1, {'@': 396}), 24: (1, {'@': 396}), 61: (1, {'@': 396}), 37: (1, {'@': 396})}, 557: {22: (1, {'@': 281}), 19: (1, {'@': 281}), 23: (1, {'@': 281}), 21: (1, {'@': 281}), 24: (1, {'@': 281}), 3: (1, {'@': 281}), 11: (1, {'@': 281}), 14: (1, {'@': 281}), 17: (1, {'@': 281}), 4: (1, {'@': 281}), 10: (1, {'@': 281}), 15: (1, {'@': 281}), 6: (1, {'@': 281}), 25: (1, {'@': 281}), 2: (1, {'@': 281}), 9: (1, {'@': 281}), 13: (1, {'@': 281}), 26: (1, {'@': 281}), 20: (1, {'@': 281}), 1: (1, {'@': 281}), 5: (1, {'@': 281}), 27: (1, {'@': 281}), 28: (1, {'@': 281}), 29: (1, {'@': 281}), 30: (1, {'@': 281}), 12: (1, {'@': 281}), 31: (1, {'@': 281}), 18: (1, {'@': 281}), 32: (1, {'@': 281}), 33: (1, {'@': 281}), 34: (1, {'@': 281}), 35: (1, {'@': 281})}, 558: {22: (1, {'@': 445}), 5: (1, {'@': 445}), 21: (1, {'@': 445}), 3: (1, {'@': 445}), 24: (1, {'@': 445}), 27: (1, {'@': 445}), 11: (1, {'@': 445}), 17: (1, {'@': 445}), 29: (1, {'@': 445}), 30: (1, {'@': 445}), 28: (1, {'@': 445}), 6: (1, {'@': 445}), 25: (1, {'@': 445}), 12: (1, {'@': 445}), 31: (1, {'@': 445}), 13: (1, {'@': 445}), 18: (1, {'@': 445}), 32: (1, {'@': 445}), 33: (1, {'@': 445}), 34: (1, {'@': 445}), 19: (1, {'@': 445}), 23: (1, {'@': 445}), 14: (1, {'@': 445}), 4: (1, {'@': 445}), 10: (1, {'@': 445}), 15: (1, {'@': 445}), 2: (1, {'@': 445}), 9: (1, {'@': 445}), 26: (1, {'@': 445}), 35: (1, {'@': 445}), 20: (1, {'@': 445}), 1: (1, {'@': 445})}, 559: {22: (1, {'@': 322}), 19: (1, {'@': 322}), 23: (1, {'@': 322}), 21: (1, {'@': 322}), 24: (1, {'@': 322}), 3: (1, {'@': 322}), 11: (1, {'@': 322}), 14: (1, {'@': 322}), 17: (1, {'@': 322}), 4: (1, {'@': 322}), 10: (1, {'@': 322}), 15: (1, {'@': 322}), 6: (1, {'@': 322}), 25: (1, {'@': 322}), 2: (1, {'@': 322}), 9: (1, {'@': 322}), 13: (1, {'@': 322}), 26: (1, {'@': 322}), 20: (1, {'@': 322}), 1: (1, {'@': 322}), 5: (1, {'@': 322}), 27: (1, {'@': 322}), 28: (1, {'@': 322}), 29: (1, {'@': 322}), 30: (1, {'@': 322}), 12: (1, {'@': 322}), 31: (1, {'@': 322}), 18: (1, {'@': 322}), 32: (1, {'@': 322}), 33: (1, {'@': 322}), 34: (1, {'@': 322}), 35: (1, {'@': 322})}, 560: {48: (1, {'@': 363}), 65: (1, {'@': 363}), 56: (1, {'@': 363}), 12: (1, {'@': 363}), 31: (1, {'@': 363}), 59: (1, {'@': 363}), 5: (1, {'@': 363}), 43: (1, {'@': 363}), 21: (1, {'@': 363}), 24: (1, {'@': 363}), 61: (1, {'@': 363}), 18: (1, {'@': 363}), 37: (1, {'@': 363})}, 561: {22: (1, {'@': 284}), 19: (1, {'@': 284}), 23: (1, {'@': 284}), 21: (1, {'@': 284}), 24: (1, {'@': 284}), 3: (1, {'@': 284}), 11: (1, {'@': 284}), 14: (1, {'@': 284}), 17: (1, {'@': 284}), 4: (1, {'@': 284}), 10: (1, {'@': 284}), 15: (1, {'@': 284}), 6: (1, {'@': 284}), 25: (1, {'@': 284}), 2: (1, {'@': 284}), 9: (1, {'@': 284}), 13: (1, {'@': 284}), 26: (1, {'@': 284}), 20: (1, {'@': 284}), 1: (1, {'@': 284}), 5: (1, {'@': 284}), 27: (1, {'@': 284}), 28: (1, {'@': 284}), 29: (1, {'@': 284}), 30: (1, {'@': 284}), 12: (1, {'@': 284}), 31: (1, {'@': 284}), 18: (1, {'@': 284}), 32: (1, {'@': 284}), 33: (1, {'@': 284}), 34: (1, {'@': 284}), 35: (1, {'@': 284})}, 562: {22: (1, {'@': 163}), 19: (1, {'@': 163}), 23: (1, {'@': 163}), 21: (1, {'@': 163}), 24: (1, {'@': 163}), 3: (1, {'@': 163}), 11: (1, {'@': 163}), 14: (1, {'@': 163}), 17: (1, {'@': 163}), 4: (1, {'@': 163}), 10: (1, {'@': 163}), 15: (1, {'@': 163}), 6: (1, {'@': 163}), 25: (1, {'@': 163}), 2: (1, {'@': 163}), 9: (1, {'@': 163}), 13: (1, {'@': 163}), 26: (1, {'@': 163}), 20: (1, {'@': 163}), 1: (1, {'@': 163}), 5: (1, {'@': 163}), 27: (1, {'@': 163}), 28: (1, {'@': 163}), 29: (1, {'@': 163}), 30: (1, {'@': 163}), 12: (1, {'@': 163}), 31: (1, {'@': 163}), 18: (1, {'@': 163}), 32: (1, {'@': 163}), 33: (1, {'@': 163}), 34: (1, {'@': 163}), 35: (1, {'@': 163})}, 563: {7: (0, 568), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 34: (0, 532)}, 564: {0: (0, 452), 30: (0, 360), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 365)}, 565: {30: (0, 372)}, 566: {22: (1, {'@': 305}), 19: (1, {'@': 305}), 23: (1, {'@': 305}), 21: (1, {'@': 305}), 24: (1, {'@': 305}), 3: (1, {'@': 305}), 11: (1, {'@': 305}), 14: (1, {'@': 305}), 17: (1, {'@': 305}), 4: (1, {'@': 305}), 10: (1, {'@': 305}), 15: (1, {'@': 305}), 6: (1, {'@': 305}), 25: (1, {'@': 305}), 2: (1, {'@': 305}), 9: (1, {'@': 305}), 13: (1, {'@': 305}), 26: (1, {'@': 305}), 20: (1, {'@': 305}), 1: (1, {'@': 305}), 5: (1, {'@': 305}), 27: (1, {'@': 305}), 28: (1, {'@': 305}), 29: (1, {'@': 305}), 30: (1, {'@': 305}), 12: (1, {'@': 305}), 31: (1, {'@': 305}), 18: (1, {'@': 305}), 32: (1, {'@': 305}), 33: (1, {'@': 305}), 34: (1, {'@': 305}), 35: (1, {'@': 305})}, 567: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 50: (0, 443), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 568: {34: (0, 76)}, 569: {42: (0, 205), 31: (0, 348)}, 570: {22: (1, {'@': 146}), 19: (1, {'@': 146}), 23: (1, {'@': 146}), 21: (1, {'@': 146}), 24: (1, {'@': 146}), 3: (1, {'@': 146}), 11: (1, {'@': 146}), 14: (1, {'@': 146}), 17: (1, {'@': 146}), 4: (1, {'@': 146}), 10: (1, {'@': 146}), 15: (1, {'@': 146}), 6: (1, {'@': 146}), 25: (1, {'@': 146}), 2: (1, {'@': 146}), 9: (1, {'@': 146}), 13: (1, {'@': 146}), 26: (1, {'@': 146}), 20: (1, {'@': 146}), 1: (1, {'@': 146}), 5: (1, {'@': 146}), 27: (1, {'@': 146}), 28: (1, {'@': 146}), 29: (1, {'@': 146}), 30: (1, {'@': 146}), 12: (1, {'@': 146}), 31: (1, {'@': 146}), 18: (1, {'@': 146}), 32: (1, {'@': 146}), 33: (1, {'@': 146}), 34: (1, {'@': 146}), 35: (1, {'@': 146})}, 571: {30: (0, 530), 0: (0, 452), 7: (0, 180), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 572: {30: (0, 368)}, 573: {7: (0, 390), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 344}), 65: (1, {'@': 344}), 56: (1, {'@': 344}), 31: (1, {'@': 344}), 59: (1, {'@': 344}), 43: (1, {'@': 344}), 21: (1, {'@': 344}), 24: (1, {'@': 344}), 61: (1, {'@': 344}), 37: (1, {'@': 344})}, 574: {0: (0, 452), 7: (0, 486), 68: (0, 490), 29: (0, 327), 18: (0, 356), 12: (0, 405), 30: (0, 496), 5: (0, 371)}, 575: {22: (1, {'@': 276}), 19: (1, {'@': 276}), 23: (1, {'@': 276}), 21: (1, {'@': 276}), 24: (1, {'@': 276}), 3: (1, {'@': 276}), 11: (1, {'@': 276}), 14: (1, {'@': 276}), 17: (1, {'@': 276}), 4: (1, {'@': 276}), 10: (1, {'@': 276}), 15: (1, {'@': 276}), 6: (1, {'@': 276}), 25: (1, {'@': 276}), 2: (1, {'@': 276}), 9: (1, {'@': 276}), 13: (1, {'@': 276}), 26: (1, {'@': 276}), 20: (1, {'@': 276}), 1: (1, {'@': 276}), 5: (1, {'@': 276}), 27: (1, {'@': 276}), 28: (1, {'@': 276}), 29: (1, {'@': 276}), 30: (1, {'@': 276}), 12: (1, {'@': 276}), 31: (1, {'@': 276}), 18: (1, {'@': 276}), 32: (1, {'@': 276}), 33: (1, {'@': 276}), 34: (1, {'@': 276}), 35: (1, {'@': 276})}, 576: {7: (0, 330), 0: (0, 452), 27: (0, 312), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 577: {28: (0, 339), 27: (1, {'@': 177}), 5: (1, {'@': 177}), 18: (1, {'@': 177}), 12: (1, {'@': 177})}, 578: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 431}), 5: (1, {'@': 431}), 27: (1, {'@': 431}), 18: (1, {'@': 431}), 32: (1, {'@': 431}), 28: (1, {'@': 431}), 34: (1, {'@': 431})}, 579: {3: (0, 395)}, 580: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 578), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 34: (0, 626), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 581: {48: (1, {'@': 76}), 65: (1, {'@': 76}), 56: (1, {'@': 76}), 12: (1, {'@': 76}), 31: (1, {'@': 76}), 59: (1, {'@': 76}), 5: (1, {'@': 76}), 43: (1, {'@': 76}), 21: (1, {'@': 76}), 24: (1, {'@': 76}), 61: (1, {'@': 76}), 18: (1, {'@': 76}), 37: (1, {'@': 76})}, 582: {0: (0, 452), 37: (0, 709), 7: (0, 567), 39: (0, 716), 24: (0, 711), 50: (0, 427), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 583: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 50: (0, 200), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 7: (0, 671), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 584: {0: (0, 452), 7: (0, 216), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 346}), 65: (1, {'@': 346}), 56: (1, {'@': 346}), 31: (1, {'@': 346}), 59: (1, {'@': 346}), 43: (1, {'@': 346}), 21: (1, {'@': 346}), 24: (1, {'@': 346}), 61: (1, {'@': 346}), 37: (1, {'@': 346})}, 585: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 50: (0, 273), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 7: (0, 436), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 586: {0: (0, 452), 1: (0, 654), 2: (0, 581), 32: (0, 469), 29: (0, 327), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 68: (0, 171), 10: (0, 87), 11: (0, 93), 7: (0, 178), 30: (0, 189), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 587: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 118), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 50: (0, 13), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 41: (0, 673), 30: (0, 570), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 588: {22: (1, {'@': 122}), 19: (1, {'@': 122}), 23: (1, {'@': 122}), 21: (1, {'@': 122}), 24: (1, {'@': 122}), 3: (1, {'@': 122}), 11: (1, {'@': 122}), 14: (1, {'@': 122}), 17: (1, {'@': 122}), 4: (1, {'@': 122}), 10: (1, {'@': 122}), 15: (1, {'@': 122}), 6: (1, {'@': 122}), 25: (1, {'@': 122}), 2: (1, {'@': 122}), 9: (1, {'@': 122}), 13: (1, {'@': 122}), 26: (1, {'@': 122}), 20: (1, {'@': 122}), 1: (1, {'@': 122}), 5: (1, {'@': 122}), 27: (1, {'@': 122}), 28: (1, {'@': 122}), 29: (1, {'@': 122}), 30: (1, {'@': 122}), 12: (1, {'@': 122}), 31: (1, {'@': 122}), 18: (1, {'@': 122}), 32: (1, {'@': 122}), 33: (1, {'@': 122}), 34: (1, {'@': 122}), 35: (1, {'@': 122})}, 589: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 503), 53: (0, 725), 54: (0, 726), 5: (0, 371), 7: (0, 703), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 590: {3: (0, 302)}, 591: {0: (0, 452), 7: (0, 120), 29: (0, 327), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 342), 68: (0, 344)}, 592: {7: (0, 399), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 340}), 65: (1, {'@': 340}), 56: (1, {'@': 340}), 31: (1, {'@': 340}), 59: (1, {'@': 340}), 43: (1, {'@': 340}), 21: (1, {'@': 340}), 24: (1, {'@': 340}), 61: (1, {'@': 340}), 37: (1, {'@': 340})}, 593: {30: (0, 442)}, 594: {22: (1, {'@': 132}), 19: (1, {'@': 132}), 23: (1, {'@': 132}), 21: (1, {'@': 132}), 24: (1, {'@': 132}), 3: (1, {'@': 132}), 11: (1, {'@': 132}), 14: (1, {'@': 132}), 17: (1, {'@': 132}), 4: (1, {'@': 132}), 10: (1, {'@': 132}), 15: (1, {'@': 132}), 6: (1, {'@': 132}), 25: (1, {'@': 132}), 2: (1, {'@': 132}), 9: (1, {'@': 132}), 13: (1, {'@': 132}), 26: (1, {'@': 132}), 20: (1, {'@': 132}), 1: (1, {'@': 132}), 5: (1, {'@': 132}), 27: (1, {'@': 132}), 28: (1, {'@': 132}), 29: (1, {'@': 132}), 30: (1, {'@': 132}), 12: (1, {'@': 132}), 31: (1, {'@': 132}), 18: (1, {'@': 132}), 32: (1, {'@': 132}), 33: (1, {'@': 132}), 34: (1, {'@': 132}), 35: (1, {'@': 132})}, 595: {0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 5: (0, 371), 6: (0, 66), 3: (0, 413), 8: (0, 70), 9: (0, 83), 7: (0, 416), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 596: {72: (0, 199)}, 597: {0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 7: (0, 453), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 3: (0, 455), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 598: {22: (1, {'@': 317}), 19: (1, {'@': 317}), 23: (1, {'@': 317}), 21: (1, {'@': 317}), 24: (1, {'@': 317}), 3: (1, {'@': 317}), 11: (1, {'@': 317}), 14: (1, {'@': 317}), 17: (1, {'@': 317}), 4: (1, {'@': 317}), 10: (1, {'@': 317}), 15: (1, {'@': 317}), 6: (1, {'@': 317}), 25: (1, {'@': 317}), 2: (1, {'@': 317}), 9: (1, {'@': 317}), 13: (1, {'@': 317}), 26: (1, {'@': 317}), 20: (1, {'@': 317}), 1: (1, {'@': 317}), 5: (1, {'@': 317}), 27: (1, {'@': 317}), 28: (1, {'@': 317}), 29: (1, {'@': 317}), 30: (1, {'@': 317}), 12: (1, {'@': 317}), 31: (1, {'@': 317}), 18: (1, {'@': 317}), 32: (1, {'@': 317}), 33: (1, {'@': 317}), 34: (1, {'@': 317}), 35: (1, {'@': 317})}, 599: {3: (0, 402)}, 600: {22: (1, {'@': 273}), 19: (1, {'@': 273}), 23: (1, {'@': 273}), 21: (1, {'@': 273}), 24: (1, {'@': 273}), 3: (1, {'@': 273}), 11: (1, {'@': 273}), 14: (1, {'@': 273}), 17: (1, {'@': 273}), 4: (1, {'@': 273}), 10: (1, {'@': 273}), 15: (1, {'@': 273}), 6: (1, {'@': 273}), 25: (1, {'@': 273}), 2: (1, {'@': 273}), 9: (1, {'@': 273}), 13: (1, {'@': 273}), 26: (1, {'@': 273}), 20: (1, {'@': 273}), 1: (1, {'@': 273}), 5: (1, {'@': 273}), 27: (1, {'@': 273}), 28: (1, {'@': 273}), 29: (1, {'@': 273}), 30: (1, {'@': 273}), 12: (1, {'@': 273}), 31: (1, {'@': 273}), 18: (1, {'@': 273}), 32: (1, {'@': 273}), 33: (1, {'@': 273}), 34: (1, {'@': 273}), 35: (1, {'@': 273})}, 601: {73: (0, 475), 0: (0, 452), 7: (0, 446), 74: (0, 439), 12: (0, 405), 76: (0, 397), 42: (0, 363), 31: (0, 348), 81: (0, 341), 75: (0, 355), 18: (0, 356), 5: (0, 371), 35: (1, {'@': 48})}, 602: {22: (1, {'@': 135}), 19: (1, {'@': 135}), 23: (1, {'@': 135}), 21: (1, {'@': 135}), 24: (1, {'@': 135}), 3: (1, {'@': 135}), 11: (1, {'@': 135}), 14: (1, {'@': 135}), 17: (1, {'@': 135}), 4: (1, {'@': 135}), 10: (1, {'@': 135}), 15: (1, {'@': 135}), 6: (1, {'@': 135}), 25: (1, {'@': 135}), 2: (1, {'@': 135}), 9: (1, {'@': 135}), 13: (1, {'@': 135}), 26: (1, {'@': 135}), 20: (1, {'@': 135}), 1: (1, {'@': 135}), 5: (1, {'@': 135}), 27: (1, {'@': 135}), 28: (1, {'@': 135}), 29: (1, {'@': 135}), 30: (1, {'@': 135}), 12: (1, {'@': 135}), 31: (1, {'@': 135}), 18: (1, {'@': 135}), 32: (1, {'@': 135}), 33: (1, {'@': 135}), 34: (1, {'@': 135}), 35: (1, {'@': 135})}, 603: {0: (0, 452), 34: (0, 288), 7: (0, 528), 18: (0, 356), 12: (0, 405), 28: (0, 533), 5: (0, 371)}, 604: {0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 34: (0, 192), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 7: (0, 170), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 605: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 7: (0, 166), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 295), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 606: {34: (0, 4)}, 607: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 437}), 5: (1, {'@': 437}), 27: (1, {'@': 437}), 18: (1, {'@': 437}), 32: (1, {'@': 437}), 28: (1, {'@': 437}), 34: (1, {'@': 437})}, 608: {0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 677), 48: (1, {'@': 372}), 65: (1, {'@': 372}), 56: (1, {'@': 372}), 31: (1, {'@': 372}), 59: (1, {'@': 372}), 43: (1, {'@': 372}), 21: (1, {'@': 372}), 24: (1, {'@': 372}), 61: (1, {'@': 372}), 37: (1, {'@': 372})}, 609: {22: (1, {'@': 202}), 19: (1, {'@': 202}), 23: (1, {'@': 202}), 21: (1, {'@': 202}), 24: (1, {'@': 202}), 3: (1, {'@': 202}), 11: (1, {'@': 202}), 14: (1, {'@': 202}), 17: (1, {'@': 202}), 4: (1, {'@': 202}), 10: (1, {'@': 202}), 15: (1, {'@': 202}), 6: (1, {'@': 202}), 25: (1, {'@': 202}), 2: (1, {'@': 202}), 9: (1, {'@': 202}), 13: (1, {'@': 202}), 26: (1, {'@': 202}), 20: (1, {'@': 202}), 1: (1, {'@': 202}), 5: (1, {'@': 202}), 27: (1, {'@': 202}), 28: (1, {'@': 202}), 29: (1, {'@': 202}), 30: (1, {'@': 202}), 12: (1, {'@': 202}), 31: (1, {'@': 202}), 18: (1, {'@': 202}), 32: (1, {'@': 202}), 33: (1, {'@': 202}), 34: (1, {'@': 202}), 35: (1, {'@': 202})}, 610: {0: (0, 452), 7: (0, 191), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 350}), 65: (1, {'@': 350}), 56: (1, {'@': 350}), 31: (1, {'@': 350}), 59: (1, {'@': 350}), 43: (1, {'@': 350}), 21: (1, {'@': 350}), 24: (1, {'@': 350}), 61: (1, {'@': 350}), 37: (1, {'@': 350})}, 611: {34: (0, 220)}, 612: {22: (1, {'@': 204}), 19: (1, {'@': 204}), 23: (1, {'@': 204}), 21: (1, {'@': 204}), 24: (1, {'@': 204}), 3: (1, {'@': 204}), 11: (1, {'@': 204}), 14: (1, {'@': 204}), 17: (1, {'@': 204}), 4: (1, {'@': 204}), 10: (1, {'@': 204}), 15: (1, {'@': 204}), 6: (1, {'@': 204}), 25: (1, {'@': 204}), 2: (1, {'@': 204}), 9: (1, {'@': 204}), 13: (1, {'@': 204}), 26: (1, {'@': 204}), 20: (1, {'@': 204}), 1: (1, {'@': 204}), 5: (1, {'@': 204}), 27: (1, {'@': 204}), 28: (1, {'@': 204}), 29: (1, {'@': 204}), 30: (1, {'@': 204}), 12: (1, {'@': 204}), 31: (1, {'@': 204}), 18: (1, {'@': 204}), 32: (1, {'@': 204}), 33: (1, {'@': 204}), 34: (1, {'@': 204}), 35: (1, {'@': 204})}, 613: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 65}), 25: (1, {'@': 65}), 34: (1, {'@': 65}), 5: (1, {'@': 65}), 27: (1, {'@': 65}), 28: (1, {'@': 65}), 29: (1, {'@': 65}), 30: (1, {'@': 65}), 12: (1, {'@': 65}), 31: (1, {'@': 65}), 35: (1, {'@': 65}), 18: (1, {'@': 65}), 32: (1, {'@': 65}), 33: (1, {'@': 65})}, 614: {22: (1, {'@': 446}), 5: (1, {'@': 446}), 21: (1, {'@': 446}), 3: (1, {'@': 446}), 24: (1, {'@': 446}), 27: (1, {'@': 446}), 11: (1, {'@': 446}), 17: (1, {'@': 446}), 29: (1, {'@': 446}), 30: (1, {'@': 446}), 28: (1, {'@': 446}), 6: (1, {'@': 446}), 25: (1, {'@': 446}), 12: (1, {'@': 446}), 31: (1, {'@': 446}), 13: (1, {'@': 446}), 18: (1, {'@': 446}), 32: (1, {'@': 446}), 33: (1, {'@': 446}), 34: (1, {'@': 446}), 19: (1, {'@': 446}), 23: (1, {'@': 446}), 14: (1, {'@': 446}), 4: (1, {'@': 446}), 10: (1, {'@': 446}), 15: (1, {'@': 446}), 2: (1, {'@': 446}), 9: (1, {'@': 446}), 26: (1, {'@': 446}), 35: (1, {'@': 446}), 20: (1, {'@': 446}), 1: (1, {'@': 446})}, 615: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 636), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 34: (0, 645), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 616: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 636), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 34: (0, 8), 65: (0, 737), 66: (0, 59)}, 617: {0: (0, 452), 7: (0, 412), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 382}), 65: (1, {'@': 382}), 56: (1, {'@': 382}), 31: (1, {'@': 382}), 59: (1, {'@': 382}), 43: (1, {'@': 382}), 21: (1, {'@': 382}), 24: (1, {'@': 382}), 61: (1, {'@': 382}), 37: (1, {'@': 382})}, 618: {22: (1, {'@': 160}), 19: (1, {'@': 160}), 23: (1, {'@': 160}), 21: (1, {'@': 160}), 24: (1, {'@': 160}), 3: (1, {'@': 160}), 11: (1, {'@': 160}), 14: (1, {'@': 160}), 17: (1, {'@': 160}), 4: (1, {'@': 160}), 10: (1, {'@': 160}), 15: (1, {'@': 160}), 6: (1, {'@': 160}), 25: (1, {'@': 160}), 2: (1, {'@': 160}), 9: (1, {'@': 160}), 13: (1, {'@': 160}), 26: (1, {'@': 160}), 20: (1, {'@': 160}), 1: (1, {'@': 160}), 5: (1, {'@': 160}), 27: (1, {'@': 160}), 28: (1, {'@': 160}), 29: (1, {'@': 160}), 30: (1, {'@': 160}), 12: (1, {'@': 160}), 31: (1, {'@': 160}), 18: (1, {'@': 160}), 32: (1, {'@': 160}), 33: (1, {'@': 160}), 34: (1, {'@': 160}), 35: (1, {'@': 160})}, 619: {22: (1, {'@': 223}), 19: (1, {'@': 223}), 23: (1, {'@': 223}), 21: (1, {'@': 223}), 24: (1, {'@': 223}), 3: (1, {'@': 223}), 11: (1, {'@': 223}), 14: (1, {'@': 223}), 17: (1, {'@': 223}), 4: (1, {'@': 223}), 10: (1, {'@': 223}), 15: (1, {'@': 223}), 6: (1, {'@': 223}), 25: (1, {'@': 223}), 2: (1, {'@': 223}), 9: (1, {'@': 223}), 13: (1, {'@': 223}), 26: (1, {'@': 223}), 20: (1, {'@': 223}), 1: (1, {'@': 223}), 5: (1, {'@': 223}), 27: (1, {'@': 223}), 28: (1, {'@': 223}), 29: (1, {'@': 223}), 30: (1, {'@': 223}), 12: (1, {'@': 223}), 31: (1, {'@': 223}), 18: (1, {'@': 223}), 32: (1, {'@': 223}), 33: (1, {'@': 223}), 34: (1, {'@': 223}), 35: (1, {'@': 223})}, 620: {22: (1, {'@': 93}), 19: (1, {'@': 93}), 23: (1, {'@': 93}), 21: (1, {'@': 93}), 24: (1, {'@': 93}), 3: (1, {'@': 93}), 11: (1, {'@': 93}), 14: (1, {'@': 93}), 17: (1, {'@': 93}), 4: (1, {'@': 93}), 10: (1, {'@': 93}), 15: (1, {'@': 93}), 6: (1, {'@': 93}), 25: (1, {'@': 93}), 2: (1, {'@': 93}), 9: (1, {'@': 93}), 13: (1, {'@': 93}), 26: (1, {'@': 93}), 20: (1, {'@': 93}), 1: (1, {'@': 93}), 5: (1, {'@': 93}), 27: (1, {'@': 93}), 28: (1, {'@': 93}), 29: (1, {'@': 93}), 30: (1, {'@': 93}), 12: (1, {'@': 93}), 31: (1, {'@': 93}), 18: (1, {'@': 93}), 32: (1, {'@': 93}), 33: (1, {'@': 93}), 34: (1, {'@': 93}), 35: (1, {'@': 93})}, 621: {22: (1, {'@': 129}), 19: (1, {'@': 129}), 23: (1, {'@': 129}), 21: (1, {'@': 129}), 24: (1, {'@': 129}), 3: (1, {'@': 129}), 11: (1, {'@': 129}), 14: (1, {'@': 129}), 17: (1, {'@': 129}), 4: (1, {'@': 129}), 10: (1, {'@': 129}), 15: (1, {'@': 129}), 6: (1, {'@': 129}), 25: (1, {'@': 129}), 2: (1, {'@': 129}), 9: (1, {'@': 129}), 13: (1, {'@': 129}), 26: (1, {'@': 129}), 20: (1, {'@': 129}), 1: (1, {'@': 129}), 5: (1, {'@': 129}), 27: (1, {'@': 129}), 28: (1, {'@': 129}), 29: (1, {'@': 129}), 30: (1, {'@': 129}), 12: (1, {'@': 129}), 31: (1, {'@': 129}), 18: (1, {'@': 129}), 32: (1, {'@': 129}), 33: (1, {'@': 129}), 34: (1, {'@': 129}), 35: (1, {'@': 129})}, 622: {44: (0, 179), 59: (0, 23)}, 623: {22: (1, {'@': 115}), 19: (1, {'@': 115}), 23: (1, {'@': 115}), 21: (1, {'@': 115}), 24: (1, {'@': 115}), 3: (1, {'@': 115}), 11: (1, {'@': 115}), 14: (1, {'@': 115}), 17: (1, {'@': 115}), 4: (1, {'@': 115}), 10: (1, {'@': 115}), 15: (1, {'@': 115}), 6: (1, {'@': 115}), 25: (1, {'@': 115}), 2: (1, {'@': 115}), 9: (1, {'@': 115}), 13: (1, {'@': 115}), 26: (1, {'@': 115}), 20: (1, {'@': 115}), 1: (1, {'@': 115}), 5: (1, {'@': 115}), 27: (1, {'@': 115}), 28: (1, {'@': 115}), 29: (1, {'@': 115}), 30: (1, {'@': 115}), 12: (1, {'@': 115}), 31: (1, {'@': 115}), 18: (1, {'@': 115}), 32: (1, {'@': 115}), 33: (1, {'@': 115}), 34: (1, {'@': 115}), 35: (1, {'@': 115})}, 624: {48: (1, {'@': 385}), 65: (1, {'@': 385}), 56: (1, {'@': 385}), 12: (1, {'@': 385}), 31: (1, {'@': 385}), 59: (1, {'@': 385}), 5: (1, {'@': 385}), 43: (1, {'@': 385}), 21: (1, {'@': 385}), 24: (1, {'@': 385}), 61: (1, {'@': 385}), 18: (1, {'@': 385}), 37: (1, {'@': 385})}, 625: {27: (0, 175)}, 626: {22: (1, {'@': 121}), 19: (1, {'@': 121}), 23: (1, {'@': 121}), 21: (1, {'@': 121}), 24: (1, {'@': 121}), 3: (1, {'@': 121}), 11: (1, {'@': 121}), 14: (1, {'@': 121}), 17: (1, {'@': 121}), 4: (1, {'@': 121}), 10: (1, {'@': 121}), 15: (1, {'@': 121}), 6: (1, {'@': 121}), 25: (1, {'@': 121}), 2: (1, {'@': 121}), 9: (1, {'@': 121}), 13: (1, {'@': 121}), 26: (1, {'@': 121}), 20: (1, {'@': 121}), 1: (1, {'@': 121}), 5: (1, {'@': 121}), 27: (1, {'@': 121}), 28: (1, {'@': 121}), 29: (1, {'@': 121}), 30: (1, {'@': 121}), 12: (1, {'@': 121}), 31: (1, {'@': 121}), 18: (1, {'@': 121}), 32: (1, {'@': 121}), 33: (1, {'@': 121}), 34: (1, {'@': 121}), 35: (1, {'@': 121})}, 627: {48: (1, {'@': 379}), 65: (1, {'@': 379}), 56: (1, {'@': 379}), 12: (1, {'@': 379}), 31: (1, {'@': 379}), 59: (1, {'@': 379}), 5: (1, {'@': 379}), 43: (1, {'@': 379}), 21: (1, {'@': 379}), 24: (1, {'@': 379}), 61: (1, {'@': 379}), 18: (1, {'@': 379}), 37: (1, {'@': 379})}, 628: {0: (0, 452), 77: (0, 244), 12: (0, 405), 79: (0, 251), 28: (0, 257), 30: (0, 261), 7: (0, 265), 18: (0, 356), 5: (0, 371)}, 629: {22: (1, {'@': 92}), 19: (1, {'@': 92}), 23: (1, {'@': 92}), 21: (1, {'@': 92}), 24: (1, {'@': 92}), 3: (1, {'@': 92}), 11: (1, {'@': 92}), 14: (1, {'@': 92}), 17: (1, {'@': 92}), 4: (1, {'@': 92}), 10: (1, {'@': 92}), 15: (1, {'@': 92}), 6: (1, {'@': 92}), 25: (1, {'@': 92}), 2: (1, {'@': 92}), 9: (1, {'@': 92}), 13: (1, {'@': 92}), 26: (1, {'@': 92}), 20: (1, {'@': 92}), 1: (1, {'@': 92}), 5: (1, {'@': 92}), 27: (1, {'@': 92}), 28: (1, {'@': 92}), 29: (1, {'@': 92}), 30: (1, {'@': 92}), 12: (1, {'@': 92}), 31: (1, {'@': 92}), 18: (1, {'@': 92}), 32: (1, {'@': 92}), 33: (1, {'@': 92}), 34: (1, {'@': 92}), 35: (1, {'@': 92})}, 630: {22: (1, {'@': 210}), 19: (1, {'@': 210}), 23: (1, {'@': 210}), 21: (1, {'@': 210}), 24: (1, {'@': 210}), 3: (1, {'@': 210}), 11: (1, {'@': 210}), 14: (1, {'@': 210}), 17: (1, {'@': 210}), 4: (1, {'@': 210}), 10: (1, {'@': 210}), 15: (1, {'@': 210}), 6: (1, {'@': 210}), 25: (1, {'@': 210}), 2: (1, {'@': 210}), 9: (1, {'@': 210}), 13: (1, {'@': 210}), 26: (1, {'@': 210}), 20: (1, {'@': 210}), 1: (1, {'@': 210}), 5: (1, {'@': 210}), 27: (1, {'@': 210}), 28: (1, {'@': 210}), 29: (1, {'@': 210}), 30: (1, {'@': 210}), 12: (1, {'@': 210}), 31: (1, {'@': 210}), 18: (1, {'@': 210}), 32: (1, {'@': 210}), 33: (1, {'@': 210}), 34: (1, {'@': 210}), 35: (1, {'@': 210})}, 631: {22: (1, {'@': 118}), 19: (1, {'@': 118}), 23: (1, {'@': 118}), 21: (1, {'@': 118}), 24: (1, {'@': 118}), 3: (1, {'@': 118}), 11: (1, {'@': 118}), 14: (1, {'@': 118}), 17: (1, {'@': 118}), 4: (1, {'@': 118}), 10: (1, {'@': 118}), 15: (1, {'@': 118}), 6: (1, {'@': 118}), 25: (1, {'@': 118}), 2: (1, {'@': 118}), 9: (1, {'@': 118}), 13: (1, {'@': 118}), 26: (1, {'@': 118}), 20: (1, {'@': 118}), 1: (1, {'@': 118}), 5: (1, {'@': 118}), 27: (1, {'@': 118}), 28: (1, {'@': 118}), 29: (1, {'@': 118}), 30: (1, {'@': 118}), 12: (1, {'@': 118}), 31: (1, {'@': 118}), 18: (1, {'@': 118}), 32: (1, {'@': 118}), 33: (1, {'@': 118}), 34: (1, {'@': 118}), 35: (1, {'@': 118})}, 632: {37: (0, 709), 38: (0, 112), 39: (0, 716), 36: (0, 668), 24: (0, 711), 50: (0, 710), 40: (0, 724), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 34: (0, 152), 65: (0, 737), 66: (0, 59)}, 633: {0: (0, 452), 7: (0, 415), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 378}), 65: (1, {'@': 378}), 56: (1, {'@': 378}), 31: (1, {'@': 378}), 59: (1, {'@': 378}), 43: (1, {'@': 378}), 21: (1, {'@': 378}), 24: (1, {'@': 378}), 61: (1, {'@': 378}), 37: (1, {'@': 378})}, 634: {48: (1, {'@': 78}), 65: (1, {'@': 78}), 56: (1, {'@': 78}), 12: (1, {'@': 78}), 31: (1, {'@': 78}), 59: (1, {'@': 78}), 5: (1, {'@': 78}), 43: (1, {'@': 78}), 21: (1, {'@': 78}), 24: (1, {'@': 78}), 61: (1, {'@': 78}), 18: (1, {'@': 78}), 37: (1, {'@': 78})}, 635: {34: (0, 657)}, 636: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 12: (1, {'@': 435}), 5: (1, {'@': 435}), 27: (1, {'@': 435}), 18: (1, {'@': 435}), 32: (1, {'@': 435}), 28: (1, {'@': 435}), 34: (1, {'@': 435})}, 637: {22: (1, {'@': 94}), 19: (1, {'@': 94}), 23: (1, {'@': 94}), 21: (1, {'@': 94}), 24: (1, {'@': 94}), 3: (1, {'@': 94}), 11: (1, {'@': 94}), 14: (1, {'@': 94}), 17: (1, {'@': 94}), 4: (1, {'@': 94}), 10: (1, {'@': 94}), 15: (1, {'@': 94}), 6: (1, {'@': 94}), 25: (1, {'@': 94}), 2: (1, {'@': 94}), 9: (1, {'@': 94}), 13: (1, {'@': 94}), 26: (1, {'@': 94}), 20: (1, {'@': 94}), 1: (1, {'@': 94}), 5: (1, {'@': 94}), 27: (1, {'@': 94}), 28: (1, {'@': 94}), 29: (1, {'@': 94}), 30: (1, {'@': 94}), 12: (1, {'@': 94}), 31: (1, {'@': 94}), 18: (1, {'@': 94}), 32: (1, {'@': 94}), 33: (1, {'@': 94}), 34: (1, {'@': 94}), 35: (1, {'@': 94})}, 638: {0: (0, 452), 7: (0, 417), 12: (0, 405), 18: (0, 356), 5: (0, 371), 48: (1, {'@': 376}), 65: (1, {'@': 376}), 56: (1, {'@': 376}), 31: (1, {'@': 376}), 59: (1, {'@': 376}), 43: (1, {'@': 376}), 21: (1, {'@': 376}), 24: (1, {'@': 376}), 61: (1, {'@': 376}), 37: (1, {'@': 376})}, 639: {30: (1, {'@': 52}), 31: (1, {'@': 52}), 35: (1, {'@': 52}), 18: (1, {'@': 52}), 12: (1, {'@': 52}), 5: (1, {'@': 52})}, 640: {34: (0, 660)}, 641: {3: (0, 91)}, 642: {44: (0, 659), 59: (0, 23)}, 643: {0: (0, 452), 7: (0, 185), 18: (0, 356), 12: (0, 405), 5: (0, 371)}, 644: {22: (1, {'@': 216}), 19: (1, {'@': 216}), 23: (1, {'@': 216}), 21: (1, {'@': 216}), 24: (1, {'@': 216}), 3: (1, {'@': 216}), 11: (1, {'@': 216}), 14: (1, {'@': 216}), 17: (1, {'@': 216}), 4: (1, {'@': 216}), 10: (1, {'@': 216}), 15: (1, {'@': 216}), 6: (1, {'@': 216}), 25: (1, {'@': 216}), 2: (1, {'@': 216}), 9: (1, {'@': 216}), 13: (1, {'@': 216}), 26: (1, {'@': 216}), 20: (1, {'@': 216}), 1: (1, {'@': 216}), 5: (1, {'@': 216}), 27: (1, {'@': 216}), 28: (1, {'@': 216}), 29: (1, {'@': 216}), 30: (1, {'@': 216}), 12: (1, {'@': 216}), 31: (1, {'@': 216}), 18: (1, {'@': 216}), 32: (1, {'@': 216}), 33: (1, {'@': 216}), 34: (1, {'@': 216}), 35: (1, {'@': 216})}, 645: {22: (1, {'@': 128}), 19: (1, {'@': 128}), 23: (1, {'@': 128}), 21: (1, {'@': 128}), 24: (1, {'@': 128}), 3: (1, {'@': 128}), 11: (1, {'@': 128}), 14: (1, {'@': 128}), 17: (1, {'@': 128}), 4: (1, {'@': 128}), 10: (1, {'@': 128}), 15: (1, {'@': 128}), 6: (1, {'@': 128}), 25: (1, {'@': 128}), 2: (1, {'@': 128}), 9: (1, {'@': 128}), 13: (1, {'@': 128}), 26: (1, {'@': 128}), 20: (1, {'@': 128}), 1: (1, {'@': 128}), 5: (1, {'@': 128}), 27: (1, {'@': 128}), 28: (1, {'@': 128}), 29: (1, {'@': 128}), 30: (1, {'@': 128}), 12: (1, {'@': 128}), 31: (1, {'@': 128}), 18: (1, {'@': 128}), 32: (1, {'@': 128}), 33: (1, {'@': 128}), 34: (1, {'@': 128}), 35: (1, {'@': 128})}, 646: {3: (0, 419)}, 647: {37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 50: (0, 483), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 648: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 459), 29: (0, 327), 32: (0, 50), 68: (0, 103), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 30: (0, 108), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 649: {0: (0, 452), 7: (0, 195), 72: (0, 431), 12: (0, 405), 18: (0, 356), 5: (0, 371)}, 650: {34: (0, 667)}, 651: {34: (0, 10)}, 652: {30: (0, 619)}, 653: {0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 50: (0, 193), 21: (0, 734), 7: (0, 211), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 654: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 713), 7: (0, 665), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 655: {22: (1, {'@': 141}), 19: (1, {'@': 141}), 23: (1, {'@': 141}), 21: (1, {'@': 141}), 24: (1, {'@': 141}), 3: (1, {'@': 141}), 11: (1, {'@': 141}), 14: (1, {'@': 141}), 17: (1, {'@': 141}), 4: (1, {'@': 141}), 10: (1, {'@': 141}), 15: (1, {'@': 141}), 6: (1, {'@': 141}), 25: (1, {'@': 141}), 2: (1, {'@': 141}), 9: (1, {'@': 141}), 13: (1, {'@': 141}), 26: (1, {'@': 141}), 20: (1, {'@': 141}), 1: (1, {'@': 141}), 5: (1, {'@': 141}), 27: (1, {'@': 141}), 28: (1, {'@': 141}), 29: (1, {'@': 141}), 30: (1, {'@': 141}), 12: (1, {'@': 141}), 31: (1, {'@': 141}), 18: (1, {'@': 141}), 32: (1, {'@': 141}), 33: (1, {'@': 141}), 34: (1, {'@': 141}), 35: (1, {'@': 141})}, 656: {22: (1, {'@': 215}), 19: (1, {'@': 215}), 23: (1, {'@': 215}), 21: (1, {'@': 215}), 24: (1, {'@': 215}), 3: (1, {'@': 215}), 11: (1, {'@': 215}), 14: (1, {'@': 215}), 17: (1, {'@': 215}), 4: (1, {'@': 215}), 10: (1, {'@': 215}), 15: (1, {'@': 215}), 6: (1, {'@': 215}), 25: (1, {'@': 215}), 2: (1, {'@': 215}), 9: (1, {'@': 215}), 13: (1, {'@': 215}), 26: (1, {'@': 215}), 20: (1, {'@': 215}), 1: (1, {'@': 215}), 5: (1, {'@': 215}), 27: (1, {'@': 215}), 28: (1, {'@': 215}), 29: (1, {'@': 215}), 30: (1, {'@': 215}), 12: (1, {'@': 215}), 31: (1, {'@': 215}), 18: (1, {'@': 215}), 32: (1, {'@': 215}), 33: (1, {'@': 215}), 34: (1, {'@': 215}), 35: (1, {'@': 215})}, 657: {22: (1, {'@': 209}), 19: (1, {'@': 209}), 23: (1, {'@': 209}), 21: (1, {'@': 209}), 24: (1, {'@': 209}), 3: (1, {'@': 209}), 11: (1, {'@': 209}), 14: (1, {'@': 209}), 17: (1, {'@': 209}), 4: (1, {'@': 209}), 10: (1, {'@': 209}), 15: (1, {'@': 209}), 6: (1, {'@': 209}), 25: (1, {'@': 209}), 2: (1, {'@': 209}), 9: (1, {'@': 209}), 13: (1, {'@': 209}), 26: (1, {'@': 209}), 20: (1, {'@': 209}), 1: (1, {'@': 209}), 5: (1, {'@': 209}), 27: (1, {'@': 209}), 28: (1, {'@': 209}), 29: (1, {'@': 209}), 30: (1, {'@': 209}), 12: (1, {'@': 209}), 31: (1, {'@': 209}), 18: (1, {'@': 209}), 32: (1, {'@': 209}), 33: (1, {'@': 209}), 34: (1, {'@': 209}), 35: (1, {'@': 209})}, 658: {22: (1, {'@': 224}), 19: (1, {'@': 224}), 23: (1, {'@': 224}), 21: (1, {'@': 224}), 24: (1, {'@': 224}), 3: (1, {'@': 224}), 11: (1, {'@': 224}), 14: (1, {'@': 224}), 17: (1, {'@': 224}), 4: (1, {'@': 224}), 10: (1, {'@': 224}), 15: (1, {'@': 224}), 6: (1, {'@': 224}), 25: (1, {'@': 224}), 2: (1, {'@': 224}), 9: (1, {'@': 224}), 13: (1, {'@': 224}), 26: (1, {'@': 224}), 20: (1, {'@': 224}), 1: (1, {'@': 224}), 5: (1, {'@': 224}), 27: (1, {'@': 224}), 28: (1, {'@': 224}), 29: (1, {'@': 224}), 30: (1, {'@': 224}), 12: (1, {'@': 224}), 31: (1, {'@': 224}), 18: (1, {'@': 224}), 32: (1, {'@': 224}), 33: (1, {'@': 224}), 34: (1, {'@': 224}), 35: (1, {'@': 224})}, 659: {59: (0, 465), 67: (0, 622), 22: (1, {'@': 112}), 19: (1, {'@': 112}), 23: (1, {'@': 112}), 21: (1, {'@': 112}), 24: (1, {'@': 112}), 3: (1, {'@': 112}), 11: (1, {'@': 112}), 14: (1, {'@': 112}), 17: (1, {'@': 112}), 4: (1, {'@': 112}), 10: (1, {'@': 112}), 15: (1, {'@': 112}), 6: (1, {'@': 112}), 25: (1, {'@': 112}), 2: (1, {'@': 112}), 9: (1, {'@': 112}), 13: (1, {'@': 112}), 26: (1, {'@': 112}), 20: (1, {'@': 112}), 1: (1, {'@': 112}), 5: (1, {'@': 112}), 27: (1, {'@': 112}), 28: (1, {'@': 112}), 29: (1, {'@': 112}), 30: (1, {'@': 112}), 12: (1, {'@': 112}), 31: (1, {'@': 112}), 18: (1, {'@': 112}), 32: (1, {'@': 112}), 33: (1, {'@': 112}), 34: (1, {'@': 112}), 35: (1, {'@': 112})}, 660: {22: (1, {'@': 211}), 19: (1, {'@': 211}), 23: (1, {'@': 211}), 21: (1, {'@': 211}), 24: (1, {'@': 211}), 3: (1, {'@': 211}), 11: (1, {'@': 211}), 14: (1, {'@': 211}), 17: (1, {'@': 211}), 4: (1, {'@': 211}), 10: (1, {'@': 211}), 15: (1, {'@': 211}), 6: (1, {'@': 211}), 25: (1, {'@': 211}), 2: (1, {'@': 211}), 9: (1, {'@': 211}), 13: (1, {'@': 211}), 26: (1, {'@': 211}), 20: (1, {'@': 211}), 1: (1, {'@': 211}), 5: (1, {'@': 211}), 27: (1, {'@': 211}), 28: (1, {'@': 211}), 29: (1, {'@': 211}), 30: (1, {'@': 211}), 12: (1, {'@': 211}), 31: (1, {'@': 211}), 18: (1, {'@': 211}), 32: (1, {'@': 211}), 33: (1, {'@': 211}), 34: (1, {'@': 211}), 35: (1, {'@': 211})}, 661: {0: (0, 452), 18: (0, 356), 12: (0, 405), 30: (0, 346), 7: (0, 350), 5: (0, 371)}, 662: {26: (0, 686), 24: (0, 56), 23: (0, 696), 71: (0, 57), 22: (0, 62), 82: (0, 67), 70: (0, 72), 83: (0, 80), 19: (1, {'@': 73}), 21: (1, {'@': 73}), 3: (1, {'@': 73}), 11: (1, {'@': 73}), 14: (1, {'@': 73}), 17: (1, {'@': 73}), 4: (1, {'@': 73}), 10: (1, {'@': 73}), 15: (1, {'@': 73}), 6: (1, {'@': 73}), 25: (1, {'@': 73}), 2: (1, {'@': 73}), 9: (1, {'@': 73}), 13: (1, {'@': 73}), 20: (1, {'@': 73}), 1: (1, {'@': 73}), 34: (1, {'@': 73}), 5: (1, {'@': 73}), 27: (1, {'@': 73}), 28: (1, {'@': 73}), 29: (1, {'@': 73}), 30: (1, {'@': 73}), 12: (1, {'@': 73}), 31: (1, {'@': 73}), 35: (1, {'@': 73}), 18: (1, {'@': 73}), 32: (1, {'@': 73}), 33: (1, {'@': 73})}, 663: {31: (0, 348), 42: (0, 449)}, 664: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 9: (0, 83), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 30: (1, {'@': 413}), 5: (1, {'@': 413}), 18: (1, {'@': 413}), 12: (1, {'@': 413}), 34: (1, {'@': 413})}, 665: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 50: (0, 513), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 666: {0: (0, 452), 1: (0, 654), 7: (0, 276), 2: (0, 581), 3: (0, 253), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 667: {22: (1, {'@': 214}), 19: (1, {'@': 214}), 23: (1, {'@': 214}), 21: (1, {'@': 214}), 24: (1, {'@': 214}), 3: (1, {'@': 214}), 11: (1, {'@': 214}), 14: (1, {'@': 214}), 17: (1, {'@': 214}), 4: (1, {'@': 214}), 10: (1, {'@': 214}), 15: (1, {'@': 214}), 6: (1, {'@': 214}), 25: (1, {'@': 214}), 2: (1, {'@': 214}), 9: (1, {'@': 214}), 13: (1, {'@': 214}), 26: (1, {'@': 214}), 20: (1, {'@': 214}), 1: (1, {'@': 214}), 5: (1, {'@': 214}), 27: (1, {'@': 214}), 28: (1, {'@': 214}), 29: (1, {'@': 214}), 30: (1, {'@': 214}), 12: (1, {'@': 214}), 31: (1, {'@': 214}), 18: (1, {'@': 214}), 32: (1, {'@': 214}), 33: (1, {'@': 214}), 34: (1, {'@': 214}), 35: (1, {'@': 214})}, 668: {7: (0, 240), 0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 50: (0, 246), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 669: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 50: (0, 268), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59), 27: (1, {'@': 173}), 5: (1, {'@': 173}), 18: (1, {'@': 173}), 12: (1, {'@': 173})}, 670: {27: (1, {'@': 169}), 5: (1, {'@': 169}), 18: (1, {'@': 169}), 12: (1, {'@': 169})}, 671: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 636), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 672: {30: (0, 354)}, 673: {30: (1, {'@': 439}), 12: (1, {'@': 439}), 5: (1, {'@': 439}), 18: (1, {'@': 439}), 28: (1, {'@': 439})}, 674: {3: (0, 683)}, 675: {1: (0, 654), 6: (0, 66), 2: (0, 581), 10: (0, 87), 11: (0, 93), 13: (0, 98), 14: (0, 102), 8: (0, 70), 15: (0, 107), 16: (0, 26), 4: (0, 634), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 9: (0, 83), 3: (1, {'@': 64}), 25: (1, {'@': 64}), 34: (1, {'@': 64}), 5: (1, {'@': 64}), 27: (1, {'@': 64}), 28: (1, {'@': 64}), 29: (1, {'@': 64}), 30: (1, {'@': 64}), 12: (1, {'@': 64}), 31: (1, {'@': 64}), 35: (1, {'@': 64}), 18: (1, {'@': 64}), 32: (1, {'@': 64}), 33: (1, {'@': 64})}, 676: {0: (0, 452), 7: (0, 527), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 408}), 65: (1, {'@': 408}), 56: (1, {'@': 408}), 31: (1, {'@': 408}), 59: (1, {'@': 408}), 43: (1, {'@': 408}), 21: (1, {'@': 408}), 24: (1, {'@': 408}), 61: (1, {'@': 408}), 37: (1, {'@': 408})}, 677: {48: (1, {'@': 371}), 65: (1, {'@': 371}), 56: (1, {'@': 371}), 12: (1, {'@': 371}), 31: (1, {'@': 371}), 59: (1, {'@': 371}), 5: (1, {'@': 371}), 43: (1, {'@': 371}), 21: (1, {'@': 371}), 24: (1, {'@': 371}), 61: (1, {'@': 371}), 18: (1, {'@': 371}), 37: (1, {'@': 371})}, 678: {22: (1, {'@': 229}), 19: (1, {'@': 229}), 23: (1, {'@': 229}), 21: (1, {'@': 229}), 24: (1, {'@': 229}), 3: (1, {'@': 229}), 11: (1, {'@': 229}), 14: (1, {'@': 229}), 17: (1, {'@': 229}), 4: (1, {'@': 229}), 10: (1, {'@': 229}), 15: (1, {'@': 229}), 6: (1, {'@': 229}), 25: (1, {'@': 229}), 2: (1, {'@': 229}), 9: (1, {'@': 229}), 13: (1, {'@': 229}), 26: (1, {'@': 229}), 20: (1, {'@': 229}), 1: (1, {'@': 229}), 5: (1, {'@': 229}), 27: (1, {'@': 229}), 28: (1, {'@': 229}), 29: (1, {'@': 229}), 30: (1, {'@': 229}), 12: (1, {'@': 229}), 31: (1, {'@': 229}), 18: (1, {'@': 229}), 32: (1, {'@': 229}), 33: (1, {'@': 229}), 34: (1, {'@': 229}), 35: (1, {'@': 229})}, 679: {59: (0, 465), 22: (1, {'@': 113}), 19: (1, {'@': 113}), 23: (1, {'@': 113}), 21: (1, {'@': 113}), 24: (1, {'@': 113}), 3: (1, {'@': 113}), 11: (1, {'@': 113}), 14: (1, {'@': 113}), 17: (1, {'@': 113}), 4: (1, {'@': 113}), 10: (1, {'@': 113}), 15: (1, {'@': 113}), 6: (1, {'@': 113}), 25: (1, {'@': 113}), 2: (1, {'@': 113}), 9: (1, {'@': 113}), 13: (1, {'@': 113}), 26: (1, {'@': 113}), 20: (1, {'@': 113}), 1: (1, {'@': 113}), 5: (1, {'@': 113}), 27: (1, {'@': 113}), 28: (1, {'@': 113}), 29: (1, {'@': 113}), 30: (1, {'@': 113}), 12: (1, {'@': 113}), 31: (1, {'@': 113}), 18: (1, {'@': 113}), 32: (1, {'@': 113}), 33: (1, {'@': 113}), 34: (1, {'@': 113}), 35: (1, {'@': 113})}, 680: {30: (1, {'@': 440}), 12: (1, {'@': 440}), 5: (1, {'@': 440}), 18: (1, {'@': 440}), 28: (1, {'@': 440})}, 681: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 607), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59), 27: (1, {'@': 167}), 5: (1, {'@': 167}), 18: (1, {'@': 167}), 12: (1, {'@': 167})}, 682: {22: (1, {'@': 145}), 19: (1, {'@': 145}), 23: (1, {'@': 145}), 21: (1, {'@': 145}), 24: (1, {'@': 145}), 3: (1, {'@': 145}), 11: (1, {'@': 145}), 14: (1, {'@': 145}), 17: (1, {'@': 145}), 4: (1, {'@': 145}), 10: (1, {'@': 145}), 15: (1, {'@': 145}), 6: (1, {'@': 145}), 25: (1, {'@': 145}), 2: (1, {'@': 145}), 9: (1, {'@': 145}), 13: (1, {'@': 145}), 26: (1, {'@': 145}), 20: (1, {'@': 145}), 1: (1, {'@': 145}), 5: (1, {'@': 145}), 27: (1, {'@': 145}), 28: (1, {'@': 145}), 29: (1, {'@': 145}), 30: (1, {'@': 145}), 12: (1, {'@': 145}), 31: (1, {'@': 145}), 18: (1, {'@': 145}), 32: (1, {'@': 145}), 33: (1, {'@': 145}), 34: (1, {'@': 145}), 35: (1, {'@': 145})}, 683: {37: (0, 709), 24: (0, 711), 0: (0, 452), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 5: (0, 371), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 675), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 7: (0, 478), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 684: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 387), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 3: (0, 394), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 685: {30: (0, 359)}, 686: {23: (0, 663), 71: (0, 77), 84: (0, 169), 22: (1, {'@': 190}), 5: (1, {'@': 190}), 21: (1, {'@': 190}), 3: (1, {'@': 190}), 24: (1, {'@': 190}), 27: (1, {'@': 190}), 11: (1, {'@': 190}), 17: (1, {'@': 190}), 28: (1, {'@': 190}), 29: (1, {'@': 190}), 30: (1, {'@': 190}), 6: (1, {'@': 190}), 25: (1, {'@': 190}), 12: (1, {'@': 190}), 31: (1, {'@': 190}), 13: (1, {'@': 190}), 18: (1, {'@': 190}), 32: (1, {'@': 190}), 33: (1, {'@': 190}), 34: (1, {'@': 190}), 19: (1, {'@': 190}), 14: (1, {'@': 190}), 4: (1, {'@': 190}), 10: (1, {'@': 190}), 15: (1, {'@': 190}), 2: (1, {'@': 190}), 9: (1, {'@': 190}), 26: (1, {'@': 190}), 35: (1, {'@': 190}), 20: (1, {'@': 190}), 1: (1, {'@': 190})}, 687: {0: (0, 452), 28: (0, 553), 7: (0, 270), 12: (0, 405), 34: (0, 275), 18: (0, 356), 5: (0, 371)}, 688: {0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 536), 29: (0, 327), 34: (0, 311), 4: (0, 634), 5: (0, 371), 68: (0, 314), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 689: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 525), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 690: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 194), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 691: {22: (1, {'@': 230}), 19: (1, {'@': 230}), 23: (1, {'@': 230}), 21: (1, {'@': 230}), 24: (1, {'@': 230}), 3: (1, {'@': 230}), 11: (1, {'@': 230}), 14: (1, {'@': 230}), 17: (1, {'@': 230}), 4: (1, {'@': 230}), 10: (1, {'@': 230}), 15: (1, {'@': 230}), 6: (1, {'@': 230}), 25: (1, {'@': 230}), 2: (1, {'@': 230}), 9: (1, {'@': 230}), 13: (1, {'@': 230}), 26: (1, {'@': 230}), 20: (1, {'@': 230}), 1: (1, {'@': 230}), 5: (1, {'@': 230}), 27: (1, {'@': 230}), 28: (1, {'@': 230}), 29: (1, {'@': 230}), 30: (1, {'@': 230}), 12: (1, {'@': 230}), 31: (1, {'@': 230}), 18: (1, {'@': 230}), 32: (1, {'@': 230}), 33: (1, {'@': 230}), 34: (1, {'@': 230}), 35: (1, {'@': 230})}, 692: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 131), 5: (0, 371)}, 693: {7: (0, 164), 0: (0, 452), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 394}), 65: (1, {'@': 394}), 56: (1, {'@': 394}), 31: (1, {'@': 394}), 59: (1, {'@': 394}), 43: (1, {'@': 394}), 21: (1, {'@': 394}), 24: (1, {'@': 394}), 61: (1, {'@': 394}), 37: (1, {'@': 394})}, 694: {3: (0, 136)}, 695: {7: (0, 603), 0: (0, 452), 1: (0, 654), 2: (0, 581), 78: (0, 687), 28: (0, 334), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 34: (0, 655), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 696: {31: (0, 348), 44: (0, 322), 42: (0, 449), 59: (0, 23)}, 697: {61: (1, {'@': 422}), 31: (1, {'@': 422}), 37: (1, {'@': 422})}, 698: {48: (1, {'@': 355}), 65: (1, {'@': 355}), 56: (1, {'@': 355}), 12: (1, {'@': 355}), 31: (1, {'@': 355}), 59: (1, {'@': 355}), 5: (1, {'@': 355}), 43: (1, {'@': 355}), 21: (1, {'@': 355}), 24: (1, {'@': 355}), 61: (1, {'@': 355}), 18: (1, {'@': 355}), 37: (1, {'@': 355})}, 699: {26: (0, 686), 24: (0, 56), 23: (0, 696), 71: (0, 57), 22: (0, 62), 82: (0, 67), 70: (0, 72), 83: (0, 80), 19: (1, {'@': 74}), 21: (1, {'@': 74}), 3: (1, {'@': 74}), 11: (1, {'@': 74}), 14: (1, {'@': 74}), 17: (1, {'@': 74}), 4: (1, {'@': 74}), 10: (1, {'@': 74}), 15: (1, {'@': 74}), 6: (1, {'@': 74}), 25: (1, {'@': 74}), 2: (1, {'@': 74}), 9: (1, {'@': 74}), 13: (1, {'@': 74}), 20: (1, {'@': 74}), 1: (1, {'@': 74}), 34: (1, {'@': 74}), 5: (1, {'@': 74}), 27: (1, {'@': 74}), 28: (1, {'@': 74}), 29: (1, {'@': 74}), 30: (1, {'@': 74}), 12: (1, {'@': 74}), 31: (1, {'@': 74}), 35: (1, {'@': 74}), 18: (1, {'@': 74}), 32: (1, {'@': 74}), 33: (1, {'@': 74})}, 700: {0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 7: (0, 306), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 50: (0, 277), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 85: (0, 518), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 27: (0, 562), 65: (0, 737), 66: (0, 59)}, 701: {0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 7: (0, 712), 50: (0, 688), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 702: {0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 27: (0, 637), 14: (0, 102), 7: (0, 209), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 703: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 183), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 704: {0: (0, 452), 7: (0, 157), 18: (0, 356), 12: (0, 405), 5: (0, 371), 48: (1, {'@': 354}), 65: (1, {'@': 354}), 56: (1, {'@': 354}), 31: (1, {'@': 354}), 59: (1, {'@': 354}), 43: (1, {'@': 354}), 21: (1, {'@': 354}), 24: (1, {'@': 354}), 61: (1, {'@': 354}), 37: (1, {'@': 354})}, 705: {0: (0, 452), 30: (0, 678), 18: (0, 356), 12: (0, 405), 5: (0, 371), 7: (0, 685)}, 706: {7: (0, 647), 50: (0, 298), 37: (0, 709), 0: (0, 452), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 707: {22: (1, {'@': 254}), 19: (1, {'@': 254}), 23: (1, {'@': 254}), 21: (1, {'@': 254}), 24: (1, {'@': 254}), 3: (1, {'@': 254}), 11: (1, {'@': 254}), 14: (1, {'@': 254}), 17: (1, {'@': 254}), 4: (1, {'@': 254}), 10: (1, {'@': 254}), 15: (1, {'@': 254}), 6: (1, {'@': 254}), 25: (1, {'@': 254}), 2: (1, {'@': 254}), 9: (1, {'@': 254}), 13: (1, {'@': 254}), 26: (1, {'@': 254}), 20: (1, {'@': 254}), 1: (1, {'@': 254}), 5: (1, {'@': 254}), 27: (1, {'@': 254}), 28: (1, {'@': 254}), 29: (1, {'@': 254}), 30: (1, {'@': 254}), 12: (1, {'@': 254}), 31: (1, {'@': 254}), 18: (1, {'@': 254}), 32: (1, {'@': 254}), 33: (1, {'@': 254}), 34: (1, {'@': 254}), 35: (1, {'@': 254})}, 708: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 215), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 709: {0: (0, 452), 37: (0, 709), 36: (0, 706), 38: (0, 112), 39: (0, 716), 24: (0, 711), 40: (0, 724), 5: (0, 371), 42: (0, 118), 43: (0, 730), 44: (0, 731), 7: (0, 2), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 41: (0, 628), 50: (0, 13), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 30: (0, 18), 65: (0, 737), 66: (0, 59)}, 710: {78: (0, 310), 7: (0, 148), 1: (0, 654), 0: (0, 452), 2: (0, 581), 28: (0, 137), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 34: (0, 266), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48)}, 711: {0: (0, 452), 37: (0, 709), 38: (0, 112), 7: (0, 632), 39: (0, 716), 24: (0, 711), 40: (0, 724), 50: (0, 695), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 36: (0, 701), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 34: (0, 36), 51: (0, 12), 52: (0, 27), 12: (0, 405), 53: (0, 725), 54: (0, 726), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 712: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 50: (0, 328), 53: (0, 725), 54: (0, 726), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 713: {3: (0, 272), 0: (0, 452), 1: (0, 654), 2: (0, 581), 7: (0, 590), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 17: (0, 31), 18: (0, 356), 19: (0, 42), 20: (0, 48), 21: (0, 16)}, 714: {48: (1, {'@': 401}), 65: (1, {'@': 401}), 56: (1, {'@': 401}), 12: (1, {'@': 401}), 31: (1, {'@': 401}), 59: (1, {'@': 401}), 5: (1, {'@': 401}), 43: (1, {'@': 401}), 21: (1, {'@': 401}), 24: (1, {'@': 401}), 61: (1, {'@': 401}), 18: (1, {'@': 401}), 37: (1, {'@': 401})}, 715: {48: (1, {'@': 399}), 65: (1, {'@': 399}), 56: (1, {'@': 399}), 12: (1, {'@': 399}), 31: (1, {'@': 399}), 59: (1, {'@': 399}), 5: (1, {'@': 399}), 43: (1, {'@': 399}), 21: (1, {'@': 399}), 24: (1, {'@': 399}), 61: (1, {'@': 399}), 18: (1, {'@': 399}), 37: (1, {'@': 399})}, 716: {22: (1, {'@': 106}), 19: (1, {'@': 106}), 23: (1, {'@': 106}), 21: (1, {'@': 106}), 24: (1, {'@': 106}), 3: (1, {'@': 106}), 11: (1, {'@': 106}), 14: (1, {'@': 106}), 17: (1, {'@': 106}), 4: (1, {'@': 106}), 10: (1, {'@': 106}), 15: (1, {'@': 106}), 6: (1, {'@': 106}), 25: (1, {'@': 106}), 2: (1, {'@': 106}), 9: (1, {'@': 106}), 13: (1, {'@': 106}), 26: (1, {'@': 106}), 20: (1, {'@': 106}), 1: (1, {'@': 106}), 5: (1, {'@': 106}), 27: (1, {'@': 106}), 28: (1, {'@': 106}), 29: (1, {'@': 106}), 30: (1, {'@': 106}), 12: (1, {'@': 106}), 31: (1, {'@': 106}), 18: (1, {'@': 106}), 32: (1, {'@': 106}), 33: (1, {'@': 106}), 34: (1, {'@': 106}), 35: (1, {'@': 106})}, 717: {0: (0, 452), 18: (0, 356), 12: (0, 405), 7: (0, 168), 5: (0, 371), 48: (1, {'@': 398}), 65: (1, {'@': 398}), 56: (1, {'@': 398}), 31: (1, {'@': 398}), 59: (1, {'@': 398}), 43: (1, {'@': 398}), 21: (1, {'@': 398}), 24: (1, {'@': 398}), 61: (1, {'@': 398}), 37: (1, {'@': 398})}, 718: {48: (0, 735), 22: (1, {'@': 103}), 5: (1, {'@': 103}), 21: (1, {'@': 103}), 3: (1, {'@': 103}), 24: (1, {'@': 103}), 27: (1, {'@': 103}), 11: (1, {'@': 103}), 17: (1, {'@': 103}), 28: (1, {'@': 103}), 29: (1, {'@': 103}), 30: (1, {'@': 103}), 6: (1, {'@': 103}), 25: (1, {'@': 103}), 12: (1, {'@': 103}), 31: (1, {'@': 103}), 13: (1, {'@': 103}), 18: (1, {'@': 103}), 32: (1, {'@': 103}), 33: (1, {'@': 103}), 34: (1, {'@': 103}), 19: (1, {'@': 103}), 23: (1, {'@': 103}), 14: (1, {'@': 103}), 4: (1, {'@': 103}), 10: (1, {'@': 103}), 15: (1, {'@': 103}), 2: (1, {'@': 103}), 9: (1, {'@': 103}), 26: (1, {'@': 103}), 35: (1, {'@': 103}), 20: (1, {'@': 103}), 1: (1, {'@': 103})}, 719: {73: (0, 475), 0: (0, 452), 12: (0, 405), 7: (0, 351), 76: (0, 397), 42: (0, 363), 31: (0, 348), 75: (0, 355), 74: (0, 409), 18: (0, 356), 5: (0, 371), 30: (1, {'@': 48})}, 720: {22: (1, {'@': 282}), 19: (1, {'@': 282}), 23: (1, {'@': 282}), 21: (1, {'@': 282}), 24: (1, {'@': 282}), 3: (1, {'@': 282}), 11: (1, {'@': 282}), 14: (1, {'@': 282}), 17: (1, {'@': 282}), 4: (1, {'@': 282}), 10: (1, {'@': 282}), 15: (1, {'@': 282}), 6: (1, {'@': 282}), 25: (1, {'@': 282}), 2: (1, {'@': 282}), 9: (1, {'@': 282}), 13: (1, {'@': 282}), 26: (1, {'@': 282}), 20: (1, {'@': 282}), 1: (1, {'@': 282}), 5: (1, {'@': 282}), 27: (1, {'@': 282}), 28: (1, {'@': 282}), 29: (1, {'@': 282}), 30: (1, {'@': 282}), 12: (1, {'@': 282}), 31: (1, {'@': 282}), 18: (1, {'@': 282}), 32: (1, {'@': 282}), 33: (1, {'@': 282}), 34: (1, {'@': 282}), 35: (1, {'@': 282})}, 721: {7: (0, 424), 0: (0, 452), 1: (0, 654), 2: (0, 581), 4: (0, 634), 5: (0, 371), 6: (0, 66), 8: (0, 70), 9: (0, 83), 10: (0, 87), 11: (0, 93), 12: (0, 405), 13: (0, 98), 14: (0, 102), 15: (0, 107), 16: (0, 26), 18: (0, 356), 17: (0, 31), 21: (0, 16), 19: (0, 42), 20: (0, 48), 30: (1, {'@': 50}), 31: (1, {'@': 50}), 35: (1, {'@': 50})}, 722: {73: (0, 475), 0: (0, 452), 74: (0, 111), 12: (0, 405), 76: (0, 397), 42: (0, 363), 7: (0, 115), 31: (0, 348), 75: (0, 355), 18: (0, 356), 5: (0, 371), 30: (1, {'@': 48})}, 723: {0: (0, 452), 29: (0, 327), 7: (0, 173), 12: (0, 405), 30: (0, 184), 18: (0, 356), 68: (0, 188), 5: (0, 371)}, 724: {26: (0, 686), 24: (0, 56), 23: (0, 696), 71: (0, 57), 22: (0, 62), 82: (0, 67), 70: (0, 72), 83: (0, 80), 15: (1, {'@': 60}), 6: (1, {'@': 60}), 25: (1, {'@': 60}), 17: (1, {'@': 60}), 2: (1, {'@': 60}), 9: (1, {'@': 60}), 13: (1, {'@': 60}), 19: (1, {'@': 60}), 20: (1, {'@': 60}), 21: (1, {'@': 60}), 3: (1, {'@': 60}), 11: (1, {'@': 60}), 14: (1, {'@': 60}), 4: (1, {'@': 60}), 10: (1, {'@': 60}), 1: (1, {'@': 60}), 34: (1, {'@': 60}), 5: (1, {'@': 60}), 27: (1, {'@': 60}), 28: (1, {'@': 60}), 29: (1, {'@': 60}), 30: (1, {'@': 60}), 12: (1, {'@': 60}), 31: (1, {'@': 60}), 35: (1, {'@': 60}), 18: (1, {'@': 60}), 32: (1, {'@': 60}), 33: (1, {'@': 60})}, 725: {15: (1, {'@': 61}), 6: (1, {'@': 61}), 25: (1, {'@': 61}), 17: (1, {'@': 61}), 2: (1, {'@': 61}), 9: (1, {'@': 61}), 13: (1, {'@': 61}), 19: (1, {'@': 61}), 20: (1, {'@': 61}), 21: (1, {'@': 61}), 3: (1, {'@': 61}), 11: (1, {'@': 61}), 14: (1, {'@': 61}), 4: (1, {'@': 61}), 10: (1, {'@': 61}), 1: (1, {'@': 61}), 34: (1, {'@': 61}), 5: (1, {'@': 61}), 27: (1, {'@': 61}), 28: (1, {'@': 61}), 29: (1, {'@': 61}), 30: (1, {'@': 61}), 12: (1, {'@': 61}), 31: (1, {'@': 61}), 35: (1, {'@': 61}), 18: (1, {'@': 61}), 32: (1, {'@': 61}), 33: (1, {'@': 61})}, 726: {19: (1, {'@': 72}), 21: (1, {'@': 72}), 3: (1, {'@': 72}), 11: (1, {'@': 72}), 14: (1, {'@': 72}), 17: (1, {'@': 72}), 4: (1, {'@': 72}), 10: (1, {'@': 72}), 15: (1, {'@': 72}), 6: (1, {'@': 72}), 25: (1, {'@': 72}), 2: (1, {'@': 72}), 9: (1, {'@': 72}), 13: (1, {'@': 72}), 20: (1, {'@': 72}), 1: (1, {'@': 72}), 34: (1, {'@': 72}), 5: (1, {'@': 72}), 27: (1, {'@': 72}), 28: (1, {'@': 72}), 29: (1, {'@': 72}), 30: (1, {'@': 72}), 12: (1, {'@': 72}), 31: (1, {'@': 72}), 35: (1, {'@': 72}), 18: (1, {'@': 72}), 32: (1, {'@': 72}), 33: (1, {'@': 72})}, 727: {22: (1, {'@': 226}), 19: (1, {'@': 226}), 23: (1, {'@': 226}), 21: (1, {'@': 226}), 24: (1, {'@': 226}), 3: (1, {'@': 226}), 11: (1, {'@': 226}), 14: (1, {'@': 226}), 17: (1, {'@': 226}), 4: (1, {'@': 226}), 10: (1, {'@': 226}), 15: (1, {'@': 226}), 6: (1, {'@': 226}), 25: (1, {'@': 226}), 2: (1, {'@': 226}), 9: (1, {'@': 226}), 13: (1, {'@': 226}), 26: (1, {'@': 226}), 20: (1, {'@': 226}), 1: (1, {'@': 226}), 5: (1, {'@': 226}), 27: (1, {'@': 226}), 28: (1, {'@': 226}), 29: (1, {'@': 226}), 30: (1, {'@': 226}), 12: (1, {'@': 226}), 31: (1, {'@': 226}), 18: (1, {'@': 226}), 32: (1, {'@': 226}), 33: (1, {'@': 226}), 34: (1, {'@': 226}), 35: (1, {'@': 226})}, 728: {0: (0, 452), 37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 40: (0, 724), 53: (0, 725), 54: (0, 726), 5: (0, 371), 48: (0, 728), 43: (0, 730), 44: (0, 731), 21: (0, 734), 55: (0, 740), 45: (0, 742), 46: (0, 744), 50: (0, 702), 47: (0, 746), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 7: (0, 708), 18: (0, 356), 51: (0, 12), 58: (0, 17), 59: (0, 23), 52: (0, 27), 60: (0, 30), 12: (0, 405), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 729: {0: (0, 452), 29: (0, 327), 68: (0, 705), 18: (0, 356), 12: (0, 405), 30: (0, 53), 7: (0, 197), 5: (0, 371)}, 730: {22: (1, {'@': 158}), 19: (1, {'@': 158}), 23: (1, {'@': 158}), 21: (1, {'@': 158}), 24: (1, {'@': 158}), 3: (1, {'@': 158}), 11: (1, {'@': 158}), 14: (1, {'@': 158}), 17: (1, {'@': 158}), 4: (1, {'@': 158}), 10: (1, {'@': 158}), 15: (1, {'@': 158}), 6: (1, {'@': 158}), 25: (1, {'@': 158}), 2: (1, {'@': 158}), 9: (1, {'@': 158}), 13: (1, {'@': 158}), 26: (1, {'@': 158}), 20: (1, {'@': 158}), 1: (1, {'@': 158}), 5: (1, {'@': 158}), 27: (1, {'@': 158}), 28: (1, {'@': 158}), 29: (1, {'@': 158}), 30: (1, {'@': 158}), 12: (1, {'@': 158}), 31: (1, {'@': 158}), 18: (1, {'@': 158}), 32: (1, {'@': 158}), 33: (1, {'@': 158}), 34: (1, {'@': 158}), 35: (1, {'@': 158})}, 731: {23: (0, 642), 59: (0, 465), 67: (0, 89), 22: (1, {'@': 110}), 19: (1, {'@': 110}), 21: (1, {'@': 110}), 24: (1, {'@': 110}), 3: (1, {'@': 110}), 11: (1, {'@': 110}), 14: (1, {'@': 110}), 17: (1, {'@': 110}), 4: (1, {'@': 110}), 10: (1, {'@': 110}), 15: (1, {'@': 110}), 6: (1, {'@': 110}), 25: (1, {'@': 110}), 2: (1, {'@': 110}), 9: (1, {'@': 110}), 13: (1, {'@': 110}), 26: (1, {'@': 110}), 20: (1, {'@': 110}), 1: (1, {'@': 110}), 5: (1, {'@': 110}), 27: (1, {'@': 110}), 28: (1, {'@': 110}), 29: (1, {'@': 110}), 30: (1, {'@': 110}), 12: (1, {'@': 110}), 31: (1, {'@': 110}), 18: (1, {'@': 110}), 32: (1, {'@': 110}), 33: (1, {'@': 110}), 34: (1, {'@': 110}), 35: (1, {'@': 110})}, 732: {61: (1, {'@': 421}), 31: (1, {'@': 421}), 37: (1, {'@': 421})}, 733: {0: (0, 452), 7: (0, 177), 18: (0, 356), 12: (0, 405), 5: (0, 371), 30: (0, 204)}, 734: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 48: (0, 728), 43: (0, 730), 44: (0, 731), 55: (0, 740), 45: (0, 742), 46: (0, 744), 40: (0, 662), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 66: (0, 59)}, 735: {0: (0, 452), 37: (0, 709), 39: (0, 716), 24: (0, 711), 40: (0, 724), 85: (0, 576), 5: (0, 371), 42: (0, 718), 43: (0, 730), 44: (0, 731), 21: (0, 734), 45: (0, 742), 46: (0, 744), 47: (0, 746), 48: (0, 728), 49: (0, 748), 50: (0, 277), 51: (0, 12), 52: (0, 27), 12: (0, 405), 7: (0, 700), 53: (0, 725), 54: (0, 726), 27: (0, 165), 55: (0, 740), 31: (0, 348), 56: (0, 1), 57: (0, 6), 18: (0, 356), 58: (0, 17), 59: (0, 23), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 65: (0, 737), 66: (0, 59)}, 736: {48: (1, {'@': 357}), 65: (1, {'@': 357}), 56: (1, {'@': 357}), 12: (1, {'@': 357}), 31: (1, {'@': 357}), 59: (1, {'@': 357}), 5: (1, {'@': 357}), 43: (1, {'@': 357}), 21: (1, {'@': 357}), 24: (1, {'@': 357}), 61: (1, {'@': 357}), 18: (1, {'@': 357}), 37: (1, {'@': 357})}, 737: {37: (0, 709), 24: (0, 711), 39: (0, 716), 42: (0, 718), 48: (0, 728), 43: (0, 730), 44: (0, 731), 55: (0, 740), 45: (0, 742), 46: (0, 744), 40: (0, 699), 31: (0, 348), 49: (0, 748), 56: (0, 1), 57: (0, 6), 51: (0, 12), 59: (0, 23), 52: (0, 27), 60: (0, 30), 61: (0, 35), 62: (0, 40), 63: (0, 45), 64: (0, 49), 66: (0, 59)}, 738: {42: (0, 301), 31: (0, 348)}, 739: {35: (1, {'@': 43})}, 740: {22: (1, {'@': 108}), 19: (1, {'@': 108}), 23: (1, {'@': 108}), 21: (1, {'@': 108}), 24: (1, {'@': 108}), 3: (1, {'@': 108}), 11: (1, {'@': 108}), 14: (1, {'@': 108}), 17: (1, {'@': 108}), 4: (1, {'@': 108}), 10: (1, {'@': 108}), 15: (1, {'@': 108}), 6: (1, {'@': 108}), 25: (1, {'@': 108}), 2: (1, {'@': 108}), 9: (1, {'@': 108}), 13: (1, {'@': 108}), 26: (1, {'@': 108}), 20: (1, {'@': 108}), 1: (1, {'@': 108}), 5: (1, {'@': 108}), 27: (1, {'@': 108}), 28: (1, {'@': 108}), 29: (1, {'@': 108}), 30: (1, {'@': 108}), 12: (1, {'@': 108}), 31: (1, {'@': 108}), 18: (1, {'@': 108}), 32: (1, {'@': 108}), 33: (1, {'@': 108}), 34: (1, {'@': 108}), 35: (1, {'@': 108})}, 741: {22: (1, {'@': 234}), 19: (1, {'@': 234}), 23: (1, {'@': 234}), 21: (1, {'@': 234}), 24: (1, {'@': 234}), 3: (1, {'@': 234}), 11: (1, {'@': 234}), 14: (1, {'@': 234}), 17: (1, {'@': 234}), 4: (1, {'@': 234}), 10: (1, {'@': 234}), 15: (1, {'@': 234}), 6: (1, {'@': 234}), 25: (1, {'@': 234}), 2: (1, {'@': 234}), 9: (1, {'@': 234}), 13: (1, {'@': 234}), 26: (1, {'@': 234}), 20: (1, {'@': 234}), 1: (1, {'@': 234}), 5: (1, {'@': 234}), 27: (1, {'@': 234}), 28: (1, {'@': 234}), 29: (1, {'@': 234}), 30: (1, {'@': 234}), 12: (1, {'@': 234}), 31: (1, {'@': 234}), 18: (1, {'@': 234}), 32: (1, {'@': 234}), 33: (1, {'@': 234}), 34: (1, {'@': 234}), 35: (1, {'@': 234})}, 742: {22: (1, {'@': 100}), 19: (1, {'@': 100}), 23: (1, {'@': 100}), 21: (1, {'@': 100}), 24: (1, {'@': 100}), 3: (1, {'@': 100}), 11: (1, {'@': 100}), 14: (1, {'@': 100}), 17: (1, {'@': 100}), 4: (1, {'@': 100}), 10: (1, {'@': 100}), 15: (1, {'@': 100}), 6: (1, {'@': 100}), 25: (1, {'@': 100}), 2: (1, {'@': 100}), 9: (1, {'@': 100}), 13: (1, {'@': 100}), 26: (1, {'@': 100}), 20: (1, {'@': 100}), 1: (1, {'@': 100}), 5: (1, {'@': 100}), 27: (1, {'@': 100}), 28: (1, {'@': 100}), 29: (1, {'@': 100}), 30: (1, {'@': 100}), 12: (1, {'@': 100}), 31: (1, {'@': 100}), 18: (1, {'@': 100}), 32: (1, {'@': 100}), 33: (1, {'@': 100}), 34: (1, {'@': 100}), 35: (1, {'@': 100})}, 743: {30: (0, 482)}, 744: {22: (1, {'@': 109}), 19: (1, {'@': 109}), 23: (1, {'@': 109}), 21: (1, {'@': 109}), 24: (1, {'@': 109}), 3: (1, {'@': 109}), 11: (1, {'@': 109}), 14: (1, {'@': 109}), 17: (1, {'@': 109}), 4: (1, {'@': 109}), 10: (1, {'@': 109}), 15: (1, {'@': 109}), 6: (1, {'@': 109}), 25: (1, {'@': 109}), 2: (1, {'@': 109}), 9: (1, {'@': 109}), 13: (1, {'@': 109}), 26: (1, {'@': 109}), 20: (1, {'@': 109}), 1: (1, {'@': 109}), 5: (1, {'@': 109}), 27: (1, {'@': 109}), 28: (1, {'@': 109}), 29: (1, {'@': 109}), 30: (1, {'@': 109}), 12: (1, {'@': 109}), 31: (1, {'@': 109}), 18: (1, {'@': 109}), 32: (1, {'@': 109}), 33: (1, {'@': 109}), 34: (1, {'@': 109}), 35: (1, {'@': 109})}, 745: {22: (1, {'@': 245}), 19: (1, {'@': 245}), 23: (1, {'@': 245}), 21: (1, {'@': 245}), 24: (1, {'@': 245}), 3: (1, {'@': 245}), 11: (1, {'@': 245}), 14: (1, {'@': 245}), 17: (1, {'@': 245}), 4: (1, {'@': 245}), 10: (1, {'@': 245}), 15: (1, {'@': 245}), 6: (1, {'@': 245}), 25: (1, {'@': 245}), 2: (1, {'@': 245}), 9: (1, {'@': 245}), 13: (1, {'@': 245}), 26: (1, {'@': 245}), 20: (1, {'@': 245}), 1: (1, {'@': 245}), 5: (1, {'@': 245}), 27: (1, {'@': 245}), 28: (1, {'@': 245}), 29: (1, {'@': 245}), 30: (1, {'@': 245}), 12: (1, {'@': 245}), 31: (1, {'@': 245}), 18: (1, {'@': 245}), 32: (1, {'@': 245}), 33: (1, {'@': 245}), 34: (1, {'@': 245}), 35: (1, {'@': 245})}, 746: {15: (1, {'@': 62}), 6: (1, {'@': 62}), 25: (1, {'@': 62}), 17: (1, {'@': 62}), 2: (1, {'@': 62}), 9: (1, {'@': 62}), 13: (1, {'@': 62}), 19: (1, {'@': 62}), 20: (1, {'@': 62}), 21: (1, {'@': 62}), 3: (1, {'@': 62}), 11: (1, {'@': 62}), 14: (1, {'@': 62}), 4: (1, {'@': 62}), 10: (1, {'@': 62}), 1: (1, {'@': 62}), 34: (1, {'@': 62}), 5: (1, {'@': 62}), 27: (1, {'@': 62}), 28: (1, {'@': 62}), 29: (1, {'@': 62}), 30: (1, {'@': 62}), 12: (1, {'@': 62}), 31: (1, {'@': 62}), 35: (1, {'@': 62}), 18: (1, {'@': 62}), 32: (1, {'@': 62}), 33: (1, {'@': 62})}, 747: {22: (1, {'@': 268}), 19: (1, {'@': 268}), 23: (1, {'@': 268}), 21: (1, {'@': 268}), 24: (1, {'@': 268}), 3: (1, {'@': 268}), 11: (1, {'@': 268}), 14: (1, {'@': 268}), 17: (1, {'@': 268}), 4: (1, {'@': 268}), 10: (1, {'@': 268}), 15: (1, {'@': 268}), 6: (1, {'@': 268}), 25: (1, {'@': 268}), 2: (1, {'@': 268}), 9: (1, {'@': 268}), 13: (1, {'@': 268}), 26: (1, {'@': 268}), 20: (1, {'@': 268}), 1: (1, {'@': 268}), 5: (1, {'@': 268}), 27: (1, {'@': 268}), 28: (1, {'@': 268}), 29: (1, {'@': 268}), 30: (1, {'@': 268}), 12: (1, {'@': 268}), 31: (1, {'@': 268}), 18: (1, {'@': 268}), 32: (1, {'@': 268}), 33: (1, {'@': 268}), 34: (1, {'@': 268}), 35: (1, {'@': 268})}, 748: {22: (1, {'@': 104}), 19: (1, {'@': 104}), 23: (1, {'@': 104}), 21: (1, {'@': 104}), 24: (1, {'@': 104}), 3: (1, {'@': 104}), 11: (1, {'@': 104}), 14: (1, {'@': 104}), 17: (1, {'@': 104}), 4: (1, {'@': 104}), 10: (1, {'@': 104}), 15: (1, {'@': 104}), 6: (1, {'@': 104}), 25: (1, {'@': 104}), 2: (1, {'@': 104}), 9: (1, {'@': 104}), 13: (1, {'@': 104}), 26: (1, {'@': 104}), 20: (1, {'@': 104}), 1: (1, {'@': 104}), 5: (1, {'@': 104}), 27: (1, {'@': 104}), 28: (1, {'@': 104}), 29: (1, {'@': 104}), 30: (1, {'@': 104}), 12: (1, {'@': 104}), 31: (1, {'@': 104}), 18: (1, {'@': 104}), 32: (1, {'@': 104}), 33: (1, {'@': 104}), 34: (1, {'@': 104}), 35: (1, {'@': 104})}}, 'start_states': {'start': 601}, 'end_states': {'start': 341}}, '__type__': 'ParsingFrontend'}, 'rules': [{'@': 43}, {'@': 44}, {'@': 45}, {'@': 46}, {'@': 47}, {'@': 48}, {'@': 49}, {'@': 50}, {'@': 51}, {'@': 52}, {'@': 53}, {'@': 54}, {'@': 55}, {'@': 56}, {'@': 57}, {'@': 58}, {'@': 59}, {'@': 60}, {'@': 61}, {'@': 62}, {'@': 63}, {'@': 64}, {'@': 65}, {'@': 66}, {'@': 67}, {'@': 68}, {'@': 69}, {'@': 70}, {'@': 71}, {'@': 72}, {'@': 73}, {'@': 74}, {'@': 75}, {'@': 76}, {'@': 77}, {'@': 78}, {'@': 79}, {'@': 80}, {'@': 81}, {'@': 82}, {'@': 83}, {'@': 84}, {'@': 85}, {'@': 86}, {'@': 87}, {'@': 88}, {'@': 89}, {'@': 90}, {'@': 91}, {'@': 92}, {'@': 93}, {'@': 94}, {'@': 95}, {'@': 96}, {'@': 97}, {'@': 98}, {'@': 99}, {'@': 100}, {'@': 101}, {'@': 102}, {'@': 103}, {'@': 104}, {'@': 105}, {'@': 106}, {'@': 107}, {'@': 108}, {'@': 109}, {'@': 110}, {'@': 111}, {'@': 112}, {'@': 113}, {'@': 114}, {'@': 115}, {'@': 116}, {'@': 117}, {'@': 118}, {'@': 119}, {'@': 120}, {'@': 121}, {'@': 122}, {'@': 123}, {'@': 124}, {'@': 125}, {'@': 126}, {'@': 127}, {'@': 128}, {'@': 129}, {'@': 130}, {'@': 131}, {'@': 132}, {'@': 133}, {'@': 134}, {'@': 135}, {'@': 136}, {'@': 137}, {'@': 138}, {'@': 139}, {'@': 140}, {'@': 141}, {'@': 142}, {'@': 143}, {'@': 144}, {'@': 145}, {'@': 146}, {'@': 147}, {'@': 148}, {'@': 149}, {'@': 150}, {'@': 151}, {'@': 152}, {'@': 153}, {'@': 154}, {'@': 155}, {'@': 156}, {'@': 157}, {'@': 158}, {'@': 159}, {'@': 160}, {'@': 161}, {'@': 162}, {'@': 163}, {'@': 164}, {'@': 165}, {'@': 166}, {'@': 167}, {'@': 168}, {'@': 169}, {'@': 170}, {'@': 171}, {'@': 172}, {'@': 173}, {'@': 174}, {'@': 175}, {'@': 176}, {'@': 177}, {'@': 178}, {'@': 179}, {'@': 180}, {'@': 181}, {'@': 182}, {'@': 183}, {'@': 184}, {'@': 185}, {'@': 186}, {'@': 187}, {'@': 188}, {'@': 189}, {'@': 190}, {'@': 191}, {'@': 192}, {'@': 193}, {'@': 194}, {'@': 195}, {'@': 196}, {'@': 197}, {'@': 198}, {'@': 199}, {'@': 200}, {'@': 201}, {'@': 202}, {'@': 203}, {'@': 204}, {'@': 205}, {'@': 206}, {'@': 207}, {'@': 208}, {'@': 209}, {'@': 210}, {'@': 211}, {'@': 212}, {'@': 213}, {'@': 214}, {'@': 215}, {'@': 216}, {'@': 217}, {'@': 218}, {'@': 219}, {'@': 220}, {'@': 221}, {'@': 222}, {'@': 223}, {'@': 224}, {'@': 225}, {'@': 226}, {'@': 227}, {'@': 228}, {'@': 229}, {'@': 230}, {'@': 231}, {'@': 232}, {'@': 233}, {'@': 234}, {'@': 235}, {'@': 236}, {'@': 237}, {'@': 238}, {'@': 239}, {'@': 240}, {'@': 241}, {'@': 242}, {'@': 243}, {'@': 244}, {'@': 245}, {'@': 246}, {'@': 247}, {'@': 248}, {'@': 249}, {'@': 250}, {'@': 251}, {'@': 252}, {'@': 253}, {'@': 254}, {'@': 255}, {'@': 256}, {'@': 257}, {'@': 258}, {'@': 259}, {'@': 260}, {'@': 261}, {'@': 262}, {'@': 263}, {'@': 264}, {'@': 265}, {'@': 266}, {'@': 267}, {'@': 268}, {'@': 269}, {'@': 270}, {'@': 271}, {'@': 272}, {'@': 273}, {'@': 274}, {'@': 275}, {'@': 276}, {'@': 277}, {'@': 278}, {'@': 279}, {'@': 280}, {'@': 281}, {'@': 282}, {'@': 283}, {'@': 284}, {'@': 285}, {'@': 286}, {'@': 287}, {'@': 288}, {'@': 289}, {'@': 290}, {'@': 291}, {'@': 292}, {'@': 293}, {'@': 294}, {'@': 295}, {'@': 296}, {'@': 297}, {'@': 298}, {'@': 299}, {'@': 300}, {'@': 301}, {'@': 302}, {'@': 303}, {'@': 304}, {'@': 305}, {'@': 306}, {'@': 307}, {'@': 308}, {'@': 309}, {'@': 310}, {'@': 311}, {'@': 312}, {'@': 313}, {'@': 314}, {'@': 315}, {'@': 316}, {'@': 317}, {'@': 318}, {'@': 319}, {'@': 320}, {'@': 321}, {'@': 322}, {'@': 323}, {'@': 324}, {'@': 325}, {'@': 326}, {'@': 327}, {'@': 328}, {'@': 329}, {'@': 330}, {'@': 331}, {'@': 332}, {'@': 333}, {'@': 334}, {'@': 335}, {'@': 336}, {'@': 337}, {'@': 338}, {'@': 339}, {'@': 340}, {'@': 341}, {'@': 342}, {'@': 343}, {'@': 344}, {'@': 345}, {'@': 346}, {'@': 347}, {'@': 348}, {'@': 349}, {'@': 350}, {'@': 351}, {'@': 352}, {'@': 353}, {'@': 354}, {'@': 355}, {'@': 356}, {'@': 357}, {'@': 358}, {'@': 359}, {'@': 360}, {'@': 361}, {'@': 362}, {'@': 363}, {'@': 364}, {'@': 365}, {'@': 366}, {'@': 367}, {'@': 368}, {'@': 369}, {'@': 370}, {'@': 371}, {'@': 372}, {'@': 373}, {'@': 374}, {'@': 375}, {'@': 376}, {'@': 377}, {'@': 378}, {'@': 379}, {'@': 380}, {'@': 381}, {'@': 382}, {'@': 383}, {'@': 384}, {'@': 385}, {'@': 386}, {'@': 387}, {'@': 388}, {'@': 389}, {'@': 390}, {'@': 391}, {'@': 392}, {'@': 393}, {'@': 394}, {'@': 395}, {'@': 396}, {'@': 397}, {'@': 398}, {'@': 399}, {'@': 400}, {'@': 401}, {'@': 402}, {'@': 403}, {'@': 404}, {'@': 405}, {'@': 406}, {'@': 407}, {'@': 408}, {'@': 409}, {'@': 410}, {'@': 411}, {'@': 412}, {'@': 413}, {'@': 414}, {'@': 415}, {'@': 416}, {'@': 417}, {'@': 418}, {'@': 419}, {'@': 420}, {'@': 421}, {'@': 422}, {'@': 423}, {'@': 424}, {'@': 425}, {'@': 426}, {'@': 427}, {'@': 428}, {'@': 429}, {'@': 430}, {'@': 431}, {'@': 432}, {'@': 433}, {'@': 434}, {'@': 435}, {'@': 436}, {'@': 437}, {'@': 438}, {'@': 439}, {'@': 440}, {'@': 441}, {'@': 442}, {'@': 443}, {'@': 444}, {'@': 445}, {'@': 446}], 'options': {'debug': False, 'keep_all_tokens': False, 'tree_class': None, 'cache': False, 'postlex': None, 'parser': 'lalr', 'lexer': 'contextual', 'transformer': None, 'start': ['start'], 'priority': 'normal', 'ambiguity': 'auto', 'regex': False, 'propagate_positions': False, 'lexer_callbacks': {}, 'maybe_placeholders': True, 'edit_terminals': None, 'g_regex_flags': 0, 'use_bytes': False, 'import_paths': [], 'source_path': None, '_plugins': {}}, '__type__': 'Lark'}
)
MEMO = (
{0: {'name': 'STRING_LIT', 'pattern': {'value': '"(?:(?:\\$\\{(?:(?:\\$\\{[^}]+\\}|(?:(?!\\${)([^}]))+))+\\}|(?:(?:(?!\\${)([^"\\\\]|\\\\.))+)+))*"', 'flags': [], '_width': [2, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 1: {'name': 'DECIMAL', 'pattern': {'value': '[0-9]', 'flags': [], '_width': [1, 1], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 2: {'name': 'EXP_MARK', 'pattern': {'value': '(?:e|E)(?:(?:\\+|\\-))?', 'flags': [], '_width': [1, 2], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 3: {'name': '__IGNORE_0', 'pattern': {'value': '[ \t]+', 'flags': [], '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 4: {'name': '__IGNORE_1', 'pattern': {'value': '\\/\\*(.|\n)*?(\\*\\/)', 'flags': [], '_width': [4, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 5: {'name': 'EQUAL', 'pattern': {'value': '=', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 6: {'name': 'LBRACE', 'pattern': {'value': '{', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 7: {'name': 'RBRACE', 'pattern': {'value': '}', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 8: {'name': 'COMMA', 'pattern': {'value': ',', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 9: {'name': '__ANON_0', 'pattern': {'value': '\n', 'flags': [], '_width': [1, 1], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 10: {'name': '__ANON_1', 'pattern': {'value': '#.*\n', 'flags': [], '_width': [2, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 11: {'name': '__ANON_2', 'pattern': {'value': '\\/\\/.*\n', 'flags': [], '_width': [3, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 12: {'name': '__ANON_3', 'pattern': {'value': '[a-zA-Z_][a-zA-Z0-9_-]*', 'flags': [], '_width': [1, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 13: {'name': 'QMARK', 'pattern': {'value': '?', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 14: {'name': 'COLON', 'pattern': {'value': ':', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 15: {'name': 'MINUS', 'pattern': {'value': '-', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 16: {'name': 'BANG', 'pattern': {'value': '!', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 17: {'name': '__ANON_4', 'pattern': {'value': '==', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 18: {'name': '__ANON_5', 'pattern': {'value': '!=', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 19: {'name': 'LESSTHAN', 'pattern': {'value': '<', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 20: {'name': 'MORETHAN', 'pattern': {'value': '>', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 21: {'name': '__ANON_6', 'pattern': {'value': '<=', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 22: {'name': '__ANON_7', 'pattern': {'value': '>=', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 23: {'name': 'STAR', 'pattern': {'value': '*', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 24: {'name': 'SLASH', 'pattern': {'value': '/', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 25: {'name': 'PERCENT', 'pattern': {'value': '%', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 26: {'name': '__ANON_8', 'pattern': {'value': '&&', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 27: {'name': '__ANON_9', 'pattern': {'value': '||', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 28: {'name': 'PLUS', 'pattern': {'value': '+', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 29: {'name': 'LPAR', 'pattern': {'value': '(', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 30: {'name': 'RPAR', 'pattern': {'value': ')', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 31: {'name': 'DOT', 'pattern': {'value': '.', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 32: {'name': 'LSQB', 'pattern': {'value': '[', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 33: {'name': 'RSQB', 'pattern': {'value': ']', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 34: {'name': '__ANON_10', 'pattern': {'value': '<<(?P<heredoc>[a-zA-Z][a-zA-Z0-9._-]+)\n(?:.|\n)+?\n+\\s*(?P=heredoc)', 'flags': [], '_width': [9, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 35: {'name': '__ANON_11', 'pattern': {'value': '<<-(?P<heredoc_trim>[a-zA-Z][a-zA-Z0-9._-]+)\n(?:.|\n)+?\n+\\s*(?P=heredoc_trim)', 'flags': [], '_width': [10, 4294967295], '__type__': 'PatternRE'}, 'priority': 0, '__type__': 'TerminalDef'}, 36: {'name': '__ANON_12', 'pattern': {'value': '...', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 37: {'name': '__ANON_13', 'pattern': {'value': '.*', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 38: {'name': '__ANON_14', 'pattern': {'value': '[*]', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 39: {'name': '__ANON_15', 'pattern': {'value': '=>', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 40: {'name': 'FOR', 'pattern': {'value': 'for', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 41: {'name': 'IN', 'pattern': {'value': 'in', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 42: {'name': 'IF', 'pattern': {'value': 'if', 'flags': [], '__type__': 'PatternStr'}, 'priority': 0, '__type__': 'TerminalDef'}, 43: {'origin': {'name': Token('RULE', 'start'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'body', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 44: {'origin': {'name': Token('RULE', 'start'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'body', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 45: {'origin': {'name': Token('RULE', 'start'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'body', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 46: {'origin': {'name': Token('RULE', 'start'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'body', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 47: {'origin': {'name': Token('RULE', 'body'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__body_star_0', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 48: {'origin': {'name': Token('RULE', 'body'), '__type__': 'NonTerminal'}, 'expansion': [], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 49: {'origin': {'name': Token('RULE', 'attribute'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'EQUAL', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 50: {'origin': {'name': Token('RULE', 'attribute'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'EQUAL', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 51: {'origin': {'name': Token('RULE', 'block'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': '__block_star_1', '__type__': 'NonTerminal'}, {'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'body', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 52: {'origin': {'name': Token('RULE', 'block'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': '__block_star_1', '__type__': 'NonTerminal'}, {'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'body', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 53: {'origin': {'name': Token('RULE', 'block'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'body', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 54: {'origin': {'name': Token('RULE', 'block'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'body', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 55: {'origin': {'name': Token('RULE', 'new_line_and_or_comma'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 56: {'origin': {'name': Token('RULE', 'new_line_and_or_comma'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 57: {'origin': {'name': Token('RULE', 'new_line_and_or_comma'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 58: {'origin': {'name': Token('RULE', 'new_line_or_comment'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 59: {'origin': {'name': Token('RULE', 'identifier'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_3', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 60: {'origin': {'name': Token('RULE', 'expression'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expr_term', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 61: {'origin': {'name': Token('RULE', 'expression'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'operation', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 62: {'origin': {'name': Token('RULE', 'expression'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'conditional', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 63: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 64: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 65: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 66: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 67: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 68: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 69: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 70: {'origin': {'name': Token('RULE', 'conditional'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'QMARK', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 71: {'origin': {'name': Token('RULE', 'operation'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'unary_op', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 72: {'origin': {'name': Token('RULE', 'operation'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'binary_op', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': True, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 73: {'origin': {'name': Token('RULE', 'unary_op'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'MINUS', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expr_term', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 74: {'origin': {'name': Token('RULE', 'unary_op'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'BANG', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expr_term', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 75: {'origin': {'name': Token('RULE', 'binary_op'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'binary_term', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 76: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_4', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 77: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_5', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 78: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LESSTHAN', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 79: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'MORETHAN', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 80: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_6', 'filter_out': False, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 81: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_7', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 82: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'MINUS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 83: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'STAR', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 84: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'SLASH', 'filter_out': False, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 85: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'PERCENT', 'filter_out': False, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 86: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_8', 'filter_out': False, '__type__': 'Terminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 87: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_9', 'filter_out': False, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 88: {'origin': {'name': Token('RULE', 'binary_operator'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'PLUS', 'filter_out': False, '__type__': 'Terminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 89: {'origin': {'name': Token('RULE', 'binary_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'binary_operator', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 90: {'origin': {'name': Token('RULE', 'binary_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'binary_operator', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 91: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 92: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 93: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 94: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 95: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'float_lit', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 96: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'int_lit', '__type__': 'NonTerminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 97: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'STRING_LIT', 'filter_out': False, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 98: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'tuple', '__type__': 'NonTerminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 99: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'object', '__type__': 'NonTerminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 100: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'function_call', '__type__': 'NonTerminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 101: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'index_expr_term', '__type__': 'NonTerminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 102: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'get_attr_expr_term', '__type__': 'NonTerminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 103: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 104: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'heredoc_template', '__type__': 'NonTerminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 105: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'heredoc_template_trim', '__type__': 'NonTerminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 106: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attr_splat_expr_term', '__type__': 'NonTerminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 107: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'full_splat_expr_term', '__type__': 'NonTerminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 108: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'for_tuple_expr', '__type__': 'NonTerminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 109: {'origin': {'name': Token('RULE', 'expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'for_object_expr', '__type__': 'NonTerminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 110: {'origin': {'name': Token('RULE', 'int_lit'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 111: {'origin': {'name': Token('RULE', 'float_lit'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, {'name': 'DOT', 'filter_out': False, '__type__': 'Terminal'}, {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, {'name': 'EXP_MARK', 'filter_out': False, '__type__': 'Terminal'}, {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 112: {'origin': {'name': Token('RULE', 'float_lit'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, {'name': 'DOT', 'filter_out': False, '__type__': 'Terminal'}, {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 113: {'origin': {'name': Token('RULE', 'float_lit'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, {'name': 'EXP_MARK', 'filter_out': False, '__type__': 'Terminal'}, {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 114: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 115: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 116: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 117: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 118: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 119: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 120: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 121: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 122: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 123: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 124: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 125: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 126: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 127: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 128: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 129: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 130: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 131: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 132: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 133: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 134: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 135: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 136: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 137: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 138: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 24, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 139: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 25, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 140: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 26, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 141: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 27, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 142: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 28, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 143: {'origin': {'name': Token('RULE', 'tuple'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 29, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 144: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': '__object_star_5', '__type__': 'NonTerminal'}, {'name': 'new_line_and_or_comma', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 145: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': '__object_star_5', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 146: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': 'new_line_and_or_comma', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 147: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 148: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 149: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': '__object_star_5', '__type__': 'NonTerminal'}, {'name': 'new_line_and_or_comma', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 150: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': '__object_star_5', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 151: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': 'new_line_and_or_comma', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 152: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 153: {'origin': {'name': Token('RULE', 'object'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': True, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 154: {'origin': {'name': Token('RULE', 'object_elem'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'EQUAL', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 155: {'origin': {'name': Token('RULE', 'object_elem'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 156: {'origin': {'name': Token('RULE', 'object_elem'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'EQUAL', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 157: {'origin': {'name': Token('RULE', 'object_elem'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 158: {'origin': {'name': Token('RULE', 'heredoc_template'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_10', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 159: {'origin': {'name': Token('RULE', 'heredoc_template_trim'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_11', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 160: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'arguments', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 161: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'arguments', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 162: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 163: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 164: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'arguments', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 165: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'arguments', '__type__': 'NonTerminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 166: {'origin': {'name': Token('RULE', 'function_call'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'LPAR', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'RPAR', 'filter_out': True, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 167: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 168: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 169: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 170: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': True, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 171: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 172: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__tuple_star_4', '__type__': 'NonTerminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 173: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 174: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 175: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 176: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': True, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 177: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 178: {'origin': {'name': Token('RULE', 'arguments'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expression', '__type__': 'NonTerminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 179: {'origin': {'name': Token('RULE', 'index_expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expr_term', '__type__': 'NonTerminal'}, {'name': 'index', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 180: {'origin': {'name': Token('RULE', 'get_attr_expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expr_term', '__type__': 'NonTerminal'}, {'name': 'get_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 181: {'origin': {'name': Token('RULE', 'attr_splat_expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expr_term', '__type__': 'NonTerminal'}, {'name': 'attr_splat', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 182: {'origin': {'name': Token('RULE', 'full_splat_expr_term'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'expr_term', '__type__': 'NonTerminal'}, {'name': 'full_splat', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 183: {'origin': {'name': Token('RULE', 'index'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 184: {'origin': {'name': Token('RULE', 'index'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 185: {'origin': {'name': Token('RULE', 'index'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 186: {'origin': {'name': Token('RULE', 'index'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': True, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 187: {'origin': {'name': Token('RULE', 'index'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'DOT', 'filter_out': True, '__type__': 'Terminal'}, {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 188: {'origin': {'name': Token('RULE', 'get_attr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'DOT', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 189: {'origin': {'name': Token('RULE', 'attr_splat'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_13', 'filter_out': True, '__type__': 'Terminal'}, {'name': '__attr_splat_star_6', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 190: {'origin': {'name': Token('RULE', 'attr_splat'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_13', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 191: {'origin': {'name': Token('RULE', 'full_splat'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_14', 'filter_out': True, '__type__': 'Terminal'}, {'name': '__full_splat_star_7', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 192: {'origin': {'name': Token('RULE', 'full_splat'), '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_14', 'filter_out': True, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 193: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 194: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 195: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 196: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 197: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 198: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 199: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 200: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 201: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 202: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 203: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 204: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 205: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 206: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 207: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 208: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 209: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 210: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 211: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 212: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 213: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 214: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 215: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 216: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 217: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 24, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 218: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 25, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 219: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 26, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 220: {'origin': {'name': Token('RULE', 'for_tuple_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LSQB', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RSQB', 'filter_out': False, '__type__': 'Terminal'}], 'order': 27, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 221: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 222: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 223: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 224: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 225: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 226: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 227: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 228: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 229: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 230: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 231: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 232: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 233: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 234: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 235: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 236: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 237: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 238: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 239: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 240: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 241: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 242: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 243: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 244: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 245: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 24, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 246: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 25, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 247: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 26, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 248: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 27, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 249: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 28, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 250: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 29, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 251: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 30, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 252: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 31, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 253: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 32, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 254: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 33, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 255: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 34, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 256: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 35, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 257: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 36, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 258: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 37, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 259: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 38, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 260: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 39, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 261: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 40, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 262: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 41, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 263: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 42, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 264: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 43, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 265: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 44, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 266: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 45, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 267: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 46, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 268: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 47, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 269: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 48, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 270: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 49, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 271: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 50, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 272: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 51, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 273: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 52, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 274: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 53, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 275: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 54, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 276: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 55, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 277: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 56, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 278: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 57, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 279: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 58, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 280: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 59, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 281: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 60, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 282: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 61, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 283: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 62, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 284: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 63, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 285: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 64, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 286: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 65, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 287: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 66, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 288: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 67, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 289: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 68, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 290: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 69, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 291: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 70, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 292: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 71, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 293: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 72, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 294: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 73, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 295: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 74, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 296: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 75, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 297: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 76, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 298: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 77, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 299: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 78, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 300: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 79, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 301: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 80, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 302: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 81, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 303: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 82, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 304: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 83, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 305: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 84, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 306: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 85, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 307: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 86, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 308: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 87, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 309: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 88, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 310: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 89, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 311: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 90, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 312: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 91, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 313: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 92, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 314: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 93, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 315: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 94, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 316: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 95, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 317: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 96, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 318: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 97, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 319: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 98, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 320: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 99, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 321: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 100, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 322: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 101, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 323: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 102, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 324: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 103, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 325: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_12', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 104, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 326: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 105, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 327: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 106, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 328: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 107, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 329: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 108, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 330: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 109, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 331: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'for_cond', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 110, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 332: {'origin': {'name': Token('RULE', 'for_object_expr'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'LBRACE', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'for_intro', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': '__ANON_15', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'RBRACE', 'filter_out': False, '__type__': 'Terminal'}], 'order': 111, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 333: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 334: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 335: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 336: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 337: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 338: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 339: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 340: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 341: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 8, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 342: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 9, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 343: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 10, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 344: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 11, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 345: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 12, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 346: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 13, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 347: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 14, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 348: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 15, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 349: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 16, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 350: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 17, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 351: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 18, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 352: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 19, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 353: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 20, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 354: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 21, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 355: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 22, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 356: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 23, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 357: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 24, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 358: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 25, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 359: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 26, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 360: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 27, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 361: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 28, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 362: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 29, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 363: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 30, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 364: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 31, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 365: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 32, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 366: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 33, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 367: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 34, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 368: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 35, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 369: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 36, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 370: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 37, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 371: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 38, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 372: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 39, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 373: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 40, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 374: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 41, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 375: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 42, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 376: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 43, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 377: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 44, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 378: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 45, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 379: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 46, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 380: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 47, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 381: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 48, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 382: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 49, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 383: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 50, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 384: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 51, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 385: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 52, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 386: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 53, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 387: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 54, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 388: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 55, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 389: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 56, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 390: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 57, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 391: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 58, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 392: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 59, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 393: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 60, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 394: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 61, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 395: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 62, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 396: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 63, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 397: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 64, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 398: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 65, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 399: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 66, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 400: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 67, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 401: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 68, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 402: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 69, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 403: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 70, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 404: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 71, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 405: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 72, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 406: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 73, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 407: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 74, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 408: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 75, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 409: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 76, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 410: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 77, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 411: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}], 'order': 78, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 412: {'origin': {'name': Token('RULE', 'for_intro'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'FOR', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}, {'name': 'IN', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}, {'name': 'COLON', 'filter_out': False, '__type__': 'Terminal'}], 'order': 79, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 413: {'origin': {'name': Token('RULE', 'for_cond'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'IF', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 414: {'origin': {'name': Token('RULE', 'for_cond'), '__type__': 'NonTerminal'}, 'expansion': [{'name': 'IF', 'filter_out': False, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': True, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 415: {'origin': {'name': '__body_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'attribute', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 416: {'origin': {'name': '__body_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'block', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 417: {'origin': {'name': '__body_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__body_star_0', '__type__': 'NonTerminal'}, {'name': 'attribute', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 418: {'origin': {'name': '__body_star_0', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__body_star_0', '__type__': 'NonTerminal'}, {'name': 'block', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 419: {'origin': {'name': '__block_star_1', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'identifier', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 420: {'origin': {'name': '__block_star_1', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'STRING_LIT', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 421: {'origin': {'name': '__block_star_1', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__block_star_1', '__type__': 'NonTerminal'}, {'name': 'identifier', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 422: {'origin': {'name': '__block_star_1', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__block_star_1', '__type__': 'NonTerminal'}, {'name': 'STRING_LIT', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 423: {'origin': {'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_0', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 424: {'origin': {'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_1', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 425: {'origin': {'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__ANON_2', 'filter_out': False, '__type__': 'Terminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 426: {'origin': {'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, {'name': '__ANON_0', 'filter_out': False, '__type__': 'Terminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 427: {'origin': {'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, {'name': '__ANON_1', 'filter_out': False, '__type__': 'Terminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 428: {'origin': {'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__new_line_or_comment_plus_2', '__type__': 'NonTerminal'}, {'name': '__ANON_2', 'filter_out': False, '__type__': 'Terminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 429: {'origin': {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'DECIMAL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 430: {'origin': {'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__int_lit_plus_3', '__type__': 'NonTerminal'}, {'name': 'DECIMAL', 'filter_out': False, '__type__': 'Terminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 431: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 432: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 433: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 434: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 435: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 4, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 436: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 5, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 437: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'new_line_or_comment', '__type__': 'NonTerminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 6, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 438: {'origin': {'name': '__tuple_star_4', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__tuple_star_4', '__type__': 'NonTerminal'}, {'name': 'COMMA', 'filter_out': True, '__type__': 'Terminal'}, {'name': 'expression', '__type__': 'NonTerminal'}], 'order': 7, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 439: {'origin': {'name': '__object_star_5', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'new_line_and_or_comma', '__type__': 'NonTerminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 440: {'origin': {'name': '__object_star_5', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__object_star_5', '__type__': 'NonTerminal'}, {'name': 'new_line_and_or_comma', '__type__': 'NonTerminal'}, {'name': 'object_elem', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 441: {'origin': {'name': '__attr_splat_star_6', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'get_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 442: {'origin': {'name': '__attr_splat_star_6', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__attr_splat_star_6', '__type__': 'NonTerminal'}, {'name': 'get_attr', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 443: {'origin': {'name': '__full_splat_star_7', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'get_attr', '__type__': 'NonTerminal'}], 'order': 0, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 444: {'origin': {'name': '__full_splat_star_7', '__type__': 'NonTerminal'}, 'expansion': [{'name': 'index', '__type__': 'NonTerminal'}], 'order': 1, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 445: {'origin': {'name': '__full_splat_star_7', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__full_splat_star_7', '__type__': 'NonTerminal'}, {'name': 'get_attr', '__type__': 'NonTerminal'}], 'order': 2, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}, 446: {'origin': {'name': '__full_splat_star_7', '__type__': 'NonTerminal'}, 'expansion': [{'name': '__full_splat_star_7', '__type__': 'NonTerminal'}, {'name': 'index', '__type__': 'NonTerminal'}], 'order': 3, 'alias': None, 'options': {'keep_all_tokens': False, 'expand1': False, 'priority': None, 'template_source': None, 'empty_indices': (), '__type__': 'RuleOptions'}, '__type__': 'Rule'}}
)
Shift = 0
Reduce = 1
def Lark_StandAlone(**kwargs):
  return Lark._load_from_dict(DATA, MEMO, **kwargs)
