
"""Open XML helpers for the HWPX document format."""

from __future__ import annotations

from .body import (
    Paragraph,
    Run,
    Section,
    TextSpan,
    parse_paragraph_element,
    parse_run_element,
    parse_section_element,
    parse_text_span,
)
from .common import GenericElement, parse_generic_element

from .document import (
    DocumentNumbering,
    HwpxOxmlDocument,
    HwpxOxmlHeader,
    HwpxOxmlInlineObject,
    HwpxOxmlMemo,
    HwpxOxmlMemoGroup,
    HwpxOxmlParagraph,
    HwpxOxmlRun,
    HwpxOxmlSection,
    HwpxOxmlSectionHeaderFooter,
    HwpxOxmlSectionProperties,
    HwpxOxmlTable,
    HwpxOxmlTableCell,
    HwpxOxmlTableRow,
    PageMargins,
    PageSize,
    RunStyle,
    SectionStartNumbering,
)

from .header import (
    BeginNum,
    BorderFillList,
    Bullet,
    BulletList,
    BulletParaHead,
    CharProperty,
    CharPropertyList,
    DocOption,
    Font,
    FontFace,
    FontFaceList,
    FontSubstitution,
    FontTypeInfo,
    ForbiddenWordList,
    Header,
    KeyDerivation,
    KeyEncryption,
    LinkInfo,
    LicenseMark,
    MemoProperties,
    MemoShape,
    NumberingList,
    ParagraphAlignment,
    ParagraphAutoSpacing,
    ParagraphBreakSetting,
    ParagraphBorder,
    ParagraphHeading,
    ParagraphLineSpacing,
    ParagraphMargin,
    ParagraphProperty,
    ParagraphPropertyList,
    RefList,
    Style,
    StyleList,
    TabProperties,
    TrackChange,
    TrackChangeAuthor,
    TrackChangeAuthorList,
    TrackChangeConfig,
    TrackChangeList,
    memo_shape_from_attributes,
    parse_begin_num,
    parse_bullet,
    parse_bullet_para_head,
    parse_bullets,
    parse_doc_option,
    parse_header_element,
    parse_memo_properties,
    parse_memo_shape,
    parse_paragraph_alignment,
    parse_paragraph_auto_spacing,
    parse_paragraph_border,
    parse_paragraph_break_setting,
    parse_paragraph_line_spacing,
    parse_paragraph_margin,
    parse_paragraph_property,
    parse_paragraph_properties,
    parse_ref_list,
    parse_style,
    parse_styles,
    parse_track_change,
    parse_track_change_author,
    parse_track_change_authors,
    parse_track_changes,
)
from .parser import element_to_model, parse_header_xml, parse_section_xml
from .schema import load_schema
from .utils import XmlSource

__all__ = [
    "BeginNum",
    "BorderFillList",
    "Bullet",
    "BulletList",
    "BulletParaHead",
    "CharProperty",
    "CharPropertyList",
    "DocOption",
    "Font",
    "FontFace",
    "FontFaceList",
    "FontSubstitution",
    "FontTypeInfo",
    "ForbiddenWordList",
    "GenericElement",
    "Header",
    "DocumentNumbering",
    "HwpxOxmlDocument",
    "HwpxOxmlHeader",
    "HwpxOxmlInlineObject",
    "HwpxOxmlMemo",
    "HwpxOxmlMemoGroup",
    "HwpxOxmlParagraph",
    "HwpxOxmlRun",
    "HwpxOxmlSection",
    "HwpxOxmlSectionHeaderFooter",
    "HwpxOxmlSectionProperties",
    "HwpxOxmlTable",
    "HwpxOxmlTableCell",
    "HwpxOxmlTableRow",
    "KeyDerivation",
    "KeyEncryption",
    "LinkInfo",
    "LicenseMark",
    "MemoProperties",
    "MemoShape",
    "NumberingList",
    "ParagraphAlignment",
    "ParagraphAutoSpacing",
    "ParagraphBreakSetting",
    "ParagraphBorder",
    "ParagraphHeading",
    "ParagraphLineSpacing",
    "ParagraphMargin",
    "ParagraphProperty",
    "ParagraphPropertyList",
    "Paragraph",
    "PageMargins",
    "PageSize",
    "RunStyle",
    "memo_shape_from_attributes",
    "RefList",
    "Run",
    "Section",
    "SectionStartNumbering",
    "Style",
    "StyleList",
    "TabProperties",
    "TrackChange",
    "TrackChangeAuthor",
    "TrackChangeAuthorList",
    "TrackChangeConfig",
    "TrackChangeList",
    "TextSpan",
    "XmlSource",
    "element_to_model",
    "load_schema",
    "parse_begin_num",
    "parse_bullet",
    "parse_bullet_para_head",
    "parse_bullets",
    "parse_doc_option",
    "parse_generic_element",
    "parse_header_element",
    "parse_memo_properties",
    "parse_memo_shape",
    "parse_paragraph_alignment",
    "parse_paragraph_auto_spacing",
    "parse_paragraph_border",
    "parse_paragraph_break_setting",
    "parse_paragraph_line_spacing",
    "parse_paragraph_margin",
    "parse_paragraph_property",
    "parse_paragraph_properties",
    "parse_header_xml",
    "parse_paragraph_element",
    "parse_ref_list",
    "parse_run_element",
    "parse_style",
    "parse_styles",
    "parse_track_change",
    "parse_track_change_author",
    "parse_track_change_authors",
    "parse_track_changes",
    "parse_section_element",
    "parse_section_xml",
    "parse_text_span",
]

