# Generated by Django 2.2.3 on 2019-10-24 22:44

from django.conf import settings
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('auth', '0011_update_proxy_permissions'),
    ]

    operations = [
        migrations.CreateModel(
            name='Subject',
            fields=[
                ('password', models.CharField(max_length=128, verbose_name='password')),
                ('last_login', models.DateTimeField(blank=True, null=True, verbose_name='last login')),
                ('is_superuser', models.BooleanField(default=False, help_text='Designates that this user has all permissions without explicitly assigning them.', verbose_name='superuser status')),
                ('id', models.UUIDField(db_column='id', default=uuid.uuid4, primary_key=True, serialize=False)),
                ('kind', models.CharField(choices=[('User', 'User'), ('ServiceAccount', 'Service Account')], db_column='kind', max_length=32)),
                ('key', models.CharField(db_column='key', max_length=255, unique=True)),
                ('groups', models.ManyToManyField(blank=True, help_text='The groups this user belongs to. A user will get all permissions granted to each of their groups.', related_name='user_set', related_query_name='user', to='auth.Group', verbose_name='groups')),
                ('user_permissions', models.ManyToManyField(blank=True, help_text='Specific permissions for this user.', related_name='user_set', related_query_name='user', to='auth.Permission', verbose_name='user permissions')),
            ],
            options={
                'db_table': 'subjects',
                'default_permissions': [],
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('subject', models.OneToOneField(db_column='subject_id', on_delete=django.db.models.deletion.PROTECT, parent_link=True, primary_key=True, serialize=False, to=settings.AUTH_USER_MODEL)),
                ('first_name', models.CharField(db_column='first_name', max_length=128)),
                ('last_name', models.CharField(db_column='last_name', max_length=128)),
            ],
            options={
                'db_table': 'usersubjects',
                'default_permissions': [],
            },
            bases=('iam.subject',),
        ),
        migrations.CreateModel(
            name='ResourceAuthorization',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('realm', models.UUIDField(db_column='realm', default='00000000-0000-0000-0000-000000000000')),
                ('kind', models.CharField(choices=[('Subject', 'Subject'), ('User', 'User'), ('ServiceAccount', 'Service Account'), ('Group', 'Group'), ('Role', 'Role')], db_column='kind', max_length=128)),
                ('principal_id', models.UUIDField(db_column='principal_id')),
                ('resource_class', models.CharField(db_column='resource_class', max_length=128)),
                ('resource_id', models.UUIDField(db_column='resource_id')),
                ('expires', models.BigIntegerField(db_column='expires', default=0)),
                ('revoked', models.BooleanField(db_column='revoked', default=False)),
                ('permission', models.ForeignKey(db_column='permission_id', on_delete=django.db.models.deletion.CASCADE, related_name='authorizations', to='auth.Permission')),
            ],
            options={
                'db_table': 'resourceauthorizations',
                'permissions': [('login', 'Login')],
                'default_permissions': [],
                'unique_together': {('realm', 'resource_class', 'resource_id', 'permission', 'principal_id')},
            },
        ),
    ]
