# Generated by Django 3.0.4 on 2020-03-18 23:40
import hashlib

from django.db import migrations, models
import django.db.models.deletion


LOREM_IPSUM = """

## Preamble

Could someone survive inside a transporter buffer for 75 years? Fear is the
true enemy, the only enemy. I suggest you drop it, Mr. Data. I think you've
let your personal feelings cloud your judgement. Flair is what marks the
difference between artistry and mere competence. Some days you get the bear,
and some days the bear gets you. Maybe if we felt any human loss as keenly as
we feel one of those close to us, human history would be far less bloody.

## An additional paragraph

We have a saboteur aboard. Earl Grey tea, watercress sandwiches... and
Bularian canapés? Are you up for promotion? Some days you get the bear,
and some days the bear gets you. My oath is between Captain Kargan and
myself. Your only concern is with how you obey my orders. Or do you prefer
the rank of prisoner to that of lieutenant? Why don't we just give everybody
a promotion and call it a night - 'Commander'? Fate. It protects fools,
little children, and ships named "Enterprise." We could cause a diplomatic
crisis. Take the ship into the Neutral Zone That might've been one of the
shortest assignments in the history of Starfleet.

## Another paragraph

I'll be sure to note that in my log. When has justice ever been as simple as
a rule book? Your shields were failing, sir. What's a knock-out like you doing
in a computer-generated gin joint like this? The Enterprise computer system
is controlled by three primary main processor cores, cross-linked with a
redundant melacortz ramistat, fourteen kiloquad interface modules. This is
not about revenge. This is about justice.

## Appendices

This section contains appendices.

### Appendix A

Did you come here for something in particular or just general Riker-bashing?
I'll alert the crew. I am your worst nightmare! Besides, you look good in a
dress. They were just sucked into space. Computer, lights up! Fate protects
fools, little children and ships named Enterprise.

### Appendix B

Maybe we better talk out here; the observation lounge has turned into a
swamp. Talk about going nowhere fast. and attack the Romulans. Well,
that's certainly good to know. Yesterday I did not know how to eat gagh.
Captain, why are we out here chasing comets?
"""


def create_lorem_terms(apps, schema_editor):
    PlatformAgreementLanguage = apps.get_model('iam.PlatformAgreementLanguage')
    PlatformAgreementLanguage.objects.create(
        agreement_id='terms',
        checksum=hashlib.sha256(b'1').hexdigest(),
        title="Terms of Service",
        language='en',
        content="# Terms of Service Placeholder\n" + LOREM_IPSUM
    )


def create_lorem_privacy(apps, schema_editor):
    PlatformAgreementLanguage = apps.get_model('iam.PlatformAgreementLanguage')
    PlatformAgreementLanguage.objects.create(
        agreement_id='privacy',
        checksum=hashlib.sha256(b'2').hexdigest(),
        title="Privacy Statement",
        language='en',
        content="# Privacy Statement Placeholder\n" + LOREM_IPSUM
    )


class Migration(migrations.Migration):

    dependencies = [
        ('iam', '0017_platformagreement'),
    ]

    operations = [
        migrations.CreateModel(
            name='PlatformAgreementLanguage',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('checksum', models.CharField(db_column='checksum', unique=True, max_length=128)),
                ('language', models.CharField(choices=[('en', 'English'), ('nl', 'Dutch')], db_column='language', max_length=15)),
                ('encoding', models.CharField(db_column='encoding', default='utf-8', editable=False, max_length=31)),
                ('markup', models.CharField(db_column='markup', default='markdown', editable=False, max_length=31)),
                ('title', models.CharField(db_column='title', max_length=127)),
                ('content', models.TextField(db_column='content')),
                ('agreement', models.ForeignKey(db_column='agreement_slug', on_delete=django.db.models.deletion.CASCADE, to='iam.PlatformAgreement')),
            ],
            options={
                'verbose_name': 'Platform Agreement Translation',
                'verbose_name_plural': 'Platform Agreements Translations',
                'db_table': 'platformagreementlanguages',
                'default_permissions': [],
                'unique_together': {('agreement', 'language')},
            },
        ),
        migrations.RunPython(create_lorem_terms),
        migrations.RunPython(create_lorem_privacy),
    ]
