"""
Django settings for subject project.

Generated by 'django-admin startproject' using Django 2.2.3.

For more information on this file, see
https://docs.djangoproject.com/en/2.2/topics/settings/

For the full list of settings and their values, see
https://docs.djangoproject.com/en/2.2/ref/settings/
"""
import os
from sqlalchemy.types import CHAR

from iam.ext.django.defaults import *

# Build paths inside the project like this: os.path.join(BASE_DIR, ...)
BASE_DIR = os.path.dirname(os.path.dirname(os.path.abspath(__file__)))


# Quick-start development settings - unsuitable for production
# See https://docs.djangoproject.com/en/2.2/howto/deployment/checklist/

# SECURITY WARNING: don't run with debug turned on in production!
DEBUG = os.getenv('DEBUG') == '1'


# Application definition

INSTALLED_APPS = [
    'django.contrib.messages',
    'django.contrib.admin',
    'django.contrib.auth',
    'django.contrib.contenttypes',
    'django.contrib.sessions',
    'django.contrib.sites',
    'django.contrib.staticfiles',
    'aorta.ext.django',
    'iam.ext.django',
    'iam.ext.app',
    'aldjemy',
    'social_django'
]

MIDDLEWARE = [
    'csp.middleware.CSPMiddleware',
    'unimatrix.ext.django.lib.middleware.HealthCheckMiddleware',
    'django.middleware.locale.LocaleMiddleware',
    'django.middleware.security.SecurityMiddleware',
    'django.contrib.sessions.middleware.SessionMiddleware',
    'iam.lib.middleware.IAMMiddleware',
    'django.middleware.common.CommonMiddleware',
    'django.middleware.csrf.CsrfViewMiddleware',
    'django.contrib.sites.middleware.CurrentSiteMiddleware',
    'django.contrib.auth.middleware.AuthenticationMiddleware',
    'django.contrib.messages.middleware.MessageMiddleware',
    'django.middleware.clickjacking.XFrameOptionsMiddleware',
]

ROOT_URLCONF = 'iam.ext.app.urls'

TEMPLATES = [
    {
        'BACKEND': 'django.template.backends.jinja2.Jinja2',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'environment': 'iam.ext.django.lib.template.environment',
            'context_processors': [
                'django.contrib.messages.context_processors.messages',
                'iam.lib.template.policies',
                'social_django.context_processors.backends',
            ]
        },
    },
    {
        'BACKEND': 'django.template.backends.django.DjangoTemplates',
        'DIRS': [],
        'APP_DIRS': True,
        'OPTIONS': {
            'context_processors': [
                'django.template.context_processors.debug',
                'django.template.context_processors.request',
                'django.contrib.auth.context_processors.auth',
                'django.contrib.messages.context_processors.messages',
            ],
        },
    },
]

WSGI_APPLICATION = 'unimatrix.ext.django.wsgi.application'


# Password validation
# https://docs.djangoproject.com/en/2.2/ref/settings/#auth-password-validators

AUTH_PASSWORD_VALIDATORS = [
    {
        'NAME': 'django.contrib.auth.password_validation.UserAttributeSimilarityValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.MinimumLengthValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.CommonPasswordValidator',
    },
    {
        'NAME': 'django.contrib.auth.password_validation.NumericPasswordValidator',
    },
]


# Internationalization
# https://docs.djangoproject.com/en/2.2/topics/i18n/

LANGUAGE_CODE = 'en'

LANGUAGES = (
    ('en', 'English'),
    ('nl', 'Dutch'),
)

TIME_ZONE = 'UTC'

USE_I18N = True

USE_L10N = True

USE_TZ = True


# Static files (CSS, JavaScript, Images)
# https://docs.djangoproject.com/en/2.2/howto/static-files/

STATIC_URL = '/static/'

STATIC_ROOT = 'static'

ALDJEMY_DATA_TYPES = {
    'UUIDField': CHAR,
}

IAM_DEBUG_PATH = ''

IAM_REALM_SETTINGS = {
    'default': {
        'public': True,
        'sso': {
            'providers': [
                'google-oauth2',
            ]
        }
    },
    'backoffice': {
        'domains': [
            'wizardsofindustry.com'
        ],
        'public': False,
        'sso': {
            'providers': [
                'google-oauth2',
            ]
        }
    }
}

CACHE_HOST = os.getenv('CACHE_HOST')

CACHE_PORT = os.getenv('CACHE_PORT')

REDIS_DATABASE = os.getenv('REDIS_DATABASE')

CACHES = {
    "default": {
        "BACKEND": "django_redis.cache.RedisCache",
        "LOCATION": f"redis://{CACHE_HOST}:{CACHE_PORT}/{REDIS_DATABASE}",
        "OPTIONS": {
            "CLIENT_CLASS": "django_redis.client.DefaultClient",
        }
    }
}


CSP_DEFAULT_SRC = (
    "'self'",
)

CSP_SCRIPT_SRC = (
    "'self'",
    'code.jquery.com',
    'kit.fontawesome.com',
    'stackpath.bootstrapcdn.com',
)

CSP_FONT_SRC = (
    "'self'",
    'kit-free.fontawesome.com',
    'maxcdn.bootstrapcdn.com',
)

CSP_STYLE_SRC = (
    "'self'",
    'kit-free.fontawesome.com',
    'kit.fontawesome.com',
    'maxcdn.bootstrapcdn.com',
    'stackpath.bootstrapcdn.com',
)

CSP_IMG_SRC = (
    "'self'",
)
