<!--
PR Title Format: Use conventional commit format
  type: description

Allowed types:
  feat:     New feature
  fix:      Bug fix
  docs:     Documentation only
  test:     Adding/updating tests
  ci:       CI/workflow changes
  build:    Build system changes
  refactor: Code refactoring
  chore:    Maintenance tasks
  perf:     Performance improvements
  security: Security fixes

Examples:
  feat: add user authentication
  fix: resolve race condition in cache
  docs: update installation guide
-->

## Description

<!-- Briefly describe what this PR does -->

## Type of Change

- [ ] Bug fix
- [ ] New feature
- [ ] Breaking change
- [ ] Documentation
- [ ] Refactoring / code quality

## Testing

- [ ] Tests pass locally (`just test`)
- [ ] Added/updated tests for changes
- [ ] Tested integration tests if applicable (`just test-integration`)

## Checklist

- [ ] Code passes `just lint` and `just fmt`
- [ ] Self-reviewed the changes
- [ ] Updated documentation if needed

## Additional Context

<!-- Optional: screenshots, related issues, etc. -->