#ifndef ICSNVC40INTERNAL__H_
#define ICSNVC40INTERNAL__H_

/* This file is Intrepid internal -- put everything that you want to put into icsnVC40 but don't want public here */

#include "icsnVC40.h"

// Driver Type Constants
#define INTREPIDCS_DRIVER_STANDARD 0
#define INTREPIDCS_DRIVER_TEST 1
#define INTREPIDCS_DRIVER_CYPRESS 2
#define INTREPIDCS_DRIVER_SYNCTOPC 3
#define INTREPIDCS_DRIVER_ENHANCED_3G 4

// device Type IDs NOTE: These are only valid for the older icsneoOpenPortEx() function
#define INTREPIDCS_DEVICE_NEO4 0
#define INTREPIDCS_DEVICE_VCAN 1
#define INTREPIDCS_DEVICE_NEO6 2
#define INTREPIDCS_DEVICE_UNKNOWN 3
#define INTREPIDCS_DEVICE_VCAN2_DW 4
#define INTREPIDCS_DEVICE_VCAN2_SW 5
#define INTREPIDCS_DEVICE_VCAN2_LSFT 6
#define INTREPIDCS_DEVICE_VCAN2_WIFI 7
#define INTREPIDCS_DEVICE_VCAN3_CANDOC 8
#define INTREPIDCS_DEVICE_NEOFIRE 10
#define INTREPIDCS_DEVICE_VCAN3 11
#define INTREPIDCS_DEVICE_NEORED INTREPIDCS_DEVICE_NEOFIRE
/*
 * deprecated hardware. RIP
 */
//#define INTREPIDCS_DEVICE_YELLOW		12

/*
 * Deprecated hardware. RIP
 * Use these when we run out of bits!
 */
//#define NEODEVICE_YELLOW           32

#define NEODEVICE_FIRE2_CYAN NEODEVICE_FIRE2

//deprecated netids
#define NETID_FIRE_HSCAN2 NETID_HSCAN2
#define NETID_FIRE_MSCAN2 NETID_HSCAN3
#define NETID_FIRE_HSCAN3 NETID_HSCAN3
#define NETID_FIRE_LIN2 NETID_LIN2
#define NETID_FIRE_LIN3 NETID_LIN3
#define NETID_FIRE_LIN4 NETID_LIN4
#define NETID_FIRE_CGI NETID_CGI

/*
VNET Network index matrix.
If above defines are modified you can easily
view/update this table using Excel/OpenOffice...

Network	Main Vnet	Slave1	Slave2
NETID_DEVICE	0	100	200
NETID_HSCAN	1	101	201
NETID_MSCAN	2	102	202
NETID_SWCAN	3	103	203
NETID_LSFTCAN	4	104	204
NETID_FORDSCP	5	105	205
NETID_J1708	6	106	206
NETID_AUX	7	107	207
NETID_JVPW	8	108	208
NETID_ISO	9	109	209
NETID_ISOPIC	10	110	210
NETID_MAIN51	11	111	211
NETID_RED	12	112	212
NETID_SCI	13	113	213
NETID_ISO2	14	114	214
NETID_ISO14230	15	115	215
NETID_LIN	16	116	216
NETID_ISO3	41	117	217
NETID_HSCAN2	42	118	218
NETID_HSCAN3	44	119	219
NETID_ISO4	47	120	220
NETID_LIN2	48	121	221
NETID_LIN3	49	122	222
NETID_LIN4	50	123	223
NETID_MOST	51	124	224
NETID_CGI	53	125	225
NETID_I2C1	71	126	226
NETID_SPI1	72	127	227
NETID_FLEXRAY1A	80	128	228
NETID_MOST25	90	129	229
NETID_MOST50	91	130	230
NETID_MOST150	92	131	231
NETID_HSCAN4	61	132	232
NETID_HSCAN5	62	133	233
NETID_RS232	63	134	234
NETID_UART	64	135	235
NETID_UART2	65	136	236
NETID_UART3	66	137	237
NETID_UART4	67	138	238
NETID_ANALOG	68	139	239
NETID_FLEXRAY1B	81	140	240
NETID_FLEXRAY2A	82	141	241
NETID_FLEXRAY2B	83	142	242
NETID_LIN5	84	143	243 
NETID_ETHERNET	93	144	244
NETID_ETHERNET_DAQ	69	145	245
NETID_RED_APP_ERROR	52	146	246
NETID_HSCAN6 96 147 247
NETID_HSCAN7 97 148 248
NETID_LIN6 98 149 249
NETID_LSFTCAN2 99 150 250
*/

#define DEVICE_OPTION_ENABLE_TIMESYNC (0x00000001)
#define DEVICE_OPTION_DISABLE_AUTO_UPDATE (0x00000002)
#define DEVICE_OPTION_DONT_ENABLE_NETCOMS (0x00000004)
#define DEVICE_OPTION_DONT_USE_NEOVISERVER (0x00000008)

#define INTREPIDCS_15765_RX_ERR_GLOBAL 0x0001
#define INTREPIDCS_15765_RX_ERR_CFRX_EXP_FF 0x0002
#define INTREPIDCS_15765_RX_ERR_FCRX_EXP_FF 0x0004
#define INTREPIDCS_15765_RX_ERR_SFRX_EXP_CF 0x0008
#define INTREPIDCS_15765_RX_ERR_FFRX_EXP_CF 0x0010
#define INTREPIDCS_15765_RX_ERR_FCRX_EXP_CF 0x0020
#define INTREPIDCS_15765_RX_ERR_CF_TIME_OUT 0x0040
#define INTREPIDCS_15765_RX_COMPLETE 0x0080
#define INTREPIDCS_15765_RX_IN_PROGRESS 0x0100
#define INTREPIDCS_15765_RX_ERR_SEQ_ERR_CF 0x0200
#define INTREPIDCS_15765_RX_ERR_INVALID_LEN 0x0400

#define NETID_RED_EXT_MEMORYREAD 20
#define NETID_RED_INT_MEMORYREAD 21
#define NETID_RED_DFLASH_READ 22
#define NETID_RED_SDCARD_READ 23
#define NETID_3G_CAN_ERRBITS 24
#define NETID_RED_DFLASH_WRITE_DONE 25
#define NETID_RED_WAVE_CAN1_LOGICAL 26
#define NETID_RED_WAVE_CAN2_LOGICAL 27
#define NETID_RED_WAVE_LIN1_LOGICAL 28
#define NETID_RED_WAVE_LIN2_LOGICAL 29
#define NETID_RED_WAVE_LIN1_ANALOG 30
#define NETID_RED_WAVE_LIN2_ANALOG 31
#define NETID_RED_WAVE_MISC_ANALOG 32
#define NETID_RED_WAVE_MISCDIO2_LOGICAL 33
#define NETID_RED_NEOVI_NETWORK 35
#define NETID_RED_READ_BAUD_SETTINGS 36
#define NETID_RED_OLDFORMAT 37
#define NETID_RED_SCOPE_CAPTURE 38
#define NETID_RED_HARDWARE_EXCEP 39
#define NETID_RED_GET_RTC 40


#define DEVELOPER_BACKDOOR 0x3835C256

//cicsneoVI::ReadSettingsEx(...)
//Sub Cmds
#define GS_EX_SUBCMD_GLOBAL (0x01)
#define GS_EX_SUBCMD_DWCAN1 (0x02)
#define GS_EX_SUBCMD_DWCAN2 (0x03)
#define GS_EX_SUBCMD_DWCAN3 (0x04)
#define GS_EX_SUBCMD_DWCAN4 (0x05)
#define GS_EX_SUBCMD_HSCAN1 (0x06)
#define GS_EX_SUBCMD_HSCAN2 (0x07)
#define GS_EX_SUBCMD_HSCAN3 (0x08)
#define GS_EX_SUBCMD_HSCAN4 (0x09)
#define GS_EX_SUBCMD_MSCAN1 (0x0a)
#define GS_EX_SUBCMD_MSCAN2 (0x0b)
#define GS_EX_SUBCMD_MSCAN3 (0x0c)
#define GS_EX_SUBCMD_MSCAN4 (0x0d)
#define GS_EX_SUBCMD_SWCAN1 (0x0e)
#define GS_EX_SUBCMD_SWCAN2 (0x0f)
#define GS_EX_SUBCMD_SWCAN3 (0x10)
#define GS_EX_SUBCMD_SWCAN4 (0x11)
#define GS_EX_SUBCMD_LSFTCAN1 (0x12)
#define GS_EX_SUBCMD_LSFTCAN2 (0x13)
#define GS_EX_SUBCMD_LSFTCAN3 (0x14)
#define GS_EX_SUBCMD_LSFTCAN4 (0x15)
#define GS_EX_SUBCMD_SLAVEFIREVNET (0x20)

//Sub Version

//GS_EX_SUBCMD_GLOBAL
#define GS_EX_SUBCMD_GLOBAL_SUBVER_LATEST (0x01)
#define GS_EX_SUBCMD_GLOBAL_SUBVER_LEGACY_0 (0x02)//ETAS
#define GS_EX_SUBCMD_GLOBAL_SUBVER_LEGACY_1 (0x03)
#define GS_EX_SUBCMD_GLOBAL_SUBVER_LEGACY_2 (0x04)
#define GS_EX_SUBCMD_GLOBAL_SUBVER_LEGACY_3 (0x05)

//GS_EX_SUBCMD_DWCAN1
#define GS_EX_SUBVER_STANDARD_STRUCT (0x01)

//GS_EX_SUBCMD_SLAVEFIREVNET
#define GS_EX_SUBCMD_SLAVEFIREVNET_SUBVER_LATEST (0x01)

//Success/Error Result
#define GS_EX_ERR_OK (0)
#define GS_EX_ERR_GENERAL_FAILURE (1)
#define GS_EX_ERR_INVALID_SUBCMD (2)
#define GS_EX_ERR_INVALID_SUBVER (3)
#define GS_EX_ERR_NOT_ENOUGH_MEM (4)
#define GS_EX_ERR_API_FAILURE (5)

#define SPY_GPS_LOCATION 0
#define SPY_GPS_SPEED 1
#define SPY_GPS_ALTITUDE 2

/**
 * No need to make this public, this is for our production tools.
 * @see FlashDevice2
 */
typedef struct _SReflashChip_t
{
	uint32_t chipId;
	char path[1024];
	uint32_t zeroes[100];
} SReflashChip_t;

typedef struct _NeoDeviceEx
{
	NeoDevice neoDevice;

	uint32_t FirmwareMajor;
	uint32_t FirmwareMinor;

#define CANNODE_STATUS_COREMINI_IS_RUNNING (0x1)
#define CANNODE_STATUS_IN_BOOTLOADER (0x2)
	uint32_t Status;// Bitfield, see defs above

/** Option bit flags */
#define MAIN_VNET (0x01)
#define SLAVE_VNET_A (0x02)
#define SLAVE_VNET_B (0x04)
#define WIFI_CONNECTION (0x08)
	uint32_t Options;

	void* pAvailWIFINetwork;
	void* pWIFIInterfaceInfo;

	uint32_t Reserved[7];// may be expanded in future revisions

} NeoDeviceEx;

/* Error constants */
#define NEOVI_ERROR_DLL_TX_BUFFER_OVERFLOW 0
#define NEOVI_ERROR_DLL_ERROR_BUFFER_OVERFLOW 1
#define NEOVI_ERROR_DLL_USB_SEND_DATA_ERROR 2
#define NEOVI_ERROR_DLL_ISO_DATA_BUFFER_ALLOC 3
#define NEOVI_ERROR_DLL_ISO_DATA_READ_BUFFER 4
#define NEOVI_ERROR_DLL_ISO_DATA_ZERO_PACKETS 5
#define NEOVI_ERROR_DLL_RX_MSG_BUFFER_OVERFLOW 6
#define NEOVI_ERROR_DLL_STOP_ISO_STREAM 7
#define NEOVI_ERROR_DLL_INVALID_NETID 8
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_RX_THREAD 9
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_TX_THREAD 10
#define NEOVI_ERROR_DLL_MAIN_PIC_BUFFER_OVERFLOW 11
#define NEOVI_ERROR_DLL_INVALID_DEVICE_RESPONSE 12
#define NEOVI_ERROR_DLL_ISOTX_DATA_BUFFER_ALLOC 13
#define NEOVI_ERROR_DLL_RX_CMD_BUFFER_OVERFLOW 14
#define NEOVI_ERROR_DLL_RS232_RX_BUFFER_OVERFLOW 15
#define NEOVI_ERROR_DLL_RS232_ERR_READCOMERR 16
#define NEOVI_ERROR_DLL_RS232_ERR_READ 17
#define NEOVI_ERROR_DLL_RS232_BUFFER_ALLOC 18
#define NEOVI_ERROR_DLL_RS232_TX_BUFFER_OVERFLOW 19
#define NEOVI_ERROR_DLL_RS232_MISC_ERROR 20
#define NEOVI_ERROR_DLL_RS232_FIND_WRITE 21
#define NEOVI_ERROR_DLL_RS232_FIND_BUFFER_ALLOC 22
#define NEOVI_ERROR_DLL_RS232_FIND_CLEARCOMM 23
#define NEOVI_ERROR_DLL_RS232_FIND_READCOMM 24
#define NEOVI_ERROR_DLL_RS232_FIND_TIMEOUT 25
#define NEOVI_ERROR_DLL_RS232_ERR_BREAK 26
#define NEOVI_ERROR_DLL_RS232_ERR_FRAME 27
#define NEOVI_ERROR_DLL_RS232_ERR_IOE 28
#define NEOVI_ERROR_DLL_RS232_ERR_OVERRUN 29
#define NEOVI_ERROR_DLL_RS232_ERR_PARITY 30
#define NEOVI_ERROR_DLL_RS232_TXBUFFER_ALLOC 31
#define NEOVI_ERROR_DLL_USB_TX_RS232_ERROR 32
#define NEOVI_ERROR_DLL_RS232_CREATE_FILE 33
#define NEOVI_ERROR_DLL_RS232_GET_COMM_STATE 34
#define NEOVI_ERROR_DLL_RS232_SET_COMM_STATE 35
#define NEOVI_ERROR_DLL_RS232_START_COMM_RX_THREAD 36
#define NEOVI_ERROR_DLL_RS232_START_COMM_TX_THREAD 37
#define NEOVI_ERROR_DLL_SYNC_COUNT_ERR 38
#define NEOVI_ERROR_DLL_RX_MSG_FRAME_ERR 39
#define NEOVI_ERROR_DLL_RX_MSG_FIFO_OVER 40
#define NEOVI_ERROR_DLL_RX_MSG_CHK_SUM_ERR 41
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_BULKIN_THREAD 42
#define NEOVI_ERROR_DLL_BULKIN_ERR_READ 43
#define NEOVI_ERROR_DLL_MAIN51_RX_FIFO_OVERFLOW 44
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW 45
#define NEOVI_ERROR_DLL_MAIN51_DEV_FIFO_OVERFLOW 46
#define NEOVI_ERROR_DLL_RESET_STATUS_CHANGED 47
#define NEOVI_ERROR_DLL_ISO_LONG_CACHE_OVERFLOW 48
#define NEOVI_ERROR_DLL_ISORX_LONG_BUFFER_ALLOC 49
#define NEOVI_ERROR_DLL_J1708_LONG_CACHE_OVERFLOW 50
#define NEOVI_ERROR_DLL_J1708_LONG_BUFFER_ALLOC 51
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_DEVICE 52
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_HSCAN 53
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_MSCAN 54
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_SWCAN 55
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_LSFTCAN 56
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_FORDSCP 57
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_J1708 58
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_AUX 59
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_JVPW 60
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_ISO 61
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_ISOPIC 62
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_MAIN51 63
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_HOST 64
#define NEOVI_ERROR_DLL_READ_ENTIRE_DEEPROM_ERROR 65
#define NEOVI_ERROR_DLL_WRITE_ENTIRE_DEEPROM_ERROR 66
#define NEOVI_ERROR_DLL_USB_PORT_ALREADY_OPEN 67
#define NEOVI_ERROR_DLL_JVPW_TX_REPORT_FIFO_ERR_IN 68
#define NEOVI_ERROR_DLL_ISOJ_TX_REPORT_FIFO_ERR_IN 69
#define NEOVI_ERROR_DLL_JVPW_TX_REPORT_FIFO_ERR_OUT 70
#define NEOVI_ERROR_DLL_ISOJ_TX_REPORT_FIFO_ERR_OUT 71
#define NEOVI_ERROR_DLL_MAIN51_TX_IN_FROM_HOST_FIFO 72
#define NEOVI_ERROR_DLL_MAIN51_TX_HOST_CHKSUM 73
#define NEOVI_ERROR_DLL_ISOJ_TX_HOST_MISSED_BYTE 74
#define NEOVI_ERROR_DLL_NEOVI_NO_RESPONSE 75
#define NEOVI_ERROR_DLL_RX_SOCKET_FIFO_OVER 76
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_TXSOCKET_THREAD 77
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_RXSOCKET_THREAD 78
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_RXSOCKET_CLIENT_THREAD 79
#define NEOVI_ERROR_DLL_TCP_CLIENT_TX 80
#define NEOVI_ERROR_DLL_TCP_CLIENT_RX 81
#define NEOVI_ERROR_DLL_TCP_CLIENT_RX_SOCK 82
#define NEOVI_ERROR_DLL_UNABLE_CONNECT_TO_SRVR 83
#define NEOVI_ERROR_DLL_UNABLE_CREATE_CLIENT_SOCK 84
#define NEOVI_ERROR_DLL_UNABLE_WSASTARTUP 85
#define NEOVI_ERROR_DLL_SOCK_CL_RD_BUFFER_ALLOC 86
#define NEOVI_ERROR_DLL_SOCK_CL_TX_BUFFER_ALLOC 87
#define NEOVI_ERROR_DLL_SOCK_SRVR_RX_BUFFER_ALLOC 88
#define NEOVI_ERROR_DLL_SOCK_SRVR_TX_BUFFER_ALLOC 89
#define NEOVI_ERROR_DLL_ILLEGAL_TX_NETWORK 90
#define NEOVI_ERROR_DLL_MAIN51_TX_HOST_OVERRUN 91
#define NEOVI_ERROR_DLL_OPEN_GET_COMM_TIMEOUT 92
#define NEOVI_ERROR_DLL_OPEN_SET_COMM_TIMEOUT 93
#define NEOVI_ERROR_DLL_OPEN_READ_DEVICE_TYPE 94
#define NEOVI_ERROR_DLL_OPEN_READ_DEVICE_TYPE_TOUT 95
#define NEOVI_ERROR_DLL_CLOSE_PURGE_COMM 96
#define NEOVI_ERROR_DLL_TX_COM_FIFO_OVERFLOW 97
#define NEOVI_ERROR_DLL_GET_USBSERIAL_DEVICES 98
#define NEOVI_ERROR_DLL_USB_TX_RS232_BCOUNT 99
#define NEOVI_ERROR_DLL_OPEN_INBOOTLOADER 100
#define NEOVI_ERROR_DLL_TOO_MANY_PERIODICS 101
#define NEOVI_ERROR_DLL_PROBLEM_FIRMWARE_INFO 102
#define NEOVI_ERROR_DLL_NRED_ODDNUMBYTES 103
#define NEOVI_ERROR_DLL_NRED_UNKNOWN_RED_NETID 104
#define NEOVI_ERROR_DLL_RED_NOT_SUPPORTED 105
/* 106 - 116 reserved for neovi red bootloader exceptions */
#define NEOVI_ERROR_DLL_RED_BL_START_INDEX 106
#define NEOVI_ERROR_DLL_3G_BL_FAILURE 107
#define NEOVI_ERROR_DLL_RED_BL_END_INDEX 116
#define NEOVI_ERROR_DLL_RED_FAILED_TO_ENTER_BL 117
#define NEOVI_ERROR_DLL_RED_REQ_SERIAL_NUMBER 118
#define NEOVI_ERROR_DLL_RED_AUTHENTICATE 119
#define NEOVI_ERROR_DLL_RED_APP_VERSION 120
#define NEOVI_ERROR_DLL_RED_SET_BAUD_COMM_FAILURE 121
#define NEOVI_ERROR_DLL_RED_INVALID_BAUD_SPECIFIED 122
#define NEOVI_ERROR_DLL_RED_READ_BAUD_COMM_FAILURE 123
#define NEOVI_ERROR_DLL_RED_FAILED_TO_SAVE_EEPROM 124
#define NEOVI_ERROR_DLL_RED_FAILED_TO_UPDATE_WAVEFORM_CHANNEL 125

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_UNKNOWN_NETWORK 126
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_UNKNOWN_NETWORK 127
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_UNKNOWN_NETWORK 128

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN1 129
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN1 130
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN1 131
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN1 132

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN2 133
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN2 134
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN2 135
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN2 136

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_MSCAN1 137
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_MSCAN1 138
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_MSCAN1 139
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_MSCAN1 140

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN3 141
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN3 142
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN3 143
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN3 144

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_SWCAN 145
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_SWCAN 146
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_SWCAN 147
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_SWCAN 148

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LSFTCAN 149
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LSFTCAN 150
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LSFTCAN 151
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LSFTCAN 152

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LIN1 153
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LIN1 154
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LIN1 155
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LIN1 156

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LIN2 157
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LIN2 158
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LIN2 159
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LIN2 160

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LIN3 161
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LIN3 162
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LIN3 163
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LIN3 164

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LIN4 165
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LIN4 166
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LIN4 167
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LIN4 168

#define NEOVI_ERROR_DLL_USB_PURGE_FAILED 169
#define NEOVI_ERROR_FIRE_COMM_BAD_PACKET 170
#define NEOVI_ERROR_FIRE_CGI_COMM_BAD_PACKET 171


#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN1 172
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN2 173
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN3 174
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_MSCAN 175
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_SWCAN 176
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LSFTCAN 177
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LIN1 178
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LIN2 179
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LIN3 180
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LIN4 181
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_UNKNOWN_NETWORK 182
#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_JVPW 183
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_JVPW 184
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_JVPW 185
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_JVPW 186
#define NEOVI_ERROR_DLL_INTERNAL_SERIAL_NO_DOES_NOT_MATCH_REGISTRY_SERIAL_NO 187
#define NEOVI_ERROR_DLL_JVPW_LONG_CACHE_OVERFLOW 188
#define NEOVI_ERROR_DLL_FAILED_TO_SET_LICENSE 189
#define NEOVI_ERROR_DLL_3G_DEVICE_LICENSE_NEEDS_TO_BE_UPGRADED 190

#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN 191
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_MSCAN 192
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN2 193
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN3 194
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LSFT 195
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_SW 196
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LIN1 197
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LIN2 198
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LIN3 199
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LIN4 200
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_JVPW 201
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_KYW 202
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_J1708 203
#define NEOVI_ERROR_DLL_MAIN51_RTC_INVALID 204
#define NEOVI_ERROR_DLL_MAIN51_LOADED_DEFAULT_SETTINGS 205

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_CGI 206
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_CGI 207
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_CGI 208
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_CGI 209
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_CGI 210
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_CGI 211
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_JVPW 212

//DLL API ERRORS
#define NEOVI_ERROR_DLL_INVALID_SCRIPT_LOCATION 213
#define NEOVI_ERROR_DLL_SDCARD_NOT_INSERTED 214
#define NEOVI_ERROR_DLL_SDCARD_NOT_FORMATTED 215
#define NEOVI_ERROR_DLL_SDCARD_WRITE_ERROR 216
#define NEOVI_ERROR_DLL_SDCARD_READ_ERROR 217
#define NEOVI_ERROR_DLL_SCRIPT_START_ERROR 218
#define NEOVI_ERROR_DLL_SCRIPT_INVALID_FUNCBLOCK_INDEX 219
#define NEOVI_ERROR_DLL_SCRIPT_ERROR_DOWNLOADING_SCRIPT 220
#define NEOVI_ERROR_DLL_SCRIPT_ERROR_CLEARING_SCRIPT 221

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ISO 222
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ISO 223
#define NEOVI_ERROR_DLL_SCRIPT_INVALID_MSG_INDEX 224
#define NEOVI_ERROR_DLL_SCRIPT_INVALID_APPSIG_INDEX 225
#define NEOVI_ERROR_DLL_SCRIPT_NO_SCRIPT_RUNNING 226
#define NEOVI_ERROR_DLL_COULD_NOT_SET_SETTINGS_FIRMWARE_MISMATCH 227
#define NEOVI_ERROR_DLL_FIRE_CGI_TX_NOT_ENABLED 228
#define NEOVI_ERROR_DLL_SEND_DEVICE_CONFIG_ERROR 229
#define NEOVI_ERROR_DLL_GET_DEVICE_CONFIG_ERROR 230
#define NEOVI_ERROR_DLL_UNKNOWN_NEOVI_TYPE 231
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ISO2 232
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ISO3 233
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ISO4 234

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ISO2 235
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_ISO2 236
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_ISO2 237
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_ISO2 238
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ISO2 239
#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ISO3 240
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_ISO3 241
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_ISO3 242
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_ISO3 243
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ISO3 244
#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ISO4 245
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_ISO4 246
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_ISO4 247
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_ISO4 248
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ISO4 249
#define NEOVI_ERROR_DLL_RED_FAILED_TO_CLEAR_LIN_SLAVE_DATA 250
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ISO1 251
#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ISO1 252
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_ISO1 253
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_ISO1 254
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ISO1 255
#define NEOVI_ERROR_DLL_DROPPED_RTC_CMD 256
#define NEOVI_ERROR_DLL_J1850_TX_REQUESTS_FLUSHED 257
#define NEOVI_ERROR_J1708_COMM_BAD_PACKET 258
#define NEOVI_ERROR_DLL_NETWORK_NOT_SUPPORTED_BY_HARDWARE 259
#define NEOVI_ERROR_DLL_FEATURE_NOT_UNLOCKED 260
#define NEOVI_ERROR_DLL_DEVICE_NOT_POWERED 261
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_OK 262////
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORBADINIT 263// See ENeoVI3GCANDownloaderReturnCode_t in neoVI3GCANDownloader.h
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORNOCANPIPE 264//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORISONEG7FRESPONSE 265//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORTOOLNOTSELECTED 266//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORINVALIDDEVICESELECTED 267//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORCOULDNOTOPENTOOL 268//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORNOFLOWCONTROL 269//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORUNSPECIFIC 270//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORCOREMININULLPTR 271//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORCOREMINIZEROLEN 272//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORRESERVED3 273//
#define NEOVI_ERROR_DLL_3GCANDOWNLOADER_ERRORRESERVED4 274//
//#define NEOVI_ERROR_DLL_YELLOW_DEPRECATED		  275
#define NEOVI_ERROR_DLL_HARDWARE_FAILURE_SRAM 276//SRAM Problem ERROR report
#define NEOVI_ERROR_ACTIVE_CONNECTION_ALREADY_EXISTS 277
#define NEOVI_ERROR_DLL_MAIN51_RTC_FAILED_READ 278
#define NEOVI_ERROR_DLL_MAIN51_RTC_AUTO_RTC 279
#define NEOVI_ERROR_PLASMA_CORE_RESTARTED 280
#define NEOVI_ERROR_REQ_VBATT_FAILED 281
#define NEOVI_ERROR_TXRX_PAIRS_TIMEOUT 282
#define NEOVI_ERROR_TXRX_PAIRS_BUSY 283
#define NEOVI_ERROR_COREMINI_IN_USE 284
//For Bug 5589 - Duplicate error number of 78 is removed and added as 285.
#define NEOVI_ERROR_DLL_PROBLEM_STOPPING_TXSOCKET_CLIENT_THREAD 285//Bug 5589
#define NEOVI_ERROR_ABORTED_FOR_SHUTDOWN 286//Bug 7440
#define NEOVI_ERROR_DLL_SEND_DEVICE_CONFIG_NOTPOSSIBLE 287//Bug 7701
#define NEOVI_ERROR_CHANNEL_LOCKED_BY_OTHER_CLIENT 288
#define NEOVI_ERROR_NEOVISERVER_GENERAL_ERROR 289
#define NEOVI_ERROR_CHANNEL_LOCKING_NOT_SUPPORTED_FOR_DEVICE 290
#define NEOVI_ERROR_DLL_TOO_MANY_TXRXPAIRS 291
#define NEOVI_ERROR_DLL_TXRXPAIRS_NOT_SUPPORTED_FOR_DEVICE 292
#define NEOVI_ERROR_TXRX_PAIRS_FAILED 293
/**
 * So we've been using NEOVI_ERROR_DLL_DEVICE_NOT_POWERED to handle just
 * about all generic failures.  The problem is that now we have hardware
 * that actually can detect if Vehicle power is missing.  So we have
 * this new define to deliniate between the general failure case and
 * ACTUALLY measuring that vehicle power is missing.
 */
#define NEOVI_ERROR_DLL_DEVICE_USB_CONNECTED_BUT_NOT_POWER 294
/* added defs for hs4 and hs5.  Before we were defaulting into hs3 enums */
#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN4 295
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN4 296
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN4 297
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN4 298
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN4 299
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN4 300

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN5 301
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN5 302
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN5 303
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN5 304
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN5 305
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN5 306

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_SWCAN2 307
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_SWCAN2 308
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_SWCAN2 309
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_SWCAN2 310
#define NEOVI_ERROR_DLL_MAIN51_TX_FIFO_OVERFLOW_SWCAN2 311
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_SWCAN2 312
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_SW2 313

#define NEOVI_ERROR_TX_INTERFACE_NOT_IMPLEMENTED 314
#define NEOVI_ERROR_TX_MESSAGES_COMM_ENABLE_IS_OFF 315
#define NEOVI_ERROR_RX_FILTER_MATCH_COUNT_EXCEEDED 316

#define FLEXRAY_ERROR_NO_DEVICES_ATTACHED 317
#define FLEXRAY_ERROR_DEVICE_COULD_NOT_BE_OPENED 318
#define FLEXRAY_ERROR_BIT_FILE_NOT_FOUND 319
#define FLEXRAY_ERROR_FPGA_CONFIG_FAILED 320
#define FLEXRAY_ERROR_OUTPUT_MESSAGE_FIFO_OVERFLOW 321
#define FLEXRAY_ERROR_DATA_INCORRECT_SEQUENCE_ERROR 322
#define FLEXRAY_ERROR_DATA_SYNCHRONIZATION_ERROR 323
#define FLEXRAY_ERROR_HELPER_DLL_COULD_NOT_BE_LOADED 324
#define FLEXRAY_ERROR_INPUT_FIFO_OVERFLOW 325
#define FLEXRAY_ERROR_INVALID_ESCAPE_SEQUENCE 326
#define FLEXRAY_ERROR_USB_LOW_LEVEL_READ_FAILURE 327
#define FLEXRAY_ERROR_ERROR_FIFO_OVERFLOW 328
#define FLEXRAY_ERROR_HEARTBEAT_SEQUENCE_ERROR 329
#define FLEXRAY_ERROR_HEARTBEAT_TIMEOUT_ERROR 330
#define NEOVI_ERROR_FAILED_TO_SET_RTC 331

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_FR1A 332
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_FR1A 333
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_FR1B 334
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_FR2A 335
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_FR2B 336

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LIN5 337
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LIN5 338
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LIN5 339
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LIN5 340
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LIN5 342
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LIN5 343

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN6 344
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN6 345
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN6 346
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN6 347
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN6 348
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN6 349

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_HSCAN7 350
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_HSCAN7 351
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_HSCAN7 352
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_HSCAN7 353
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_HSCAN7 354
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_HSCAN7 355

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LSFTCAN2 356
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LSFTCAN2 357
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LSFTCAN2 358
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LSFTCAN2 359
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LSFTCAN2 360
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LSFTCAN2 361

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_LIN6 362
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_LIN6 363
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_LIN6 364
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_LIN6 365
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_LIN6 366
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_LIN6 367
#define NEOVI_ERROR_DLL_CONTACT_TECH_SUPPORT 368

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH1 NEOVI_ERROR_DLL_CONTACT_TECH_SUPPORT + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH1 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH1 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH1 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH1 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH1 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH1 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH1 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH1 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH1 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH1 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH2 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH1 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH2 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH2 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH2 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH2 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH2 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH2 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH2 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH2 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH2 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH2 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH3 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH2 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH3 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH3 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH3 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH3 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH3 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH3 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH3 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH3 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH3 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH3 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH4 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH3 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH4 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH4 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH4 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH4 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH4 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH4 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH4 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH4 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH4 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH4 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH5 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH4 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH5 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH5 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH5 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH5 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH5 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH5 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH5 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH5 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH5 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH5 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH6 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH5 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH6 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH6 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH6 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH6 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH6 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH6 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH6 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH6 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH6 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH6 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH7 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH6 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH7 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH7 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH7 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH7 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH7 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH7 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH7 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH7 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH7 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH7 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH8 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH7 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH8 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH8 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH8 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH8 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH8 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH8 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH8 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH8 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH8 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH8 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH9 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH8 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH9 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH9 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH9 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH9 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH9 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH9 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH9 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH9 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH9 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH9 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH10 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH9 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH10 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH10 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH10 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH10 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH10 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH10 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH10 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH10 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH10 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH10 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH11 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH10 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH11 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH11 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH11 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH11 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH11 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH11 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH11 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH11 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH11 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH11 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH12 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH11 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_OP_ETH12 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH12 + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_OP_ETH12 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH12 + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_OP_ETH12 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH12 + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_OP_ETH12 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH12 + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH12 NEOVI_ERROR_DLL_RED_RX_MSG_FULL_OP_ETH12 + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_OP_ETH12 + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_ETHERNET NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_ETHERNET NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_ETHERNET NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ETHERNET NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ETHERNET NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET + 5

#define NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET_DAQ NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ETHERNET + 1
#define NEOVI_ERROR_DLL_RED_TX_MSG_FULL_ETHERNET_DAQ NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET_DAQ + 1
#define NEOVI_ERROR_DLL_RED_TX_REPORT_MSG_FULL_ETHERNET_DAQ NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET_DAQ + 2
#define NEOVI_ERROR_DLL_RED_DRIVER_OVERFLOW_ETHERNET_DAQ NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET_DAQ + 3
#define NEOVI_ERROR_DLL_NETWORK_NOT_ENABLED_ETHERNET_DAQ NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET_DAQ + 4
#define NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ETHERNET_DAQ NEOVI_ERROR_DLL_RED_RX_MSG_FULL_ETHERNET_DAQ + 5

#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH1 NEOVI_ERROR_DLL_RED_SETTINGS_NOT_SET_ETHERNET_DAQ + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH2 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH1 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH3 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH2 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH4 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH3 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH5 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH4 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH6 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH5 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH7 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH6 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH8 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH7 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH9 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH8 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH10 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH9 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH11 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH10 + 1
#define NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH12 NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH11 + 1

#define NEOVI_ERROR_DLL_ETH_PCAP_TX_ERROR NEOVI_ERROR_DLL_RED_PREEMPTION_NOT_ENABLED_OP_ETH12 + 1
#define NEOVI_ERROR_DLL_ETH_PCAP_RX_ERROR NEOVI_ERROR_DLL_ETH_PCAP_TX_ERROR + 1

// Constants for describing error severity
#define icsspyErrCritical 0x10
#define icsspyErrQuestion 0x20
#define icsspyErrExclamation 0x30
#define icsspyErrInformation 0x40

typedef struct _SPerformanceStats
{
	uint32_t average_main_loop_us;
	uint32_t min_main_loop_us;
	uint32_t max_main_loop_us;
} SPerformanceStats;

/* product ids */
#define NEOVI_RED_PROD_ID 0
#define NEOVI_FIRE_PROD_ID 1
#define NEOVI_VCAN3_PROD_ID 2
#define NEOVI_ECU_PROD_ID 4
#define NEOVI_IEVB_PROD_ID 5
#define NEOVI_PENDANT_PROD_ID 6
#define NEOVI_NEOANALOG_PROD_ID 7
#define NEOVI_PLASMA_PROD_ID 10
#define NEOVI_ION_PROD_ID 11
#define NEOVI_VCAN4_PROD_ID 12
#define NEOVI_CMPROBE_PROD_ID 14
#define NEOVI_EEVB_PROD_ID 15
#define NEOVI_RADSTAR_PROD_ID 16
#define NEOVI_VCANRF_PROD_ID 17
#define NEOVI_FIRE2_CYAN_PROD_ID 18
#define NEOVI_RADGALAXY_PROD_ID 19
#define NEOVI_RADSTAR2_PROD_ID 20
#define NEOVI_VIVIDCAN_PROD_ID 21
#define NEOOBD2_SIM_PROD_ID 22
#define NEOOBD2_PRO_PROD_ID 23
#define NEO_VCAN412_PROD_ID 24

/*
 * deprecated hardware. RIP
 */
//#define NEOVI_YELLOW_PROD_ID        3

/* chip ids */
#define NEOVI_FIRE_MCHIP_ID 0
#define NEOVI_FIRE_LCHIP_ID 1
#define NEOVI_FIRE_UCHIP_ID 2
#define NEOVI_FIRE_JCHIP_ID 3

#define NEOVI_VCAN3_MCHIP_ID 4

#define NEOVI_ECU_MPIC_ID 6

#define NEOVI_IEVB_MPIC_ID 7

#define NEOVI_PENDANT_MPIC_ID 8

#define NEOVI_VNETFIRE_MCHIP_ID 9
#define NEOVI_VNETFIRE_LCHIP_ID 10
#define NEOVI_PLASMA_CORE_ID 11
#define NEOVI_PLASMA_HID_ID 12

#define NEOVI_ANALOG_MPIC_ID 13

#define NEOVI_PLASMA_ANALOG_CORE_ID 14
#define NEOVI_PLASMA_FLEXRAY_CORE_ID 15
#define NEOVI_PLASMA_CORE_ID_1_12 16

#define NEOVI_SLAVE_VNETFIRE_MCHIP_ID 17
#define NEOVI_SLAVE_VNETFIRE_LCHIP_ID 18

#define NEOVI_ION_CORE_ID 19
#define NEOVI_ION_HID_ID 20
#define NEOVI_ION_CORE_LOADER_ID 21
#define NEOVI_ION_HID_LOADER_ID 22
#define NEOVI_ION_FPGA_BIT_ID 23

#define NEOVI_VNETFIRE_EP_MCHIP_ID 24
#define NEOVI_VNETFIRE_EP_LCHIP_ID 25
#define NEOVI_AOUT_MCHIP 26
#define NEOVI_MOST25_MCHIP 27
#define NEOVI_MOST50_MCHIP 28
#define NEOVI_MOST150_MCHIP 29
#define NEOVI_VCAN4_MCHIP_ID 30
#define NEOVI_VCAN4_SCHIP_ID 31

#define NEOVI_CMPROBE_ZYNQ_ID 33
#define NEOVI_EEVB_STM32_ID 34

#define NEOVI_VNETFIRE_SLAVE_EP_MCHIP_ID 35
#define NEOVI_VNETFIRE_SLAVE_EP_LCHIP_ID 36

#define NEOVI_RADSTAR_MCHIP_ID 37
#define NEOVI_VCANRF_MCHIP_ID 38

#define NEOVI_FIRE2_CYAN_MCHIP_ID 39
#define NEOVI_FIRE2_CYAN_CCHIP_ID 40
#define NEOVI_FIRE2_CYAN_CORE_ID 41
#define NEOVI_FIRE2_CYAN_BLECHIP_ID 42
#define NEOVI_FIRE2_CYAN_ZYNQ_ID 43// FIRE2 MVNET Z - Zynq
#define NEOVI_FIRE2_CYAN_SECURITYCHIP_ID 44
#define NEOVI_RADGALAXY_ZYNQ_ID 45
#define FIRE2_VNET_MCHIP_ID 46
#define SLAVE_A_FIRE2_VNET_MCHIP_ID 47
#define SLAVE_A_FIRE2_VNET_CCHIP_ID 48
#define FIRE2_VNET_CCHIP_ID 49
#define FIRE2_VNET_CORE_ID 50
#define NEOVI_RADSTAR2_ZYNQ_ID 51
#define NEOVI_VIVIDCAN_MCHIP_ID 52
#define NEOVI_OBD2_SIM_MCHIP_ID 53
#define FIRE2_VNETZ_MCHIP_ID 54
#define FIRE2_VNETZ_ZYNQ_ID 55
#define SLAVE_A_FIRE2_VNETZ_MCHIP_ID 56
#define SLAVE_A_FIRE2_VNETZ_ZYNQ_ID 57
#define NEOVI_VIVIDCAN_EXT_FLASH_ID 58
#define NEOVI_VIVIDCAN_NRF52_ID 59
#define CMPROBE_ZYNQ_ID 60
#define NEO_OBD2_PRO_MCHIP_ID 61
#define VCAN41_MCHIP_ID 62
#define VCAN42_MCHIP_ID 63

/* begin slave B chip ids
 * for vspy internal use only
 * actual vnet should always report the base chip id above */
#define SLAVE_B_FIRE2_VNETZ_ZYNQ_ID 241
#define SLAVE_B_FIRE2_VNETZ_MCHIP_ID 242
#define SLAVE_B_FIRE2_VNET_MCHIP_ID 243
#define SLAVE_B_FIRE2_VNET_CCHIP_ID 244
#define NEOVI_SLAVE_B_VNETFIRE_MCHIP_ID 245
#define NEOVI_SLAVE_B_VNETFIRE_LCHIP_ID 246
#define NEOVI_PLASMA_SLAVE_B_ANALOG_CORE_ID 247
#define NEOVI_PLASMA_SLAVE_B_FLEXRAY_CORE_ID 248
#define NEOVI_SLAVE_B_MOST25_MCHIP 249
#define NEOVI_SLAVE_B_MOST50_MCHIP 250
#define NEOVI_SLAVE_B_MOST150_MCHIP 251
#define NEOVI_SLAVE_B_AOUT_MCHIP 252
#define NEOVI_VNETFIRE_SLAVE_B_EP_MCHIP_ID 253
#define NEOVI_VNETFIRE_SLAVE_B_EP_LCHIP_ID 254
/* end slave B chip ids */

/*
 * deprecated hardware. RIP
 */
//#define NEOVI_YELLOW_MCHIP_ID 	5
//#define NEOVI_YELLOW_UCHIP_ID    NEOVI_FIRE_UCHIP_ID

/* VNET IDs */
#define VNET_ID_FIRE 1
#define VNET_ID_FIRE_EP 2
#define VNET_ID_SLAVEFIRE 3
#define VNET_ID_SLAVEFIRE_EP 4
#define VNET_ID_AIN 5
#define VNET_ID_FLEXRAY 6
#define VNET_ID_FIRE2 7
#define VNET_ID_SLAVEFIRE2 8
#define VNET_ID_FIRE2Z 9
#define VNET_ID_SLAVEFIRE2Z 10

#define ICS_NEODEVICE_OLD_VERSION(x) (x == NEODEVICE_DW_VCAN || x == NEODEVICE_BLUE)
#define ICS_NEODEVICE_NEW_VERSION(x) (x == NEODEVICE_FIRE || x == NEODEVICE_VCAN3 || x == NEODEVICE_CT_OBD)

#define HARDWARE_TIMESTAMP_ID_NONE (unsigned char)0
#define HARDWARE_TIMESTAMP_ID_VSI (unsigned char)1
#define HARDWARE_TIMESTAMP_ID_AVT_716 (unsigned char)2
#define HARDWARE_TIMESTAMP_ID_NI_CAN (unsigned char)3
#define HARDWARE_TIMESTAMP_ID_NEOVI (unsigned char)4
#define HARDWARE_TIMESTAMP_ID_AVT_717 (unsigned char)5
#define HARDWARE_TIMESTAMP_ID_NEOv6_VCAN (unsigned char)6
#define HARDWARE_TIMESTAMP_ID_DOUBLE_SEC (unsigned char)7
#define HARDWARE_TIMESTAMP_ID_NEORED_10US (unsigned char)8
#define HARDWARE_TIMESTAMP_ID_NEORED_25NS (unsigned char)9
#define HARDWARE_TIMESTAMP_ID_NEORED_10NS (unsigned char)10

#define SYSTEM_TIMESTAMP_ID_NONE (unsigned char)0
#define SYSTEM_TIMESTAMP_ID_TIMEGETTIME_API (unsigned char)1

// these are used in status2 for Vehicle Spy 3
#define icsspystatusChangeLength (long)0x10
#define icsspystatusChangeBitH1 (long)0x20
#define icsspystatusChangeBitH2 (long)0x40
#define icsspystatusChangeBitH3 (long)0x80
#define icsspystatusChangeBitB1 (long)0x100
#define icsspystatusChangeBitB2 (long)0x200
#define icsspystatusChangeBitB3 (long)0x400
#define icsspystatusChangeBitB4 (long)0x800
#define icsspystatusChangeBitB5 (long)0x1000
#define icsspystatusChangeBitB6 (long)0x2000
#define icsspystatusChangeBitB7 (long)0x4000
#define icsspystatusChangeBitB8 (long)0x8000
#define icsspystatusChangedGlobal (long)0x10000

typedef enum _can_clock_t { CAN_CLK_INVALID, CAN_CLK_40MIPS, CAN_CLK_64MIPS, CAN_CLK_16MIPS } can_clock_t;

typedef enum _can_clock_fire2_t {
	CAN_CLK_FIRE2_40MHz,
	CAN_CLK_FIRE2_80MHz,
} can_clock_fire2_t;

#pragma pack(push, 2)

/**
 * To make up VisualStudio's in ability to tightly pack bitfields
 * redef the settings structure with the tail end all bitfields.
 */
typedef struct _CAN_SETTINGS_DECODE
{
	uint8_t Mode;
	uint8_t SetBaudrate;
	uint8_t Baudrate;
	uint8_t transceiver_mode;
	uint8_t TqSeg1;
	uint8_t TqSeg2;
	uint8_t TqProp;
	uint8_t TqSync;
	uint16_t BRP;
	uint8_t auto_baud;
	unsigned innerFrameDelay25us : 4;// 0 - 375us, 25us resolution
	unsigned : 2;
	unsigned clk : 2;//!< 0 is invalid, 1 is 40Mips, 2 is 64 Mips, 3 is 16Mbps.
} CAN_SETTINGS_DECODE;

typedef struct _SNeoMostGatewaySettingsDecode
{
	uint16_t netId; /* Netid of CAN network to use */
	uint8_t zero0;
	unsigned enabled : 1; /* set to 1 to enable neoMOST network. */
	unsigned miscIoIndex : 3;//1< index of which miscio to use for timestamp sync. 0 => MISC1.
	unsigned echoOnCan : 1;
	unsigned zero1 : 3;
} SNeoMostGatewaySettingsDecode;

enum
{
	MSCAN2,
	LSFTCAN2,
	SWCAN2
};// CAN2 Network Type

/* Deprecated Yellow settings
typedef VS_MODIFIER struct _SYellowSettings
{
    CAN_SETTINGS can1;
    CAN_SETTINGS can2;

    //RS232_SETTINGS rs232;
    icscm_uint16 rs232_deprecated[3];
        
    icscm_uint16 hs2_j1708_enable;		// Use hs2 + J1708
    icscm_uint16 iso_j1850_enable;		// Select ISO + J1850
    icscm_uint16 j1708_j1850_enable;	// Use J1708 + J1850
    
    icscm_uint16 network_enables;
    icscm_uint16 network_enables_2;  
    icscm_uint16 network_enabled_on_boot;
    
    icscm_uint32 pwm_man_timeout;
    icscm_uint16 pwr_man_enable; // 0 - off, 1 - sleep enabled, 2- idle enabled (fast wakeup)
    
    icscm_uint16 misc_io_initial_ddr;  
    icscm_uint16 misc_io_initial_latch;
    icscm_uint16 misc_io_analog_enable;
    icscm_uint16 misc_io_report_period;
    icscm_uint16 misc_io_on_report_events;
    icscm_uint16 ain_sample_period;
    icscm_uint16 ain_threshold;

    //ISO 15765 Transport Layer
    icscm_int16 iso15765_separation_time_offset;
    
    //ISO9141 - KEYWORD 2000 1
    icscm_int16 iso9141_kwp_enable_reserved;
    ISO9141_KEYWORD2000_SETTINGS iso9141_kwp_settings;
    LIN_SETTINGS lin1;
    
    //ISO9141 - KEYWORD 2000 2 // remove later
    icscm_int16 iso9141_kwp_enable_reserved_2; // remove later
    ISO9141_KEYWORD2000_SETTINGS iso9141_kwp_settings_2; // remove later
    LIN_SETTINGS lin2;

    //J1708
    J1708_SETTINGS j1708;

    //Performance Test
    icscm_uint16 perf_en;
    
    //ISO9141 - Parity
    icscm_uint16 iso_parity; // 0 - no parity, 1 - event, 2 - odd
    icscm_uint16 iso_msg_termination; // 0 - use inner frame time, 1 - GME CIM-SCL
    icscm_uint16 iso_tester_pullup_enable;
    
    //remove later
    icscm_uint16 iso_parity_2; 							// 0 - no parity, 1 - event, 2 - odd
    icscm_uint16 iso_msg_termination_2; 				// 0 - use inner frame time, 1 - GME CIM-SCL
    
    
    icscm_uint16 fast_init_network_enables_1;
    icscm_uint16 fast_init_network_enables_2;
    
    UART_SETTINGS uart;
    UART_SETTINGS uart2;
    
    STextAPISettings text_api;

} GCC_MODIFIER SYellowSettings;
#define        SYellowSettings_SIZE 438
*/

typedef struct _SReflashRequest
{
	char fire_mpic_ief[1024];
	unsigned long fire_mpic_enable;

	char fire_lpic_ief[1024];
	unsigned long fire_lpic_enable;

	char fire_yellow_upic_ief[1024];
	unsigned long fire_yellow_upic_enable;

	char fire_yellow_jpic_ief[1024];
	unsigned long fire_yellow_jpic_enable;

	char yellow_mpic_ief[1024];
	unsigned long yellow_mpic_enable;

	char vcan3_mpic_ief[1024];
	unsigned long vcan3_mpic_enable;

} SReflashRequest;

enum
{
	LL_DEAD,
	LL_PRODUCTION,
	LL_FIRE_DEMO,
	LL_FIRE,
	LL_RED_LIMITED,
	LL_RED,
	LL_YELLOW_LIMITED,
	LL_YELLOW,
	LL_VCAN3_LIMITED,
	LL_VCAN3,
	LL_VCAN3_PRODUCTION,// limited number of transmits and then hardware trap
	LL_FIRE_PRODUCTION,// limited number of transmits and then hardware trap, cgi enabled until power off or hardware trap
	LL_ECU_40,
	LL_IEVB,
	LL_ECU_20,// limit USB communication
	LL_NEO_HDA,
	LL_NEOOBD_LOGGER,
	LL_ETHERNET_EVB,
	LL_VALUECAN_RF,
	LL_FIRE2_CYAN,
	LL_RADGALAXY,
	LL_RADSTAR2,
	LL_VIVIDCAN,
	LL_NEOOBD2_SIM,
	LL_CMPROBE,
	LL_VCAN4_1,
	LL_VCAN4_2,
	LL_VCAN4_4,
	LL_VCAN4_LE,
	LL_OBD2_PRO,
};

#pragma pack(pop)

typedef struct
{
	unsigned int StatusBitField;
	unsigned int StatusBitField2;
	unsigned int TimeHardware;
	unsigned int TimeHardware2;
	unsigned int TimeSystem;
	unsigned int TimeSystem2;
	unsigned char TimeStampHardwareID;
	unsigned char TimeStampSystemID;
	unsigned char NetworkID;
	unsigned char NodeID;
	unsigned char Protocol;
	unsigned char MessagePieceID;
	unsigned char ExtraDataPtrEnabled;
	short GPSDataID;
	short DescriptionID;
	unsigned char AckBytes[8];
	double Value1;
	double Value2;
	unsigned char MiscData;
} icsSpyMessageGPS;

typedef struct
{
	unsigned int StatusBitField;
	unsigned int StatusBitField2;
	unsigned int TimeHardware;
	unsigned int TimeHardware2;
	unsigned int TimeSystem;
	unsigned int TimeSystem2;
	unsigned char TimeStampHardwareID;
	unsigned char TimeStampSystemID;
	unsigned char NetworkID;
	unsigned char NodeID;
	unsigned char Protocol;
	unsigned char MessagePieceID;
	unsigned char ExtraDataPtrEnabled;
	short AIDataID;
	short DescriptionID;
	double Value;
	short HardwareIndex;
	unsigned char AckBytes[8];
	short iDummy;
	int lDummy;
	unsigned char MiscData;
} icsSpyMessageAnalog;


typedef struct
{
	unsigned int SystemTimeStampID;
	unsigned int SystemTime1;
	unsigned int SystemTime2;
	unsigned int HardwareTimeStampID;
	unsigned int HardwareTime1;
	unsigned int HardwareTime2;
} icsSpyMsgTime;

typedef struct
{
	unsigned int StatusValue;
	unsigned int StatusMask;
	unsigned int Status2Value;
	unsigned int Status2Mask;
	unsigned char Header[4];
	unsigned char HeaderMask[4];
	unsigned int MiscData;
	unsigned int MiscDataMask;
	unsigned char ByteData[8];
	unsigned char ByteDataMask[8];
	unsigned int HeaderLength;
	unsigned int ByteDataLength;
	unsigned int NetworkID;
	unsigned short FrameMaster;
	unsigned char bUseArbIdRangeFilter;
	unsigned char bStuff2;
	unsigned int ExpectedLength;
	unsigned int NodeID;
} spyFilterBytes;

typedef struct
{
	unsigned char sec;// --- Seconds (00-59)
	unsigned char min;// --- (00-59)
	unsigned char hour;// --- (00-23)
	unsigned char day;// --- (01-31)
	unsigned char month;// --- (01-12)
	unsigned char year;// --- (00-99)
} icsSpyTime;

static inline void icsSpyMessage_SetId(icsSpyMessage* m, unsigned int id)
{
	m->NetworkID = id;
	m->NetworkID2 = id >> 8;
}

static inline unsigned int icsSpyMessage_GetId(const icsSpyMessage* m)
{
	return ((((unsigned int)m->NetworkID2) << 8) | m->NetworkID);
}

static inline void icsSpyMessageLong_SetId(icsSpyMessageLong* m, unsigned int id)
{
	m->NetworkID = id;
	m->NetworkID2 = id >> 8;
}

static inline unsigned int icsSpyMessageLong_GetId(const icsSpyMessageLong* m)
{
	return ((((unsigned int)m->NetworkID2) << 8) | m->NetworkID);
}

static inline void icsSpyMessageVSB_SetId(icsSpyMessageVSB* m, unsigned int id)
{
	m->NetworkID = id;
	m->NetworkID2 = id >> 8;
}

static inline unsigned int icsSpyMessageVSB_GetId(const icsSpyMessageVSB* m)
{
	return ((((unsigned int)m->NetworkID2) << 8) | m->NetworkID);
}

static inline void icsSpyMessageJ1850_SetId(icsSpyMessageJ1850* m, unsigned int id)
{
	m->NetworkID = id;
	m->NetworkID2 = id >> 8;
}

static inline unsigned int icsSpyMessageJ1850_GetId(const icsSpyMessageJ1850* m)
{
	return ((((unsigned int)m->NetworkID2) << 8) | m->NetworkID);
}

// Please note that these functions copy everything BUT the Extra Data Pointer
void CopyVsbMessage(icsSpyMessage* rawMessage, icsSpyMessageVSB* vsbMessage);
descIdType CopyToVsbMessage(icsSpyMessageVSB* vsbMessage, const icsSpyMessage* rawMessage);

#endif// ICSNVC40INTERNAL__H_
