#include "object_vcan3_settings.h"

PyTypeObject vcan3_settings_object_type = {
    PyVarObject_HEAD_INIT(NULL, 0)
    MODULE_NAME "." VCAN3_SETTINGS_OBJECT_NAME, /* tp_name */
    sizeof(vcan3_settings_object), /* tp_basicsize */
    0,                         /* tp_itemsize */
    (destructor)0,             /* tp_dealloc */
    0,                         /* tp_print */
    (getattrfunc)PyObject_GenericGetAttr, /* tp_getattr */
    (setattrfunc)PyObject_GenericSetAttr, /* tp_setattr */
    0,                         /* tp_reserved */
    0,                         /* tp_repr */
    0,                         /* tp_as_number */
    0,                         /* tp_as_sequence */
    0,                         /* tp_as_mapping */ 
    0,                         /* tp_hash  */
    0,                         /* tp_call */
    0,                         /* tp_str */
    PyObject_GenericGetAttr,   /* tp_getattro */
    PyObject_GenericSetAttr,   /* tp_setattro */
    0,                         /* tp_as_buffer */
    Py_TPFLAGS_DEFAULT |
    Py_TPFLAGS_BASETYPE,       /* tp_flags */
    VCAN3_SETTINGS_OBJECT_NAME" object",      /* tp_doc */
    0,                         /* tp_traverse */
    0,                         /* tp_clear */
    0,                         /* tp_richcompare */
    0,                         /* tp_weaklistoffset */
    0,                         /* tp_iter */
    0,                         /* tp_iternext */
    0,                         /* tp_methods */
    vcan3_settings_object_members, /* tp_members */
    0,                         /* tp_getset */
    0,                         /* tp_base */
    0,                         /* tp_dict */
    0,                         /* tp_descr_get */
    0,                         /* tp_descr_set */
    0,                         /* tp_dictoffset */
    (initproc)vcan3_settings_object_init, /* tp_init */
    0,                         /* tp_alloc */
    0,                         /* tp_new */
};

bool setup_vcan3_settings_object(PyObject* module)
{
    vcan3_settings_object_type.tp_new = PyType_GenericNew;
    if (PyType_Ready(&vcan3_settings_object_type) < 0) {
        return false;
    }
    Py_INCREF(&vcan3_settings_object_type);
    PyModule_AddObject(module, VCAN3_SETTINGS_OBJECT_NAME, (PyObject*)&vcan3_settings_object_type);
    return true;
}

void vcan3_settings_object_update_from_struct(PyObject* settings)
{
    assert(PyVcan3Settings_CheckExact(settings));
    SVCAN3Settings* s = &((vcan3_settings_object*)settings)->s;
    vcan3_settings_object* s_obj = (vcan3_settings_object*)settings;

    // Since CAN Structures are Python objects, we need to manually update them here.
    ((can_settings_object*)s_obj->can1)->s = s->can1;
    ((can_settings_object*)s_obj->can2)->s = s->can2;
}

void vcan3_settings_object_update_from_objects(PyObject* settings)
{
    assert(PyVcan3Settings_CheckExact(settings));
    vcan3_settings_object* s_obj = (vcan3_settings_object*)settings;
    SVCAN3Settings* s = &s_obj->s;

    // Since CAN Structures are Python objects, we need to manually update them here.
    s->can1 = ((can_settings_object*)s_obj->can1)->s;
    s->can2 = ((can_settings_object*)s_obj->can2)->s;
}