/* -*- mode: C -*-  */
/* 
   IGraph library.
   Copyright (C) 2006  Gabor Csardi <csardi@rmki.kfki.hu>
   MTA RMKI, Konkoly-Thege Miklos st. 29-33, Budapest 1121, Hungary
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc.,  51 Franklin Street, Fifth Floor, Boston, MA 
   02110-1301 USA

*/

#ifndef PYTHON_COMMON_H
#define PYTHON_COMMON_H

#include <Python.h>

#ifdef RC_DEBUG
#define RC_ALLOC(T, P) fprintf(stderr, "[ alloc ] " T " @ %p\n", P)
#define RC_DEALLOC(T, P) fprintf(stderr, "[dealloc] " T " @ %p\n", P);
#define RC_TRAVERSE(T, P)
//#define RC_TRAVERSE(T, P) fprintf(stderr, "[ travr ] " T " @ %p\n", P);
#else
#define RC_ALLOC(T, P)
#define RC_DEALLOC(T, P)
#define RC_TRAVERSE(T, P)
#endif

/* Compatibility stuff for Python 2.3 */
#ifndef Py_RETURN_TRUE
#define Py_RETURN_TRUE { Py_INCREF(Py_True); return Py_True; }
#endif

#ifndef Py_RETURN_FALSE
#define Py_RETURN_FALSE { Py_INCREF(Py_False); return Py_False; }
#endif

#ifndef Py_RETURN_NONE
#define Py_RETURN_NONE { Py_INCREF(Py_None); return Py_None; }
#endif

/* Compatibility stuff for Python 2.4 */
#if (PY_MAJOR_VERSION <= 2) & (PY_MINOR_VERSION <= 4)
#define lenfunc inquiry
#define ssizeargfunc intargfunc
#define ssizessizeargfunc intintargfunc
#define Py_ssize_t int
#endif

#define ATTRHASH_IDX_GRAPH 0
#define ATTRHASH_IDX_VERTEX 1
#define ATTRHASH_IDX_EDGE 2

#define ATTRIBUTE_TYPE_VERTEX 1
#define ATTRIBUTE_TYPE_EDGE 2

PyObject* igraphmodule_unimplemented(PyObject* self, PyObject* args, PyObject* kwds);
PyObject* igraphmodule_resolve_graph_weakref(PyObject* ref);
#endif
