# -*- coding: utf-8 -*-
"""
Expanded LegacyREST/Redfish interface for schema validation, database for responses, caching,
and error registries.
"""

from .sharedtypes import JSONEncoder

from .ris import (
    RisInstanceNotFoundError,
    RisMonolithMemberBase,
    RisMonolithMemberv100,
    RisMonolith,
    SessionExpired,
)

from .rmc_helper import (
    UndefinedClientError,
    InstanceNotFoundError,
    CurrentlyLoggedInError,
    NothingSelectedError,
    NothingSelectedFilterError,
    NothingSelectedSetError,
    InvalidSelectionError,
    IdTokenError,
    ValidationError,
    ValueChangedError,
    RmcCacheManager,
    ScepenabledError,
    IloLicenseError,
    RmcFileCacheManager,
)

from .rmc import RmcApp

from .validation import ValidationManager, RegistryValidationError
