CHARACTERS = {
    "CONTROL"     : {## Control characters ##
        #Unknown    SPaCe       LeFT        UP          DoWN        ORiGin      FULL        TOP         TAB         Re-TaB
        "UNK":"00", "SPC":"01", "LFT":"02", "UPP":"03", "DWN":"04", "ORG":"05", "FUL":"06", "TOP":"07", "TAB":"08", "RTB":"09"},
    "FORMAT"      : {## Format characters ##
        #UnFormat   UnderLine   TopLine     OverLine    ITalic      BolD        Cnt-Italic  ThiN        VertMirror  HrztlMirror
        "UF": "20", "UL": "21", "TL": "22", "OL": "23", "IT": "24", "BD": "25", "CI": "26", "TN": "27", "VM": "28", "HM": "29",
        #BackGrnd   ForeGround  LineS
        "BG": "30", "FG": "31", "LS": "32"},
    "DIACRITICS"  : {## Diacritics ## Using char's unicode's table point
        # Grave acc. Acute acc.   Circumflex   Caron acc.   Double grave Double acute Diaeresis    Dot above    Breve acc.   Macron acc.
        "0300":"40", "0301":"41", "0302":"42", "030c":"43", "030f":"44", "030b":"45", "0308":"46", "0307":"47", "0306":"48", "0304":"49",
        # Tilde acc. Line above   Dbl line ab. Ring above   Hook above
        "0303":"50", "030d":"51", "030e":"52", "030a":"53", "0309":"54",
        # Cedilla    Ogonyek      Line below   Dot below    Diaeresis b.
        "0327":"60", "0328":"61", "0329":"62", "0323":"63", "0324":"64",
        # Comb. horn
        "031b":"80"},
    "SYMBOLS"     : {## Numbers and symbols ##
        "0": "A0", "1": "A1", "2": "A2", "3": "A3", "4": "A4", "5": "A5", "6": "A6", "7": "A7", "8": "A8", "9": "A9",
        ".": "B0", ",": "B1", ":": "B2", ";": "B3", "-": "B4", "_": "B5", "!": "B6", "?": "B7", "¡": "B8", "¿": "B9",
        "'": "C0", '"': "C1", "·": "C2", "$": "C3", "%": "C4", "&": "C5", "/": "C6", "=": "C7", "+": "C8", "*": "C9",
        "(": "D0", ")": "D1", "[": "D2", "]": "D3", "{": "D4", "}": "D5", "|": "D6", "@": "D7", "#": "D8", "¬": "D9",
        "º": "E0", "ª": "E1", "`": "E2", "´": "E3", "^": "E4", "¨": "E5", "~": "E6", "€": "E7", "¢": "E8", "¶": "E9",
        "<": "F0", ">": "F1","\\": "F2", "£": "F3", "™": "F4", "±": "F5", "¦": "F6", "©": "F7", "×": "F8", "÷": "F9",
        "’": "G0", "«": "G1", "»": "G2"},
    "latin_c"     : {## Latin capitals ##
        "A":"A00", "B":"A01", "C":"A02", "D":"A03", "E":"A04", "F":"A05", "G":"A06", "H":"A07", "I":"A08", "J":"A09",
        "K":"A10", "L":"A11", "M":"A12", "N":"A13", "O":"A14", "P":"A15", "Q":"A16", "R":"A17", "S":"A18", "T":"A19",
        "U":"A20", "V":"A21", "W":"A22", "X":"A23", "Y":"A24", "Z":"A25", "Æ":"A26", "Œ":"A27", "Þ":"A28", "Ð":"A29"},
    "cyrillic_c"  : {## Cyrillic capitals ##
        "А":"A30", "Б":"A31", "В":"A32", "Г":"A33", "Д":"A34", "Е":"A35", "Ё":"A36", "Ж":"A37", "З":"A38", "И":"A39",
        "Й":"A40", "К":"A41", "Л":"A42", "М":"A43", "Н":"A44", "О":"A45", "П":"A46", "Р":"A47", "С":"A48", "Т":"A49",
        "У":"A50", "Ф":"A51", "Х":"A52", "Ц":"A53", "Ч":"A54", "Ш":"A55", "Щ":"A56", "Ъ":"A57", "Ы":"A58", "Ь":"A59",
        "Э":"A60", "Ю":"A61", "Я":"A62"},
    "greek_c"     : {## Greek capitals ##
        "Α":"A70", "Β":"A71", "Γ":"A72", "Δ":"A73", "Ε":"A74", "Ζ":"A75", "Η":"A76", "Θ":"A77", "Ι":"A78", "Κ":"A79",
        "Λ":"A80", "Μ":"A81", "Ν":"A82", "Ξ":"A83", "Ο":"A84", "Π":"A85", "Ρ":"A86", "Σ":"A87", "Ʃ":"A88", "Τ":"A89",
        "Υ":"A90", "Φ":"A91", "Χ":"A92", "Ψ":"A93", "Ω":"A94"},
    "archaic_g_c" : {## Archaic greek capitals ##
        "Ϙ":"A95", "Ϡ":"A96", "Ͳ":"A97"},
    "latin_l"     : {## latin lowercase ##
        "a":"B00", "b":"B01", "c":"B02", "d":"B03", "e":"B04", "f":"B05", "g":"B06", "h":"B07", "i":"B08", "j":"B09",
        "k":"B10", "l":"B11", "m":"B12", "n":"B13", "o":"B14", "p":"B15", "q":"B16", "r":"B17", "s":"B18", "t":"B19",
        "u":"B20", "v":"B21", "w":"B22", "x":"B23", "y":"B24", "z":"B25", "æ":"B26", "œ":"B27", "þ":"B28", "ð":"B29"},
    "cyrillic_l"  : {## cyrillic lowercase ##
        "а":"B30", "б":"B31", "в":"B32", "г":"B33", "д":"B34", "е":"B35", "ё":"B36", "ж":"B37", "з":"B38", "и":"B39",
        "й":"B40", "к":"B41", "л":"B42", "м":"B43", "н":"B44", "о":"B45", "п":"B46", "р":"B47", "с":"B48", "т":"B49",
        "у":"B50", "ф":"B51", "х":"B52", "ц":"B53", "ч":"B54", "ш":"B55", "щ":"B56", "ъ":"B57", "ы":"B58", "ь":"B59",
        "э":"B60", "ю":"B61", "я":"B62"},
    "greek_l"     : {## greek lowercase ##
        "α":"B70", "β":"B71", "γ":"B72", "δ":"B73", "ε":"B74", "ζ":"B75", "η":"B76", "θ":"B77", "ι":"B78", "κ":"B79",
        "λ":"B80", "μ":"B81", "ν":"B82", "ξ":"B83", "ο":"B84", "π":"B85", "ρ":"B86", "σ":"B87", "ς":"B88", "τ":"B89",
        "υ":"B90", "φ":"B91", "χ":"B92", "ψ":"B93", "ω":"B94"},
    "archaic_g_l" : {## archaic greek lowercase ##
        "ϙ":"B95", "ϡ":"B96", "ͳ":"B97"},
    "greek_other" : {## other greek lowercase ##
        "ϵ":"A98", "϶":"A99", "ϑ":"B98", "ϐ":"B99"},
    "VIETNAMIESE" : {## vietnamiese letters ##
        "Đ":"A63", "đ":"B63"},
    "HEBREW"      : {## Hebrew abjad ##
        "א":"C00", "ב":"C01", "ג":"C02", "ד":"C03", "ה":"C04", "ו":"C05", "ז":"C06", "ח":"C07", "ט":"C08", "י":"C09",
        "כ":"C10", "ך":"C11", "ל":"C12", "מ":"C13", "ם":"C14", "נ":"C15", "ן":"C16", "ס":"C17", "ע":"C18", "פ":"C19",
        "ף":"C20", "צ":"C21", "ץ":"C22", "ק":"C23", "ר":"C24", "ש":"C25", "ת":"C26", "בּ":"C27", "גּ":"C28", "דּ":"C29",
        "כּ":"C30", "ךּ":"C31", "פּ":"C32", "ףּ":"C33", "שׁ":"C34", "שׂ":"C35", "תּ":"C36", "ו":"C37", "וּ":"C38", "וֹ":"C39"},
    "GEORGIAN"    : {## Mkhedruli ##
        'ა':'C40', 'ბ':'C41', 'გ':'C42', 'დ':'C43', 'ე':'C44', 'ვ':'C45', 'ზ':'C46', 'თ':'C47', 'ი':'C48', 'კ':'C49',
        'ლ':'C50', 'მ':'C51', 'ნ':'C52', 'ო':'C53', 'პ':'C54', 'ჟ':'C55', 'რ':'C56', 'ს':'C57', 'ტ':'C58', 'უ':'C59',
        'ფ':'C60', 'ქ':'C61', 'ღ':'C62', 'ყ':'C63', 'შ':'C64', 'ჩ':'C65', 'ც':'C66', 'ძ':'C67', 'წ':'C68', 'ჭ':'C69',
        'ხ':'C70', 'ჯ':'C71', 'ჰ':'C72'},
    "HIRAGANA"    : {## Japanese's hiragana ##
        'あ':'D00', 'い':'D01', 'う':'D02', 'え':'D03', 'お':'D04', 'か':'D05', 'き':'D06', 'く':'D07', 'け':'D08', 'こ':'D09',
        'さ':'D10', 'し':'D11', 'す':'D12', 'せ':'D13', 'そ':'D14', 'た':'D15', 'ち':'D16', 'つ':'D17', 'て':'D18', 'と':'D19',
        'な':'D20', 'に':'D21', 'ぬ':'D22', 'ね':'D23', 'の':'D24', 'は':'D25', 'ひ':'D26', 'ふ':'D27', 'へ':'D28', 'ほ':'D29',
        'ま':'D30', 'み':'D31', 'む':'D32', 'め':'D33', 'も':'D34', 'や':'D35', 'ゆ':'D36', 'よ':'D37', 'ら':'D38', 'り':'D39',
        'る':'D40', 'れ':'D41', 'ろ':'D42', 'わ':'D43', 'を':'D44', 'ん':'D45', 'ゃ':'D46', 'ゅ':'D47'},
    "KATAKANA"    : {## Japanese's katakana ##
        'ア':'D50', 'イ':'D51', 'ウ':'D52', 'エ':'D53', 'オ':'D54', 'カ':'D55', 'キ':'D56', 'ク':'D57', 'ケ':'D58', 'コ':'D59',
        'サ':'D60', 'シ':'D61', 'ス':'D62', 'セ':'D63', 'ソ':'D64', 'タ':'D65', 'チ':'D66', 'ツ':'D67', 'テ':'D68', 'ト':'D69',
        'ナ':'D70', 'ニ':'D71', 'ヌ':'D72', 'ネ':'D73', 'ノ':'D74', 'ハ':'D75', 'ヒ':'D76', 'フ':'D77', 'ヘ':'D78', 'ホ':'D79',
        'マ':'D80', 'ミ':'D81', 'ム':'D82', 'メ':'D83', 'モ':'D84', 'ヤ':'D85', 'ユ':'D86', 'ヨ':'D87', 'ラ':'D88', 'リ':'D89',
        'ル':'D90', 'レ':'D91', 'ロ':'D92', 'ワ':'D93', 'ヲ':'D94', 'ン':'D95', 'ャ':'D96', 'ュ':'D97'},
    "armenian_c"  : {## armenian capitals ##
        'Ա':'E00', 'Բ':'E01', 'Գ':'E02', 'Դ':'E03', 'Ե':'E04', 'Զ':'E05', 'Է':'E06', 'Ը':'E07', 'Թ':'E08', 'Ժ':'E09',
        'Ի':'E10', 'Լ':'E11', 'Խ':'E12', 'Ծ':'E13', 'Կ':'E14', 'Հ':'E15', 'Ձ':'E16', 'Ղ':'E17', 'Ճ':'E18', 'Մ':'E19',
        'Յ':'E20', 'Ն':'E21', 'Շ':'E22', 'Ո':'E23', 'Չ':'E24', 'Պ':'E25', 'Ջ':'E26', 'Ռ':'E27', 'Ս':'E28', 'Վ':'E29',
        'Տ':'E30', 'Ր':'E31', 'Ց':'E32', 'Ւ':'E33', 'Փ':'E34', 'Ք':'E35', 'Օ':'E36', 'Ֆ':'E37'},
    "armenian_l"  : {## armenian lowercase ##
        'ա':'E40', 'բ':'E41', 'գ':'E42', 'դ':'E43', 'ե':'E44', 'զ':'E45', 'է':'E46', 'ը':'E47', 'թ':'E48', 'ժ':'E49',
        'ի':'E50', 'լ':'E51', 'խ':'E52', 'ծ':'E53', 'կ':'E54', 'հ':'E55', 'ձ':'E56', 'ղ':'E57', 'ճ':'E58', 'մ':'E59',
        'յ':'E60', 'ն':'E61', 'շ':'E62', 'ո':'E63', 'չ':'E64', 'պ':'E65', 'ջ':'E66', 'ռ':'E67', 'ս':'E68', 'վ':'E69',
        'տ':'E70', 'ր':'E71', 'ց':'E72', 'ւ':'E73', 'փ':'E74', 'ք':'E75', 'օ':'E76', 'ֆ':'E77'},
    "sitelen_o"   : {## Official toki pona words ##
        'a':     'F00', 'akesi': 'F01', 'ala':   'F02', 'alasa': 'F03', 'ale':    'F04', 'anpa':   'F05', 'ante':  'F06', 'anu':   'F07', 'awen':'F08', 'e':     'F09',
        'en':    'F10', 'esun':  'F11', 'ijo':   'F12', 'ike':   'F13', 'ilo':    'F14', 'insa':   'F15', 'jaki':  'F16', 'jan':   'F17', 'jelo':'F18', 'jo':    'F19',
        'kala':  'F20', 'kalama':'F21', 'kama':  'F22', 'kasi':  'F23', 'ken':    'F24', 'kepeken':'F25', 'kili':  'F26', 'kiwen': 'F27', 'ko':  'F28', 'kon':   'F29',
        'kule':  'F30', 'kulupu':'F31', 'kute':  'F32', 'la':    'F33', 'lape':   'F34', 'laso':   'F35', 'lawa':  'F36', 'len':   'F37', 'lete':'F38', 'li':    'F39',
        'lili':  'F40', 'linja': 'F41', 'lipu':  'F42', 'loje':  'F43', 'lon':    'F44', 'luka':   'F45', 'lukin': 'F46', 'lupa':  'F47', 'ma':  'F48', 'mama':  'F49',
        'mani':  'F50', 'mi':    'F51', 'moku':  'F52', 'moli':  'F53', 'monsi':  'F54', 'mu':     'F55', 'mun':   'F56', 'musi':  'F57', 'mute':'F58', 'nanpa': 'F59',
        'nasa':  'F60', 'nasin': 'F61', 'nena':  'F62', 'ni':    'F63', 'nimi':   'F64', 'noka':   'F65', 'o':     'F66', 'olin':  'F67', 'ona': 'F68', 'open':  'F69',
        'pakala':'F70', 'pali':  'F71', 'palisa':'F72', 'pan':   'F73', 'pana':   'F74', 'pi':     'F75', 'pilin': 'F76', 'pimeja':'F77', 'pini':'F78', 'pipi':  'F79',
        'poka':  'F80', 'poki':  'F81', 'pona':  'F82', 'pu':    'F83', 'sama':   'F84', 'seli':   'F85', 'selo':  'F86', 'seme':  'F87', 'sewi':'F88', 'sijelo':'F89',
        'sike':  'F90', 'sin':   'F91', 'sina':  'F92', 'sinpin':'F93', 'sitelen':'F94', 'sona':   'F95', 'soweli':'F96', 'suli':  'F97', 'suno':'F98', 'supa':  'F99',
        'suwi':  'G00', 'tan':   'G01', 'taso':  'G02', 'tawa':  'G03', 'telo':   'G04', 'tenpo':  'G05', 'toki':  'G06', 'tomo':  'G07', 'tu':  'G08', 'unpa':  'G09',
        'uta':   'G10', 'utala': 'G11', 'walo':  'G12', 'wan':   'G13', 'waso':   'G14', 'wawa':   'G15', 'weka':  'G16', 'wile':  'G17'},
    "sitelen_c"   : {## Common toki pona words ##
        'kijetesantakalu':'G20', 'kin': 'G21', 'kipisi':'G22', 'ku': 'G23', 'leko': 'G24', 'meli': 'G25', 'mije': 'G26', 'misikeke': 'G27', 'monsuta': 'G28', 'n': 'G29',
        'namako':         'G30', 'soko':'G31', 'tonsi': 'G32'},
    "sitelen_r"   : {## Rare toki pona words ##
        'ali': 'G40', 'epiku': 'G41', 'jasima': 'G42', 'lanpan': 'G43', 'linluwi': 'G44', 'majuna': 'G45', 'meso': 'G46', 'nimisin': 'G47', 'oko': 'G48', 'su': 'G49'},
    "sitelen_a"   : {## Other toki pona words (a for alter) ##
        'apeja': 'G50', 'isipin':'G51', 'jami':'G52', 'jonke':   'G53', 'kamalawala':'G54', 'kapesi':'G55', 'kiki':    'G56', 'kokosila':'G57', 'konwe':       'G58', 'kulijo':  'G59',
        'melome':'G60', 'mijomi':'G61', 'misa':'G62', 'mulapisu':'G63', 'nja':       'G64', 'ojuta': 'G65', 'oke':     'G66', 'omekapo': 'G67', 'owe':         'G68', 'pake':    'G69',
        'pakola':'G70', 'penpo': 'G71', 'pika':'G72', 'po':      'G73', 'powe':      'G74', 'puwa':  'G75', 'san':     'G76', 'soto':    'G77', 'sutopatikuna':'G78', 'taki':    'G79',
        'te':    'G80', 'teje':  'G81', 'to':  'G82', 'unu':     'G83', 'usawi':     'G84', 'wa':    'G85', 'wasoweli':'G86', 'wekama':  'G87', 'wuwojiti':    'G88', 'yupekosi':'G89'},
}

## Scripts to be added:
### ···

CONV = {k:CHARACTERS[i][k] for i in CHARACTERS for k in CHARACTERS[i]}
CHARS = {CONV[k] for k in CONV}

if __name__ == "__main__":
    used, total = len(CHARS), 100 + 26*10 + 26*100 # (0-99)+(A0-A9)+(A00-Z99)
    print(f"{used:0>4}/{total} => {used/total:.2%} used")
    print("For (un) assigned codepoints cf. CODEPOINTS.md")