# Copyright (c) 2022 Lowell D. Thomas, all rights reserved
# BSD-2-Clause (https://opensource.org/licenses/BSD-2-Clause)
#

# SUMMARY
#      rules = 61
#       udts = 4
#    opcodes = 292
#        ---   ABNF original opcodes
#        ALT = 37
#        CAT = 25
#        REP = 31
#        RNM = 95
#        TLS = 15
#        TBS = 49
#        TRG = 32
#        ---   SABNF super set opcodes
#        UDT = 4
#        AND = 2
#        NOT = 0
#        BKA = 0
#        BKN = 0
#        BKR = 0
#        ABG = 0
#        AEN = 2
# characters = [9 - 126] + user defined
#

# RULES
rules = ({'name': 'ini-file',
  'lower': 'ini-file',
  'index': 0,
  'line': 42,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 5)},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 1, 'children': (3, 4)},
              {'type': 4, 'index': 49},
              {'type': 4, 'index': 5},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 4, 'index': 1})},
 {'name': 'section',
  'lower': 'section',
  'index': 1,
  'line': 43,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2)},
              {'type': 4, 'index': 2},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 1, 'children': (4, 5)},
              {'type': 4, 'index': 49},
              {'type': 4, 'index': 5})},
 {'name': 'section-line',
  'lower': 'section-line',
  'index': 2,
  'line': 44,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 4, 'index': 3},
              {'type': 4, 'index': 4})},
 {'name': 'good-section-line',
  'lower': 'good-section-line',
  'index': 3,
  'line': 45,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 3, 4, 5, 6, 7, 9)},
              {'type': 6, 'string': (91,)},
              {'type': 4, 'index': 56},
              {'type': 4, 'index': 11},
              {'type': 4, 'index': 56},
              {'type': 6, 'string': (93,)},
              {'type': 4, 'index': 56},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 55},
              {'type': 4, 'index': 52})},
 {'name': 'bad-section-line',
  'lower': 'bad-section-line',
  'index': 4,
  'line': 46,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 4)},
              {'type': 6, 'string': (91,)},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 4, 'index': 60},
              {'type': 4, 'index': 52})},
 {'name': 'value-line',
  'lower': 'value-line',
  'index': 5,
  'line': 47,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 4, 'index': 6},
              {'type': 4, 'index': 8})},
 {'name': 'good-value',
  'lower': 'good-value',
  'index': 6,
  'line': 48,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 7, 8, 10)},
              {'type': 4, 'index': 12},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 2, 'children': (4, 5)},
              {'type': 4, 'index': 7},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 9},
              {'type': 4, 'index': 56},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 55},
              {'type': 4, 'index': 52})},
 {'name': 'key-delim',
  'lower': 'key-delim',
  'index': 7,
  'line': 49,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 7)},
              {'type': 2, 'children': (2, 3, 6)},
              {'type': 4, 'index': 56},
              {'type': 1, 'children': (4, 5)},
              {'type': 6, 'string': (61,)},
              {'type': 6, 'string': (58,)},
              {'type': 4, 'index': 56},
              {'type': 4, 'index': 57})},
 {'name': 'bad-value-line',
  'lower': 'bad-value-line',
  'index': 8,
  'line': 50,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 4, 8)},
              {'type': 1, 'children': (2, 3)},
              {'type': 5, 'min': 33, 'max': 90},
              {'type': 5, 'min': 92, 'max': 126},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 1, 'children': (6, 7)},
              {'type': 4, 'index': 54},
              {'type': 4, 'index': 60},
              {'type': 4, 'index': 52})},
 {'name': 'value-array',
  'lower': 'value-array',
  'index': 9,
  'line': 51,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2)},
              {'type': 4, 'index': 14},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 2, 'children': (4, 5)},
              {'type': 4, 'index': 10},
              {'type': 4, 'index': 14})},
 {'name': 'value-delim',
  'lower': 'value-delim',
  'index': 10,
  'line': 52,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 5)},
              {'type': 2, 'children': (2, 3, 4)},
              {'type': 4, 'index': 56},
              {'type': 6, 'string': (44,)},
              {'type': 4, 'index': 56},
              {'type': 4, 'index': 57})},
 {'name': 'section-name',
  'lower': 'section-name',
  'index': 11,
  'line': 53,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 4, 'index': 13},)},
 {'name': 'key-name',
  'lower': 'key-name',
  'index': 12,
  'line': 54,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 4, 'index': 13},)},
 {'name': 'name',
  'lower': 'name',
  'index': 13,
  'line': 55,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 1, 'children': (2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)},
              {'type': 5, 'min': 97, 'max': 122},
              {'type': 5, 'min': 65, 'max': 90},
              {'type': 5, 'min': 48, 'max': 57},
              {'type': 6, 'string': (33,)},
              {'type': 5, 'min': 36, 'max': 38},
              {'type': 5, 'min': 40, 'max': 43},
              {'type': 5, 'min': 45, 'max': 46},
              {'type': 6, 'string': (60,)},
              {'type': 5, 'min': 62, 'max': 64},
              {'type': 5, 'min': 94, 'max': 95},
              {'type': 5, 'min': 123, 'max': 126})},
 {'name': 'value',
  'lower': 'value',
  'index': 14,
  'line': 66,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3, 4, 5)},
              {'type': 4, 'index': 19},
              {'type': 4, 'index': 15},
              {'type': 4, 'index': 31},
              {'type': 4, 'index': 33},
              {'type': 4, 'index': 30})},
 {'name': 'boolean',
  'lower': 'boolean',
  'index': 15,
  'line': 67,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3)},
              {'type': 4, 'index': 18},
              {'type': 4, 'index': 16},
              {'type': 4, 'index': 17})},
 {'name': 'true',
  'lower': 'true',
  'index': 16,
  'line': 68,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3)},
              {'type': 7, 'string': (116, 114, 117, 101)},
              {'type': 7, 'string': (121, 101, 115)},
              {'type': 7, 'string': (111, 110)})},
 {'name': 'false',
  'lower': 'false',
  'index': 17,
  'line': 69,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3)},
              {'type': 7, 'string': (102, 97, 108, 115, 101)},
              {'type': 7, 'string': (110, 111)},
              {'type': 7, 'string': (111, 102, 102)})},
 {'name': 'null',
  'lower': 'null',
  'index': 18,
  'line': 70,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3)},
              {'type': 7, 'string': (110, 117, 108, 108)},
              {'type': 7, 'string': (118, 111, 105, 100)},
              {'type': 7, 'string': (110, 111, 110, 101)})},
 {'name': 'number',
  'lower': 'number',
  'index': 19,
  'line': 71,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 4)},
              {'type': 1, 'children': (2, 3)},
              {'type': 4, 'index': 20},
              {'type': 4, 'index': 21},
              {'type': 12},
              {'type': 1, 'children': (6, 7, 8)},
              {'type': 6, 'string': (44,)},
              {'type': 4, 'index': 57},
              {'type': 4, 'index': 53})},
 {'name': 'int',
  'lower': 'int',
  'index': 20,
  'line': 74,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 5, 7)},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 1, 'children': (3, 4)},
              {'type': 6, 'string': (43,)},
              {'type': 6, 'string': (45,)},
              {'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 4, 'index': 59},
              {'type': 12},
              {'type': 1, 'children': (9, 10, 11)},
              {'type': 6, 'string': (44,)},
              {'type': 4, 'index': 57},
              {'type': 4, 'index': 53})},
 {'name': 'float',
  'lower': 'float',
  'index': 21,
  'line': 75,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 3, 4)},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 22},
              {'type': 4, 'index': 23},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 27})},
 {'name': 'sign',
  'lower': 'sign',
  'index': 22,
  'line': 76,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 7, 'string': (43,)},
              {'type': 7, 'string': (45,)})},
 {'name': 'decimal',
  'lower': 'decimal',
  'index': 23,
  'line': 77,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 8)},
              {'type': 2, 'children': (2, 3)},
              {'type': 4, 'index': 24},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 2, 'children': (5, 6)},
              {'type': 4, 'index': 25},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 26},
              {'type': 2, 'children': (9, 10)},
              {'type': 4, 'index': 25},
              {'type': 4, 'index': 26})},
 {'name': 'integer',
  'lower': 'integer',
  'index': 24,
  'line': 79,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 5, 'min': 48, 'max': 57})},
 {'name': 'dot',
  'lower': 'dot',
  'index': 25,
  'line': 80,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 7, 'string': (46,)},)},
 {'name': 'fraction',
  'lower': 'fraction',
  'index': 26,
  'line': 81,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 5, 'min': 48, 'max': 57})},
 {'name': 'exponent',
  'lower': 'exponent',
  'index': 27,
  'line': 82,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 4)},
              {'type': 7, 'string': (101,)},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 28},
              {'type': 4, 'index': 29})},
 {'name': 'esign',
  'lower': 'esign',
  'index': 28,
  'line': 83,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 7, 'string': (43,)},
              {'type': 7, 'string': (45,)})},
 {'name': 'exp',
  'lower': 'exp',
  'index': 29,
  'line': 84,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 5, 'min': 48, 'max': 57})},
 {'name': 'string',
  'lower': 'string',
  'index': 30,
  'line': 85,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 1, 'children': (2, 3, 4, 5, 6, 7, 8, 9, 10)},
              {'type': 6, 'string': (33,)},
              {'type': 5, 'min': 36, 'max': 38},
              {'type': 5, 'min': 40, 'max': 43},
              {'type': 5, 'min': 45, 'max': 46},
              {'type': 5, 'min': 48, 'max': 57},
              {'type': 6, 'string': (60,)},
              {'type': 5, 'min': 62, 'max': 91},
              {'type': 5, 'min': 93, 'max': 126},
              {'type': 4, 'index': 35})},
 {'name': 'd-quoted-string',
  'lower': 'd-quoted-string',
  'index': 31,
  'line': 87,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 3)},
              {'type': 6, 'string': (34,)},
              {'type': 4, 'index': 32},
              {'type': 6, 'string': (34,)})},
 {'name': 'd-quoted-value',
  'lower': 'd-quoted-value',
  'index': 32,
  'line': 88,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 1, 'children': (2, 3, 4, 5)},
              {'type': 5, 'min': 32, 'max': 33},
              {'type': 5, 'min': 35, 'max': 91},
              {'type': 5, 'min': 93, 'max': 126},
              {'type': 4, 'index': 35})},
 {'name': 's-quoted-string',
  'lower': 's-quoted-string',
  'index': 33,
  'line': 89,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 3)},
              {'type': 6, 'string': (39,)},
              {'type': 4, 'index': 34},
              {'type': 6, 'string': (39,)})},
 {'name': 's-quoted-value',
  'lower': 's-quoted-value',
  'index': 34,
  'line': 90,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 1, 'children': (2, 3, 4, 5)},
              {'type': 5, 'min': 32, 'max': 38},
              {'type': 5, 'min': 40, 'max': 91},
              {'type': 5, 'min': 93, 'max': 126},
              {'type': 4, 'index': 35})},
 {'name': 'escaped',
  'lower': 'escaped',
  'index': 35,
  'line': 91,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2)},
              {'type': 4, 'index': 36},
              {'type': 1,
               'children': (3,
                            4,
                            5,
                            6,
                            7,
                            8,
                            9,
                            10,
                            11,
                            12,
                            13,
                            14,
                            15,
                            16,
                            17,
                            18,
                            19)},
              {'type': 4, 'index': 36},
              {'type': 4, 'index': 41},
              {'type': 4, 'index': 37},
              {'type': 4, 'index': 38},
              {'type': 4, 'index': 39},
              {'type': 4, 'index': 40},
              {'type': 4, 'index': 42},
              {'type': 4, 'index': 43},
              {'type': 4, 'index': 44},
              {'type': 4, 'index': 45},
              {'type': 4, 'index': 46},
              {'type': 4, 'index': 47},
              {'type': 4, 'index': 48},
              {'type': 11, 'empty': False, 'index': 0},
              {'type': 11, 'empty': False, 'index': 1},
              {'type': 11, 'empty': False, 'index': 2},
              {'type': 11, 'empty': False, 'index': 3})},
 {'name': 'reverse-solidus',
  'lower': 'reverse-solidus',
  'index': 36,
  'line': 113,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (92,)},)},
 {'name': 'double-quote',
  'lower': 'double-quote',
  'index': 37,
  'line': 114,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (34,)},)},
 {'name': 'hash',
  'lower': 'hash',
  'index': 38,
  'line': 115,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (35,)},)},
 {'name': 'single-quote',
  'lower': 'single-quote',
  'index': 39,
  'line': 116,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (39,)},)},
 {'name': 'comma',
  'lower': 'comma',
  'index': 40,
  'line': 117,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (44,)},)},
 {'name': 'solidus',
  'lower': 'solidus',
  'index': 41,
  'line': 118,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (47,)},)},
 {'name': 'colon',
  'lower': 'colon',
  'index': 42,
  'line': 119,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (58,)},)},
 {'name': 'semicolon',
  'lower': 'semicolon',
  'index': 43,
  'line': 120,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (59,)},)},
 {'name': 'equal-sign',
  'lower': 'equal-sign',
  'index': 44,
  'line': 121,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (61,)},)},
 {'name': 'blank',
  'lower': 'blank',
  'index': 45,
  'line': 122,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (98,)},)},
 {'name': 'tab',
  'lower': 'tab',
  'index': 46,
  'line': 123,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (116,)},)},
 {'name': 'line-feed',
  'lower': 'line-feed',
  'index': 47,
  'line': 124,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (110,)},)},
 {'name': 'carriage-return',
  'lower': 'carriage-return',
  'index': 48,
  'line': 125,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 6, 'string': (114,)},)},
 {'name': 'blank-line',
  'lower': 'blank-line',
  'index': 49,
  'line': 126,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 4, 'index': 50},
              {'type': 4, 'index': 51})},
 {'name': 'good-blank-line',
  'lower': 'good-blank-line',
  'index': 50,
  'line': 127,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 4)},
              {'type': 4, 'index': 56},
              {'type': 3, 'min': 0, 'max': 1},
              {'type': 4, 'index': 55},
              {'type': 4, 'index': 52})},
 {'name': 'bad-blank-line',
  'lower': 'bad-blank-line',
  'index': 51,
  'line': 128,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 4, 5, 8, 10)},
              {'type': 1, 'children': (2, 3)},
              {'type': 6, 'string': (32,)},
              {'type': 6, 'string': (9,)},
              {'type': 4, 'index': 56},
              {'type': 1, 'children': (6, 7)},
              {'type': 5, 'min': 33, 'max': 58},
              {'type': 5, 'min': 60, 'max': 126},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 4, 'index': 60},
              {'type': 4, 'index': 52})},
 {'name': 'line-end',
  'lower': 'line-end',
  'index': 52,
  'line': 129,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3, 4)},
              {'type': 6, 'string': (13, 10)},
              {'type': 6, 'string': (10,)},
              {'type': 6, 'string': (13,)},
              {'type': 18})},
 {'name': 'digit-line-end',
  'lower': 'digit-line-end',
  'index': 53,
  'line': 130,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2, 3, 4)},
              {'type': 6, 'string': (13, 10)},
              {'type': 6, 'string': (10,)},
              {'type': 6, 'string': (13,)},
              {'type': 18})},
 {'name': 'line-continue',
  'lower': 'line-continue',
  'index': 54,
  'line': 131,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 2, 4, 5)},
              {'type': 6, 'string': (47,)},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 4, 'index': 60},
              {'type': 4, 'index': 52},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 1, 'children': (7, 8)},
              {'type': 6, 'string': (32,)},
              {'type': 6, 'string': (9,)})},
 {'name': 'comment',
  'lower': 'comment',
  'index': 55,
  'line': 132,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 2, 'children': (1, 4)},
              {'type': 1, 'children': (2, 3)},
              {'type': 6, 'string': (35,)},
              {'type': 6, 'string': (59,)},
              {'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 4, 'index': 60})},
 {'name': 'owsp',
  'lower': 'owsp',
  'index': 56,
  'line': 133,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 0, 'max': 9223372036854775807},
              {'type': 1, 'children': (2, 3, 4)},
              {'type': 6, 'string': (32,)},
              {'type': 6, 'string': (9,)},
              {'type': 4, 'index': 54})},
 {'name': 'wsp',
  'lower': 'wsp',
  'index': 57,
  'line': 134,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 3, 'min': 1, 'max': 9223372036854775807},
              {'type': 1, 'children': (2, 3, 4)},
              {'type': 6, 'string': (32,)},
              {'type': 6, 'string': (9,)},
              {'type': 4, 'index': 54})},
 {'name': 'alpha',
  'lower': 'alpha',
  'index': 58,
  'line': 135,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 5, 'min': 65, 'max': 90},
              {'type': 5, 'min': 97, 'max': 122})},
 {'name': 'digit',
  'lower': 'digit',
  'index': 59,
  'line': 136,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 5, 'min': 48, 'max': 57},)},
 {'name': 'any',
  'lower': 'any',
  'index': 60,
  'line': 137,
  'is_bkru': False,
  'is_bkrr': False,
  'has_bkrr': False,
  'opcodes': ({'type': 1, 'children': (1, 2)},
              {'type': 5, 'min': 32, 'max': 126},
              {'type': 6, 'string': (9,)})})

# UDTS
udts = ({'name': 'u_unicode8',
  'lower': 'u_unicode8',
  'index': 0,
  'is_bkru': False,
  'is_bkrr': False,
  'empty': False},
 {'name': 'u_unicode4',
  'lower': 'u_unicode4',
  'index': 1,
  'is_bkru': False,
  'is_bkrr': False,
  'empty': False},
 {'name': 'u_hexadecimal',
  'lower': 'u_hexadecimal',
  'index': 2,
  'is_bkru': False,
  'is_bkrr': False,
  'empty': False},
 {'name': 'u_escaped-error',
  'lower': 'u_escaped-error',
  'index': 3,
  'is_bkru': False,
  'is_bkrr': False,
  'empty': False})

has_bkru = False
has_bkrr = False


def to_string():
    '''Displays the original SABNF syntax.'''
    sabnf = ""
    sabnf += ";\n"
    sabnf += "; Ref: https://en.wikipedia.org/wiki/INI_file\n"
    sabnf += "; This SABNF grammar encompasses most of the stable and varying feature of the WikiPedia\n"
    sabnf += "; artcle. The only significant ommission is that subsections are not supported.\n"
    sabnf += ";\n"
    sabnf += "; comments begin with the semicolon(;) or hash(#) and continue to the end of the line\n"
    sabnf += "; comments may appear on valid section and value lines as well as blank lines\n"
    sabnf += "; line ends may be CRLF, LF or CR\n"
    sabnf += "; lines may be continued by ending them with a backslash and the following line begins with space or tab\n"
    sabnf += "; e.g.\n"
    sabnf += "; key = value , value, \\\n"
    sabnf += ";       value\n"
    sabnf += ";\n"
    sabnf += "; section and key names are case sensitive\n"
    sabnf += "; section and key names are liberally defined as one or more characters from the set:\n"
    sabnf += ";   a-z\n"
    sabnf += ";   A-Z\n"
    sabnf += ";   0-9\n"
    sabnf += ";   !$%&()*+-.<>?@^_`{|}~\n"
    sabnf += ";   (basically, alphabet, numeric, underscore, hyphen or any character not used as a special or reserved character)\n"
    sabnf += ";\n"
    sabnf += "; keys may have multiple values\n"
    sabnf += ";   - multiple values may be given as a comma or space delimited list on a single line\n"
    sabnf += ";   - values are \"disjoint\" - values listed for multiple occurrances of a key are concatenated\n"
    sabnf += ";   - values may be numbers, booleans, or strings\n"
    sabnf += ";   - strings may be single-quoted, double-quoted strings or unquoted\n"
    sabnf += ";\n"
    sabnf += "; keys appearing before the first section are allowed and termed the \"global\" section.\n"
    sabnf += ";\n"
    sabnf += "; section names are optional - the file may consist of only a \"global\" section\n"
    sabnf += ";\n"
    sabnf += "; sections are \"disjoint\",\n"
    sabnf += ";   - that is the keys in multiple occurrences of a section name are\n"
    sabnf += ";     joined together as if they appeared contiguously in a single section\n"
    sabnf += ";\n"
    sabnf += "; sections end at the beginning of a new section or the end of file\n"
    sabnf += ";\n"
    sabnf += "; The grammar is designed to accept any string of ASCII characters without failure.\n"
    sabnf += "; The \"error productions\", bad-section-line, bad-value-line, bad-blank-line are meant to accept all lines\n"
    sabnf += "; that are not otherwise correct blank, section or value lines. This allows the\n"
    sabnf += "; parser to report the input errors in an application-dependent manner.\n"
    sabnf += ";\n"
    sabnf += "ini-file            = *(blank-line / value-line) *section\n"
    sabnf += "section             = section-line *(blank-line / value-line)\n"
    sabnf += "section-line        = good-section-line / bad-section-line\n"
    sabnf += "good-section-line   = %d91 owsp section-name owsp %d93 owsp [comment] line-end\n"
    sabnf += "bad-section-line    = %d91 *any line-end;\n"
    sabnf += "value-line          = good-value / bad-value-line\n"
    sabnf += "good-value          = key-name [key-delim [value-array]] owsp [comment] line-end\n"
    sabnf += "key-delim           = (owsp (%d61 / %d58) owsp) / wsp ; = or : or white space\n"
    sabnf += "bad-value-line      = (%d33-90 / %d92-126) *(line-continue / any) line-end\n"
    sabnf += "value-array         = value *(value-delim value)\n"
    sabnf += "value-delim         = (owsp %d44 owsp) / wsp\n"
    sabnf += "section-name        = name\n"
    sabnf += "key-name            = name\n"
    sabnf += "name                = 1*(%d97-122 \n"
    sabnf += "                    / %d65-90 \n"
    sabnf += "                    / %d48-57 \n"
    sabnf += "                    / %d33 \n"
    sabnf += "                    / %d36-38\n"
    sabnf += "                    / %d40-43\n"
    sabnf += "                    / %d45-46\n"
    sabnf += "                    / %d60 \n"
    sabnf += "                    / %d62-64 \n"
    sabnf += "                    / %d94-95\n"
    sabnf += "                    / %d123-126)\n"
    sabnf += "value               = number / boolean / d-quoted-string / s-quoted-string / string\n"
    sabnf += "boolean             = null / true / false\n"
    sabnf += "true                = \"true\" / \"yes\" / \"on\"\n"
    sabnf += "false               = \"false\" / \"no\" / \"off\"\n"
    sabnf += "null                = \"null\" / \"void\" / \"none\"\n"
    sabnf += "number              = (int / float) &(%d44 / wsp / digit-line-end)\n"
    sabnf += "                      ; digit-line-end is a line that does not increment the line counter\n"
    sabnf += "                      ; numbers must be followed by a delimiter or line end\n"
    sabnf += "int                 = [%d43 / %d45] 1*digit &(%d44 / wsp / digit-line-end)\n"
    sabnf += "float               = [sign] decimal [exponent]\n"
    sabnf += "sign                = \"+\" / \"-\"\n"
    sabnf += "decimal             = integer [dot [fraction]]\n"
    sabnf += "                    / dot fraction\n"
    sabnf += "integer             = 1*%d48-57\n"
    sabnf += "dot                 = \".\"\n"
    sabnf += "fraction            = 1*%d48-57\n"
    sabnf += "exponent            = \"e\" [esign] exp\n"
    sabnf += "esign               = \"+\" / \"-\"\n"
    sabnf += "exp                 = 1*%d48-57                      \n"
    sabnf += "string              = 1*(%d33 / %d36-38 / %d40-43 / %d45-46 / %d48-57 / %d60 / %d62-91 / %d93-126 / escaped)\n"
    sabnf += "                      ; characters not allowed: space \" # ' , / : ; = \\\n"
    sabnf += "d-quoted-string     = %d34  d-quoted-value %d34\n"
    sabnf += "d-quoted-value      = 1*(%d32-33 / %d35-91 / %d93-126 / escaped)\n"
    sabnf += "s-quoted-string     = %d39 s-quoted-value %d39\n"
    sabnf += "s-quoted-value      = 1*(%d32-38  /  %d40-91 / %d93-126 / escaped)\n"
    sabnf += "escaped             = reverse-solidus (reverse-solidus\n"
    sabnf += "                    / solidus\n"
    sabnf += "                    / double-quote\n"
    sabnf += "                    / hash\n"
    sabnf += "                    / single-quote\n"
    sabnf += "                    / comma\n"
    sabnf += "                    / colon\n"
    sabnf += "                    / semicolon\n"
    sabnf += "                    / equal-sign\n"
    sabnf += "                    / blank\n"
    sabnf += "                    / tab\n"
    sabnf += "                    / line-feed\n"
    sabnf += "                    / carriage-return\n"
    sabnf += "                    / u_unicode8\n"
    sabnf += "                    / u_unicode4\n"
    sabnf += "                    / u_hexadecimal\n"
    sabnf += "                    / u_escaped-error)\n"
    sabnf += "; u_hexadecimal - UDT \"xhh\", exactly 2 hex digits [0-9a-fA-F]                    \n"
    sabnf += "; u_unicode4    - UDT \"uhhhh\", exactly 4 hex digits and semantic checking for valid Unicode characters\n"
    sabnf += ";                 surrogates, xd800 - xdfff, not allowed\n"
    sabnf += "; u_unicode8    - UDT \"Uhhhhhhhh\", exactly 8 hex digits and semantic checking for valid Unicode characters\n"
    sabnf += ";                 surrogates, xd800 - xdfff, and > x10ffff not allowed\n"
    sabnf += "reverse-solidus     = %x5c\n"
    sabnf += "double-quote        = %x22\n"
    sabnf += "hash                = %x23\n"
    sabnf += "single-quote        = %x27\n"
    sabnf += "comma               = %x2c\n"
    sabnf += "solidus             = %x2f\n"
    sabnf += "colon               = %x3a\n"
    sabnf += "semicolon           = %x3b\n"
    sabnf += "equal-sign          = %x3d\n"
    sabnf += "blank               = %s\"b\" ; %x20\n"
    sabnf += "tab                 = %s\"t\" ; %x09\n"
    sabnf += "line-feed           = %s\"n\" ; %x0a\n"
    sabnf += "carriage-return     = %s\"r\" ; %x0d\n"
    sabnf += "blank-line          = good-blank-line / bad-blank-line\n"
    sabnf += "good-blank-line     = owsp [comment] line-end\n"
    sabnf += "bad-blank-line      = (%d32 / %d9) owsp (%d33-58 / %d60-126) *any line-end\n"
    sabnf += "line-end            = %d13.10 / %d10 / %d13 / %$\n"
    sabnf += "digit-line-end      = %d13.10 / %d10 / %d13 / %$\n"
    sabnf += "line-continue       = %d47 *any line-end *(%d32 / %d9)\n"
    sabnf += "comment             = (%d35 / %d59) *any\n"
    sabnf += "owsp                = *(%d32 / %d9 / line-continue)\n"
    sabnf += "wsp                 = 1*(%d32 / %d9 / line-continue)\n"
    sabnf += "alpha               = %d65-90 / %d97-122\n"
    sabnf += "digit               = %d48-57\n"
    sabnf += "any                 = %d32-126 / %d9\n"
    return sabnf

