# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.content_sources_list import ContentSourcesList
from .ai_agent_source_type import AiAgentSourceType


class AiAgent(UncheckedBaseModel):
    """
    Data related to AI Agent involvement in the conversation.
    """

    source_type: AiAgentSourceType = pydantic.Field()
    """
    The type of the source that triggered AI Agent involvement in the conversation.
    """

    source_title: typing.Optional[str] = pydantic.Field(default=None)
    """
    The title of the source that triggered AI Agent involvement in the conversation. If this is `essentials_plan_setup` then it will return `null`.
    """

    last_answer_type: typing.Optional[str] = pydantic.Field(default=None)
    """
    The type of the last answer delivered by AI Agent. If no answer was delivered then this will return `null`
    """

    resolution_state: typing.Optional[str] = pydantic.Field(default=None)
    """
    The resolution state of AI Agent. If no AI or custom answer has been delivered then this will return `null`.
    """

    rating: typing.Optional[int] = pydantic.Field(default=None)
    """
    The customer satisfaction rating given to AI Agent, from 1-5.
    """

    rating_remark: typing.Optional[str] = pydantic.Field(default=None)
    """
    The customer satisfaction rating remark given to AI Agent.
    """

    content_sources: typing.Optional[ContentSourcesList] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
