# This file was auto-generated by Fern from our API Definition.

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .feeds.client import AsyncFeedsClient, FeedsClient
from .items.client import AsyncItemsClient, ItemsClient
from .raw_client import AsyncRawNewsClient, RawNewsClient


class NewsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawNewsClient(client_wrapper=client_wrapper)
        self.items = ItemsClient(client_wrapper=client_wrapper)

        self.feeds = FeedsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawNewsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawNewsClient
        """
        return self._raw_client


class AsyncNewsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawNewsClient(client_wrapper=client_wrapper)
        self.items = AsyncItemsClient(client_wrapper=client_wrapper)

        self.feeds = AsyncFeedsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawNewsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawNewsClient
        """
        return self._raw_client
