# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.custom_attributes import CustomAttributes
from ..types.phone_switch import PhoneSwitch
from .raw_client import AsyncRawPhoneCallRedirectsClient, RawPhoneCallRedirectsClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class PhoneCallRedirectsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawPhoneCallRedirectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawPhoneCallRedirectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawPhoneCallRedirectsClient
        """
        return self._raw_client

    def create(
        self,
        *,
        phone: str,
        custom_attributes: typing.Optional[CustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneSwitch:
        """
        You can use the API to deflect phone calls to the Intercom Messenger.
        Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.

        If custom attributes are specified, they will be added to the user or lead's custom data attributes.

        Parameters
        ----------
        phone : str
            Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.

        custom_attributes : typing.Optional[CustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneSwitch
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.phone_call_redirects.create(
            phone="+353832345678",
            custom_attributes={"issue_type": "Billing", "priority": "High"},
        )
        """
        _response = self._raw_client.create(
            phone=phone, custom_attributes=custom_attributes, request_options=request_options
        )
        return _response.data


class AsyncPhoneCallRedirectsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawPhoneCallRedirectsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawPhoneCallRedirectsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawPhoneCallRedirectsClient
        """
        return self._raw_client

    async def create(
        self,
        *,
        phone: str,
        custom_attributes: typing.Optional[CustomAttributes] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> PhoneSwitch:
        """
        You can use the API to deflect phone calls to the Intercom Messenger.
        Calling this endpoint will send an SMS with a link to the Messenger to the phone number specified.

        If custom attributes are specified, they will be added to the user or lead's custom data attributes.

        Parameters
        ----------
        phone : str
            Phone number in E.164 format, that will receive the SMS to continue the conversation in the Messenger.

        custom_attributes : typing.Optional[CustomAttributes]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        PhoneSwitch
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.phone_call_redirects.create(
                phone="+353832345678",
                custom_attributes={"issue_type": "Billing", "priority": "High"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(
            phone=phone, custom_attributes=custom_attributes, request_options=request_options
        )
        return _response.data
