# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.admin_priority_level import AdminPriorityLevel


class Team(UncheckedBaseModel):
    """
    Teams are groups of admins in Intercom.
    """

    type: typing.Literal["team"] = pydantic.Field(default="team")
    """
    Value is always "team"
    """

    id: str = pydantic.Field()
    """
    The id of the team
    """

    name: str = pydantic.Field()
    """
    The name of the team
    """

    admin_ids: typing.List[int] = pydantic.Field()
    """
    The list of admin IDs that are a part of the team.
    """

    admin_priority_level: typing.Optional[AdminPriorityLevel] = None

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
