# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .action_component import ActionComponent
from .button_component_style import ButtonComponentStyle


class ButtonComponent(UncheckedBaseModel):
    """
    A button component is used to take an action by clicking a button. This can either:
    - [Trigger a submit request to be sent](https://developers.intercom.com/docs/references/canvas-kit/actioncomponents/submit-action) Inbox Messenger
    - [Open a link in a new page](https://developers.intercom.com/docs/references/canvas-kit/actioncomponents/url-action) Inbox Messenger
    - [Open a sheet](https://developers.intercom.com/docs/references/canvas-kit/actioncomponents/sheets-action) Messenger
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the component.
    """

    label: str = pydantic.Field()
    """
    The text that will be rendered inside the button.
    """

    action: ActionComponent = pydantic.Field()
    """
    This can be a Submit Action, URL Action, or Sheets Action.
    """

    style: typing.Optional[ButtonComponentStyle] = pydantic.Field(default=None)
    """
    Styles the button. Default is 'primary'.
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles the button and prevents the action. Default is false.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
