# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .addressable_list import AddressableList


class ContactSubscriptionTypes(UncheckedBaseModel):
    """
    An object containing Subscription Types meta data about the SubscriptionTypes that a contact has.
    """

    data: typing.List[AddressableList] = pydantic.Field()
    """
    This object represents the subscriptions attached to a contact.
    """

    url: str = pydantic.Field()
    """
    Url to get more subscription type resources for this contact
    """

    total_count: int = pydantic.Field()
    """
    Int representing the total number of subscription types attached to this contact
    """

    has_more: bool = pydantic.Field()
    """
    Whether there's more Addressable Objects to be viewed. If true, use the url to view all
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
