# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.serialization import FieldMetadata
from ..core.unchecked_base_model import UncheckedBaseModel
from .create_message_request_from import CreateMessageRequestFrom
from .create_message_request_to import CreateMessageRequestTo


class CreateMessageRequestWithEmail(UncheckedBaseModel):
    subject: str = pydantic.Field()
    """
    The title of the email.
    """

    body: str = pydantic.Field()
    """
    The content of the message. HTML and plaintext are supported.
    """

    template: str = pydantic.Field()
    """
    The style of the outgoing message. Possible values `plain` or `personal`.
    """

    from_: typing_extensions.Annotated[CreateMessageRequestFrom, FieldMetadata(alias="from")] = pydantic.Field()
    """
    The sender of the message. If not provided, the default sender will be used.
    """

    to: CreateMessageRequestTo = pydantic.Field()
    """
    The sender of the message. If not provided, the default sender will be used.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time the message was created. If not provided, the current time will be used.
    """

    create_conversation_without_contact_reply: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether a conversation should be opened in the inbox for the message without the contact replying. Defaults to false if not provided.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
