# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class UpdateVisitorRequestWithId(UncheckedBaseModel):
    id: str = pydantic.Field()
    """
    A unique identified for the visitor which is given by Intercom.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The visitor's name.
    """

    custom_attributes: typing.Optional[typing.Dict[str, str]] = pydantic.Field(default=None)
    """
    The custom attributes which are set for the visitor.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
