# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel


class ExternalPage(UncheckedBaseModel):
    """
    External pages that you have added to your Fin Content Library.
    """

    type: typing.Literal["external_page"] = pydantic.Field(default="external_page")
    """
    Always external_page
    """

    id: str = pydantic.Field()
    """
    The unique identifier for the external page which is given by Intercom.
    """

    title: str = pydantic.Field()
    """
    The title of the external page.
    """

    html: str = pydantic.Field()
    """
    The body of the external page in HTML.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.
    """

    ai_agent_availability: bool = pydantic.Field()
    """
    Whether the external page should be used to answer questions by AI Agent.
    """

    ai_copilot_availability: bool = pydantic.Field()
    """
    Whether the external page should be used to answer questions by AI Copilot.
    """

    fin_availability: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Deprecated. Use ai_agent_availability and ai_copilot_availability instead.
    """

    locale: typing.Literal["en"] = pydantic.Field(default="en")
    """
    Always en
    """

    source_id: int = pydantic.Field()
    """
    The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.
    """

    external_id: str = pydantic.Field()
    """
    The identifier for the external page which was given by the source. Must be unique for the source.
    """

    created_at: int = pydantic.Field()
    """
    The time when the external page was created.
    """

    updated_at: int = pydantic.Field()
    """
    The time when the external page was last updated.
    """

    last_ingested_at: int = pydantic.Field()
    """
    The time when the external page was last ingested.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
