# This file was auto-generated by Fern from our API Definition.

import typing

from ...core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ...core.request_options import RequestOptions
from ..types.team_list import TeamList
from .raw_client import AsyncRawTeamsClient, RawTeamsClient
from .types.team import Team


class TeamsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawTeamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawTeamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawTeamsClient
        """
        return self._raw_client

    def list_teams(self, *, request_options: typing.Optional[RequestOptions] = None) -> TeamList:
        """
        This will return a list of team objects for the App.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TeamList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.teams.list_teams()
        """
        _response = self._raw_client.list_teams(request_options=request_options)
        return _response.data

    def retrieve_team(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Team:
        """
        You can fetch the details of a single team, containing an array of admins that belong to this team.

        Parameters
        ----------
        id : str
            The unique identifier of a given team.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Team
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.unstable.teams.retrieve_team(
            id="123",
        )
        """
        _response = self._raw_client.retrieve_team(id, request_options=request_options)
        return _response.data


class AsyncTeamsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawTeamsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawTeamsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawTeamsClient
        """
        return self._raw_client

    async def list_teams(self, *, request_options: typing.Optional[RequestOptions] = None) -> TeamList:
        """
        This will return a list of team objects for the App.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        TeamList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.teams.list_teams()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_teams(request_options=request_options)
        return _response.data

    async def retrieve_team(self, id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Team:
        """
        You can fetch the details of a single team, containing an array of admins that belong to this team.

        Parameters
        ----------
        id : str
            The unique identifier of a given team.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Team
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.unstable.teams.retrieve_team(
                id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.retrieve_team(id, request_options=request_options)
        return _response.data
