# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.segment_list import SegmentList
from .raw_client import AsyncRawSegmentsClient, RawSegmentsClient
from .types.segment import Segment


class SegmentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawSegmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawSegmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawSegmentsClient
        """
        return self._raw_client

    def list(
        self, *, include_count: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> SegmentList:
        """
        You can fetch a list of all segments.

        Parameters
        ----------
        include_count : typing.Optional[bool]
            It includes the count of contacts that belong to each segment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.segments.list()
        """
        _response = self._raw_client.list(include_count=include_count, request_options=request_options)
        return _response.data

    def find(self, segment_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Segment:
        """
        You can fetch the details of a single segment.

        Parameters
        ----------
        segment_id : str
            The unique identified of a given segment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Segment
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.segments.find(
            segment_id="123",
        )
        """
        _response = self._raw_client.find(segment_id, request_options=request_options)
        return _response.data


class AsyncSegmentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawSegmentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawSegmentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawSegmentsClient
        """
        return self._raw_client

    async def list(
        self, *, include_count: typing.Optional[bool] = None, request_options: typing.Optional[RequestOptions] = None
    ) -> SegmentList:
        """
        You can fetch a list of all segments.

        Parameters
        ----------
        include_count : typing.Optional[bool]
            It includes the count of contacts that belong to each segment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SegmentList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.segments.list()


        asyncio.run(main())
        """
        _response = await self._raw_client.list(include_count=include_count, request_options=request_options)
        return _response.data

    async def find(self, segment_id: str, *, request_options: typing.Optional[RequestOptions] = None) -> Segment:
        """
        You can fetch the details of a single segment.

        Parameters
        ----------
        segment_id : str
            The unique identified of a given segment.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Segment
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.segments.find(
                segment_id="123",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(segment_id, request_options=request_options)
        return _response.data
