# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class AddressableList(UncheckedBaseModel):
    """
    A list used to access other resources from a parent model.
    """

    type: str = pydantic.Field()
    """
    The addressable object type
    """

    id: str = pydantic.Field()
    """
    The id of the addressable object
    """

    url: str = pydantic.Field()
    """
    Url to get more company resources for this contact
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
