# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..articles.types.article_list_item import ArticleListItem
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class ArticleList(UncheckedBaseModel):
    """
    This will return a list of articles for the App.
    """

    type: typing.Literal["list"] = pydantic.Field(default="list")
    """
    The type of the object - `list`.
    """

    pages: typing.Optional[typing.Optional[typing.Any]] = None
    total_count: int = pydantic.Field()
    """
    A count of the total number of articles.
    """

    data: typing.List[ArticleListItem] = pydantic.Field()
    """
    An array of Article objects
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
