# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .contact_company import ContactCompany


class ContactCompanies(UncheckedBaseModel):
    """
    An object containing companies meta data about the companies that a contact has. Up to 10 will be displayed here. Use the url to get more.
    """

    type: typing.Optional[typing.Literal["list"]] = pydantic.Field(default=None)
    """
    The type of object
    """

    data: typing.Optional[typing.List[ContactCompany]] = pydantic.Field(default=None)
    """
    An array containing Company Objects
    """

    url: str = pydantic.Field()
    """
    Url to get more company resources for this contact
    """

    total_count: int = pydantic.Field()
    """
    Int representing the total number of companyies attached to this contact
    """

    has_more: bool = pydantic.Field()
    """
    Whether there's more Addressable Objects to be viewed. If true, use the url to view all
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
