# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .starting_after_paging import StartingAfterPaging


class CursorPages(UncheckedBaseModel):
    """
    Cursor-based pagination is a technique used in the Intercom API to navigate through large amounts of data.
    A "cursor" or pointer is used to keep track of the current position in the result set, allowing the API to return the data in small chunks or "pages" as needed.
    """

    type: typing.Literal["pages"] = pydantic.Field(default="pages")
    """
    the type of object `pages`.
    """

    page: typing.Optional[int] = pydantic.Field(default=None)
    """
    The current page
    """

    next: typing.Optional[StartingAfterPaging] = None
    per_page: typing.Optional[int] = pydantic.Field(default=None)
    """
    Number of results per page
    """

    total_pages: typing.Optional[int] = pydantic.Field(default=None)
    """
    Total number of pages
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
