# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel


class SingleSelectOption(UncheckedBaseModel):
    """
    A single select option component that can be selected.
    """

    type: typing.Literal["option"] = pydantic.Field(default="option")
    """
    The type of component you are rendering.
    """

    id: str = pydantic.Field()
    """
    A unique identifier for the option.
    """

    text: str = pydantic.Field()
    """
    The text shown within this option.
    """

    disabled: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Styles the option and prevents the action. Default is false.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
