# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ..admins.types.admin import Admin
from ..contacts.types.contact import Contact
from ..conversations.types.conversation import Conversation
from ..core.pydantic_utilities import IS_PYDANTIC_V2
from ..core.unchecked_base_model import UncheckedBaseModel
from .context import Context
from .current_canvas import CurrentCanvas


class SubmitRequest(UncheckedBaseModel):
    """
    The Submit request is triggered when a component with a submit action is interacted with in Messenger Inbox.
    """

    workspace_id: str = pydantic.Field()
    """
    The workspace ID of the teammate. Attribute is `app_id` for V1.2 and below.
    """

    workspace_region: str = pydantic.Field()
    """
    The Intercom hosted region that this app is located in.
    """

    admin: Admin = pydantic.Field()
    """
    The Intercom teammate viewing the conversation.
    """

    component_id: str = pydantic.Field()
    """
    The id of the component clicked by the teammate to trigger the request.
    """

    context: Context = pydantic.Field()
    """
    The context of where the app is added, where the user last visited, and information on the Messenger settings.
    """

    conversation: Conversation = pydantic.Field()
    """
    The conversation where your app is being shown.
    """

    current_canvas: CurrentCanvas = pydantic.Field()
    """
    The current canvas the teammate can see.
    """

    contact: Contact = pydantic.Field()
    """
    The contact which is currently being viewed by the teammate in the conversation details panel.
    """

    input_values: typing.Dict[str, typing.Optional[typing.Any]] = pydantic.Field()
    """
    A list of key/value pairs of data, inputted by the teammate on the current canvas.
    """

    user: Contact = pydantic.Field()
    """
    The user who took the action.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
