# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ....core.pydantic_utilities import IS_PYDANTIC_V2
from ....core.unchecked_base_model import UncheckedBaseModel
from ...types.group_translated_content import GroupTranslatedContent


class Collection(UncheckedBaseModel):
    """
    Collections are top level containers for Articles within the Help Center.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the collection which is given by Intercom.
    """

    workspace_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the workspace which the collection belongs to.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the collection. For multilingual collections, this will be the name of the default language's content.
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the collection. For multilingual help centers, this will be the description of the collection for the default language.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was created (seconds). For multilingual articles, this will be the timestamp of creation of the default language's content.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the article was last updated (seconds). For multilingual articles, this will be the timestamp of last update of the default language's content.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL of the collection. For multilingual help centers, this will be the URL of the collection for the default language.
    """

    icon: typing.Optional[str] = pydantic.Field(default=None)
    """
    The icon of the collection.
    """

    order: typing.Optional[int] = pydantic.Field(default=None)
    """
    The order of the section in relation to others sections within a collection. Values go from `0` upwards. `0` is the default if there's no order.
    """

    default_locale: typing.Optional[str] = pydantic.Field(default=None)
    """
    The default locale of the help center. This field is only returned for multilingual help centers.
    """

    translated_content: typing.Optional[GroupTranslatedContent] = None
    parent_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the parent collection. If `null` then it is the first level collection.
    """

    help_center_id: typing.Optional[int] = pydantic.Field(default=None)
    """
    The id of the help center the collection is in.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
