# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from python_intercom import Intercom, AsyncIntercom
from python_intercom.types.companies import CompanyAttachedContacts

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestContacts:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_list(self, client: Intercom) -> None:
        contact = client.companies.contacts.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

    @parametrize
    def test_method_list_with_all_params(self, client: Intercom) -> None:
        contact = client.companies.contacts.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            intercom_version="2.11",
        )
        assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

    @parametrize
    def test_raw_response_list(self, client: Intercom) -> None:
        response = client.companies.contacts.with_raw_response.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        contact = response.parse()
        assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

    @parametrize
    def test_streaming_response_list(self, client: Intercom) -> None:
        with client.companies.contacts.with_streaming_response.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            contact = response.parse()
            assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_list(self, client: Intercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.companies.contacts.with_raw_response.list(
                id="",
            )


class TestAsyncContacts:
    parametrize = pytest.mark.parametrize("async_client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    async def test_method_list(self, async_client: AsyncIntercom) -> None:
        contact = await async_client.companies.contacts.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )
        assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncIntercom) -> None:
        contact = await async_client.companies.contacts.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
            intercom_version="2.11",
        )
        assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

    @parametrize
    async def test_raw_response_list(self, async_client: AsyncIntercom) -> None:
        response = await async_client.companies.contacts.with_raw_response.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        contact = await response.parse()
        assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncIntercom) -> None:
        async with async_client.companies.contacts.with_streaming_response.list(
            id="5f4d3c1c-7b1b-4d7d-a97e-6095715c6632",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            contact = await response.parse()
            assert_matches_type(CompanyAttachedContacts, contact, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_list(self, async_client: AsyncIntercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.companies.contacts.with_raw_response.list(
                id="",
            )
