# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from __future__ import annotations

import os
from typing import Any, cast

import pytest

from tests.utils import assert_matches_type
from python_intercom import Intercom, AsyncIntercom
from python_intercom.types.shared import Company
from python_intercom.types.contacts import ContactAttachedCompanies

base_url = os.environ.get("TEST_API_BASE_URL", "http://127.0.0.1:4010")


class TestCompanies:
    parametrize = pytest.mark.parametrize("client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    def test_method_create(self, client: Intercom) -> None:
        company = client.contacts.companies.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    def test_method_create_with_all_params(self, client: Intercom) -> None:
        company = client.contacts.companies.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
            intercom_version="2.11",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    def test_raw_response_create(self, client: Intercom) -> None:
        response = client.contacts.companies.with_raw_response.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        company = response.parse()
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    def test_streaming_response_create(self, client: Intercom) -> None:
        with client.contacts.companies.with_streaming_response.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            company = response.parse()
            assert_matches_type(Company, company, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_create(self, client: Intercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `contact_id` but received ''"):
            client.contacts.companies.with_raw_response.create(
                contact_id="",
                company_id="6657add46abd0167d9419cd2",
            )

    @parametrize
    def test_method_list(self, client: Intercom) -> None:
        company = client.contacts.companies.list(
            contact_id="contact_id",
        )
        assert_matches_type(ContactAttachedCompanies, company, path=["response"])

    @parametrize
    def test_method_list_with_all_params(self, client: Intercom) -> None:
        company = client.contacts.companies.list(
            contact_id="contact_id",
            intercom_version="2.11",
        )
        assert_matches_type(ContactAttachedCompanies, company, path=["response"])

    @parametrize
    def test_raw_response_list(self, client: Intercom) -> None:
        response = client.contacts.companies.with_raw_response.list(
            contact_id="contact_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        company = response.parse()
        assert_matches_type(ContactAttachedCompanies, company, path=["response"])

    @parametrize
    def test_streaming_response_list(self, client: Intercom) -> None:
        with client.contacts.companies.with_streaming_response.list(
            contact_id="contact_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            company = response.parse()
            assert_matches_type(ContactAttachedCompanies, company, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_list(self, client: Intercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `contact_id` but received ''"):
            client.contacts.companies.with_raw_response.list(
                contact_id="",
            )

    @parametrize
    def test_method_delete(self, client: Intercom) -> None:
        company = client.contacts.companies.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    def test_method_delete_with_all_params(self, client: Intercom) -> None:
        company = client.contacts.companies.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
            intercom_version="2.11",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    def test_raw_response_delete(self, client: Intercom) -> None:
        response = client.contacts.companies.with_raw_response.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        company = response.parse()
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    def test_streaming_response_delete(self, client: Intercom) -> None:
        with client.contacts.companies.with_streaming_response.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            company = response.parse()
            assert_matches_type(Company, company, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    def test_path_params_delete(self, client: Intercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `contact_id` but received ''"):
            client.contacts.companies.with_raw_response.delete(
                id="58a430d35458202d41b1e65b",
                contact_id="",
            )

        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            client.contacts.companies.with_raw_response.delete(
                id="",
                contact_id="58a430d35458202d41b1e65b",
            )


class TestAsyncCompanies:
    parametrize = pytest.mark.parametrize("async_client", [False, True], indirect=True, ids=["loose", "strict"])

    @parametrize
    async def test_method_create(self, async_client: AsyncIntercom) -> None:
        company = await async_client.contacts.companies.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    async def test_method_create_with_all_params(self, async_client: AsyncIntercom) -> None:
        company = await async_client.contacts.companies.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
            intercom_version="2.11",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    async def test_raw_response_create(self, async_client: AsyncIntercom) -> None:
        response = await async_client.contacts.companies.with_raw_response.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        company = await response.parse()
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    async def test_streaming_response_create(self, async_client: AsyncIntercom) -> None:
        async with async_client.contacts.companies.with_streaming_response.create(
            contact_id="contact_id",
            company_id="6657add46abd0167d9419cd2",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            company = await response.parse()
            assert_matches_type(Company, company, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_create(self, async_client: AsyncIntercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `contact_id` but received ''"):
            await async_client.contacts.companies.with_raw_response.create(
                contact_id="",
                company_id="6657add46abd0167d9419cd2",
            )

    @parametrize
    async def test_method_list(self, async_client: AsyncIntercom) -> None:
        company = await async_client.contacts.companies.list(
            contact_id="contact_id",
        )
        assert_matches_type(ContactAttachedCompanies, company, path=["response"])

    @parametrize
    async def test_method_list_with_all_params(self, async_client: AsyncIntercom) -> None:
        company = await async_client.contacts.companies.list(
            contact_id="contact_id",
            intercom_version="2.11",
        )
        assert_matches_type(ContactAttachedCompanies, company, path=["response"])

    @parametrize
    async def test_raw_response_list(self, async_client: AsyncIntercom) -> None:
        response = await async_client.contacts.companies.with_raw_response.list(
            contact_id="contact_id",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        company = await response.parse()
        assert_matches_type(ContactAttachedCompanies, company, path=["response"])

    @parametrize
    async def test_streaming_response_list(self, async_client: AsyncIntercom) -> None:
        async with async_client.contacts.companies.with_streaming_response.list(
            contact_id="contact_id",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            company = await response.parse()
            assert_matches_type(ContactAttachedCompanies, company, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_list(self, async_client: AsyncIntercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `contact_id` but received ''"):
            await async_client.contacts.companies.with_raw_response.list(
                contact_id="",
            )

    @parametrize
    async def test_method_delete(self, async_client: AsyncIntercom) -> None:
        company = await async_client.contacts.companies.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    async def test_method_delete_with_all_params(self, async_client: AsyncIntercom) -> None:
        company = await async_client.contacts.companies.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
            intercom_version="2.11",
        )
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    async def test_raw_response_delete(self, async_client: AsyncIntercom) -> None:
        response = await async_client.contacts.companies.with_raw_response.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
        )

        assert response.is_closed is True
        assert response.http_request.headers.get("X-Stainless-Lang") == "python"
        company = await response.parse()
        assert_matches_type(Company, company, path=["response"])

    @parametrize
    async def test_streaming_response_delete(self, async_client: AsyncIntercom) -> None:
        async with async_client.contacts.companies.with_streaming_response.delete(
            id="58a430d35458202d41b1e65b",
            contact_id="58a430d35458202d41b1e65b",
        ) as response:
            assert not response.is_closed
            assert response.http_request.headers.get("X-Stainless-Lang") == "python"

            company = await response.parse()
            assert_matches_type(Company, company, path=["response"])

        assert cast(Any, response.is_closed) is True

    @parametrize
    async def test_path_params_delete(self, async_client: AsyncIntercom) -> None:
        with pytest.raises(ValueError, match=r"Expected a non-empty value for `contact_id` but received ''"):
            await async_client.contacts.companies.with_raw_response.delete(
                id="58a430d35458202d41b1e65b",
                contact_id="",
            )

        with pytest.raises(ValueError, match=r"Expected a non-empty value for `id` but received ''"):
            await async_client.contacts.companies.with_raw_response.delete(
                id="",
                contact_id="58a430d35458202d41b1e65b",
            )
