# This file was auto-generated by Fern from our API Definition.

import os
import typing

import httpx
from .admins.client import AdminsClient, AsyncAdminsClient
from .articles.client import ArticlesClient, AsyncArticlesClient
from .companies.client import AsyncCompaniesClient, CompaniesClient
from .contacts.client import AsyncContactsClient, ContactsClient
from .conversations.client import AsyncConversationsClient, ConversationsClient
from .core.api_error import ApiError
from .core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from .data_attributes.client import AsyncDataAttributesClient, DataAttributesClient
from .data_export.client import AsyncDataExportClient, DataExportClient
from .environment import IntercomEnvironment
from .events.client import AsyncEventsClient, EventsClient
from .help_centers.client import AsyncHelpCentersClient, HelpCentersClient
from .messages.client import AsyncMessagesClient, MessagesClient
from .news.client import AsyncNewsClient, NewsClient
from .notes.client import AsyncNotesClient, NotesClient
from .phone_call_redirects.client import AsyncPhoneCallRedirectsClient, PhoneCallRedirectsClient
from .segments.client import AsyncSegmentsClient, SegmentsClient
from .subscription_types.client import AsyncSubscriptionTypesClient, SubscriptionTypesClient
from .tags.client import AsyncTagsClient, TagsClient
from .teams.client import AsyncTeamsClient, TeamsClient
from .ticket_types.client import AsyncTicketTypesClient, TicketTypesClient
from .tickets.client import AsyncTicketsClient, TicketsClient
from .unstable.client import AsyncUnstableClient, UnstableClient
from .visitors.client import AsyncVisitorsClient, VisitorsClient


class Intercom:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : IntercomEnvironment
        The environment to use for requests from the client. from .environment import IntercomEnvironment



        Defaults to IntercomEnvironment.US_PRODUCTION



    token : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.Client]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from intercom import Intercom

    client = Intercom(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: IntercomEnvironment = IntercomEnvironment.US_PRODUCTION,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("INTERCOM_API_KEY"),
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.Client] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if token is None:
            raise ApiError(
                body="The client must be instantiated be either passing in token or setting INTERCOM_API_KEY"
            )
        self._client_wrapper = SyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.Client(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.Client(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.admins = AdminsClient(client_wrapper=self._client_wrapper)
        self.articles = ArticlesClient(client_wrapper=self._client_wrapper)
        self.help_centers = HelpCentersClient(client_wrapper=self._client_wrapper)
        self.companies = CompaniesClient(client_wrapper=self._client_wrapper)
        self.contacts = ContactsClient(client_wrapper=self._client_wrapper)
        self.notes = NotesClient(client_wrapper=self._client_wrapper)
        self.tags = TagsClient(client_wrapper=self._client_wrapper)
        self.conversations = ConversationsClient(client_wrapper=self._client_wrapper)
        self.data_attributes = DataAttributesClient(client_wrapper=self._client_wrapper)
        self.events = EventsClient(client_wrapper=self._client_wrapper)
        self.data_export = DataExportClient(client_wrapper=self._client_wrapper)
        self.messages = MessagesClient(client_wrapper=self._client_wrapper)
        self.segments = SegmentsClient(client_wrapper=self._client_wrapper)
        self.subscription_types = SubscriptionTypesClient(client_wrapper=self._client_wrapper)
        self.phone_call_redirects = PhoneCallRedirectsClient(client_wrapper=self._client_wrapper)
        self.teams = TeamsClient(client_wrapper=self._client_wrapper)
        self.ticket_types = TicketTypesClient(client_wrapper=self._client_wrapper)
        self.tickets = TicketsClient(client_wrapper=self._client_wrapper)
        self.visitors = VisitorsClient(client_wrapper=self._client_wrapper)
        self.news = NewsClient(client_wrapper=self._client_wrapper)
        self.unstable = UnstableClient(client_wrapper=self._client_wrapper)


class AsyncIntercom:
    """
    Use this class to access the different functions within the SDK. You can instantiate any number of clients with different configuration that will propagate to these functions.

    Parameters
    ----------
    base_url : typing.Optional[str]
        The base url to use for requests from the client.

    environment : IntercomEnvironment
        The environment to use for requests from the client. from .environment import IntercomEnvironment



        Defaults to IntercomEnvironment.US_PRODUCTION



    token : typing.Optional[typing.Union[str, typing.Callable[[], str]]]
    timeout : typing.Optional[float]
        The timeout to be used, in seconds, for requests. By default the timeout is 60 seconds, unless a custom httpx client is used, in which case this default is not enforced.

    follow_redirects : typing.Optional[bool]
        Whether the default httpx client follows redirects or not, this is irrelevant if a custom httpx client is passed in.

    httpx_client : typing.Optional[httpx.AsyncClient]
        The httpx client to use for making requests, a preconfigured client is used by default, however this is useful should you want to pass in any custom httpx configuration.

    Examples
    --------
    from intercom import AsyncIntercom

    client = AsyncIntercom(
        token="YOUR_TOKEN",
    )
    """

    def __init__(
        self,
        *,
        base_url: typing.Optional[str] = None,
        environment: IntercomEnvironment = IntercomEnvironment.US_PRODUCTION,
        token: typing.Optional[typing.Union[str, typing.Callable[[], str]]] = os.getenv("INTERCOM_API_KEY"),
        timeout: typing.Optional[float] = None,
        follow_redirects: typing.Optional[bool] = True,
        httpx_client: typing.Optional[httpx.AsyncClient] = None,
    ):
        _defaulted_timeout = (
            timeout if timeout is not None else 60 if httpx_client is None else httpx_client.timeout.read
        )
        if token is None:
            raise ApiError(
                body="The client must be instantiated be either passing in token or setting INTERCOM_API_KEY"
            )
        self._client_wrapper = AsyncClientWrapper(
            base_url=_get_base_url(base_url=base_url, environment=environment),
            token=token,
            httpx_client=httpx_client
            if httpx_client is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout, follow_redirects=follow_redirects)
            if follow_redirects is not None
            else httpx.AsyncClient(timeout=_defaulted_timeout),
            timeout=_defaulted_timeout,
        )
        self.admins = AsyncAdminsClient(client_wrapper=self._client_wrapper)
        self.articles = AsyncArticlesClient(client_wrapper=self._client_wrapper)
        self.help_centers = AsyncHelpCentersClient(client_wrapper=self._client_wrapper)
        self.companies = AsyncCompaniesClient(client_wrapper=self._client_wrapper)
        self.contacts = AsyncContactsClient(client_wrapper=self._client_wrapper)
        self.notes = AsyncNotesClient(client_wrapper=self._client_wrapper)
        self.tags = AsyncTagsClient(client_wrapper=self._client_wrapper)
        self.conversations = AsyncConversationsClient(client_wrapper=self._client_wrapper)
        self.data_attributes = AsyncDataAttributesClient(client_wrapper=self._client_wrapper)
        self.events = AsyncEventsClient(client_wrapper=self._client_wrapper)
        self.data_export = AsyncDataExportClient(client_wrapper=self._client_wrapper)
        self.messages = AsyncMessagesClient(client_wrapper=self._client_wrapper)
        self.segments = AsyncSegmentsClient(client_wrapper=self._client_wrapper)
        self.subscription_types = AsyncSubscriptionTypesClient(client_wrapper=self._client_wrapper)
        self.phone_call_redirects = AsyncPhoneCallRedirectsClient(client_wrapper=self._client_wrapper)
        self.teams = AsyncTeamsClient(client_wrapper=self._client_wrapper)
        self.ticket_types = AsyncTicketTypesClient(client_wrapper=self._client_wrapper)
        self.tickets = AsyncTicketsClient(client_wrapper=self._client_wrapper)
        self.visitors = AsyncVisitorsClient(client_wrapper=self._client_wrapper)
        self.news = AsyncNewsClient(client_wrapper=self._client_wrapper)
        self.unstable = AsyncUnstableClient(client_wrapper=self._client_wrapper)


def _get_base_url(*, base_url: typing.Optional[str] = None, environment: IntercomEnvironment) -> str:
    if base_url is not None:
        return base_url
    elif environment is not None:
        return environment.value
    else:
        raise Exception("Please pass in either base_url or environment to construct the client")
