# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from ...types.part_attachment import PartAttachment
from ...types.reference import Reference
from ...types.ticket_part_author import TicketPartAuthor
from .ticket_part_previous_ticket_state import TicketPartPreviousTicketState
from .ticket_part_ticket_state import TicketPartTicketState


class TicketPart(UncheckedBaseModel):
    """
    A Ticket Part represents a message in the ticket.
    """

    type: typing.Literal["ticket_part"] = pydantic.Field(default="ticket_part")
    """
    Always ticket_part
    """

    id: str = pydantic.Field()
    """
    The id representing the ticket part.
    """

    part_type: str = pydantic.Field()
    """
    The type of ticket part.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The message body, which may contain HTML.
    """

    previous_ticket_state: typing.Optional[TicketPartPreviousTicketState] = pydantic.Field(default=None)
    """
    The previous state of the ticket.
    """

    ticket_state: TicketPartTicketState = pydantic.Field()
    """
    The state of the ticket.
    """

    created_at: int = pydantic.Field()
    """
    The time the ticket part was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The last time the ticket part was updated.
    """

    assigned_to: typing.Optional[Reference] = pydantic.Field(default=None)
    """
    The id of the admin that was assigned the ticket by this ticket_part (null if there has been no change in assignment.)
    """

    author: typing.Optional[TicketPartAuthor] = None
    attachments: typing.Optional[typing.List[PartAttachment]] = pydantic.Field(default=None)
    """
    A list of attachments for the part.
    """

    external_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The external id of the ticket part
    """

    redacted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the ticket part has been redacted.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
