# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .conversation_part_author import ConversationPartAuthor
from .conversation_source_type import ConversationSourceType
from .part_attachment import PartAttachment


class ConversationSource(UncheckedBaseModel):
    """
    The type of the conversation part that started this conversation. Can be Contact, Admin, Campaign, Automated or Operator initiated.
    """

    type: typing.Optional[ConversationSourceType] = pydantic.Field(default=None)
    """
    This includes conversation, email, facebook, instagram, phone_call, phone_switch, push, sms, twitter and whatsapp.
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id representing the message.
    """

    delivered_as: typing.Optional[str] = pydantic.Field(default=None)
    """
    The conversation's initiation type. Possible values are customer_initiated, campaigns_initiated (legacy campaigns), operator_initiated (Custom bot), automated (Series and other outbounds with dynamic audience message) and admin_initiated (fixed audience message, ticket initiated by an admin, group email).
    """

    subject: typing.Optional[str] = pydantic.Field(default=None)
    """
    Optional. The message subject. For Twitter, this will show a generic message regarding why the subject is obscured.
    """

    body: typing.Optional[str] = pydantic.Field(default=None)
    """
    The message body, which may contain HTML. For Twitter, this will show a generic message regarding why the body is obscured.
    """

    author: typing.Optional[ConversationPartAuthor] = None
    attachments: typing.Optional[typing.List[PartAttachment]] = pydantic.Field(default=None)
    """
    A list of attachments for the part.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL where the conversation was started. For Twitter, Email, and Bots, this will be blank.
    """

    redacted: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether or not the source message has been redacted. Only applicable for contact initiated messages.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
