# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel
from .custom_channel_contact_type import CustomChannelContactType


class CustomChannelContact(UncheckedBaseModel):
    type: CustomChannelContactType = pydantic.Field()
    """
    Type of contact, must be "user" or "lead".
    """

    external_id: str = pydantic.Field()
    """
    External identifier for the contact. Intercom will take care of the mapping of your external_id with our internal ones so you don't have to worry about it.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    Name of the contact. Required for user type.
    """

    email: typing.Optional[str] = pydantic.Field(default=None)
    """
    Email address of the contact. Required for user type.
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
