# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class DataEventSummaryItem(UncheckedBaseModel):
    """
    This will return a summary of a data event for the App.
    """

    name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The name of the event
    """

    first: typing.Optional[str] = pydantic.Field(default=None)
    """
    The first time the event was sent
    """

    last: typing.Optional[str] = pydantic.Field(default=None)
    """
    The last time the event was sent
    """

    count: typing.Optional[int] = pydantic.Field(default=None)
    """
    The number of times the event was sent
    """

    description: typing.Optional[str] = pydantic.Field(default=None)
    """
    The description of the event
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
