# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawAiContentClient, RawAiContentClient
from .types.content_import_source import ContentImportSource
from .types.content_import_sources_list import ContentImportSourcesList
from .types.create_content_import_source_request_status import CreateContentImportSourceRequestStatus
from .types.external_page import ExternalPage
from .types.external_pages_list import ExternalPagesList
from .types.update_content_import_source_request_status import UpdateContentImportSourceRequestStatus
from .types.update_content_import_source_request_sync_behavior import UpdateContentImportSourceRequestSyncBehavior

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class AiContentClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawAiContentClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawAiContentClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawAiContentClient
        """
        return self._raw_client

    def list_content_import_sources(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContentImportSourcesList:
        """
        You can retrieve a list of all content import sources for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSourcesList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.list_content_import_sources()
        """
        _response = self._raw_client.list_content_import_sources(request_options=request_options)
        return _response.data

    def create_content_import_source(
        self,
        *,
        url: str,
        status: typing.Optional[CreateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContentImportSource:
        """
        You can create a new content import source by sending a POST request to this endpoint.

        Parameters
        ----------
        url : str
            The URL of the content import source.

        status : typing.Optional[CreateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSource
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.create_content_import_source(
            url="https://www.example.com",
        )
        """
        _response = self._raw_client.create_content_import_source(
            url=url, status=status, request_options=request_options
        )
        return _response.data

    def get_content_import_source(
        self, source_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContentImportSource:
        """
        Parameters
        ----------
        source_id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSource
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.get_content_import_source(
            source_id="source_id",
        )
        """
        _response = self._raw_client.get_content_import_source(source_id, request_options=request_options)
        return _response.data

    def update_content_import_source(
        self,
        source_id: str,
        *,
        sync_behavior: UpdateContentImportSourceRequestSyncBehavior,
        url: str,
        status: typing.Optional[UpdateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContentImportSource:
        """
        You can update an existing content import source.

        Parameters
        ----------
        source_id : str
            The unique identifier for the content import source which is given by Intercom.

        sync_behavior : UpdateContentImportSourceRequestSyncBehavior
            If you intend to create or update External Pages via the API, this should be set to `api`. You can not change the value to or from api.

        url : str
            The URL of the content import source. This may only be different from the existing value if the sync behavior is API.

        status : typing.Optional[UpdateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSource
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.update_content_import_source(
            source_id="source_id",
            sync_behavior="api",
            url="https://www.example.com",
        )
        """
        _response = self._raw_client.update_content_import_source(
            source_id, sync_behavior=sync_behavior, url=url, status=status, request_options=request_options
        )
        return _response.data

    def delete_content_import_source(
        self, source_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.

        Parameters
        ----------
        source_id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.delete_content_import_source(
            source_id="source_id",
        )
        """
        _response = self._raw_client.delete_content_import_source(source_id, request_options=request_options)
        return _response.data

    def list_external_pages(self, *, request_options: typing.Optional[RequestOptions] = None) -> ExternalPagesList:
        """
        You can retrieve a list of all external pages for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPagesList
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.list_external_pages()
        """
        _response = self._raw_client.list_external_pages(request_options=request_options)
        return _response.data

    def create_external_page(
        self,
        *,
        title: str,
        html: str,
        source_id: int,
        external_id: str,
        url: typing.Optional[str] = OMIT,
        ai_agent_availability: typing.Optional[bool] = OMIT,
        ai_copilot_availability: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExternalPage:
        """
        You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.

        Parameters
        ----------
        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        external_id : str
            The identifier for the external page which was given by the source. Must be unique for the source.

        url : typing.Optional[str]
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.

        ai_agent_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.

        ai_copilot_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.create_external_page(
            title="Test",
            html="<html><body><h1>Test</h1></body></html>",
            url="https://www.example.com",
            source_id=44,
            external_id="abc1234",
        )
        """
        _response = self._raw_client.create_external_page(
            title=title,
            html=html,
            source_id=source_id,
            external_id=external_id,
            url=url,
            ai_agent_availability=ai_agent_availability,
            ai_copilot_availability=ai_copilot_availability,
            request_options=request_options,
        )
        return _response.data

    def get_external_page(
        self, page_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalPage:
        """
        You can retrieve an external page.

        Parameters
        ----------
        page_id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.get_external_page(
            page_id="page_id",
        )
        """
        _response = self._raw_client.get_external_page(page_id, request_options=request_options)
        return _response.data

    def update_external_page(
        self,
        page_id: str,
        *,
        title: str,
        html: str,
        url: str,
        source_id: int,
        fin_availability: typing.Optional[bool] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExternalPage:
        """
        You can update an existing external page (if it was created via the API).

        Parameters
        ----------
        page_id : str
            The unique identifier for the external page which is given by Intercom.

        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        url : str
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        fin_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by Fin.

        external_id : typing.Optional[str]
            The identifier for the external page which was given by the source. Must be unique for the source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.update_external_page(
            page_id="page_id",
            title="Test",
            html="<html><body><h1>Test</h1></body></html>",
            url="https://www.example.com",
            source_id=47,
            external_id="5678",
        )
        """
        _response = self._raw_client.update_external_page(
            page_id,
            title=title,
            html=html,
            url=url,
            source_id=source_id,
            fin_availability=fin_availability,
            external_id=external_id,
            request_options=request_options,
        )
        return _response.data

    def delete_external_page(
        self, page_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalPage:
        """
        Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.

        Parameters
        ----------
        page_id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.ai_content.delete_external_page(
            page_id="page_id",
        )
        """
        _response = self._raw_client.delete_external_page(page_id, request_options=request_options)
        return _response.data


class AsyncAiContentClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawAiContentClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawAiContentClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawAiContentClient
        """
        return self._raw_client

    async def list_content_import_sources(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContentImportSourcesList:
        """
        You can retrieve a list of all content import sources for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSourcesList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.list_content_import_sources()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_content_import_sources(request_options=request_options)
        return _response.data

    async def create_content_import_source(
        self,
        *,
        url: str,
        status: typing.Optional[CreateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContentImportSource:
        """
        You can create a new content import source by sending a POST request to this endpoint.

        Parameters
        ----------
        url : str
            The URL of the content import source.

        status : typing.Optional[CreateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSource
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.create_content_import_source(
                url="https://www.example.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_content_import_source(
            url=url, status=status, request_options=request_options
        )
        return _response.data

    async def get_content_import_source(
        self, source_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ContentImportSource:
        """
        Parameters
        ----------
        source_id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSource
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.get_content_import_source(
                source_id="source_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_content_import_source(source_id, request_options=request_options)
        return _response.data

    async def update_content_import_source(
        self,
        source_id: str,
        *,
        sync_behavior: UpdateContentImportSourceRequestSyncBehavior,
        url: str,
        status: typing.Optional[UpdateContentImportSourceRequestStatus] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ContentImportSource:
        """
        You can update an existing content import source.

        Parameters
        ----------
        source_id : str
            The unique identifier for the content import source which is given by Intercom.

        sync_behavior : UpdateContentImportSourceRequestSyncBehavior
            If you intend to create or update External Pages via the API, this should be set to `api`. You can not change the value to or from api.

        url : str
            The URL of the content import source. This may only be different from the existing value if the sync behavior is API.

        status : typing.Optional[UpdateContentImportSourceRequestStatus]
            The status of the content import source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ContentImportSource
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.update_content_import_source(
                source_id="source_id",
                sync_behavior="api",
                url="https://www.example.com",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_content_import_source(
            source_id, sync_behavior=sync_behavior, url=url, status=status, request_options=request_options
        )
        return _response.data

    async def delete_content_import_source(
        self, source_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> None:
        """
        You can delete a content import source by making a DELETE request this endpoint. This will also delete all external pages that were imported from this source.

        Parameters
        ----------
        source_id : str
            The unique identifier for the content import source which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.delete_content_import_source(
                source_id="source_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_content_import_source(source_id, request_options=request_options)
        return _response.data

    async def list_external_pages(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalPagesList:
        """
        You can retrieve a list of all external pages for a workspace.

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPagesList
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.list_external_pages()


        asyncio.run(main())
        """
        _response = await self._raw_client.list_external_pages(request_options=request_options)
        return _response.data

    async def create_external_page(
        self,
        *,
        title: str,
        html: str,
        source_id: int,
        external_id: str,
        url: typing.Optional[str] = OMIT,
        ai_agent_availability: typing.Optional[bool] = OMIT,
        ai_copilot_availability: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExternalPage:
        """
        You can create a new external page by sending a POST request to this endpoint. If an external page already exists with the specified source_id and external_id, it will be updated instead.

        Parameters
        ----------
        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        external_id : str
            The identifier for the external page which was given by the source. Must be unique for the source.

        url : typing.Optional[str]
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on. When a URL is not present, Fin will not reference the source.

        ai_agent_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Agent. Will not default when updating an existing external page.

        ai_copilot_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by AI Copilot. Will not default when updating an existing external page.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.create_external_page(
                title="Test",
                html="<html><body><h1>Test</h1></body></html>",
                url="https://www.example.com",
                source_id=44,
                external_id="abc1234",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_external_page(
            title=title,
            html=html,
            source_id=source_id,
            external_id=external_id,
            url=url,
            ai_agent_availability=ai_agent_availability,
            ai_copilot_availability=ai_copilot_availability,
            request_options=request_options,
        )
        return _response.data

    async def get_external_page(
        self, page_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalPage:
        """
        You can retrieve an external page.

        Parameters
        ----------
        page_id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.get_external_page(
                page_id="page_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_external_page(page_id, request_options=request_options)
        return _response.data

    async def update_external_page(
        self,
        page_id: str,
        *,
        title: str,
        html: str,
        url: str,
        source_id: int,
        fin_availability: typing.Optional[bool] = OMIT,
        external_id: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ExternalPage:
        """
        You can update an existing external page (if it was created via the API).

        Parameters
        ----------
        page_id : str
            The unique identifier for the external page which is given by Intercom.

        title : str
            The title of the external page.

        html : str
            The body of the external page in HTML.

        url : str
            The URL of the external page. This will be used by Fin to link end users to the page it based its answer on.

        source_id : int
            The unique identifier for the source of the external page which was given by Intercom. Every external page must be associated with a Content Import Source which represents the place it comes from and from which it inherits a default audience (configured in the UI). For a new source, make a POST request to the Content Import Source endpoint and an ID for the source will be returned in the response.

        fin_availability : typing.Optional[bool]
            Whether the external page should be used to answer questions by Fin.

        external_id : typing.Optional[str]
            The identifier for the external page which was given by the source. Must be unique for the source.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.update_external_page(
                page_id="page_id",
                title="Test",
                html="<html><body><h1>Test</h1></body></html>",
                url="https://www.example.com",
                source_id=47,
                external_id="5678",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update_external_page(
            page_id,
            title=title,
            html=html,
            url=url,
            source_id=source_id,
            fin_availability=fin_availability,
            external_id=external_id,
            request_options=request_options,
        )
        return _response.data

    async def delete_external_page(
        self, page_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> ExternalPage:
        """
        Sending a DELETE request for an external page will remove it from the content library UI and from being used for AI answers.

        Parameters
        ----------
        page_id : str
            The unique identifier for the external page which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ExternalPage
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.ai_content.delete_external_page(
                page_id="page_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_external_page(page_id, request_options=request_options)
        return _response.data
