# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..types.article_list import ArticleList
from ..types.article_translated_content import ArticleTranslatedContent
from ..types.create_article_request import CreateArticleRequest
from ..types.deleted_article_object import DeletedArticleObject
from .raw_client import AsyncRawArticlesClient, RawArticlesClient
from .types.article import Article
from .types.article_list_item import ArticleListItem
from .types.article_search_response import ArticleSearchResponse
from .types.update_article_request_state import UpdateArticleRequestState

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class ArticlesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawArticlesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ArticleListItem, ArticleList]:
        """
        You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.

        > 📘 How are the articles sorted and ordered?
        >
        > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ArticleListItem, ArticleList]
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        response = client.articles.list()
        for item in response:
            yield item
        # alternatively, you can paginate page-by-page
        for page in response.iter_pages():
            yield page
        """
        return self._raw_client.list(page=page, per_page=per_page, request_options=request_options)

    def create(
        self,
        *,
        request: typing.Optional[CreateArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Article:
        """
        You can create a new article by making a POST request to `https://api.intercom.io/articles`.

        Parameters
        ----------
        request : typing.Optional[CreateArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            article created

        Examples
        --------
        from intercom import (
            ArticleContent,
            ArticleTranslatedContent,
            CreateArticleRequest,
            Intercom,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.articles.create(
            request=CreateArticleRequest(
                title="Thanks for everything",
                description="Description of the Article",
                body="Body of the Article",
                author_id=991267497,
                state="published",
                parent_id=145,
                parent_type="collection",
                translated_content=ArticleTranslatedContent(
                    fr=ArticleContent(
                        title="Merci pour tout",
                        description="Description de l'article",
                        body="Corps de l'article",
                        author_id=991267497,
                        state="published",
                    ),
                ),
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def find(self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Article:
        """
        You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            Article found

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.articles.find(
            article_id=1,
        )
        """
        _response = self._raw_client.find(article_id, request_options=request_options)
        return _response.data

    def update(
        self,
        article_id: int,
        *,
        title: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        state: typing.Optional[UpdateArticleRequestState] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        parent_type: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[ArticleTranslatedContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Article:
        """
        You can update the details of a single article by making a PUT request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.For multilingual articles, this will be the title of the default language's content.

        description : typing.Optional[str]
            The description of the article. For multilingual articles, this will be the description of the default language's content.

        body : typing.Optional[str]
            The content of the article. For multilingual articles, this will be the body of the default language's content.

        author_id : typing.Optional[int]
            The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.

        state : typing.Optional[UpdateArticleRequestState]
            Whether the article will be `published` or will be a `draft`. Defaults to draft. For multilingual articles, this will be the state of the default language's content.

        parent_id : typing.Optional[str]
            The id of the article's parent collection or section. An article without this field stands alone.

        parent_type : typing.Optional[str]
            The type of parent, which can either be a `collection` or `section`.

        translated_content : typing.Optional[ArticleTranslatedContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.articles.update(
            article_id=1,
            title="Christmas is here!",
            body="<p>New gifts in store for the jolly season</p>",
        )
        """
        _response = self._raw_client.update(
            article_id,
            title=title,
            description=description,
            body=body,
            author_id=author_id,
            state=state,
            parent_id=parent_id,
            parent_type=parent_type,
            translated_content=translated_content,
            request_options=request_options,
        )
        return _response.data

    def delete(
        self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedArticleObject:
        """
        You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedArticleObject
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.articles.delete(
            article_id=1,
        )
        """
        _response = self._raw_client.delete(article_id, request_options=request_options)
        return _response.data

    def search(
        self,
        *,
        phrase: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        help_center_id: typing.Optional[int] = None,
        highlight: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ArticleSearchResponse:
        """
        You can search for articles by making a GET request to `https://api.intercom.io/articles/search`.

        Parameters
        ----------
        phrase : typing.Optional[str]
            The phrase within your articles to search for.

        state : typing.Optional[str]
            The state of the Articles returned. One of `published`, `draft` or `all`.

        help_center_id : typing.Optional[int]
            The ID of the Help Center to search in.

        highlight : typing.Optional[bool]
            Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ArticleSearchResponse
            Search successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.articles.search(
            phrase="Getting started",
            state="published",
            help_center_id=1,
            highlight=True,
        )
        """
        _response = self._raw_client.search(
            phrase=phrase,
            state=state,
            help_center_id=help_center_id,
            highlight=highlight,
            request_options=request_options,
        )
        return _response.data


class AsyncArticlesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawArticlesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawArticlesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawArticlesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ArticleListItem, ArticleList]:
        """
        You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.

        > 📘 How are the articles sorted and ordered?
        >
        > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ArticleListItem, ArticleList]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            response = await client.articles.list()
            async for item in response:
                yield item

            # alternatively, you can paginate page-by-page
            async for page in response.iter_pages():
                yield page


        asyncio.run(main())
        """
        return await self._raw_client.list(page=page, per_page=per_page, request_options=request_options)

    async def create(
        self,
        *,
        request: typing.Optional[CreateArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Article:
        """
        You can create a new article by making a POST request to `https://api.intercom.io/articles`.

        Parameters
        ----------
        request : typing.Optional[CreateArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            article created

        Examples
        --------
        import asyncio

        from intercom import (
            ArticleContent,
            ArticleTranslatedContent,
            AsyncIntercom,
            CreateArticleRequest,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.articles.create(
                request=CreateArticleRequest(
                    title="Thanks for everything",
                    description="Description of the Article",
                    body="Body of the Article",
                    author_id=991267497,
                    state="published",
                    parent_id=145,
                    parent_type="collection",
                    translated_content=ArticleTranslatedContent(
                        fr=ArticleContent(
                            title="Merci pour tout",
                            description="Description de l'article",
                            body="Corps de l'article",
                            author_id=991267497,
                            state="published",
                        ),
                    ),
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def find(self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None) -> Article:
        """
        You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            Article found

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.articles.find(
                article_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.find(article_id, request_options=request_options)
        return _response.data

    async def update(
        self,
        article_id: int,
        *,
        title: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        state: typing.Optional[UpdateArticleRequestState] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        parent_type: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[ArticleTranslatedContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> Article:
        """
        You can update the details of a single article by making a PUT request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.For multilingual articles, this will be the title of the default language's content.

        description : typing.Optional[str]
            The description of the article. For multilingual articles, this will be the description of the default language's content.

        body : typing.Optional[str]
            The content of the article. For multilingual articles, this will be the body of the default language's content.

        author_id : typing.Optional[int]
            The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.

        state : typing.Optional[UpdateArticleRequestState]
            Whether the article will be `published` or will be a `draft`. Defaults to draft. For multilingual articles, this will be the state of the default language's content.

        parent_id : typing.Optional[str]
            The id of the article's parent collection or section. An article without this field stands alone.

        parent_type : typing.Optional[str]
            The type of parent, which can either be a `collection` or `section`.

        translated_content : typing.Optional[ArticleTranslatedContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        Article
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.articles.update(
                article_id=1,
                title="Christmas is here!",
                body="<p>New gifts in store for the jolly season</p>",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(
            article_id,
            title=title,
            description=description,
            body=body,
            author_id=author_id,
            state=state,
            parent_id=parent_id,
            parent_type=parent_type,
            translated_content=translated_content,
            request_options=request_options,
        )
        return _response.data

    async def delete(
        self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> DeletedArticleObject:
        """
        You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DeletedArticleObject
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.articles.delete(
                article_id=1,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete(article_id, request_options=request_options)
        return _response.data

    async def search(
        self,
        *,
        phrase: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        help_center_id: typing.Optional[int] = None,
        highlight: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> ArticleSearchResponse:
        """
        You can search for articles by making a GET request to `https://api.intercom.io/articles/search`.

        Parameters
        ----------
        phrase : typing.Optional[str]
            The phrase within your articles to search for.

        state : typing.Optional[str]
            The state of the Articles returned. One of `published`, `draft` or `all`.

        help_center_id : typing.Optional[int]
            The ID of the Help Center to search in.

        highlight : typing.Optional[bool]
            Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        ArticleSearchResponse
            Search successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.articles.search(
                phrase="Getting started",
                state="published",
                help_center_id=1,
                highlight=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.search(
            phrase=phrase,
            state=state,
            help_center_id=help_center_id,
            highlight=highlight,
            request_options=request_options,
        )
        return _response.data
