# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pagination import AsyncPager, SyncPager
from ..core.request_options import RequestOptions
from ..core.serialization import convert_and_respect_annotation_metadata
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.not_found_error import NotFoundError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.article_list import ArticleList
from ..types.article_translated_content import ArticleTranslatedContent
from ..types.create_article_request import CreateArticleRequest
from ..types.deleted_article_object import DeletedArticleObject
from ..types.error import Error
from .types.article import Article
from .types.article_list_item import ArticleListItem
from .types.article_search_response import ArticleSearchResponse
from .types.update_article_request_state import UpdateArticleRequestState

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawArticlesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> SyncPager[ArticleListItem, ArticleList]:
        """
        You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.

        > 📘 How are the articles sorted and ordered?
        >
        > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        SyncPager[ArticleListItem, ArticleList]
            successful
        """
        page = page if page is not None else 1

        _response = self._client_wrapper.httpx_client.request(
            "articles",
            method="GET",
            params={
                "page": page,
                "per_page": per_page,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ArticleList,
                    construct_type(
                        type_=ArticleList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True
                _get_next = lambda: self.list(
                    page=page + 1,
                    per_page=per_page,
                    request_options=request_options,
                )
                return SyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def create(
        self,
        *,
        request: typing.Optional[CreateArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Article]:
        """
        You can create a new article by making a POST request to `https://api.intercom.io/articles`.

        Parameters
        ----------
        request : typing.Optional[CreateArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Article]
            article created
        """
        _response = self._client_wrapper.httpx_client.request(
            "articles",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateArticleRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Article,
                    construct_type(
                        type_=Article,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def find(
        self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[Article]:
        """
        You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Article]
            Article found
        """
        _response = self._client_wrapper.httpx_client.request(
            f"articles/{jsonable_encoder(article_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Article,
                    construct_type(
                        type_=Article,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def update(
        self,
        article_id: int,
        *,
        title: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        state: typing.Optional[UpdateArticleRequestState] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        parent_type: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[ArticleTranslatedContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[Article]:
        """
        You can update the details of a single article by making a PUT request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.For multilingual articles, this will be the title of the default language's content.

        description : typing.Optional[str]
            The description of the article. For multilingual articles, this will be the description of the default language's content.

        body : typing.Optional[str]
            The content of the article. For multilingual articles, this will be the body of the default language's content.

        author_id : typing.Optional[int]
            The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.

        state : typing.Optional[UpdateArticleRequestState]
            Whether the article will be `published` or will be a `draft`. Defaults to draft. For multilingual articles, this will be the state of the default language's content.

        parent_id : typing.Optional[str]
            The id of the article's parent collection or section. An article without this field stands alone.

        parent_type : typing.Optional[str]
            The type of parent, which can either be a `collection` or `section`.

        translated_content : typing.Optional[ArticleTranslatedContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[Article]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"articles/{jsonable_encoder(article_id)}",
            method="PUT",
            json={
                "title": title,
                "description": description,
                "body": body,
                "author_id": author_id,
                "state": state,
                "parent_id": parent_id,
                "parent_type": parent_type,
                "translated_content": convert_and_respect_annotation_metadata(
                    object_=translated_content, annotation=ArticleTranslatedContent, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Article,
                    construct_type(
                        type_=Article,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def delete(
        self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[DeletedArticleObject]:
        """
        You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[DeletedArticleObject]
            successful
        """
        _response = self._client_wrapper.httpx_client.request(
            f"articles/{jsonable_encoder(article_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeletedArticleObject,
                    construct_type(
                        type_=DeletedArticleObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def search(
        self,
        *,
        phrase: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        help_center_id: typing.Optional[int] = None,
        highlight: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[ArticleSearchResponse]:
        """
        You can search for articles by making a GET request to `https://api.intercom.io/articles/search`.

        Parameters
        ----------
        phrase : typing.Optional[str]
            The phrase within your articles to search for.

        state : typing.Optional[str]
            The state of the Articles returned. One of `published`, `draft` or `all`.

        help_center_id : typing.Optional[int]
            The ID of the Help Center to search in.

        highlight : typing.Optional[bool]
            Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[ArticleSearchResponse]
            Search successful
        """
        _response = self._client_wrapper.httpx_client.request(
            "articles/search",
            method="GET",
            params={
                "phrase": phrase,
                "state": state,
                "help_center_id": help_center_id,
                "highlight": highlight,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ArticleSearchResponse,
                    construct_type(
                        type_=ArticleSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawArticlesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def list(
        self,
        *,
        page: typing.Optional[int] = None,
        per_page: typing.Optional[int] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncPager[ArticleListItem, ArticleList]:
        """
        You can fetch a list of all articles by making a GET request to `https://api.intercom.io/articles`.

        > 📘 How are the articles sorted and ordered?
        >
        > Articles will be returned in descending order on the `updated_at` attribute. This means if you need to iterate through results then we'll show the most recently updated articles first.

        Parameters
        ----------
        page : typing.Optional[int]
            The page of results to fetch. Defaults to first page

        per_page : typing.Optional[int]
            How many results to display per page. Defaults to 15

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncPager[ArticleListItem, ArticleList]
            successful
        """
        page = page if page is not None else 1

        _response = await self._client_wrapper.httpx_client.request(
            "articles",
            method="GET",
            params={
                "page": page,
                "per_page": per_page,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _parsed_response = typing.cast(
                    ArticleList,
                    construct_type(
                        type_=ArticleList,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                _items = _parsed_response.data
                _has_next = True

                async def _get_next():
                    return await self.list(
                        page=page + 1,
                        per_page=per_page,
                        request_options=request_options,
                    )

                return AsyncPager(has_next=_has_next, items=_items, get_next=_get_next, response=_parsed_response)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def create(
        self,
        *,
        request: typing.Optional[CreateArticleRequest] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Article]:
        """
        You can create a new article by making a POST request to `https://api.intercom.io/articles`.

        Parameters
        ----------
        request : typing.Optional[CreateArticleRequest]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Article]
            article created
        """
        _response = await self._client_wrapper.httpx_client.request(
            "articles",
            method="POST",
            json=convert_and_respect_annotation_metadata(
                object_=request, annotation=CreateArticleRequest, direction="write"
            ),
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Article,
                    construct_type(
                        type_=Article,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def find(
        self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[Article]:
        """
        You can fetch the details of a single article by making a GET request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Article]
            Article found
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"articles/{jsonable_encoder(article_id)}",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Article,
                    construct_type(
                        type_=Article,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def update(
        self,
        article_id: int,
        *,
        title: typing.Optional[str] = OMIT,
        description: typing.Optional[str] = OMIT,
        body: typing.Optional[str] = OMIT,
        author_id: typing.Optional[int] = OMIT,
        state: typing.Optional[UpdateArticleRequestState] = OMIT,
        parent_id: typing.Optional[str] = OMIT,
        parent_type: typing.Optional[str] = OMIT,
        translated_content: typing.Optional[ArticleTranslatedContent] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[Article]:
        """
        You can update the details of a single article by making a PUT request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        title : typing.Optional[str]
            The title of the article.For multilingual articles, this will be the title of the default language's content.

        description : typing.Optional[str]
            The description of the article. For multilingual articles, this will be the description of the default language's content.

        body : typing.Optional[str]
            The content of the article. For multilingual articles, this will be the body of the default language's content.

        author_id : typing.Optional[int]
            The id of the author of the article. For multilingual articles, this will be the id of the author of the default language's content. Must be a teammate on the help center's workspace.

        state : typing.Optional[UpdateArticleRequestState]
            Whether the article will be `published` or will be a `draft`. Defaults to draft. For multilingual articles, this will be the state of the default language's content.

        parent_id : typing.Optional[str]
            The id of the article's parent collection or section. An article without this field stands alone.

        parent_type : typing.Optional[str]
            The type of parent, which can either be a `collection` or `section`.

        translated_content : typing.Optional[ArticleTranslatedContent]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[Article]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"articles/{jsonable_encoder(article_id)}",
            method="PUT",
            json={
                "title": title,
                "description": description,
                "body": body,
                "author_id": author_id,
                "state": state,
                "parent_id": parent_id,
                "parent_type": parent_type,
                "translated_content": convert_and_respect_annotation_metadata(
                    object_=translated_content, annotation=ArticleTranslatedContent, direction="write"
                ),
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    Article,
                    construct_type(
                        type_=Article,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def delete(
        self, article_id: int, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[DeletedArticleObject]:
        """
        You can delete a single article by making a DELETE request to `https://api.intercom.io/articles/<id>`.

        Parameters
        ----------
        article_id : int
            The unique identifier for the article which is given by Intercom.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[DeletedArticleObject]
            successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"articles/{jsonable_encoder(article_id)}",
            method="DELETE",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    DeletedArticleObject,
                    construct_type(
                        type_=DeletedArticleObject,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 404:
                raise NotFoundError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def search(
        self,
        *,
        phrase: typing.Optional[str] = None,
        state: typing.Optional[str] = None,
        help_center_id: typing.Optional[int] = None,
        highlight: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[ArticleSearchResponse]:
        """
        You can search for articles by making a GET request to `https://api.intercom.io/articles/search`.

        Parameters
        ----------
        phrase : typing.Optional[str]
            The phrase within your articles to search for.

        state : typing.Optional[str]
            The state of the Articles returned. One of `published`, `draft` or `all`.

        help_center_id : typing.Optional[int]
            The ID of the Help Center to search in.

        highlight : typing.Optional[bool]
            Return a highlighted version of the matching content within your articles. Refer to the response schema for more details.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[ArticleSearchResponse]
            Search successful
        """
        _response = await self._client_wrapper.httpx_client.request(
            "articles/search",
            method="GET",
            params={
                "phrase": phrase,
                "state": state,
                "help_center_id": help_center_id,
                "highlight": highlight,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    ArticleSearchResponse,
                    construct_type(
                        type_=ArticleSearchResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
