# This file was auto-generated by Fern from our API Definition.

# isort: skip_file

import typing
from importlib import import_module

if typing.TYPE_CHECKING:
    from .api_error import ApiError
    from .client_wrapper import AsyncClientWrapper, BaseClientWrapper, SyncClientWrapper
    from .custom_pagination import AsyncCustomPager, SyncCustomPager
    from .datetime_utils import serialize_datetime
    from .file import File, convert_file_dict_to_httpx_tuples, with_content_type
    from .http_client import AsyncHttpClient, HttpClient
    from .http_response import AsyncHttpResponse, HttpResponse
    from .jsonable_encoder import jsonable_encoder
    from .pagination import AsyncPager, SyncPager
    from .pydantic_utilities import (
        IS_PYDANTIC_V2,
        UniversalBaseModel,
        UniversalRootModel,
        parse_obj_as,
        universal_field_validator,
        universal_root_validator,
        update_forward_refs,
    )
    from .query_encoder import encode_query
    from .remove_none_from_dict import remove_none_from_dict
    from .request_options import RequestOptions
    from .serialization import FieldMetadata, convert_and_respect_annotation_metadata
    from .unchecked_base_model import UncheckedBaseModel, UnionMetadata, construct_type
_dynamic_imports: typing.Dict[str, str] = {
    "ApiError": ".api_error",
    "AsyncClientWrapper": ".client_wrapper",
    "AsyncCustomPager": ".custom_pagination",
    "AsyncHttpClient": ".http_client",
    "AsyncHttpResponse": ".http_response",
    "AsyncPager": ".pagination",
    "BaseClientWrapper": ".client_wrapper",
    "FieldMetadata": ".serialization",
    "File": ".file",
    "HttpClient": ".http_client",
    "HttpResponse": ".http_response",
    "IS_PYDANTIC_V2": ".pydantic_utilities",
    "RequestOptions": ".request_options",
    "SyncClientWrapper": ".client_wrapper",
    "SyncCustomPager": ".custom_pagination",
    "SyncPager": ".pagination",
    "UncheckedBaseModel": ".unchecked_base_model",
    "UnionMetadata": ".unchecked_base_model",
    "UniversalBaseModel": ".pydantic_utilities",
    "UniversalRootModel": ".pydantic_utilities",
    "construct_type": ".unchecked_base_model",
    "convert_and_respect_annotation_metadata": ".serialization",
    "convert_file_dict_to_httpx_tuples": ".file",
    "encode_query": ".query_encoder",
    "jsonable_encoder": ".jsonable_encoder",
    "parse_obj_as": ".pydantic_utilities",
    "remove_none_from_dict": ".remove_none_from_dict",
    "serialize_datetime": ".datetime_utils",
    "universal_field_validator": ".pydantic_utilities",
    "universal_root_validator": ".pydantic_utilities",
    "update_forward_refs": ".pydantic_utilities",
    "with_content_type": ".file",
}


def __getattr__(attr_name: str) -> typing.Any:
    module_name = _dynamic_imports.get(attr_name)
    if module_name is None:
        raise AttributeError(f"No {attr_name} found in _dynamic_imports for module name -> {__name__}")
    try:
        module = import_module(module_name, __package__)
        if module_name == f".{attr_name}":
            return module
        else:
            return getattr(module, attr_name)
    except ImportError as e:
        raise ImportError(f"Failed to import {attr_name} from {module_name}: {e}") from e
    except AttributeError as e:
        raise AttributeError(f"Failed to get {attr_name} from {module_name}: {e}") from e


def __dir__():
    lazy_attrs = list(_dynamic_imports.keys())
    return sorted(lazy_attrs)


__all__ = [
    "ApiError",
    "AsyncClientWrapper",
    "AsyncCustomPager",
    "AsyncHttpClient",
    "AsyncHttpResponse",
    "AsyncPager",
    "BaseClientWrapper",
    "FieldMetadata",
    "File",
    "HttpClient",
    "HttpResponse",
    "IS_PYDANTIC_V2",
    "RequestOptions",
    "SyncClientWrapper",
    "SyncCustomPager",
    "SyncPager",
    "UncheckedBaseModel",
    "UnionMetadata",
    "UniversalBaseModel",
    "UniversalRootModel",
    "construct_type",
    "convert_and_respect_annotation_metadata",
    "convert_file_dict_to_httpx_tuples",
    "encode_query",
    "jsonable_encoder",
    "parse_obj_as",
    "remove_none_from_dict",
    "serialize_datetime",
    "universal_field_validator",
    "universal_root_validator",
    "update_forward_refs",
    "with_content_type",
]
