# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.custom_object_instance_deleted import CustomObjectInstanceDeleted
from .raw_client import AsyncRawCustomObjectInstancesClient, RawCustomObjectInstancesClient
from .types.custom_object_instance import CustomObjectInstance

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class CustomObjectInstancesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawCustomObjectInstancesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawCustomObjectInstancesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawCustomObjectInstancesClient
        """
        return self._raw_client

    def get_custom_object_instances_by_external_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CustomObjectInstance]:
        """
        Fetch a Custom Object Instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CustomObjectInstance]
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.custom_object_instances.get_custom_object_instances_by_external_id(
            custom_object_type_identifier="Order",
            external_id="external_id",
        )
        """
        _response = self._raw_client.get_custom_object_instances_by_external_id(
            custom_object_type_identifier, external_id=external_id, request_options=request_options
        )
        return _response.data

    def create_custom_object_instances(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: typing.Optional[str] = OMIT,
        external_created_at: typing.Optional[int] = OMIT,
        external_updated_at: typing.Optional[int] = OMIT,
        custom_attributes: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CustomObjectInstance]:
        """
        Create or update a custom object instance

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : typing.Optional[str]
            A unique identifier for the Custom Object instance in the external system it originated from.

        external_created_at : typing.Optional[int]
            The time when the Custom Object instance was created in the external system it originated from.

        external_updated_at : typing.Optional[int]
            The time when the Custom Object instance was last updated in the external system it originated from.

        custom_attributes : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            The custom attributes which are set for the Custom Object instance.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CustomObjectInstance]
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.custom_object_instances.create_custom_object_instances(
            custom_object_type_identifier="Order",
            external_id="123",
            external_created_at=1392036272,
            external_updated_at=1392036272,
            custom_attributes={
                "order_number": "ORDER-12345",
                "total_amount": "custom_attributes",
            },
        )
        """
        _response = self._raw_client.create_custom_object_instances(
            custom_object_type_identifier,
            external_id=external_id,
            external_created_at=external_created_at,
            external_updated_at=external_updated_at,
            custom_attributes=custom_attributes,
            request_options=request_options,
        )
        return _response.data

    def delete_custom_object_instances_by_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomObjectInstanceDeleted:
        """
        Delete a single Custom Object instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomObjectInstanceDeleted
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.custom_object_instances.delete_custom_object_instances_by_id(
            custom_object_type_identifier="Order",
            external_id="external_id",
        )
        """
        _response = self._raw_client.delete_custom_object_instances_by_id(
            custom_object_type_identifier, external_id=external_id, request_options=request_options
        )
        return _response.data

    def get_custom_object_instances_by_id(
        self,
        custom_object_type_identifier: str,
        custom_object_instance_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CustomObjectInstance]:
        """
        Fetch a Custom Object Instance by id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        custom_object_instance_id : str
            The id or external_id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CustomObjectInstance]
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.custom_object_instances.get_custom_object_instances_by_id(
            custom_object_type_identifier="Order",
            custom_object_instance_id="custom_object_instance_id",
        )
        """
        _response = self._raw_client.get_custom_object_instances_by_id(
            custom_object_type_identifier, custom_object_instance_id, request_options=request_options
        )
        return _response.data

    def delete_custom_object_instances_by_external_id(
        self,
        custom_object_type_identifier: str,
        custom_object_instance_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomObjectInstanceDeleted:
        """
        Delete a single Custom Object instance using the Intercom defined id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        custom_object_instance_id : str
            The Intercom defined id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomObjectInstanceDeleted
            successful

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.custom_object_instances.delete_custom_object_instances_by_external_id(
            custom_object_type_identifier="Order",
            custom_object_instance_id="custom_object_instance_id",
        )
        """
        _response = self._raw_client.delete_custom_object_instances_by_external_id(
            custom_object_type_identifier, custom_object_instance_id, request_options=request_options
        )
        return _response.data


class AsyncCustomObjectInstancesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawCustomObjectInstancesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawCustomObjectInstancesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawCustomObjectInstancesClient
        """
        return self._raw_client

    async def get_custom_object_instances_by_external_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CustomObjectInstance]:
        """
        Fetch a Custom Object Instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CustomObjectInstance]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_object_instances.get_custom_object_instances_by_external_id(
                custom_object_type_identifier="Order",
                external_id="external_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_custom_object_instances_by_external_id(
            custom_object_type_identifier, external_id=external_id, request_options=request_options
        )
        return _response.data

    async def create_custom_object_instances(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: typing.Optional[str] = OMIT,
        external_created_at: typing.Optional[int] = OMIT,
        external_updated_at: typing.Optional[int] = OMIT,
        custom_attributes: typing.Optional[typing.Dict[str, typing.Optional[str]]] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CustomObjectInstance]:
        """
        Create or update a custom object instance

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : typing.Optional[str]
            A unique identifier for the Custom Object instance in the external system it originated from.

        external_created_at : typing.Optional[int]
            The time when the Custom Object instance was created in the external system it originated from.

        external_updated_at : typing.Optional[int]
            The time when the Custom Object instance was last updated in the external system it originated from.

        custom_attributes : typing.Optional[typing.Dict[str, typing.Optional[str]]]
            The custom attributes which are set for the Custom Object instance.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CustomObjectInstance]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_object_instances.create_custom_object_instances(
                custom_object_type_identifier="Order",
                external_id="123",
                external_created_at=1392036272,
                external_updated_at=1392036272,
                custom_attributes={
                    "order_number": "ORDER-12345",
                    "total_amount": "custom_attributes",
                },
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create_custom_object_instances(
            custom_object_type_identifier,
            external_id=external_id,
            external_created_at=external_created_at,
            external_updated_at=external_updated_at,
            custom_attributes=custom_attributes,
            request_options=request_options,
        )
        return _response.data

    async def delete_custom_object_instances_by_id(
        self,
        custom_object_type_identifier: str,
        *,
        external_id: str,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomObjectInstanceDeleted:
        """
        Delete a single Custom Object instance by external_id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        external_id : str

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomObjectInstanceDeleted
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_object_instances.delete_custom_object_instances_by_id(
                custom_object_type_identifier="Order",
                external_id="external_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_custom_object_instances_by_id(
            custom_object_type_identifier, external_id=external_id, request_options=request_options
        )
        return _response.data

    async def get_custom_object_instances_by_id(
        self,
        custom_object_type_identifier: str,
        custom_object_instance_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> typing.Optional[CustomObjectInstance]:
        """
        Fetch a Custom Object Instance by id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        custom_object_instance_id : str
            The id or external_id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        typing.Optional[CustomObjectInstance]
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_object_instances.get_custom_object_instances_by_id(
                custom_object_type_identifier="Order",
                custom_object_instance_id="custom_object_instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_custom_object_instances_by_id(
            custom_object_type_identifier, custom_object_instance_id, request_options=request_options
        )
        return _response.data

    async def delete_custom_object_instances_by_external_id(
        self,
        custom_object_type_identifier: str,
        custom_object_instance_id: str,
        *,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> CustomObjectInstanceDeleted:
        """
        Delete a single Custom Object instance using the Intercom defined id.

        Parameters
        ----------
        custom_object_type_identifier : str
            The unique identifier of the custom object type that defines the structure of the custom object instance.

        custom_object_instance_id : str
            The Intercom defined id of the custom object instance

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        CustomObjectInstanceDeleted
            successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.custom_object_instances.delete_custom_object_instances_by_external_id(
                custom_object_type_identifier="Order",
                custom_object_instance_id="custom_object_instance_id",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.delete_custom_object_instances_by_external_id(
            custom_object_type_identifier, custom_object_instance_id, request_options=request_options
        )
        return _response.data
