# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.create_data_attribute_request import CreateDataAttributeRequest
from ..types.data_attribute_list import DataAttributeList
from ..types.update_data_attribute_request_body import UpdateDataAttributeRequestBody
from .raw_client import AsyncRawDataAttributesClient, RawDataAttributesClient
from .types.data_attribute import DataAttribute
from .types.data_attributes_list_request_model import DataAttributesListRequestModel

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DataAttributesClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDataAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDataAttributesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDataAttributesClient
        """
        return self._raw_client

    def list(
        self,
        *,
        model: typing.Optional[DataAttributesListRequestModel] = None,
        include_archived: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataAttributeList:
        """
        You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.

        Parameters
        ----------
        model : typing.Optional[DataAttributesListRequestModel]
            Specify the data attribute model to return.

        include_archived : typing.Optional[bool]
            Include archived attributes in the list. By default we return only non archived data attributes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttributeList
            Successful response

        Examples
        --------
        from intercom import Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.data_attributes.list(
            model="contact",
            include_archived=True,
        )
        """
        _response = self._raw_client.list(
            model=model, include_archived=include_archived, request_options=request_options
        )
        return _response.data

    def create(
        self, *, request: CreateDataAttributeRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> DataAttribute:
        """
        You can create a data attributes for a `contact` or a `company`.

        Parameters
        ----------
        request : CreateDataAttributeRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        from intercom import CreateDataAttributeRequestOne, Intercom

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.data_attributes.create(
            request=CreateDataAttributeRequestOne(
                data_type="string",
            ),
        )
        """
        _response = self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    def update(
        self,
        data_attribute_id: int,
        *,
        request: UpdateDataAttributeRequestBody,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataAttribute:
        """

        You can update a data attribute.

        > 🚧 Updating the data type is not possible
        >
        > It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.

        Parameters
        ----------
        data_attribute_id : int
            The data attribute id

        request : UpdateDataAttributeRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        from intercom import (
            Intercom,
            UpdateDataAttributeRequestOptions,
            UpdateDataAttributeRequestOptionsOptionsItem,
        )

        client = Intercom(
            token="YOUR_TOKEN",
        )
        client.data_attributes.update(
            data_attribute_id=1,
            request=UpdateDataAttributeRequestOptions(
                options=[
                    UpdateDataAttributeRequestOptionsOptionsItem(
                        value="1-10",
                    ),
                    UpdateDataAttributeRequestOptionsOptionsItem(
                        value="11-20",
                    ),
                ],
            ),
        )
        """
        _response = self._raw_client.update(data_attribute_id, request=request, request_options=request_options)
        return _response.data


class AsyncDataAttributesClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDataAttributesClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDataAttributesClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDataAttributesClient
        """
        return self._raw_client

    async def list(
        self,
        *,
        model: typing.Optional[DataAttributesListRequestModel] = None,
        include_archived: typing.Optional[bool] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataAttributeList:
        """
        You can fetch a list of all data attributes belonging to a workspace for contacts, companies or conversations.

        Parameters
        ----------
        model : typing.Optional[DataAttributesListRequestModel]
            Specify the data attribute model to return.

        include_archived : typing.Optional[bool]
            Include archived attributes in the list. By default we return only non archived data attributes.

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttributeList
            Successful response

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.data_attributes.list(
                model="contact",
                include_archived=True,
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.list(
            model=model, include_archived=include_archived, request_options=request_options
        )
        return _response.data

    async def create(
        self, *, request: CreateDataAttributeRequest, request_options: typing.Optional[RequestOptions] = None
    ) -> DataAttribute:
        """
        You can create a data attributes for a `contact` or a `company`.

        Parameters
        ----------
        request : CreateDataAttributeRequest

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        import asyncio

        from intercom import AsyncIntercom, CreateDataAttributeRequestOne

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.data_attributes.create(
                request=CreateDataAttributeRequestOne(
                    data_type="string",
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.create(request=request, request_options=request_options)
        return _response.data

    async def update(
        self,
        data_attribute_id: int,
        *,
        request: UpdateDataAttributeRequestBody,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> DataAttribute:
        """

        You can update a data attribute.

        > 🚧 Updating the data type is not possible
        >
        > It is currently a dangerous action to execute changing a data attribute's type via the API. You will need to update the type via the UI instead.

        Parameters
        ----------
        data_attribute_id : int
            The data attribute id

        request : UpdateDataAttributeRequestBody

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        DataAttribute
            Successful

        Examples
        --------
        import asyncio

        from intercom import (
            AsyncIntercom,
            UpdateDataAttributeRequestOptions,
            UpdateDataAttributeRequestOptionsOptionsItem,
        )

        client = AsyncIntercom(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.data_attributes.update(
                data_attribute_id=1,
                request=UpdateDataAttributeRequestOptions(
                    options=[
                        UpdateDataAttributeRequestOptionsOptionsItem(
                            value="1-10",
                        ),
                        UpdateDataAttributeRequestOptionsOptionsItem(
                            value="11-20",
                        ),
                    ],
                ),
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.update(data_attribute_id, request=request, request_options=request_options)
        return _response.data
