# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.request_options import RequestOptions
from ..core.unchecked_base_model import construct_type
from ..errors.bad_request_error import BadRequestError
from ..errors.too_many_requests_error import TooManyRequestsError
from ..errors.unauthorized_error import UnauthorizedError
from ..types.error import Error
from .types.get_export_reporting_data_get_datasets_response import GetExportReportingDataGetDatasetsResponse
from .types.post_export_reporting_data_enqueue_response import PostExportReportingDataEnqueueResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class RawExportClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def enqueue_a_new_reporting_data_export_job(
        self,
        *,
        dataset_id: str,
        attribute_ids: typing.Sequence[str],
        start_time: int,
        end_time: int,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[PostExportReportingDataEnqueueResponse]:
        """
        Parameters
        ----------
        dataset_id : str

        attribute_ids : typing.Sequence[str]

        start_time : int

        end_time : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[PostExportReportingDataEnqueueResponse]
            Job enqueued successfully
        """
        _response = self._client_wrapper.httpx_client.request(
            "export/reporting_data/enqueue",
            method="POST",
            json={
                "dataset_id": dataset_id,
                "attribute_ids": attribute_ids,
                "start_time": start_time,
                "end_time": end_time,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostExportReportingDataEnqueueResponse,
                    construct_type(
                        type_=PostExportReportingDataEnqueueResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def list_available_datasets_and_attributes(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> HttpResponse[GetExportReportingDataGetDatasetsResponse]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GetExportReportingDataGetDatasetsResponse]
            List of datasets
        """
        _response = self._client_wrapper.httpx_client.request(
            "export/reporting_data/get_datasets",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetExportReportingDataGetDatasetsResponse,
                    construct_type(
                        type_=GetExportReportingDataGetDatasetsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawExportClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def enqueue_a_new_reporting_data_export_job(
        self,
        *,
        dataset_id: str,
        attribute_ids: typing.Sequence[str],
        start_time: int,
        end_time: int,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[PostExportReportingDataEnqueueResponse]:
        """
        Parameters
        ----------
        dataset_id : str

        attribute_ids : typing.Sequence[str]

        start_time : int

        end_time : int

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[PostExportReportingDataEnqueueResponse]
            Job enqueued successfully
        """
        _response = await self._client_wrapper.httpx_client.request(
            "export/reporting_data/enqueue",
            method="POST",
            json={
                "dataset_id": dataset_id,
                "attribute_ids": attribute_ids,
                "start_time": start_time,
                "end_time": end_time,
            },
            headers={
                "content-type": "application/json",
            },
            request_options=request_options,
            omit=OMIT,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    PostExportReportingDataEnqueueResponse,
                    construct_type(
                        type_=PostExportReportingDataEnqueueResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 400:
                raise BadRequestError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        typing.Any,
                        construct_type(
                            type_=typing.Any,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 401:
                raise UnauthorizedError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            if _response.status_code == 429:
                raise TooManyRequestsError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        Error,
                        construct_type(
                            type_=Error,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def list_available_datasets_and_attributes(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> AsyncHttpResponse[GetExportReportingDataGetDatasetsResponse]:
        """
        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GetExportReportingDataGetDatasetsResponse]
            List of datasets
        """
        _response = await self._client_wrapper.httpx_client.request(
            "export/reporting_data/get_datasets",
            method="GET",
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GetExportReportingDataGetDatasetsResponse,
                    construct_type(
                        type_=GetExportReportingDataGetDatasetsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
