# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
from ...core.pydantic_utilities import IS_PYDANTIC_V2
from ...core.unchecked_base_model import UncheckedBaseModel


class HelpCenter(UncheckedBaseModel):
    """
    Help Centers contain collections
    """

    id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The unique identifier for the Help Center which is given by Intercom.
    """

    workspace_id: typing.Optional[str] = pydantic.Field(default=None)
    """
    The id of the workspace which the Help Center belongs to.
    """

    created_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the Help Center was created.
    """

    updated_at: typing.Optional[int] = pydantic.Field(default=None)
    """
    The time when the Help Center was last updated.
    """

    identifier: typing.Optional[str] = pydantic.Field(default=None)
    """
    The identifier of the Help Center. This is used in the URL of the Help Center.
    """

    website_turned_on: typing.Optional[bool] = pydantic.Field(default=None)
    """
    Whether the Help Center is turned on or not. This is controlled in your Help Center settings.
    """

    display_name: typing.Optional[str] = pydantic.Field(default=None)
    """
    The display name of the Help Center only seen by teammates.
    """

    url: typing.Optional[str] = pydantic.Field(default=None)
    """
    The URL for the help center, if you have a custom domain then this will show the URL using the custom domain.
    """

    custom_domain: typing.Optional[str] = pydantic.Field(default=None)
    """
    Custom domain configured for the help center
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
